//
// zoomControl.js
//

var zoomControl = {
	
	// add date or filter items by selecting rows in multiple report elements

	zoomItems: {}, // contains any date item or filter item (the row id) which has to be added to the filter
	
	isZoomItems: false, // New, indicates if any zoom items are active
	
	// Following three properties are used for the zoomInfo box,
	// they indicate what items are selected (date and/or non-date items)
	// and if the report or report element has an in-build filter.
	isDateFilter: false,
	isFilterItems: false,
	showAddBuildInReportFilters: false,
	
	silentZoomItemsIds: {},  // keeps track of zoomItemsId's which have already been send to the server in silent mode
	currentSilentZoomItemsId: '', // contains any active zoomItemId in silent mode
	
	dateFilter: '', // Don't remove, dateFilter is used by Calendar!
	
	// currentTimeoutId: '',
	// dateFilter: '',
	// dateFilterDisplay: '',
	// filterId: '',
	// itemStack: {},
	// itemStackId: '',  // i.e.: 're0:row:0-re0:row:3'
	// isAddBuildInReportFilters: false,
	// justAddedFilterItems: [], // Contains added filter items. Array is used in report_tools.js!
	
	// isAddBuildInReportFilters is set to true if a build in report filter or
	// report element filter exists and if "Add build in report filter(s) is checked.
	
	// The itemStack contains any filterId and justAddedFilterItems array we received from the server.
	// property name (itemStackId) is a combination of the itemId in alphabetical order,
	//	re0:row:0 = {
	//		filterId: 'abc123...',
	//		filterItems: [{...}, {...}, ...]
	//	}
	//	re0:row:0-re0:row:1 = {
	//		filterId: 'abc123...',
	//	 	filterItems: [{...}, {...}, ...]
	//	}
	
	
	addRemoveZoomItem: function(rowId, isAddItem) {
		
		var zoomItems = zoomControl.zoomItems;
		var isZoomItems = false;
		
		if (isAddItem) {
			
			// Add item to zoomItems
			zoomItems[rowId] = true;
			isZoomItems = true;
		}
		else {
			
			// Remove item from zoomItems
			delete zoomItems[rowId];
			
			// Check if there are any zoomItems yet
			for (var prop in zoomItems) {
				isZoomItems = true;
				break;
			}
		}
		
		if (isZoomItems) {
			
			zoomControl.updateSelectedZoomItemState();
			zoomInfo.update(zoomControl.isDateFilter, zoomControl.isFilterItems, zoomControl.showAddBuildInReportFilters);
			zoomControl.isZoomItems = true;
		}
		else {
			
			zoomControl.cancelZoom();
		}
	},
	
	cancelZoom: function() {
		
		// deselects all selected rows
		// and resets filterItems objects
				
		// Reset zoom object
		zoomControl.isZoomItems = false;
		zoomControl.zoomItems = {};
		
		zoomControl.isDateFilter = false;
		zoomControl.isFilterItems = false;
		zoomControl.showAddBuildInReportFilters = false;
		
		// Note, we don't reset zoomControl.silentZoomItemsIds!
		zoomControl.currentSilentZoomItemsId = '';
		
		/*
		zoomControl.itemStackId = '';
		zoomControl.dateFilter = '';
		zoomControl.dateFilterDisplay = '';
		zoomControl.filterId = '';
		zoomControl.justAddedFilterItems = [];
		zoomControl.isAddBuildInReportFilters = false;
		*/
		
		reportsMenu.updateMenuItemLinks(
			reportsMenuDb,
			reportInfo.dateFilter,
			reportInfo.commandLineFilter,
			reportInfo.commandLineFilterComment,
			reportInfo.filterId,
			''
		);
		
		
		// Reset the rows
		report.rowSelection.resetZoomItems();
	
		// Close zoom info	
		zoomInfo.close();
		
		// util.hideE('add_filter_items_info');
	},	
		
	
	zoomRegular: function() {
		
		var zoomInfoId = zoomControl.getZoomInfoId();
		
		// Invoked via click on report by left mouse click
		var url = '?dp+statistics.filters.zoom.zoom_regular';
		url += '+p+' + reportInfo.profileName;
		
		var dat = 'v.sys.page_token=' + reportInfo.pageToken + '&';
		dat += zoomControl.getZoomItemsDat(zoomInfoId);

		util.serverPost(url, dat);
	},
	
	zoomRegularResponse: function(dat) {
		
		// util.showObject(dat);
		// return false;
		
		newReport.getReportByMenuItemViaZoomRegular(dat.dateFilter, dat.filterId);
	},
	
	zoomSilent: function(evt) {
		
		// Invoked via click on report menu item by right mouse click
		// We save current zoom data in sessions so that a date_filter and/or filter
		// can be created when the report is opened in a new tab or window
		
		// Check if any zoom item is active
		var isZoomItems = true; // test
		
		if (zoomControl.isZoomItems) {
		
			// Check if the user clicked the left mouse button (we need the right one but the left one is easier to check)
			var isLeftMouseBtnClick = (evt.which == 1 || evt.button == 1);
			
			if (!isLeftMouseBtnClick) {
				
				// This must be a right mouse button click
				// alert('prepareFilterUponMenuRightClick() - prepare the filter in the background');
				
				// In order to send the zoom info multiple times we check if it has already been send.
				var activeZoomItemsId = zoomControl.getActiveZoomItemsId();
				
				//
				// silentZoomItemsIds: {},  // keeps track of zoomItemId's which have already been send to the server in silent mode
				// currentSilentZoomItemsId: ''
				//
				
				if (zoomControl.currentSilentZoomItemsId != activeZoomItemsId) {
					
					// Verify if activeZoomItemsId has not been handled
					
					var silentZoomItemsIds = zoomControl.silentZoomItemsIds;
					var zoomInfoId;
					
					if (silentZoomItemsIds[activeZoomItemsId] == null) {
						
						var zoomInfoId = zoomControl.getZoomInfoId();
						silentZoomItemsIds[activeZoomItemsId] = zoomInfoId;
						
						// Send zoomInfo to server
						var url = '?dp+statistics.filters.zoom.zoom_silent';
						url += '+p+' + reportInfo.profileName;

						
						var dat = 'v.sys.page_token=' + reportInfo.pageToken + '&';
						dat += zoomControl.getZoomItemsDat(zoomInfoId);
						
						util.serverPost(url, dat);
					}
					else {
						
						// ZoomItemsDat has already been send
						
						zoomInfoId = silentZoomItemsIds[activeZoomItemsId];
					}
					
					// alert('activeZoomItemsId: ' + activeZoomItemsId + '\nzoomInfoId :' + zoomInfoId);
					
					zoomControl.currentSilentZoomItemsId = activeZoomItemsId;
					
					reportsMenu.updateMenuItemLinks(
						reportsMenuDb,
						reportInfo.dateFilter,
						reportInfo.commandLineFilter,
						reportInfo.commandLineFilterComment,
						reportInfo.filterId,
						zoomInfoId
					);
				}
			}
		}
	},
	

	zoomSilentResponse: function() {
		// No action required, return false
		return false;
	},

	getZoomItemsDat: function(zoomInfoId) {
		
		//
		// Collect zoom items
		//
	
		// Create an object like
		// o = {'1256732371':{'0':[],'1':['3', '2']}, '1256732371':{'2':[], '10':[]}}
		
		var reportElements = reportInfo.reportElements;
		
		var zoomItems = zoomControl.zoomItems;
		var items = {};
		
		for (var prop in zoomItems) {
			
			var dat = prop.split(':');
			var shortReportElementId = dat[0];
			var row = dat[2];
			var subRow = (dat.length == 4) ? dat[3] : '';
			
			// alert('prop: ' + prop + '\nsubRow: ' + subRow);
			
			var reportElementId = reportElements[h(shortReportElementId)].id;
			
			if (items[reportElementId] == null) {
				items[reportElementId] = {};
			}
			
			var reportElement = items[reportElementId];
			
			if (reportElement[row] == null) {
				reportElement[row] = [];
			}
			
			// Add any subrows
			if (subRow != '') {
				
				var reportElementRowArray = reportElement[row];
				
				reportElementRowArray[reportElementRowArray.length] = subRow;
			}
		}
		
		var isAddBuildInReportFilters = zoomControl.showAddBuildInReportFilters ? util.getF('zoom_info:add_build_in_filters') : false;
		
		// util.showObject(items);
	
		var dat = 'v.sys.is_zoom_items=true'; // Used when assembling the dat string in globalFilter.js, don't remove!
		dat += '&v.sys.zoom_info_id=' + zoomInfoId;
		dat += '&v.sys.active_filter_id=' + reportInfo.filterId; // Also used when assembling zoom items in globalFilter.js, don't rename or remove!
		// dat += '&v.sys.item_stack_id=' + itemStackId;
		// dat += '&v.sys.client_processing_type=' + cientProcessingType;
		dat += '&v.sys.is_add_build_in_report_filters=' + isAddBuildInReportFilters;
		dat += '&v.sys.is_report_filter=' + reportInfo.isReportFilter;
		dat += '&v.sys.is_report_element_filters=' + reportInfo.isReportElementFilters;
		dat += '&v.sys.report_job_id=' + reportInfo.reportJobId;
		
		var reportElementCount = 0;
		
		for (var reportElementProp in items) {
			
			var reportElementRows = items[reportElementProp];
			
			dat += '&v.sys.report_elements.' + reportElementCount + '.report_element_id=' + reportElementProp;
			
			for (var rowProp in reportElementRows) {
				
				var subRowsDat = reportElementRows[rowProp];
				
				if (subRowsDat.length == 0) {
				
					dat += '&v.sys.report_elements.' + reportElementCount + '.rows.' + rowProp + '=true';
				}
				else {
					
					for (var i = 0; i < subRowsDat.length; i++) {
						
						dat += '&v.sys.report_elements.' + reportElementCount + '.rows.' + rowProp + '.' + subRowsDat[i] + '=true';
					}
				}
			}
			
			reportElementCount++;
		}
		
		return dat;
	},
		
	//
	//
	// Utilities
	//
	//
	
	getZoomInfoId: function() {
		
		// Returns a unique ID
		var date = new Date();
		return date.getTime();
	},
	
	getActiveZoomItemsId: function() {
		
		// Creates an ID of the active zoom items
		
		var zoomItems = zoomControl.zoomItems;
		var zoomItemsList = [];
		
		var i = 0;
		for (var prop in zoomItems) {
			zoomItemsList[i] = prop;
			i++;
		}
		
		// Sort the zoomItemsList so that we get unique zoomItemId's regardless of the zoom items order
		
		zoomItemsList.sort();
		var zoomItemsId = '';
		for (var i = 0; i < zoomItemsList.length; i++) {
			zoomItemsId += (i + 1 != zoomItemsList.length) ? zoomItemsList[i] + '_' : zoomItemsList[i];
		}
		
		zoomItemsId = zoomItemsId.replace(/:/g, '_');
		
		// Get checkbox value of AddBuildInReportFilters if it is active
		if (zoomControl.showAddBuildInReportFilters && util.getF('zoom_info:add_build_in_filters')) {
			zoomItemsId += '_add_build_in_filters_true';
		}
		
		return zoomItemsId;
	},

	/*
	toggleAddBuildInReportFilters: function() {
		
		var isAddBuildInReportFilters = this.checked;
		zoomControl.isAddBuildInReportFilters = isAddBuildInReportFilters;
		
		// Update filter
		// zoomControl.checkForFilter();
	},
	*/
	
	updateSelectedZoomItemState: function() {
		
		// Checks all selected zoom items to set state for
		// isDateFilter
		// isFilterItems
		// showAddBuildInReportFilters
		
		// We need to check of rows in zoomItems if the row contains date-items and/or non-date items.
		
		var alreadyCheckedOuterRows = {}; // Contains report element id if it has been already checked
		var alreadyCheckedInnerRows = {}; // Contains report element id of an inner row if it has been already checked
		
		var isDateFilter = false;
		var isFilterItems = false;
		var zoomItems = zoomControl.zoomItems;
		
		var queryFieldsDb = reportInfo.queryFieldsDb;
		
		for (var prop in zoomItems) {
			
			// prop is the rowId
			
			var dat = prop.split(':');
			var shortReportElementId = dat[0];
			var isInnerRow = (dat.length == 4);
			var checkRow = false;
			var reportFieldName;
			var reportField;
			
			if (!isInnerRow) {
				checkRow = (alreadyCheckedOuterRows[shortReportElementId] == null);
			}
			else {
				checkRow = (alreadyCheckedInnerRows[shortReportElementId] == null);
			}
			
			if (checkRow) {
				
				var columns = reportInfo.reportElementColumns[shortReportElementId];
				
				for (var columnPro in columns) {
					
					reportFieldName = columns[columnPro];
					reportField = queryFieldsDb[h(reportFieldName)];
					
					if (!reportField.isAggregatingField) {
						
						if (reportField.category != 'date_time') {
							isFilterItems = true;
						}
						else {
							isDateFilter = true;
						}
					}
				}
				
				// Above case also covered the outer row of a pivot table, so we can mark it as done.
				alreadyCheckedOuterRows[shortReportElementId] = true;
				
				if (isInnerRow) {
					
					// We need yet to check the category of the pivot report field
					var reportElement = reportInfo.reportElements[h(shortReportElementId)];
					var reportFieldName = reportElement.pivotTable.reportField;
					var reportField = queryFieldsDb[h(reportFieldName)];
					
					if (reportField.category != 'date_time') {
						isFilterItems = true;
					}
					else {
						isDateFilter = true;
					}
				}
			}
		}
		
		zoomControl.isDateFilter = isDateFilter;
		zoomControl.isFilterItems = isFilterItems;
		zoomControl.showAddBuildInReportFilters = zoomControl.getShowAddBuildInReportFilters();
		
		// alert('updateSelectedZoomItemState()\nisDateFilter: ' + isDateFilter + '\nisFilterItems: ' + isFilterItems + '\nshowAddBuildInReportFilters: ' + zoomControl.showAddBuildInReportFilters);
	},
	
	
	getShowAddBuildInReportFilters: function() {
		
		// Returns true if the "Add build in report filters" checkbox should be shown in zoom info
		
		// We show the "Add build in report filters" checkbox if:
		// a.) The report contains a filter
		// b.) The report element of selected zoom items contains a filter
		// Note, in case of multiple build in report filters we add them as separate
		// filter expressions.
		
		// We only need to update this feature in case that one report filter or one report element filter exists
		
		var reportElements = reportInfo.reportElements;
		var isReportFilter = reportInfo.isReportFilter;
		var isReportElementFilters = reportInfo.isReportElementFilters;
		
		var showAddBuildInReportFilters = false;
	
		if (isReportFilter || isReportElementFilters) {
		
			var zoomItems = zoomControl.zoomItems;
			var isZoomItems = false;
			
			for (var prop in zoomItems) {
				isZoomItems = true;
				break;
			}
			
			if (isZoomItems) {
				
				if (isReportFilter) {
					
					showAddBuildInReportFilters = true;
				}
				else {
					
					// This report has one or more report element filters
					
					if (reportElements.length == 1) {
						
						// There is only one report element, so all
						// selected items must be from this report element.
						
						showAddBuildInReportFilters = true;
					}
					else {
						
						// Multiple report elements
						// We need to check if any checked item belongs
						// to a report element which has a report element filter.
						
						var activeReportElementIds = {};
						
						for (var prop in zoomItems) {
							var dat = prop.split(':');
							var shortReportElementId = dat[0];
							activeReportElementIds[shortReportElementId] = true;
						}
						
						for (var shortReportElementId in activeReportElementIds) {
							
							var isReportElementFilter = reportElements[h(shortReportElementId)].isReportElementFilter;
							
							if (isReportElementFilter) {
								showAddBuildInReportFilters = true;
								break;
							}
						}
					}
				}
			}
		}
		
		// alert('isShowBuildInReportFilters(): ' + showAddBuildInReportFilters);
			
		return showAddBuildInReportFilters;
	}
}
