//
//
// creGeneral.js (Customize Report Element General, used in Config Reports Element Editor only)
//
//

var creGeneral = {
	
	descriptionBtn: null,
	heaaderBtn: null,
	footerBtn: null,
	
	// Keep active omitParenthesizedItems and useOverviewForTotals state
	// so that we can recover the state when swicthing between different
	// constructionTypes
	omitParenthesizedItems: false,
	useOverviewForTotals: false,
	
	init: function() {
		
		creGeneral.descriptionBtn = new util.CommandLink('cre_obj:general:description:btn', creGeneral.setDescriptionHeaderFooterActor);
		creGeneral.headerBtn = new util.CommandLink('cre_obj:general:header:btn', creGeneral.setDescriptionHeaderFooterActor);
		creGeneral.footerBtn = new util.CommandLink('cre_obj:general:footer:btn', creGeneral.setDescriptionHeaderFooterActor);
		
		yEvent.addListener('cre_obj:general:omit_parenthesized_items', 'click', creGeneral.omitParenthesizedItemsActor);
		yEvent.addListener('cre_obj:general:use_overview_for_totals', 'click', creGeneral.useOverviewForTotalsActor);
	},
	
	updateForm: function(reportElementDb, constructionType, isLogDetail) {
		
		// Called upon initial openeing of the report element editor (not upon meta type change)
		
		// util.showObject(reportElementDb);
		// alert('creGeneral.updateForm()');
		
		util.setF('cre_obj:general:show_header_bar', reportElementDb.show_header_bar);
		util.setF('cre_obj:general:description', reportElementDb.description);
		util.setF('cre_obj:general:header', reportElementDb.header);
		util.setF('cre_obj:general:footer', reportElementDb.footer);
		
		
		// omit_parenthesized_items and use_overview_for_totals checkbox
		// is further handled in setConstructionTypeDependencies.
		var omitParenthesizedItems = (constructionType == 'standard' && !isLogDetail) ? reportElementDb.omit_parenthesized_items : false;
		var useOverviewForTotals = (constructionType == 'standard' && !isLogDetail) ? reportElementDb.use_overview_for_totals : false;
		
		creGeneral.omitParenthesizedItems = omitParenthesizedItems;
		creGeneral.useOverviewForTotals = useOverviewForTotals;
		
		//
		// Make description the active text field panel
		//
		creGeneral.setDescriptionHeaderFooterByName('description');
	},
	
	setConstructionTypeDependencies: function(constructionType, isLogDetail) {
		
		// Called upon report element type (metaType) change.
		
		// alert('creGeneral.setConstructionTypeDependencies()');
		
		var makeEnabled = (constructionType == 'standard' && !isLogDetail);
		
		// Recover state if makeEnabled, else set checkboxes to false and disbale them
		var omitParenthesizedItems = makeEnabled ? creGeneral.omitParenthesizedItems : false;
		var useOverviewForTotals = makeEnabled ? creGeneral.useOverviewForTotals : false;
	
		util.setF('cre_obj:general:omit_parenthesized_items', omitParenthesizedItems);
		util.setF('cre_obj:general:use_overview_for_totals', useOverviewForTotals);
		
		util.showEV('cre_obj:general:advanced_options', makeEnabled);
		
		util.enableE('cre_obj:general:omit_parenthesized_items', makeEnabled);
		util.enableE('cre_obj:general:use_overview_for_totals', makeEnabled);
	},
	
	omitParenthesizedItemsActor: function() {
		creGeneral.omitParenthesizedItems = this.checked;
	},
	
	useOverviewForTotalsActor: function() {
		creGeneral.useOverviewForTotals = this.checked;
	},
	
	saveChanges: function(reportElementDb, constructionType, isLogDetail) {
		
		// Save changes to the given reportElementDb
		
		reportElementDb.show_header_bar = util.getF('cre_obj:general:show_header_bar');
		reportElementDb.description = util.getF('cre_obj:general:description');
		reportElementDb.header = util.getF('cre_obj:general:header');
		reportElementDb.footer = util.getF('cre_obj:general:footer');

		
		if (constructionType == 'standard' && !isLogDetail) {
			reportElementDb.omit_parenthesized_items = creGeneral.omitParenthesizedItems;
			reportElementDb.use_overview_for_totals = creGeneral.useOverviewForTotals;
		}
	},
	
	setDescriptionHeaderFooterActor: function() {
		
		var dat = this.id.split(':');
		var textFieldName = dat[2];
		creGeneral.setDescriptionHeaderFooterByName(textFieldName);
	},
	
	setDescriptionHeaderFooterByName: function(textFieldName) {
		
		// textFieldName is: description | header | footer
		
		util.hideE(['cre_obj:general:description', 'cre_obj:general:header', 'cre_obj:general:footer']);
		
		creGeneral.descriptionBtn.enable();
		creGeneral.headerBtn.enable();
		creGeneral.footerBtn.enable();
		
		util.showE('cre_obj:general:' + textFieldName);
		
		var fieldLabel = '';
		
		if (textFieldName == 'description') {
			fieldLabel = langVar('lang_stats.customize_report_element.description');
			creGeneral.descriptionBtn.disable();
		}
		else if (textFieldName == 'header') {
			fieldLabel = langVar('lang_stats.customize_report_element.header');
			creGeneral.headerBtn.disable();
		}
		else {
			fieldLabel = langVar('lang_stats.customize_report_element.footer');
			creGeneral.footerBtn.disable();
		}
		
		util.updateT('cre_obj:general:text_field_label', fieldLabel + ':');
	}
};
