//
//
// creUtil.js (Customize Report Element utilities, used in Reports and Reports Editor)
//
//



// Contains helper utilities for cre*.js files

var creUtil = {
	
	getConstructionType: function(reportElementType) {
	
		// Returns the construction_type of a report element.
		// construction_type is: overview | standard | session_page_paths, session_paths

		var constructionType = '';
		
		if (reportElementType == 'overview' || reportElementType == 'sessions_overview') {
			
			constructionType = 'overview';
		}
		else if (reportElementType == 'session_paths') {
		
			constructionType = 'session_paths';
		}
		else if (reportElementType == 'session_page_paths') {
		
			constructionType = 'session_page_paths';
		}
		else {
		
			constructionType = 'standard';
		}
	
		return constructionType;
	},
	
	getReportElementGraphsObjectFromGraphsDb: function(graphsDb) {
		
		// Returns a graphs object as required to save in report element. The graphs object is created
		// from an up to date graphsDb object.
		
		var metaGraphType = graphsDb.metaGraphType;
		var isChrono = (metaGraphType.indexOf('chrono_') != -1);
		var graphs = {};
		var graphType = '';
		
		if (isChrono) {
			
			graphs = util.cloneObject(graphsDb.chrono_bar_line_graph);
			
			graphType = (metaGraphType == 'chrono_bar') ? 'bar' : 'line';
		}
		else {
			
			if (metaGraphType != 'pie') {
				
				graphs = util.cloneObject(graphsDb.bar_line_graph);
			}
			else {
				
				graphs = util.cloneObject(graphsDb.pie_chart);
			}
			
			graphType = metaGraphType;
		}
		
		graphs.graph_type = graphType;
		
		return graphs;
	},
	
	
	getIsChronoGraphSupport: function(reportFieldsDb, columns) {
		
		var isChronoGraphSupport = false;
		var numberOfTextFields = 0;
		var textFieldName = '';
		
		for (var i = 0; i < columns.length; i++) {
			// We assume that show_column is true for text field
			var isTextField = (columns[i].show_percent_column == null);
			
			if (isTextField) {
				textFieldName = columns[i].report_field;
				numberOfTextFields++;
			}
		}
		
		if (numberOfTextFields == 1) {
			
			// alert('textFieldName: ' + textFieldName);
			
			var category = reportFieldsDb[h(textFieldName)].category;
			
			// alert('category: ' + category);
			
			if (category == 'date_time' ||
				category == 'day_of_week' ||
				category == 'hour_of_day') {
					
				isChronoGraphSupport = true;
			}
		}
		
		return isChronoGraphSupport;
	},
	
	buildSortDirectionList: function(selectElementId) {
		
		// Populate sort direction list
		var sortDirectionList = [{name:'ascending', label:langVar('lang_stats.btn.ascending')}, {name:'descending', label:langVar('lang_stats.btn.descending')}];
		util.populateSelect(selectElementId, sortDirectionList, 'name', 'label');
	},
	
	getSortByFirstListEntryLabel: function(reportFieldsDb, columns, label) {
		
		// Label is the first list entrty in sort by select element. We add some spaces
		// so that the GUI doen's flicker when columns are unchecked
		
		var maxLength = 0;
		
		for (var i = 0; i < columns.length; i++) {
			
			var reportField = columns[i].report_field;
			var columnLabel = reportFieldsDb[h(reportField)].label;
			
			if (columnLabel.length > maxLength) {
				maxLength = columnLabel.length;
			}
		}
		
		for (var i = label.length; i < maxLength + 10; i++) {
			
			label += '\u00a0';
		}
		
		return label;
	}
}



		


