//
// util.js
//

var yEvent = YAHOO.util.Event;
var yDom = YAHOO.util.Dom;

//
//
//
// Regular util functions
//
//
//


var util = {
	
	// validHtmlElementAttributes & validImgElementAttributes are uses in createE() to distinguish
	// between html element and html style attributes
	validHtmlElementAttributes: {
		cellSpacing:true,
		colSpan:true,
		cols:true,
		className:true,
		href:true,
		htmlFor:true,
		id:true,
		rows:true,
		target:true,
		title:true,
		type:true,
		value:true
	},
		
	validImgElementAttributes: {
		id:true,
		className:true,
		src:true,
		width:true,
		height:true,
		title:true,
		alt:true
	},
	
	xObj: null,
	
	uniqueElementIdCount: 0, // used with getUniqueElementId
	
	getUniqueElementId: function() {
		
		var i = util.uniqueElementIdCount + 1;
		
		while (document.getElementById('ueid_' + i)) {
			i++;
		}
		
		// set global ueid count to new i
		
		util.uniqueElementIdCount = i;
		
		return 'ueid_' + i;
	},
	
	userAgent: {
		
		isIE: false,
		isIE6: false,
		name: '',
		
		init: function() {
			
			// returns the user agent brand
	
			var userAgentString = navigator.userAgent.toLowerCase();
			var userAgentAppName = navigator.appName.toLowerCase();
			var brand;
			
			// Note, Interent Explorer may contain multiple versions (8.0 and 6.0!) as this one:
			// -mozilla/4.0 (compatible; msie 8.0; windows nt 5.2; wow64; trident/4.0; mozilla/4.0 (compatible; msie 6.0; windows nt 5.1; sv1) ; .net clr 2.0.50727; .net clr 3.0.04506.30; .net clr 3.0.4506.2152; .net clr3.5.30729)
			// Consider this when checking for isIE6!
			
			if (userAgentString.indexOf('safari') != -1) {
				util.userAgent.name = 'safari';
			}
			else if (userAgentString.indexOf('opera') != -1) {
				util.userAgent.name = 'opera';
			}
			else if (userAgentAppName == 'netscape') {
				util.userAgent.name = 'netscape';
			}
			else if (userAgentAppName == 'microsoft internet explorer') {
				util.userAgent.name = 'msie';
				util.userAgent.isIE = true;
				
				// Check if this is Internet Explorer Version 6
				// (Regular Expression as defined in MSDN - Detecting Internet Explorer More Effectively)
				var re = new RegExp("msie ([0-9]{1,}[\.0-9]{0,})");
				var ieVersion = -1;
				if (re.exec(userAgentString) != null) {
					ieVersion = parseFloat(RegExp.$1);
				}
				
				// alert('ieVersion: ' + ieVersion);
				
				if (ieVersion >= 6.0 && ieVersion < 7.0) {
					util.userAgent.isIE6 = true;
				}
			}
			else {
				util.userAgent.name = 'unknown';
			}
			
			// alert('util.userAgent.isIE: ' + util.userAgent.isIE + '\nutil.userAgent.isIE6: ' + util.userAgent.isIE6 + '\nutil.userAgent.name: ' + util.userAgent.name);
		}
	},
	
	trim: function(theString) {
		// removes leading and trailing white space
		theString = theString.replace(/^\s+/, '');
		theString = theString.replace(/\s+$/, '');
		return theString;	
	},
	
	isBoolean: function(a) {
    	return typeof a == 'boolean';
	},
	
	isObject: function(a) {
	 	return (a && typeof a == 'object') || util.isFunction(a);
	},
	
	isFunction: function(a) {
		 return typeof a == 'function';
	},
	
	isArray: function(a) {
		
		return util.isObject(a) && a.constructor == Array;
	},
	
	isUndefined: function(a) {
		return typeof a == 'undefined';
	},
	
	
	isInteger: function(a, /* optional */ min, /* optional */ max) {
		
		var pattern = /^[-]?\d+$/;
		
		if (a != '' && pattern.test(a)) {
			
			var minIsValid = true;
			var maxIsValid = true;
			
			if (!util.isUndefined(min)) {
				if (parseInt(a, 10) < parseInt(min, 10)) {
					minIsValid = false;
				}
			}
			
			if (!util.isUndefined(max)) {
				if (parseInt(a, 10) > parseInt(max, 10)) {
					maxIsValid = false;
				}
			}
			
			if (minIsValid && maxIsValid) {
				return true;
			}
		}
		
		return false;
	},
	
	isFloat: function(a, min, max) {
		
		var pattern = /^[-]?\d*\.?\d*$/;
		
		if (a != '' && pattern.test(a)) {
			
			var minIsValid = true;
			var maxIsValid = true;
			
			if (!util.isUndefined(min)) {
				if (parseFloat(a) < parseFloat(min)) {
					minIsValid = false;
				}
			}
			
			if (!util.isUndefined(max)) {
				if (parseFloat(a) > parseFloat(max)) {
					maxIsValid = false;
				}
			}
			
			if (minIsValid && maxIsValid) {
				return true;
			}
		}
		
		return false
	},
	
	isRegularExpression: function(s) {
		
		if (s != '') {
		
			try {
				var obj = new RegExp(s);
				return true;
			}
			catch(e) {
				return false;
			}
		}
		
		return false;
	},
	
	isEmailAddress: function(s) {
		
		// Returns true if s is a valid email address in the format:
		// 'username@hostname' || '<username@hostname>' || 'display name <username@hostname>'
	
		// pattern1 matches: 'display name <username@hostname>' || '<username@hostname>'
		// pattern2 matches: 'username@hostname'
		
		var pattern1 = /^.*<\w[-.&\w]+@[-a-z0-9]+(\.[-a-z0-9]+)*\.[a-z]{2,}>$/;
		var pattern2 = /^\w[-.&\w]+@[-a-z0-9]+(\.[-a-z0-9]+)*\.[a-z]{2,}$/;
		
		// alert('s: ' + s + '\nmatched pattern1: ' + s.match(pattern1) + '\nmatched pattern2: ' + s.match(pattern2));
		
		var isValid = (pattern1.test(s) || pattern2.test(s));

		return isValid;
	},
	
	getE: function(elementId) {
		
		// get element reference
		
		return document.getElementById(elementId);
	},
	
	focusE: function(elementId) {
		
		var element = util.getE(elementId);
		if (element) {
			element.focus();
		}
		else {
			alert('focusE(), element with id "' + elementId + '" \ndoes not exist.');
		}
	},

	enableE: function(elementList, /* optional */ enableElement) {
		
		if (typeof enableElement === 'undefined') {
			enableElement = true;
		}
		
		util.enableDisableElement(elementList, !enableElement);
	},
	
	
	disableE: function(elementList, /* optional */ disableElement) {
		
		if (typeof disableElement === 'undefined') {
			disableElement = true;
		}
		
		util.enableDisableElement(elementList, disableElement);
	},
	
	enableDisableElement: function(elementList, isDisabled) {
		
		var a = [];
		if (!util.isArray(elementList)) {
			a[0] = elementList;
		}
		else {
			a = elementList;
		}
		
		for (var i = 0; i < a.length; i++) {
						
			var element = util.getE(a[i]);
			
			if (element) {
				
				element.disabled = isDisabled;
			}
			else {
				
				alert('enableDisableElement(), element with id "' + a[i] + '" \ndoes not exist.');	
			}
		}
	},
	
	showEV: function(elementList, /* optional */ showElement) {
		// show Elements visibility
		if (typeof showElement === 'undefined') {
			showElement = true;
		}
	
		util.showHideElementVisibility(elementList, showElement);
	},
	
	hideEV: function(elementList, /* optional */ hideElement) {
		// hide Elements visibility
		if (typeof hideElement === 'undefined') {
			hideElement = true;
		}
	
		util.showHideElementVisibility(elementList, !hideElement);
	},
	
	showHideElementVisibility: function(elementList, displayElement) {
		
		var a = [];
		if (!util.isArray(elementList)) {
			a[0] = elementList;
		}
		else {
			a = elementList;
		}
		
		// alert('showHideElementVisibility displayElement: ' + displayElement);
				
		for (var i = 0; i < a.length; i++) {
						
			var element = util.getE(a[i]);
					
			if (element) {
				var visibility = displayElement ? 'visible' : 'hidden';
				element.style.visibility = visibility;
			}
			else {
				alert('showHideElementVisibility(), element with id "' + a[i] + '" \ndoes not exist.');						
			}
		}
	},
	
	showE: function(elementList, /* optional */ showElement) {
		// Use only for display, not for visibility
		if (typeof showElement === 'undefined') {
			showElement = true;
		}
		
		util.showHideElement(elementList, showElement);
	},
	
	hideE: function(elementList, /* optional */ hideElement) {
		// Use only for display, not for visibility
		if (typeof hideElement === 'undefined') {
			hideElement = true;
		}

		util.showHideElement(elementList, !hideElement);
	},
	
	showHideElement: function(elementList, displayElement) {
		
		var a = [];
		if (!util.isArray(elementList)) {
			a[0] = elementList;
		}
		else {
			a = elementList;
		}
		
		// alert('elementList 2: ' + elementList);
				
		for (var i = 0; i < a.length; i++) {
						
			var element = util.getE(a[i]);
		
			if (element) {
	
				var elementType = element.nodeName;
				var displayType;
				
				if (displayElement) {
					
					displayType = (elementType != 'TD' && elementType != 'TR' && elementType != 'TBODY' && elementType != 'LI') ? 'block' : '';
				}
				else {
					displayType = 'none';
				}
				
				if (element.style.display != displayType) {
					element.style.display = displayType;
				}
			}
			else {
				alert('showHideElement(), element with id "' + a[i] + '" \ndoes not exist.');						
			}
		}
	},
		
	setF: function(elementId, theValue) {
		
		// set Form Value
		
		var element = document.getElementById(elementId);
		
		if (element) {
			var elementType = element.nodeName;
			
			// alert(elementType);
			
			switch (elementType) {
				
				case 'INPUT' :
				
					var typeAttr = element.type;
				
					if (typeAttr == 'text' || typeAttr == 'hidden') {
						
						element.value = theValue;
					}
					else if (typeAttr == 'checkbox' || typeAttr == 'radio') {
						
						element.checked = theValue;
					}
					else if (typeAttr == 'password') {
						
						// A password field can only be set when dynamically created
						// and by setting its value before appending it to the document.
						// Hence we create a new password field, set its value and replace 
						// it with the existing one.
						
						var elementWidth = element.style.width;
						var containerElement = element.parentNode;
	
						// delete existing password element
						containerElement.removeChild(element);
					
						// create new password element
						var newPasswordElement = document.createElement('input');
						newPasswordElement.type = 'password';
						newPasswordElement.id = elementId;
						newPasswordElement.value = theValue;
						newPasswordElement.style.width = elementWidth;
						containerElement.appendChild(newPasswordElement);
					}
					break;
				
				case 'SELECT' :
								
					var options = element.options;
					
					for (var i = 0; i < options.length; i++) {
						
						// alert(options[i].value);
						
						if (options[i].value == theValue) {
							options[i].selected = true;
							break;
						}
					}
					
					break;
				
				case 'TEXTAREA' :
				
					element.value = theValue;
					break;
			}
		}
		else {
			alert('setFormValue(), element with id "' + elementId + '" \ndoes not exist.');
		}	
	},	
	
	getF: function(elementId, /* optional */ trimFormValue) {
		
		// get Form Value
		
		var element = document.getElementById(elementId);
		var theValue;
		
		if (element) {
			
			var elementType = element.nodeName;
			
			// Set default trimFormValue if undefined
			if (typeof trimFormValue === 'undefined') {
				trimFormValue = true;
			}
			
			switch (elementType) {
				
				case 'INPUT' :
				
					var typeAttr = element.type;
				
					if (typeAttr == "text" || typeAttr == 'hidden' || typeAttr == 'password') {
						
						theValue = trimFormValue ? util.trim(element.value) : element.value; 
					}
					else {
						
						theValue = element.checked;
					}
					break;
				
				case 'SELECT' :
				
					var i = element.selectedIndex;
					theValue = (i != -1) ? element.options[i].value : '';
					break;
					
				case 'TEXTAREA' :
				
					theValue = trimFormValue ? util.trim(element.value) : element.value;
					break;
			}
			
			return theValue;
		}
		else {
			
			alert('getF(), element with id "' + elementId + '" \ndoes not exist.');
		}
	},
	
	resetF: function(elementList) {
		
		// Resets a form element, argument is a single form element Id or an array with form element Id's
		
		var a = [];
		if (!util.isArray(elementList)) {
			a[0] = elementList;
		}
		else {
			a = elementList;
		}
				
		for (var i = 0; i < a.length; i++) {
						
			var element = util.getE(a[i]);
			
			if (element) {
				
				element.reset();
			}
			else {
				alert('resetF(), element with id "' + a[i] + '" \ndoes not exist.');
			}
		}
	},
	
	populateSelect: function(elementId, theList, valueKey, textKey) {
		
		// Populates a select element. theList is an array with objects
		
		var element = document.getElementById(elementId);
		
		if (element) {
			
			// util.showObject(theList);
			
			element.options.length = 0;
			
			for (var i = 0; i < theList.length; i++) {
				element.options[i] = new Option(theList[i][textKey], theList[i][valueKey], false, false);
			}						
		}
		else {
			alert('populateSelect(), element with id "' + elementId + '" \ndoes not exist.');
		}
	},
	
	extendSelect: function(elementId, theList, valueKey, textKey) {
		
		// This adds aditional options to a select element which is already populated
		
		var element = document.getElementById(elementId);
		
		if (element) {
			
			for (var i = 0; i < theList.length; i++) {
				element.options[element.options.length] = new Option(theList[i][textKey], theList[i][valueKey], false, false);
			}						
		}
		else {
			alert('extendPopulatedSelect(), element with id "' + elementId + '" \ndoes not exist.');
		}
	},
	
	getSelectOptionText: function(elementId) {
		
		// returns the text of the selected option in a select element
		
		var text = '';
		var element = util.getE(elementId); 
		
		if (element && (element.selectedIndex >= 0)) {
		
			text = element.options[element.selectedIndex].text;
		}
		
		return text;
	},
	
	getEncodedURIComponent: function(theValue) {
	
		// returns an encoded URI component value if theValue contains special characters
		
		var pattern = /\W/; // The pattern /\W/ is equal [^a-zA-Z0-9_]
		
		if (pattern.test(theValue)) {
			theValue = encodeURIComponent(theValue);
		}
	
		return theValue;
	},
	
	getRepetitionSequenceLetter: function(theSequence, theIndex) {
		
		// theSequence is an array, i.e. the latin alphabet ['A', 'B', 'C', ...]
		// theIndex is an integer which refers a letter in theSequence. 
		// We return theSequence value.
		// If theIndex is equal or greater the length of theSequence then we extend theSequence
		// by adding duplicates of the initial sequence, so the sequence becomes:
		// ['A', 'B', 'C', ..., 'Z', 'AA', 'BB', 'CC', ..., 'ZZ', 'AAA', 'BBB', 'CCC', ... 'ZZZ', 'AAAA', ...]
		
		var numberOfSequenceItems = theSequence.length;
		
		if (theIndex < numberOfSequenceItems) {
			return theSequence[theIndex];
		}
		else {
			// Return a repetition of a single letter
			var repetitionFactor = Math.floor(theIndex / numberOfSequenceItems) + 1;
			var theIndexWhichFits = theIndex % numberOfSequenceItems;
			var theLetter = theSequence[theIndexWhichFits];
			var theLetterRepetition = '';
			for (var i = 0; i < repetitionFactor; i++) {
				theLetterRepetition += theLetter;
			}
			
			return theLetterRepetition
		}
	},
	
	createHash: function(theArray, theKey) {
		
		// Note, all hash values are in uppercase so that names such as "length" don't conflict with javascript
			
		var hasKey = (theKey != null) ? true : false;
				
		for (var i = 0; i < theArray.length; i++) {
			
			if (hasKey) {
				// var s = theArray[i][theKey].toUpperCase();
				var s = '__h__' + theArray[i][theKey];
				theArray[s] = theArray[i];
			}
			else {
				// var s = theArray[i].toUpperCase();
				var s = '__h__' + theArray[i];
				theArray[s] = theArray[i];
			}
		}
	},
	
	h: function(name) {
		// converts a hash name to the above hash format
		// return name.toUpperCase();
		return '__h__' + name;
	},
	
	/*
	createNewKeyValue: function(the_array, the_key) {
		
		// creates and returns a unique node name
		
		// create lookup
		var a = [];
		for (var i = 0; i < the_array.length; i++) {
			var theValue = the_array[i][the_key];
			a[theValue] = true;
		}
		
		// create new unique key value
		
		var isUnique = false;
		var count = 0;
		
		while (!isUnique) {
			count++;
			var newKeyValue = "new" + count;
			if (!a[newKeyValue]) {
				isUnique = true;
			}
		}
		return newKeyValue;
	},
	*/
	
	getArrayObject: function(theArray, theKey, theValue) {
		
		// returns an object reference from theArray where theKey has the value theValue
		var obj = {};
		for (var i = 0; i < theArray.length; i++) {
			if (theArray[i][theKey] == theValue) {
				obj = theArray[i];
				break;
			}
		}
		return obj;
	},
	
	getArrayObjectIndex: function(theArray, theKey, theValue) {
		
		// returns the index of the specified object
		for (var i = 0; i < theArray.length; i++) {
			if (theArray[i][theKey] == theValue) {
				return i;
			}
		}
	},
	
	getNextArrayObject: function(theArray, theKey, theValue) {
		
		// returns the next object of the given object in the array. If there is no next
		// object it will return the previous object. If there is no next or
		// previous object it will return null.
		
		var nextObject = null;
		var numberOfObjects = theArray.length;
		
		if (numberOfObjects > 1) {
			
			// get position of given object
			
			for (var i = 0; i < numberOfObjects; i++) {
				
				if (theArray[i][theKey] == theValue) {
					break;
				}
			}
			
			var nextIndex;
			
			if (i < (numberOfObjects - 1)) {
				nextIndex = i + 1;
			}
			else {
				nextIndex = i - 1;
			}
			
			nextObject = theArray[nextIndex];
		}
		
		return nextObject;
	},
	
	deleteArrayObject: function(theArray, theKey, theValue) {
		
		// Delete the object from theArray where theKey has the value theValue.
		// Ignore deletion if the object does not exist
		
		// get index of object to delete
		var objExists = false;
		
		for (var i = 0; i < theArray.length; i++) {
			
			if (theArray[i][theKey] == theValue) {
				objExists = true;
				break;
			}
		}
		
		// alert('index to delete: ' + i);
		
		if (objExists) {
			theArray.splice(i, 1);
		}
	},
	
	cloneObject: function(oriValue) {
		
		// returns a true copy of an array or object
		
		if (util.isArray(oriValue)) {
			
			// alert('isArray');
			
			var newValue = [];
			
			for (var i = 0; i < oriValue.length; i++) {
				
				newValue[i] = util.cloneObject(oriValue[i]);
			}
		}
		else if (util.isObject(oriValue)) {
			
			// alert('isObject');
			
			var newValue = {};
			
			for (var prop in oriValue) {
				
				newValue[prop] = util.cloneObject(oriValue[prop]);
			}
		}
		else {
			// no oject or array, return oriValue
			// alert('return oriValue');
			var newValue = oriValue;
		}
		
		// util.showObject(newValue);
		
		return newValue;
	},
	
	removeChildElements: function(s /* s is an elementID or an element*/) {
		
		var element = util.isObject(s) ? s : util.getE(s);
		
		while (element.lastChild) {
			var childElement = element.lastChild;
			element.removeChild(childElement);
		}
	},
	
	createE: function(elementType, attributes) {
		
		// Creates an element. attributes and labelText are optional arguments.
		// Note, attributes may contain html attributes and style attributes,
		// we check for differences here
		// I.e.:
		// util.createE('div');
		// util.createE('input', {id:id, type:'checkbox'});
		// util.createE('input', {id:id, type:'checkbox'}, {paddingLeft:'14px', margin:'5px'});
		
		var element = document.createElement(elementType);
		
		if (attributes != null) {
			
			var validAttributes = (elementType != 'img') ? util.validHtmlElementAttributes : util.validImgElementAttributes;
			
			for (var prop in attributes) {
				
				if (validAttributes[prop]) {
					// Apply element attribute
					element[prop] = attributes[prop];
				}
				else {
					// Apply element style attribute
					element.style[prop] = attributes[prop];
				}
			}
		}
		
		return element;
	},
	
	createT: function(s) {
		
		// Creates a new text node
		
		if (s == '&nbsp;') {
			s = '\u00a0';
		}
		
		return document.createTextNode(s);
	},

	updateT: function(elementId, text) {
		
		// Replaces any existing text of the element or creates a new text node if it does not yet exist
		
		var element = document.getElementById(elementId);
		
		if (element) {
			
			// alert('updateT() - element with text: ' + text);
						
			if (text == 0) {
				// alert('the text: ' + text + '\nis interpreted as the number 0');
				text = '0';
			}
			else if (text == '&nbsp;') {
				// alert('the text: ' + text + '\nis interpreted as space');
				text = '\u00a0'; // &nbsp;
			}
			
			var newText = document.createTextNode(text);
			
			if (element.firstChild) {
				// replace existing text
				var oldText = element.firstChild;
				element.replaceChild(newText, oldText);
			}
			else {
				// append new text
				element.appendChild(newText);
			}
		}
		else {
			alert('updateT() - element with elementId "' + elementId + '" does not exist.');
		}
	},	
			
	chainE: function(/* html elements */) { // accepts any number of arguments
		
		// Chain elements appends the given html elements in two different ways
		
		// a.) Cascading (html elements are not given in an array)
		// Each previous element is the parent element, i.e.:
		// util.chainE(div, p, span, text);
		// span is the parent of text, p is the parent of span, div is the parent of p
		
		// b.) Tree (html elements are given in an array)
		// The first element of the array is the parent element, all following
		// elements in the array are appended to the 1st array element, i.e.:
		// util.chainE([div, p1, p2, p3, p4]);
		// All p elements (1-4) are appended to the 1st div element
		
		// Cascading and Tree can be combined, i.e.:
		// util.chainE(table, [tbody, [tr1, td1, text1], [tr2, td2, text2]]);
		// Arbitrary nesting of tree like arrays is allowed.
		
		
		var numberOfArguments = arguments.length;
		
		if (numberOfArguments > 1) {
		
			for (var i = numberOfArguments - 1; i > 0; i--) {
				
				var parentElement = arguments[i - 1];
				var childElement = arguments[i];
				
				if (util.isArray(parentElement)) {
					parentElement = util._chainElementsTreeLike(parentElement);
				}
				
				if (util.isArray(childElement)) {
					childElement =  util._chainElementsTreeLike(childElement);
				}
				
				// alert('chainE()' + '\nparentElement: ' + parentElement + '\nchildElement: ' + childElement);
				
				parentElement.appendChild(childElement);
			}
		}
		else {
			// There is only one argument, this must be an array to which we apply _chainElementsTreeLike()
			
			var element = util._chainElementsTreeLike(arguments[0]);
			// The var element is not required in this case, its just a placeholder for the returned element
		}
		
		// alert('chainE() completed' );
	},
	
	_chainElementsTreeLike: function(elements) {
		
		// See chainE() for details
		
		// alert('_chainElementsTreeLike(): ' + elements);
		
		var parentElement = elements[0];
		
		if (util.isArray(parentElement)) {
			parentElement = util._chainElementsTreeLike(parentElement);
		}
		
		for (var i = 1; i < elements.length; i++) {
			
			var childElement = elements[i];
			
			if (util.isArray(childElement)) {
				childElement = util._chainElementsTreeLike(childElement);
			}
			
			parentElement.appendChild(childElement);
		}
		
		// alert('We return parentElement: ' + parentElement);
		
		return parentElement;
	},

	setConfigItemListHeight: function() {
		
		var config_item_list_body = document.getElementById('config_item_list_body');
		
		// alert('setConfigItemListHeight(): ' + config_item_list_body);
	
		var pos = YAHOO.util.Dom.getXY('config_item_list_body');
		var configItemListY = pos[1];
		var clientY = YAHOO.util.Dom.getClientHeight();
		
		var configItemListHeight = clientY - (configItemListY + 40);
		
		config_item_list_body.style.height = configItemListHeight + 'px';
	},
	
	//
	// Encoding
	//
	
	/* Disabled - It looks like that the backslashes escaping problem only exists
	for File Manager, respectively the problem only exists when using GET, so 
	when a pathname, i.e. C:\_logs\2007\, is part of the URL
	encodeDat: function(s) {
		
		// Encodes a string send from the client to the server via GET or POST
		// Note that we escape backslashes because Salang thinks we are escaping
		// something.
		s = s.replace(/\\/g, '\\');
		s = encodeURIComponent(s);
		
		return s;
	},
	*/
	
	//
	// Serever background calls
	//
	
	serverPost: function(url, dat) {
		
		// dat is optional
		
		// add volatile node for error handling
		if (dat) {
			dat += '&volatile.is_server_background_call=true';
		}
		else {
			var dat = 'volatile.is_server_background_call=true';
		}
		
		// var xObj = util.XMLHttpObject;
				
	    // native XMLHttpRequest object
	    if (window.XMLHttpRequest) {
	        util.xObj = new XMLHttpRequest();
	        // util.xObj.onreadystatechange = process_response;
	        util.xObj.onreadystatechange = util.serverPostResponse;
	        util.xObj.open("POST", url, true);
	        util.xObj.send(dat);
	    } // IE ActiveX version
	    else if (window.ActiveXObject) {
	        util.xObj = new ActiveXObject("Microsoft.XMLHTTP");
	        if (util.xObj) {
	            // util.xObj.onreadystatechange = process_response;
	           	util.xObj.onreadystatechange = util.serverPostResponse;
	            util.xObj.open("POST", url, true);
	            util.xObj.send(dat);
	        }
	    }
	},
	
	serverPostResponse: function() {
			
		if (util.xObj.readyState == 4) {
			
			if (util.xObj.status == 200) {
		
				// alert(util.xObj.getAllResponseHeaders());
				// alert(util.xObj.responseText);
				// alert(util.xObj.responseXML);
				
				eval('(' + util.xObj.responseText + ')');
				
				
				/* DISABLED try and catch because it does not allow detailed debugging with Firebug
				try {
				
					eval('(' + util.xObj.responseText + ')');
				}
				catch (ex) {
					
					alertMsg = 'Inavlid response from server.\n\nServer response text:\n\n';
					alertMsg += util.xObj.responseText;
					alertMsg += '\n\n JavaScript error message:\n\n' + ex;
					
					alert(alertMsg);
				}
				*/
			}
		}
	},
	
	authenticationFailureInServerBackgroundCall: function(dat) {
		
		// alert('authenticationFailureInServerBackgroundCall');
		alert(dat.errorMessage);
		
		// reload the current page so that we get the login form
		location.reload();
	},
	
	labelToNodeName: function(label) {
		
		// returns a valid node name of label or empty '' if the label contains no single alphanumerical character
		
		var label = label.toLowerCase();
		var nodeName = '';
		var pattern = /[a-z0-9]/;
		
		if (pattern.test(label)) {
			
			// alert(label + ' Matched!');
			
			pattern = /[_a-z0-9]/;
			
			for (var i = 0; i < label.length; i++) {
				
				var s = label.charAt(i);
				var sUnicode = s.charCodeAt(0);
				// alert(s);\
				
				if (!pattern.test(s)) {
					
					if (sUnicode < 128) {
					
						s = '_';
					}
					else {
						// covert to hex
						s = sUnicode.toString(16);
					}
				}
				
				nodeName += s;
			}
		}
		
		return nodeName;
	},
	
	labelToUniqueNodeName: function(label, existingNodeNames, nodeNamePrefix) {
		
		// Returns a valid and unique node name.
		// The nodeNamePrefix is used as name in case that the label does not contain any alphanumerical English characters.
		
		var i;
		var s;
		var nodeNameLookup = {};
		
		// Create nodeNameLookup
		// nodeNameLookup is an object in the format
		// o._name1 = true
		// o._name2 = true
		// the starting underscore "_" is not part of the node name but added to avoid any name conflicts
	
		for (i = 0; i < existingNodeNames.length; i++) {
			nodeNameLookup['_' + existingNodeNames[i]] = true;
		}
		
		
		var newNodeName = util.labelToNodeName(label);
		
	
		if (newNodeName != '') {
			
			i = 1;
			s = '';
		}
		else {
			
			// The label does not contain any alphanumerical characters.
			// Give it the node name prefix
		
			newNodeName = nodeNamePrefix;
			i = 1;
			s = '_' + i;
		}
		
		while (nodeNameLookup['_' + newNodeName + s]) {
			i++;
			s = '_' + i;
		}
			
		newNodeName = newNodeName + s;
		
		return newNodeName;
	},
	
	arrayToString: function(a) {
		
		var s = "";
		
		for (var i = 0; i <a.length; i++) {
			
			var obj = a[i];
			
			for (var prop in obj) {
				
				s += "{" + prop + ":" + obj[prop] + "}";
			}
		}
		
		return s;
	},
	
	setTabBarSpace: function(parentElementId, spacerCellId) {
		
		// Sets the space of a tab-bar if the tab-bar consists of GUI controls on the right side
		// so that the tab-bar table expands to the length of the parent panel.
		// The spacer cell is a td element between the left tabs and right GUI controls.
		
		var region = yDom.getRegion(parentElementId);
		var parentElementWidth = region.width;
	
		var cellElement = util.getE(spacerCellId);
		var table = cellElement.parentNode;
		var tableRegion = yDom.getRegion(table);
		var tableWidth = tableRegion.width;
		
		// alert('parentElementWidth: ' + parentElementWidth + '\ntableWidth: ' + tableWidth);
		
		var deltaWidth = parentElementWidth - tableWidth;
		
		if (deltaWidth > 0) {
			// We apply a padding so that the table width can flow upon text sizing!
			cellElement.style.paddingLeft = deltaWidth + 'px';
		}
	},
	
	//
	// Date
	//
	
	salangDateToSimpleDateObject: function(salangDate) {
	
		// converts a salang date, i.e. 18/Jan/2006 to a javascript object in the format
		// o.year = 2006
		// o.month = 0
		// o.day = 18
		
		var salangJsMonths = {jan:0, feb:1, mar:2, apr:3, may:4, jun:5, jul:6, aug:7, sep:8, oct:9 ,nov:10, dec:11};
		var dat = salangDate.split('/');
		
		// util.showObject({"salangDateToSimpleDateObject() - salangDate argument": salangDate});
		// util.showObject({"salangDateToSimpleDateObject() - dat": dat});
		
		var obj = {};
				
		obj.year = parseInt(dat[2], 10);
		obj.month = salangJsMonths[dat[1].toLowerCase()];
		obj.day = parseInt(dat[0], 10); // make sure the radix of base 10 is defined so that i.e. "08" isn't converted to "0" which could occur in ECMAScript v3
		
		// util.showObject({"salangDateToSimpleDateObject() - obj": obj});
		
		return obj;
	},
	
	
	//
	//
	// File manager window
	//
	//
	
	fileManagerWindow: {
		
		theWindow: null,
		
		open: function(pathnameElementId) {
			
			// alert('util.fileManagerWindow.open()');
			
			var url = '?dp+templates.file_manager.file_manager_page';
			url += '+volatile.sys.pathname_element_id+' + encodeURIComponent(pathnameElementId);
			
			var windowName = 'file_manager';
			var width = 700;
			var height = 480;
		
			// check if a path is defined in the pathname field
			// if a path exists then start the file manager with the defined path
			var pathname = util.getF(pathnameElementId);
			
			// alert('pathname not encoded: ' + pathname);
				
			if (pathname != '') {
						
				// pathname = pathname.replace(/\$/g, '__HexEsc__24');
				pathname = pathname.replace(/\\/g, '__HexEsc__5C');
				
				// alert(pathname);
				url += '+volatile.sys.default_pathname+' + encodeURIComponent(pathname);
			}
			
			var left = parseInt((screen.availWidth/2) - (width/2), 10);
		    var top = parseInt((screen.availHeight/2) - (height/2), 10);
		    
			util.fileManagerWindow.theWindow = window.open(url,windowName,'location=no,width=' + width + ',height=' + height + ',left=' + left + ',top=' + top + ',status=yes,scrollbars=yes,resizable=yes');
		    util.fileManagerWindow.theWindow.focus();
		},
		
		setPathnameValue: function(pathnameElementId, pathname) {
			
			// This function is initiated from file manager,
			// it sets the pathname element to the given pathname
			util.setF(pathnameElementId, pathname);
		}
	},
	
	
	//
	//
	// Help window
	//
	//
	
	helpWindow: {
		
		theWindow: null,
		centralUrl: '?dp+docs.technical_manual.toc',
		contextUrl: '', // Set upon init, the link refers to a specific topic group, i.e. Log Filters or Reports
		
		init: function(contextUrl) {
			
			// alert('helpWindow.init()');
								
			yEvent.addListener('central_help_btn', 'click', util.helpWindow.openCentralHelp);
			
			if (contextUrl && contextUrl != '') {
				util.helpWindow.contextUrl = contextUrl;
				yEvent.addListener('context_help_btn', 'click', util.helpWindow.openContextHelp);
			}
		},
		
		openCentralHelp: function(evt) {
						
			// Opens the help window via central help button
			yEvent.preventDefault(evt);
			util.helpWindow.open(util.helpWindow.centralUrl);
		},
		
		openContextHelp: function(evt) {
						
			// Opens the help window via toolbar context help button
			yEvent.preventDefault(evt);
			util.helpWindow.open(util.helpWindow.contextUrl);
		},
		
		openGeneralHelp: function(evt) {
						
			// Opens the help window from any link in the GUI. The URL must be specified
			// as regular anchor because we get the URL from this anchor.
			
			yEvent.preventDefault(evt);
			var element = evt.target || evt.srcElement;
			var url = element.href;
			util.helpWindow.open(url);
		},
		
		open: function(url) {
					
			var width = yDom.getViewportWidth() - 120;
			var height = yDom.getViewportHeight() - 60;
			var features = 'width=' + width + ',height=' + height + ',location=yes,menubar=yes,toolbar=yes,status=yes,scrollbars=yes,resizable=yes';
			
			util.helpWindow.theWindow = window.open(url, 'help', features);
			util.helpWindow.theWindow.focus();
		}
	},
	
	//
	//
	// About
	//
	//
	
	about: {
		
		isDisplayed: false,
		
		toggleAboutSection: function() {
			
			var showAboutSection = !util.about.isDisplayed;
			util.showE('product_bar:about_section', showAboutSection);
			util.about.isDisplayed = showAboutSection;
		}
	},
	
	//
	//
	// Error / Alert handling
	//
	//
	
	errorInServerBackgroundCall: {
		
		panel: null,
		
		init: function() {
			
			//
			// Create the error panel
			//
			
			var panelId = 'error_in_server_background_call:panel';
			
			
			var bodyElements = document.getElementsByTagName('body');
			var body = bodyElements[0];
			
			var mainDiv = util.createE('div', {id:panelId, className:'panel-50'});
			
			util.chainE(body, mainDiv);
			
			// We create the alert panel via innerHTML because it doesn't correctly render
			// when creating it via DOM elements in Firefox
			var htmlString = '<div class="panel-50-body">';
			
			htmlString += '<div class="panel-50-form" style="width:340px;background-color:White">';
			// htmlString += '<strong style="color:Red">' + langVar('lang_stats.error_handling.error_while_processing_last_request') + '</strong>';
			htmlString += '<p style="font-weight:bold;color:Red">' + langVar('lang_stats.error_handling.error_while_processing_last_request') + '</p>';
			
			htmlString += '<a id="error_in_server_background_call:view_alert_msg_btn" href="?dp=alert" target="_blank">';
			htmlString += langVar('lang_stats.error_handling.click_here_to_view_alert_msg');
			htmlString +=  '</a>';
			htmlString += '</div>'; // panel-50-form
			
			htmlString += '<div style="text-align:center;padding:12px"><a id="error_in_server_background_call:close_alert_btn" href="javascript:;">';
			htmlString += langVar('lang_stats.btn.close');
			htmlString +=  '</a></div>';
			
			
			htmlString += '</div>'; // panel-50-body
			
			mainDiv.innerHTML = htmlString;			
			
			//
			// Init the error panel object
			//
			
			var panelObj = {
				panelId: panelId,
				panelClassName: 'panel-50',
				panelHeaderLabel: langVar('lang_stats.error_handling.product_alert_info'),
				left: 60,
				top: 60,
				zIndex: 5000,
				isCover: true,
				isCloseButton: false
			};
			
			util.errorInServerBackgroundCall.panel = new util.Panel3(panelObj);
			
			yEvent.addListener('error_in_server_background_call:close_alert_btn', 'click', util.errorInServerBackgroundCall.close);
		},
		
		open: function(alertId) {
			
			if (!util.errorInServerBackgroundCall.panel) {
				util.errorInServerBackgroundCall.init();
			}
			
			var viewAlertBtn = util.getE('error_in_server_background_call:view_alert_msg_btn');
			viewAlertBtn.href = '?dp=alert&ai=' + alertId;
			
			util.errorInServerBackgroundCall.panel.open();
		},
		
		close: function() {
			
			util.errorInServerBackgroundCall.panel.close();
			
			// If this is the New Profile Wizard window
			// then restore the new profile wizard page
			
			try {
				restoreNewProfileWizardPageAfterError();
			}
			catch(msg) {}
		}
	},

	
	//
	// Trial mode utilities
	//
	
	trialMode: {
		
		// btn: null,
		
		init: function() {
		
			// Init the Change Trial Mode button
			// util.trialMode.btn = new util.CommandLink('change_trial_mode:btn', util.trialMode.setMenu, true);
			var a = [
				'prompt_for_trial_tier:lite',
				'prompt_for_trial_tier:pro',
				'prompt_for_trial_tier:advanced',
				'prompt_for_trial_tier:enterprise'
			];
			
			yEvent.addListener(a, 'click', util.trialMode.changeMode);
			// util.trialMode.btn.enable();
			// yEvent.addListener(document, 'unload', util.trialMode.exit);
			
			// Enable dropDownMenu
			util.dropDownMenu.add('change_trial_mode:btn', 'prompt_for_trial_tier:drop_down');
		},
		
		exit: function() {
			
			// alert('exit trial mode');
			// util.trialMode.btn.disable();
		},
		
		changeMode: function() {
			
			var elementId = this.id;
			
			// Check if we have any unsaved changes on the current page
			
			if (adminConfig.getIsExitPagePermission()) {
			
				var bodyElements = document.getElementsByTagName('body');
				var bodyElement = bodyElements[0];
				bodyElement.style.display = 'none';
					
				// User clicked on a link to change the trial mode
				var dat = elementId.split(':');
				var trialMode = dat[1];
				
				// alert('change trial mode to: ' + trialMode);
				var url = '?dp+util.change_trial_mode';
				var dat = 'v.fp.page_token=' + pageInfo.changeTrialModeToken + '&';
				dat += 'v.fp.trial_mode=' + trialMode;
				util.serverPost(url, dat);
			}
		},
		
		changeModeResponse: function() {
			
			location.reload(true);
		}
	},
	
	
	//
	//
	//
	// MISCELLANEOUS
	//
	//
	//
	
	//
	//
	// showObject handling
	//
	//
	
	showObjectWindowId: '', // Used with showObject, keeps the showObjectWindowId
	
	createShowObjectWindow: function() {
		
		var bodyElements = document.getElementsByTagName('body');
		var body = bodyElements[0];
		
		var showObjectWindowId = util.getUniqueElementId();
		
		var mainDivProperties = {
			id:showObjectWindowId,
			position:'absolute',
			top:0,
			right:0,
			borderStyle: 'solid',
			borderWidth: '1px',
			borderColor: 'Silver',
			backgroundColor: 'White'
		};
		
		var objectDivProperties = {
			id:showObjectWindowId + ':body',
			width:'800px',
			height:'700px',
			overflow: 'scroll'
		}
		
		var mainDiv = util.createE('div', mainDivProperties);
		var headerDiv = util.createE('div', {padding:'4px', backgroundColor:'#f5f5f5'});
		var a = util.createE('a', {id:showObjectWindowId + ':close_btn', href:'javascript:;'});
		var aText = util.createT('Close Object Window');
		var objectDiv = util.createE('div', objectDivProperties);
		
		util.chainE(headerDiv, a, aText);
		util.chainE(body, [mainDiv, headerDiv, objectDiv]);
		
		yEvent.addListener(showObjectWindowId + ':close_btn', 'click', util.closeShowObjectWindow);
		
		util.showObjectWindowId = showObjectWindowId;
	},
	
	closeShowObjectWindow: function() {
		
		var showObjectWindowId = util.showObjectWindowId;
		
		// Clean object viewer
		util.removeChildElements(showObjectWindowId + ':body');
		util.hideE(showObjectWindowId);
	},
	
	showObject: function(obj, comment) {
		
		// showObject outputs objects to a debug window
		// The comment argument is optional
		
		if (util.showObjectWindowId == '') {
			
			util.createShowObjectWindow();
		}
		
		var showObjectWindowId = util.showObjectWindowId;
		
		// Create a new div which we append to the already existing object viewer
		var container = util.getE(showObjectWindowId + ':body');
		var div = util.createE('div', {padding:'0 14px', borderBottom:'1px solid Silver', zIndex: 5000});
		util.chainE(container, div);
		
		var text = '';
		
		if (comment) {
			text += '<strong>' + comment + '</strong><br />';
		}
		
		var objAsString = JSON.stringify(obj, null, '&nbsp;');
		
		text += '<pre>' + objAsString.replace(/\u000A/g, '<br />') + '</pre>';
		
		div.innerHTML = text;
		
		util.showE(showObjectWindowId);
	}
};

/*
	Button2 class (Initializes custom buttons with round corners)
*/

util.Button2 = function(buttonId, className, buttonEvent) {
	
	this.buttonId = buttonId;
	this.className = className
	this.isDisabled = true;
	
	var btn = util.getE(buttonId);
	btn.className = className;
	var btnLabel = btn.firstChild.nodeValue;
	
	// alert('btnLabel: ' + btnLabel);
	
	//
	// Add padding and fix short words by adding extra padding
	//
	
	// Don't add any padding to IE as it always adds is own padding!
	var padding = (!util.userAgent.isIE) ? 12 : 0;
			
	if (btnLabel.length < 6) {
		
		// We add some extra padding to each side,
		// which depends on the number of characters
		// (one character is about 9px in medium size)
		var missingChar = 6 - btnLabel.length;
		var paddingByMissingCharacters = [4, 8, 10, 14]; // padding defined for one side only (left/right)
		padding += paddingByMissingCharacters[missingChar - 1];
	}
		
	if (padding > 0) {
		btn.style.paddingLeft = padding + 'px';
		btn.style.paddingRight = padding + 'px';
	}
	
	// Attach the events
	yEvent.addListener(btn, 'click', buttonEvent);
	yEvent.addListener(btn, 'mouseover', this.hoverOn);
	yEvent.addListener(btn, 'mouseout', this.hoverOff);
}


util.Button2.prototype.enable = function() {
	
	this.enableDisable(true);
}

util.Button2.prototype.disable = function() {
	
	this.enableDisable(false);
}

util.Button2.prototype.enableDisable = function(enableButton) {
	
	// We don't change button state if it is already in desired state
	/*
	if (this.isEnabled != enableButton) {
			
		// update button state
		
		var buttons = this.buttonsDb;
		
		for (var i = 0; i < buttons.length; i++) {
							
			var element = util.getE(buttons[i].id);
			
			if (enableButton) {
				
				// alert('enable button: ' + buttons[i].id);
				
				yEvent.addListener(element, 'click', buttons[i].f);
				element.className = 'btn';
			}
			else {
				
				// alert('disable button: ' + buttons[i].id);
				
				yEvent.removeListener(element, 'click', buttons[i].f);
				element.className = 'btn-disabled';
			}
		}
		
		this.isEnabled = enableButton;
		
		// alert('this.isEnabled: ' + this.isEnabled);
	}
	*/
}

util.Button2.prototype.hoverOn = function() {
	
	// Note, this referes to the element object and not anymore to the Button object!
	// alert('this.id: ' + this.id + '\nthis.isDisabled: ' + this.isDisabled  + '\nthis.disabled: ' + this.disabled);

	if (!this.disabled) {
		this.className = this.className + '-hover';
	}
}

util.Button2.prototype.hoverOff = function() {
	
	if (!this.disabled) {
		var className = this.className;
		this.className = className.replace(/-hover$/, '');
	}
}


/*
	CommandLink (used for anchor buttons)
*/


util.CommandLink = function(elementId, buttonEvent, /*  optional */ isDisabled) {
	// isDisabled defines the default disabled state
	this.elementId = elementId;
	this.buttonEvent = buttonEvent;
	this.isDisabled = (typeof isDisabled !== 'undefined') ? isDisabled : false;
	
	// Set default className
	var btn = util.getE(elementId);
	
	// Get the baseClassName from the button element. The baseClassName does
	// not contain the "-disabled" word, so we have to remove it if the element
	//  has a default disabled state, i.e. "command-link-20-disabled"
	
	var baseClassName = btn.className;
	if (baseClassName.indexOf('-disabled') != -1) {
		baseClassName = baseClassName.replace(/-disabled$/, '');
	}

	this.baseClassName = baseClassName;
	
	// initialize the button
	if (!this.isDisabled) {
		yEvent.addListener(elementId, 'click', buttonEvent);
	}
}

util.CommandLink.prototype.enable = function(/* optional */makeEnabled) {
	
	if (typeof makeEnabled === 'undefined') {
		makeEnabled = true;
	}
		
	// Only enable the button if it is not yet enabled
	if (makeEnabled) {
		if (this.isDisabled) {
			var btn = util.getE(this.elementId);
			yEvent.addListener(btn, 'click', this.buttonEvent);
			btn.className = this.baseClassName;
			this.isDisabled = false;
		}
	}
	else {
		this.disable();
	}
}

util.CommandLink.prototype.disable = function() {
	
	// Don't disable the button if it is already disabled

	if (!this.isDisabled) {
		// alert('disable button');
		var btn = util.getE(this.elementId);
		yEvent.removeListener(btn, 'click', this.buttonEvent);
		btn.className = this.baseClassName + '-disabled';
		this.isDisabled = true;
		
		// alert(btn.className);
	}
}


/**
*
*
* 
* ToolbarButton class (could eventually replace the CommandLink class, so that we only use one class!)
*
* Creates an object for a toolbar button composed of an anchor with an image.
* The ToolbarButton object considers rbac state by defining a "ignore" method.
* I.e.:, saveBtn.ignore() will hide the button and ignore it any other method
* which is applied so that hoverOn(), disable() or enable() does not have any effect.
* This allows us to code buttons as in non-rbac mode and simply ignore then in case
* that there is no permission to use the saveBtn or any other RBAC feature.

* 
* Arguments:
* 	buttonItemName: This is not the element ID but a simple button item name which acts as a referece in buttonsDb and from which we compose the elementId
* 	buttonEvent: The event which is fired upon onclick
* 	buttonsDb: Includes general button properties and all toolbar buttons, it has following format:
*	 buttonsDb = {
*		classNameEnabled: 'btn-10',
*		classNameDisabled: 'btn-10-disabled',
*		classNameHover: 'btn-10-hover',
*   	enabled: {"_save_changes:"new Image(), "_new_role":new Image()},
*   	disabled: {"_save_changes:"new Image(), "_new_role":new Image()},
*	}
*	buttonsDb.enabled._save_changes.src = "/picts/toolbars/save_changes.gif",
*	buttonsDb.enabled._new_role.src = "/picts/toolbars/new_role.gif",
*	buttonsDb.disabled._save_changes.src = "/picts/toolbars/save_changes_dis.gif",
*	buttonsDb.disabled._new_role.src = "/picts/toolbars/new_role_dis.gif"
*
*
*	// Note, all button item Id's start internally with an underbar to avoid any name conflicts
*	// The elementId is a composistion of "toolbar:buttonItemID"
*
*		
*
*
*/


util.ToolbarButton = function(buttonName, buttonEvent, buttonsDb) {
	
	// By default we set all buttons to the disabled state, that's how
	// the html code is specified.
	
	// ignore=true will ignore this button upon all apllied methods.
	// We also set buttonName to true if the button does not exist due
	// RBAC or licensing features. So we must always check for button
	// existence!

	
	var buttonId = '_' + buttonName;
	var elementId = 'toolbar:' + buttonName;
	
	var btn = util.getE(elementId);
	
	this.elementId = elementId;
	this.buttonEvent = buttonEvent;
	this.isDisabled = true;
	this.ignore = (btn != null) ? false : true;
	this.classNameEnabled = buttonsDb.classNameEnabled;
	this.classNameDisabled = buttonsDb.classNameDisabled;
	this.classNameHover = buttonsDb.classNameHover;
	this.srcEnabled = buttonsDb.enabled[buttonId]['src'];
	this.srcDisabled = buttonsDb.disabled[buttonId]['src'];
}

util.ToolbarButton.prototype.enable = function(/* optional */makeEnabled) {
	
	if (!this.ignore) {
		
		if (typeof makeEnabled === 'undefined') {
			makeEnabled = true;
		}
			
		// Only enable the button if it is not yet enabled
		if (makeEnabled) {
			if (this.isDisabled) {
				
				var btn = util.getE(this.elementId);
				yEvent.addListener(btn, 'click', this.buttonEvent);
				btn.className = this.classNameEnabled;
				
				var img = btn.firstChild;
				img.src = this.srcEnabled;
				
				this.isDisabled = false;
			}
		}
		else {
			this.disable();
		}
	}
}

util.ToolbarButton.prototype.disable = function() {
	
	// Don't disable the button if it is already disabled

	if (!this.ignore && !this.isDisabled) {
		
		// alert('disable button');
		var btn = util.getE(this.elementId);
		yEvent.removeListener(btn, 'click', this.buttonEvent);
		btn.className = this.classNameDisabled;
		
		var img = btn.firstChild;
		img.src = this.srcDisabled;
		
		this.isDisabled = true;
	}
}

util.ToolbarButton.prototype.disableAndIgnore = function() {

	// This sets a button to disabled and ignored state
	
	if (!this.ignore) {
		
		// if not yet disbaled
		if (!this.isDisabled) {
			this.disable();
		}
		
		this.ignore = true;
	}
}

util.ToolbarButton.prototype.hoverOn = function() {
	
	if (!this.ignore) {
		
		
	}
}

util.ToolbarButton.prototype.hoverOff = function() {
	
	if (!this.ignore) {
		
		
	}
}



/*
	Tab class
*/

util.Tabs = function(tabElementIds, tabEvent) {
	
	this.tabElementIds = tabElementIds;
	this.tabEvent = tabEvent;
	this.activeTabId = null;
	
	// init the tabs
	for (var i = 0; i < tabElementIds.length; i++) {
		yEvent.addListener(tabElementIds[i], 'click', tabEvent);
	}
}

util.Tabs.prototype.setTab = function(tabId) {
	
	// alert('set tab to: ' + tabId);
	// Reset active tab
	if (this.activeTabId != null) {
		var aElement = util.getE(this.activeTabId);
		aElement.className = '';
		yEvent.addListener(this.activeTabId, 'click', this.tabEvent);
	}
	
	// Activate tab
	var aElement2 = util.getE(tabId);
	aElement2.className = 'active';
	yEvent.removeListener(tabId, 'click', this.tabEvent);
	
	this.activeTabId = tabId;
}

/*
	Tab2 class
*/


util.Tabs2 = function(tabElementIds, tabEvent) {
	
	this.tabElementIds = tabElementIds;
	this.tabEvent = tabEvent;
	this.selectedTabElementId = null;
	
	// init the tabs
	for (var i = 0; i < tabElementIds.length; i++) {
		
		// alert('init the tabs: ' + tabElementIds[i]);
		
		yEvent.addListener(tabElementIds[i], 'click', tabEvent);
		yEvent.addListener(tabElementIds[i], 'mouseover', this.hoverOn);
		yEvent.addListener(tabElementIds[i], 'mouseout', this.hoverOff);
	}
}

util.Tabs2.prototype.setActiveTab = function(tabElementId) {
	
	// alert('util.Tabs2.prototype.setActiveTab: ' + tabElementId);
	
	var li;
	var a;
	
	
	var selectedTabElementId = this.selectedTabElementId;
	
	// If the tab isn't already selected
	
	if (selectedTabElementId != tabElementId) {
	
		// Reset selected tab
		if (selectedTabElementId != null) {
			
			// alert('Tabs2 class - Reset selected tab');
			
			li = util.getE(selectedTabElementId);
			a = li.firstChild;
			li.className = '';
			a.className = '';
			yEvent.addListener(selectedTabElementId, 'click', this.tabEvent);
			yEvent.addListener(selectedTabElementId, 'mouseover', this.hoverOn);
			yEvent.addListener(selectedTabElementId, 'mouseout', this.hoverOff);
		}
		
		// Select tab of given tabElementId
		
		// alert('Tabs2 class - Select tab of given tabElementId: ' + tabElementId);
		
		li = util.getE(tabElementId);
		a = li.firstChild;
		li.className = 'active';
		a.className = 'active';
		yEvent.removeListener(tabElementId, 'click', this.tabEvent);
		yEvent.removeListener(tabElementId, 'mouseover', this.hoverOn);
		yEvent.removeListener(tabElementId, 'mouseout', this.hoverOff);
		
		
		// remove focus
		a.blur();
		
		this.selectedTabElementId = tabElementId;
	}
	
	// util.showObject(this);
	
	// alert('util.Tabs2.prototype.setActiveTab - this.selectedTabElementId: ' + this.selectedTabElementId);
}


util.Tabs2.prototype.hide = function(tabElementId) {
	// hide the tab or tabs
	util.hideE(tabElementId);
}

util.Tabs2.prototype.show = function(tabElementId) {
	// show the tab or tabs
	util.showE(tabElementId);
}

util.Tabs2.prototype.hoverOn = function() {
	
	var li = this;
	var a = li.firstChild;
	li.className = 'hover';
	a.className = 'hover';
}

util.Tabs2.prototype.hoverOff = function() {

	var li = this;
	var a = li.firstChild;
	li.className = '';
	a.className = '';
}

/*
	Tab3 class (should replace Tab and Tab2 classs)
	This class fixes a IE bug where hiding a li element which
	is not the last li element messes up the tab display.
	Tab3 hides li elements in sequence, beginning from
	the last li element and re-creates the tab labels.
	
*/

util.Tabs3 = function(ulContainer, allTabIds, tabEvent) {
	
	// 'ulContainer' is the elementId of the tab element
	
	// 'allTabIds' is a simple array with all tab Id's (not element Id's!), i.e.:
	// ['graphs', 'graph_options', 'table']
	// The element Id's for the list elements are created here. We also read the labels and
	// save them within a new tabs object, because we need the labels if we change the tab sequence.
	// tabs must contain all possible tabs, respectively as they exist in the ul element, in the right order.
	// The tabs can later be set by setSequence to any number or order of the given tabs.
	
	// We create a tab object to handle the tabs, which looks as follows:
	
	// The tabsDb contains all tabs identified by ID ...
	/*
	 tabsDb = {
		graphs: {
			label: 'Graphs'
			currentTabIndex: 0
		},
		
		graph_options: {
			label: 'Graph Options'
			currentTabIndex: 0
			
		}
		...
	}
	*/
	
	// The tab li elements become an ID with tabIndex (0,1,2,...) in combination with an idPrefix, i.e.:
	// ue_id:0
	// ue_id:1
	
	var idPrefix = util.getUniqueElementId();
	var tabsDb = {};

	this.idPrefix = idPrefix;
	this.allTabIds = allTabIds;
	this.tabEvent = tabEvent;
	this.selectedTabIndex = -1; // 0, 1, 2, ... refers to the tab array position
	this.tabSequence = []; // initialized upon setSequence() , i.e. ['graphs', 'table'] will only show the graphs and table tab
	
	var ul = util.getE(ulContainer);
	var liElements = ul.getElementsByTagName('li');
	
	// init the tabs
	for (var i = 0; i < allTabIds.length; i++) {
		
		var tabId = allTabIds[i];
		var elementId = idPrefix + ':' + i;
		var li = liElements[i];
		li.id = elementId;
		
		var a = li.firstChild;
		var aText = a.firstChild;
		var label = aText.nodeValue;
		// alert('tab label: ' + label);
		
		tabsDb[tabId] = {label: label};
		// tabsDb[tabId]['currentTabIndex'] = -0;
		
		yEvent.addListener(li, 'click', this.tabActivated, this);
		yEvent.addListener(li, 'mouseover', this.hoverOn);
		yEvent.addListener(li, 'mouseout', this.hoverOff);
	}
	
	this.tabsDb = tabsDb;
	// util.Tabs3SelfReferences[idPrefix] = this;
}

util.Tabs3.prototype.tabActivated = function(evt, self) {
	
	// Activates the tab function defined in this.tabEvent, which
	// is a function in the module of the tabs object.
	// We return the tabId as argument
	
	// alert('util.Tabs3.prototype.tabActivated() - this.id: ' + this.id);
	var elementId = this.id;
	var dat = elementId.split(':');
	var idPrefix = dat[0];
	var tabIndex = parseInt(dat[1], 10);
	
	// alert('tabIndex: ' + tabIndex);
	
	// var self = util.Tabs3SelfReferences[idPrefix];
	var tabSequence = self.tabSequence;
	var tabId = tabSequence[tabIndex];
	
	// alert('util.Tabs3.prototype.tabActivated() - tabId: ' + tabId);
	
	self.tabEvent(tabId);
}

util.Tabs3.prototype.setSequence = function(tabSequence, setToTabId) {
	
	// alert('setSequence()');
	
	var idPrefix = this.idPrefix;
	var allTabIds = this.allTabIds;
	var tabsDb = this.tabsDb;
	var i;
	
	var newSelectedTabIndex = -1;
	
	for (i = 0; i < tabSequence.length; i++) {
		
		var tabId = tabSequence[i];
		var tabElementId = idPrefix + ':' + i;
		var tabLi = util.getE(tabElementId);
		var tabAnchor = tabLi.firstChild;
		var existingTextNode = tabAnchor.firstChild;
		var newTextNode = document.createTextNode(tabsDb[tabId].label);
		tabAnchor.replaceChild(newTextNode, existingTextNode);
		
		// display the tab
		if (tabLi.style.display == 'none') {
			// alert('Set style.display of tab index: ' + i);
			tabLi.style.display = '';
		}
		
		// get the index of the activeTabId
		
		if (tabId == setToTabId) {
			newSelectedTabIndex = i;
		}
	}
	
	if (tabSequence.length < allTabIds.length) {
		
		// hide all further tab elements
		for (i = tabSequence.length; i < allTabIds.length; i++) {
			util.hideE(idPrefix + ':' + i);
		}
	}
	
	if (newSelectedTabIndex > -1) {
		// make the tab active
		this.setActiveTabByIndex(newSelectedTabIndex);
		
	}
	/*
	else {
		// There is some mismatch with setToTabId
		alert('Tabs3.setSquence - invalid setToTabId: ' + setToTabId);
	}
	*/
	
	this.tabSequence = tabSequence;
}

util.Tabs3.prototype.setActiveTab = function(tabId) {
	
	// Get the index of the tabId and then set the tab by setActiveTabByIndex()
	
	// alert('util.Tabs3.prototype.setActiveTab - tabId: ' + tabId);
	
	var tabSequence = this.tabSequence;
	for (var i = 0; i < tabSequence.length; i++) {
		if (tabId == tabSequence[i]) {
			this.setActiveTabByIndex(i);
			break;
		}
	}
}

util.Tabs3.prototype.setActiveTabByIndex = function(newTabIndex) {
	
	// Only set the tab if it is not already active
	
	var selectedTabIndex = this.selectedTabIndex;
	
	if (selectedTabIndex != newTabIndex) {
		
		// If the tab isn't already selected
		
		var idPrefix = this.idPrefix;
		// var tabElementIds = this.tabElementIds;
	
		var li;
		var a;
		
		if (selectedTabIndex != -1) {
		
			// Reset selected tab
			
			// alert('Tabs3 class - Reset selected tab');
			li = util.getE(idPrefix + ':' + selectedTabIndex);
			a = li.firstChild;
			li.className = '';
			a.className = '';
			yEvent.addListener(li, 'click', this.tabEvent);
			yEvent.addListener(li, 'mouseover', this.hoverOn);
			yEvent.addListener(li, 'mouseout', this.hoverOff);
		}
			
		// Select tab of newTabIndex
		
		// alert('Tabs2 class - Select tab of given tabElementId: ' + tabElementId);
		
		li = util.getE(idPrefix + ':' + newTabIndex);
		a = li.firstChild;
		li.className = 'active';
		a.className = 'active';
		yEvent.removeListener(li, 'click', this.tabEvent);
		yEvent.removeListener(li, 'mouseover', this.hoverOn);
		yEvent.removeListener(li, 'mouseout', this.hoverOff);
		
		
		// remove focus
		a.blur();
		
		this.selectedTabIndex = newTabIndex;
	}
}

util.Tabs3.prototype.hoverOn = function() {
	
	var li = this;
	var a = li.firstChild;
	li.className = 'hover';
	a.className = 'hover';
}

util.Tabs3.prototype.hoverOff = function() {

	var li = this;
	var a = li.firstChild;
	li.className = '';
	a.className = '';
}

/*
	VerticalTabs (Such as in report and report element editor)

*/
/*
util.VerticalTabs = function(elementIds, calleeListener) {
	
	this.calleeListener = calleeListener;
	this.activeTabElementId = null;
	
	// Add events to all tabs
	yEvent.addListener(elementIds, 'click', this.tabActivated, this);
}

util.VerticalTabs.prototype = {
	
	tabActivated: function(evt, self) {
		
		// Tab activated
		var tabElementId = this.id;
		
		// Ignore if this is the active tab
		if (tabElementId != self.activeTabElementId) {
		
			// Inform callee
			self.calleeListener(tabElementId);
			
			// Set tab
			self.setTab(tabElementId);
		}
		
		this.blur();
	},
	
	setTab: function(tabElementId) {
		
		if (this.activeTabElementId) {
			
			var currentTabElement = util.getE(this.activeTabElementId);
			currentTabElement.className = '';
		}
		
		var tabElement = util.getE(tabElementId);
		tabElement.className = 'active';
		this.activeTabElementId = tabElementId;
	}
}
*/

/*
	dropDownMenu control
*/

util.dropDownMenu = {

	register: {}, // contains obj as defined below, accessable by callerElementId
	activeObject: null,
	region: { // keeps the space of any active drop down including some padding
		left: 0,
		top: 0,
		right: 0,
		bottom: 0
	},
	
	add: function(callerElementId, dropDownElementId) {
		
		// alert('dropDownMenu.add()');
		
		// register by callerElementId
		
		var obj = {};
		
		// obj.isOpen = false;
		obj.callerElementId = callerElementId;
		obj.dropDownElementId = dropDownElementId;
		/*
		obj.left = 0;
		obj.top = 0;
		obj.right = 0;
		obj.bottom = 0;
		*/
		
		util.dropDownMenu.register[callerElementId] = obj;
		
		// add event
		yEvent.addListener(callerElementId, 'click', util.dropDownMenu.toggle);
	},
	
	toggle: function() {
		// invoked upon click on callerElementId
		// open or close drop down
		// alert('toggleDropDown: ' + this.id);
		// var obj = util.dropDownMenu.register[this.id];
		
		var obj = util.dropDownMenu.activeObject;
		
		if (obj == null) {
			
			obj = util.dropDownMenu.register[this.id];
			
			// get Region of reference element
			var callerRegion = yDom.getRegion(obj.callerElementId);
			
			var ul = util.getE(obj.dropDownElementId);
			ul.style.top = callerRegion.bottom + 'px';
			ul.style.left = callerRegion.left + 'px';
			
			ul.style.display = 'block';
			
			// Write ul region to obj which we check for move out coordinates
			
			var dropDownRegion = yDom.getRegion(ul);
			// Override the top region with the caller region so that we can move out of the ul,
			// We also add some padding around so that the ul does not immediately disappear.
			
			var region = util.dropDownMenu.region;
		
			region.top = callerRegion.top;
			region.left = dropDownRegion.left - 18;
			region.right = dropDownRegion.right + 18;
			region.bottom = dropDownRegion.bottom + 18;
			
			util.dropDownMenu.activeObject = obj;
			
			yEvent.addListener(document, 'mousemove', util.dropDownMenu.closeByMoveOut);
			yEvent.addListener(ul, 'mouseup', util.dropDownMenu.closeByMouseClick);
			
		}
		else {
			// drop down is open, close it
			util.dropDownMenu.close(obj);
		}
	},
	
	close: function(obj) {
		
		yEvent.removeListener(document, 'mousemove', util.dropDownMenu.closeByMoveOut);
		yEvent.removeListener(obj.dropDownElementId, 'mouseup', util.dropDownMenu.closeByMouseClick);
		util.hideE(obj.dropDownElementId);
		// obj.isOpen = false;
		util.dropDownMenu.activeObject = null;
	},
	
	closeByMouseClick: function(evt) {
		
		// Close the drop down upon left mousedown 
		
		var i = (!util.userAgent.isIE) ? evt.button : evt.button - 1;
		
		if (i == 0) {
			util.dropDownMenu.close(util.dropDownMenu.activeObject);
		}
		
		// alert('closeByMouseClick: ' + evt.button);
	}, 
	
	closeByMoveOut: function(evt) {
		
		// closes the drop down when moving out of it
		var region = util.dropDownMenu.region;
		var x = evt.clientX;
		var y = evt.clientY;
			
		// alert('x: ' + x + '\ny: ' + y);
		// util.showObject(region);
		
		if (x < region.left || x > region.right || y < region.top || y > region.bottom) {
			util.dropDownMenu.close(util.dropDownMenu.activeObject);
		}
	}
}




/*
	Validator class
*/

// note, we must always return the form value, even if the item is already logged, so that 
// the callee object alwyas gets a value, or simply don't return something?

util.Validator = function() {
	
	this.errorLog = [];
}

util.Validator.prototype.reset = function() {
	
	// remove all error messages and clear the error log
	
	var errorLog = this.errorLog;
	
	for (var i = 0; i < errorLog.length; i++) {
		var elementId = errorLog[i].elementId + ':error';
		var element = document.getElementById(elementId);
		if (element) {
			util.hideE(elementId);
		}
	}
	
	this.errorLog = [];
}

// util.Validator.prototype.resetElement = function(elementId) {
util.Validator.prototype.resetElement = function(e, validatorObj) {
	
	// alert('reset element of elementId: ' + this.id + '\nerrorLog: ' + validatorObj);
		
	var elementId = this.id;
	
	var formElement = document.getElementById(elementId);
	var errorElement = document.getElementById(elementId + ':error');
	
	// remove the event listener from form element
	if (formElement) {
		yEvent.removeListener(formElement,'click', validatorObj.resetElement);
	}
	
	// hide error message
	if (errorElement) {
		util.hideE(elementId + ':error');
	}
	
	// remove elementId in error log 
	// util.deleteArrayObject(this.errorLog, 'elementId', elementId);
	util.deleteArrayObject(validatorObj.errorLog, 'elementId', elementId);
}


util.Validator.prototype.allValid = function() {
	
	// checks the errorLog for errors and if there is
	// any error it displays them
	
	var errorLog = this.errorLog;
	
	if (errorLog.length > 0) {
		
		for (var i = 0; i < errorLog.length; i++) {
			
			// util.showObject(errorLog[i]);
			
			// var formElement = document.getElementById(errorLog[i].elementId);
			var errorElement = document.getElementById(errorLog[i].elementId + ':error');
			
			// alert(formElement + '\n' + errorElement);
			
			
			// if (formElement && errorElement) {
			if (errorElement) {
				// alert('write and show error');
				// write error message to ':error' element container		
				util.updateT(errorLog[i].elementId + ':error', errorLog[i].msg);
				util.showE(errorLog[i].elementId + ':error');
			}
			else {
				// alert('formElement or errorElement does not exist');
			}
		}
		
		return false;
	}
	
	return true;
}

util.Validator.prototype.getIsLogged = function(elementId) {
	
	// This returns true if the elementId is already logged in this.errorLog
	
	var isLogged = false;
	var errorLog = this.errorLog;
		
	for (var i = 0; i < errorLog.length; i++) {
		
		if (errorLog[i].elementId == elementId) {
			isLogged = true;
			break;
		}
	}
	
	return isLogged;
}

util.Validator.prototype.logInvalidElementValue = function(elementId, msg) {

	// add element and type to error log
	var errorLog = this.errorLog;
	errorLog[errorLog.length] = {elementId:elementId, msg: msg};
	
	
	// Add event which will hide the error message upon element click
	// Note, 'isCustom' might not have an element, hence check for the element
	
	var element = util.getE(elementId);
	
	// alert(' Set error element: ' + element);
	
	if (element) {
		
		// alert('add eventListener to: ' + elementId);
		
		// We need to add the Validator object in the Listener so that we
		// get an object reference in resetElement()
		yEvent.addListener(element,'click', this.resetElement, this);
	}
	
	// alert('added item to error log, new length: ' + this.errorLog.length);
}

util.Validator.prototype.isValue = function(elementId, /* optional */ trimFormValue) {
	
	// Checks the form element to be not empty.
	
	// Set default trimFormValue if undefined
	if (typeof trimFormValue === 'undefined') {
		trimFormValue = true;
	}
	
	var theValue = util.getF(elementId, trimFormValue);
	
	// If this element hasn't been validated yet
	if (!this.getIsLogged(elementId) && (theValue == '')) {
		
		var msg = langVar('lang_stats.form_validation.no_value');
		this.logInvalidElementValue(elementId, msg);
	}
	
	return theValue;
}

util.Validator.prototype.isUnique = function(elementId, lookupItems, /* optional */ convertToLowercase, /* optional */ trimFormValue) {
	
	// We check if the value of elementId exists in the lookupItems array
	
	// Set default convertToLowercase if undefined
	if (typeof convertToLowercase === 'undefined') {
		convertToLowercase = false;
	}
	
	// Set default trimFormValue if undefined
	if (typeof trimFormValue === 'undefined') {
		trimFormValue = true;
	}
	
	var theValue = util.getF(elementId, trimFormValue);
	
	// If this element hasn't been validated yet
	if (!this.getIsLogged(elementId)) {
		
		var isDuplicateItemValue = false;
		var s = !convertToLowercase ? theValue : theValue.toLowerCase();
		
		for (var i = 0; i < lookupItems.length; i++) {
			
			var lookupItemValue = lookupItems[i];
			if (convertToLowercase) {
				lookupItemValue = lookupItemValue.toLowerCase();
			}
			
			if (s == lookupItemValue) {
				isDuplicateItemValue = true;
				break;
			}
		}
		
		if (isDuplicateItemValue) {
			var msg = langVar('lang_stats.form_validation.duplicat_name');
			this.logInvalidElementValue(elementId, msg);
		}
	}
	
	return theValue;
}

util.Validator.prototype.isInteger = function(elementId, /* optional */ min, /* optional */ max) {
	
	var theValue = util.getF(elementId);
	
	if (!this.getIsLogged(elementId) && !util.isInteger(theValue, min, max)) {
		
		var minDefined = !util.isUndefined(min);
		var maxDefined = !util.isUndefined(max);
		var msg = '';
		
		if (minDefined && maxDefined) {
			msg = langVar('lang_stats.form_validation.invalid_integer_min_max');
			msg = msg.replace(/__PARAM__1/, min);
			msg = msg.replace(/__PARAM__2/, max);
		}
		else if (minDefined) {
			msg = langVar('lang_stats.form_validation.invalid_integer_min');
			msg = msg.replace(/__PARAM__1/, min);
		}
		else if (maxDefined) {
			msg = langVar('lang_stats.form_validation.invalid_integer_max');
			msg = msg.replace(/__PARAM__1/, max);
		}
		else {
			msg = langVar('lang_stats.form_validation.invalid_integer');
		}
		
		this.logInvalidElementValue(elementId, msg);
	}
	
	return theValue;
}

util.Validator.prototype.isFloat = function(elementId, /* optional */ min, /* optional */ max) {
	
	var theValue = util.getF(elementId);
	
	if (!this.getIsLogged(elementId) && !util.isFloat(theValue, min, max)) {
		
		var msg = '';
		var minDefined = !util.isUndefined(min);
		var maxDefined = !util.isUndefined(max);
		
		if (minDefined && maxDefined) {
			msg = langVar('lang_stats.form_validation.invalid_float_min_max');
			msg = msg.replace(/__PARAM__1/, min);
			msg = msg.replace(/__PARAM__2/, max);
		}
		else if (minDefined) {
			msg = langVar('lang_stats.form_validation.invalid_float_min');
			msg = msg.replace(/__PARAM__1/, min);
		}
		else if (maxDefined) {
			msg = langVar('lang_stats.form_validation.invalid_float_max');
			msg = msg.replace(/__PARAM__1/, max);
		}
		else {
			msg = langVar('lang_stats.form_validation.invalid_float');
		}
		
		this.logInvalidElementValue(elementId, msg);
	}

	return theValue;
}

util.Validator.prototype.isNumber = function(elementId, /* optional */ min, /* optional */ max) {

	// This checks for any number (int or float)
	
	var theValue = util.getF(elementId);
	
	if (!this.getIsLogged(elementId) && !util.isInteger(theValue, min, max) && !util.isFloat(theValue, min, max)) {
		
		var msg = langVar('lang_stats.form_validation.invalid_number');
		this.logInvalidElementValue(elementId, msg);
	}
	
	return theValue;
}

util.Validator.prototype.isRegularExpression = function(elementId) {
	
	var theValue = util.getF(elementId);
	
	if (!this.getIsLogged(elementId) && !util.isRegularExpression(theValue)) {
					
		var msg = langVar('lang_stats.form_validation.invalid_regular_expression');
		this.logInvalidElementValue(elementId, msg);
	}
	
	return theValue;
}

util.Validator.prototype.isEmailAddress = function(elementId) {
	
	// This validates a single email address
	
	var theValue = util.getF(elementId);
		
	if (!this.getIsLogged(elementId) && !util.isEmailAddress(theValue)) {
		
		var msg = langVar('lang_stats.form_validation.invalid_email_address');
		this.logInvalidElementValue(elementId, msg);
	}
	
	return theValue;
}

util.Validator.prototype.isEmailAddresses = function(elementId) {

	// This validates a single email address or multiple email addresses separated by a comma.
	
	var theValue = util.getF(elementId);
	
	if (!this.getIsLogged(elementId)) {
		
		var isValidEmailAddress = true;
		
		if (theValue.indexOf(',') == -1) {
			// single email address
			isValidEmailAddress = util.isEmailAddress(theValue);
		}
		else {
			// multiple email addresses
			var emailAddressesDat = theValue.split(',');
			for (var i = 0; i < emailAddressesDat.length; i++) {
				var emailAddress = util.trim(emailAddressesDat[i]);
				if (!util.isEmailAddress(emailAddress)) {
					isValidEmailAddress = false;
					break;
				}
			}
		}
		
		if (!isValidEmailAddress) {
			var msg = langVar('lang_stats.form_validation.invalid_email_addresses');
			this.logInvalidElementValue(elementId, msg);
		}
	}
	
	return theValue;
}

util.Validator.prototype.isNodeName = function(elementId) {
	
	// checks to be a valid node name
	
	var theValue = util.getF(elementId);
	
	if (!this.getIsLogged(elementId)) {
		
		var pattern = /[^_a-z0-9]/;
			
		if (pattern.test(theValue)) {
			var msg = langVar('lang_stats.form_validation.invalid_identifier');
			this.logInvalidElementValue(elementId, msg);
		}
	}
	
	return theValue;
}


util.Validator.prototype.isCustom = function(elementId, msg) {

	// This does not require validation, it simply throws a custom error message
	// and does not return a form value.
	
	if (!this.getIsLogged(elementId)) {
		this.logInvalidElementValue(elementId, msg);
	}
}


/*
	Panel3 class
*/

util.Panel3 = function(obj) {
	
	this.panelId = obj.panelId;
	this.panelClassName = obj.panelClassName; // i.e. panel-50
	this.width = (obj.width != null) ? obj.width : null;
	this.height = (obj.height != null) ? obj.height : null;
	this.top = (obj.top != null) ? obj.top : null;
	this.left = (obj.left != null) ? obj.left : null;
	this.right = (obj.right != null) ? obj.right : null;
	this.bottom = (obj.bottom != null) ? obj.bottom : null;
	this.zIndex = (obj.zIndex != null) ? obj.zIndex : 20; // The zIndex of the panel, we require the zIndex for the form, the cover and iframe!
	this.isCover = (obj.isCover != null) ? obj.isCover : false; // Creates a background cover if true
	this.isCloseButton = (obj.isCloseButton != null) ? obj.isCloseButton : true;
	this.closeEvent = (obj.closeEvent != null) ? obj.closeEvent : null;
	this.isIframe = util.userAgent.isIE;
	
	// alert('this.isIframe: ' + this.isIframe);
	
	// If isSticky is given and is true then we don't re-position the panel upon "scroll",
	// it sticks at the position where the panel is initially positioned.
	// This is useful for panels which don't fit in Admin or Config
	this.isSticky = (obj.isSticky != null) ? obj.isSticky : false; 
	
	// this.isScroll = (obj.isScroll != null) ? obj.isScroll : false;
			
	this.headerTitleId = '';
	this.coverId = '';
	this.iframeId = '';
	
	// alert('this.top: ' + this.top);
		
	var panel = util.getE(this.panelId);
	
	panel.style.zIndex = this.zIndex;
		
	if (this.width != null) {
		panel.style.width = this.width + 'px';
	}
	
	if (this.height != null) {
		panel.style.height = this.height + 'px';
	}

	// obj.panelHeaderLabel = null;
	
	if (obj.panelHeaderLabel) {
		
		//
		// Create the panel header and insert it into the panel
		//
		
		var titleId =  util.getUniqueElementId();
		var imageContainerId = util.getUniqueElementId();
		
		var firstElement = panel.firstChild;
	
		var headerDiv = document.createElement('div');
		headerDiv.className = this.panelClassName + '-header';
		
		var headerFrameDiv = document.createElement('div');
		headerFrameDiv.id = imageContainerId;
		headerFrameDiv.className = this.panelClassName + '-header-frame';
		
		var headerTitleDiv = document.createElement('div');
		headerTitleDiv.id = titleId;
		headerTitleDiv.className = this.panelClassName + '-header-title';
		var headerTitleTxt = document.createTextNode(obj.panelHeaderLabel);
		
		var headerBottomDiv = document.createElement('div');
		headerBottomDiv.className = this.panelClassName + '-header-bottom';
		
		// var spaceTxt = document.createTextNode('\u00a0'); // inserts &nbsp;
		var spaceTxtA = document.createTextNode('\u00a0');
		var spaceTxtB = document.createTextNode('\u00a0');
		
		if (this.isCloseButton) {
		
			var img = document.createElement('img');
			img.src = imgDb.panelClose.src;
			img.alt = langVar('lang_stats.btn.close');
			img.width = imgDb.panelClose.width;
			img.height = imgDb.panelClose.height;
			
			if (this.closeEvent) {
				// Use external close event to close the panel
				yEvent.addListener(img, 'click', this.closeEvent, this);
			}
			else {
				// Use internal close event to close the panel
				yEvent.addListener(img, 'click', this.__close, this);
			}
		}
		
		headerTitleDiv.appendChild(headerTitleTxt);
		headerFrameDiv.appendChild(headerTitleDiv);
		headerFrameDiv.appendChild(spaceTxtA);
		headerBottomDiv.appendChild(spaceTxtB);
		
		if (this.isCloseButton) {
			headerFrameDiv.appendChild(img);
		}
		
		headerDiv.appendChild(headerFrameDiv);
		headerDiv.appendChild(headerBottomDiv);
		
		panel.insertBefore(headerDiv, firstElement);
		
		this.headerTitleId = titleId;
	}
	
	//
	// Create the footer
	//
	
	var footerDiv = document.createElement('div');
	footerDiv.className = this.panelClassName + '-footer';
	var footerOffsetDiv = document.createElement('div');
	footerOffsetDiv.className = this.panelClassName + '-footer-offset';
	
	var footerSpaceTxt = util.createT('&nbsp;');
	
	footerOffsetDiv.appendChild(footerSpaceTxt);
	footerDiv.appendChild(footerOffsetDiv);
	panel.appendChild(footerDiv);
	
	//
	// Create background cover which hides underlying elements
	//
	
	if (this.isCover) {
		
		this.coverId = util.getUniqueElementId();
		var coverZIndex = this.zIndex - 5;
		var coverDiv = util.createE('div', {id:this.coverId, className:'form-cover', zIndex:coverZIndex});
		var coverText = util.createT('&nbsp;');
		util.chainE(coverDiv, coverText);
		panel.parentNode.appendChild(coverDiv);
	}
	
	
	// Create iframe element as form backround.
	// This fixes IE so that no elements shine through the form.
	
	if (this.isIframe) {
		
		this.iframeId = util.getUniqueElementId();
	
		var iframe = document.createElement('iframe');
		iframe.id = this.iframeId;
		iframe.tabIndex = '-1';
		iframe.src = 'javascript:false;';
		iframe.className = 'form-cover';
		iframe.style.zIndex = this.zIndex - 2;
		panel.parentNode.appendChild(iframe);
	}
}

util.Panel3.prototype.open = function(obj) {
	
	// obj is optional and has the properties left, top, right, bottom and label 
	// If a position argument is given it overrides any existing absolute position
	// If a label argument is given it sets the panel header label
	
	if (obj != null) {
		
		// Note, if i.e. the "left" position is given then we set the "right" position to null!
	
		if (obj.left) {
			this.left = obj.left;
			this.right = null;
		}
		
		if (obj.right) {
			this.right = obj.right;
			this.left = null;
		}
		
		if (obj.top) {
			this.top = obj.top;
			this.bottom = null;
		}
		
		if (obj.bottom) {
			this.bottom = obj.bottom;
			this.top = null;
		}
		
		if (obj.label) {
			util.updateT(this.headerTitleId, obj.label);
		}
	}
	
	// alert('this.top after open(): ' + this.top);
	
	if (this.isCover) {
		
		this.setCoverSize();
		yEvent.addListener(window, 'resize', this.setCoverSizeUponResize, this);
		util.showE(this.coverId);
	}
	
	if (!this.isSticky) {
		yEvent.addListener(window, 'scroll', this.__setPositionByWindow, this);
	}
	
	// set initial position
	this.__setPosition(true/* true because this is the initial positioning */);

	util.showE(this.panelId);
	
	if (this.isIframe) {
		this.setIframePositionAndSize();
		util.showE(this.iframeId);
	}
}

util.Panel3.prototype.__close = function(evt, self) {
	
	// __close() is only used if no external closeEvent is given!
	self.close();
}

util.Panel3.prototype.close = function() {
	
	if (!this.isSticky) {
		yEvent.removeListener(window, 'scroll', this.__setPositionByWindow);
	}
	
	util.hideE(this.panelId);
	
	if (this.isIframe) {
		util.hideE(this.iframeId);
	}
	
	if (this.isCover) {
		yEvent.removeListener(window, 'resize', this.setCoverSizeUponResize, this);
		util.hideE(this.coverId);
	}
}

util.Panel3.prototype.__setPositionByWindow = function(evt, self) {
	
	var isInitialPositioning = false;
	self.__setPosition(isInitialPositioning);
}

util.Panel3.prototype.__setPosition = function(isInitialPositioning) {
	
	// If isInitialPositioning is true then we don't position the iframe
	// because the panel is not yet open, in all other cases we
	// position the iframe if it exists.
	
	// alert('update position of panelId: ' + this.panelId);
	var element = util.getE(this.panelId);
	var scrollY = yDom.getDocumentScrollTop();
	var scrollX = yDom.getDocumentScrollLeft();
	
	// util.showObject(this);
	
	if (this.top) {
		// alert('this.top: ' + this.top + '\nthis.left: ' + this.left);
		// alert('this.top: ' + this.top + '\nscrollY: ' + scrollY);
		element.style.top = (this.top + scrollY) + 'px';
	}
	
	if (this.left) {
		// alert('set left position to: ' + (left + scrollX) + 'px');
		element.style.left = (this.left + scrollX) + 'px';
	}
	
	if (this.right) {
		// alert('set right position to: ' + (right + scrollX) + 'px');
		element.style.right = (this.right + scrollX) + 'px';
	}
	
	if (!isInitialPositioning && this.isIframe) {
		this.setIframePositionAndSize();
	}
	
	// util.showObject(element.style.top);
}

util.Panel3.prototype.setIframePositionAndSize = function() {
	
	var region = yDom.getRegion(this.panelId);
	var element = util.getE(this.iframeId);
	element.style.top = region.top;
	element.style.left = region.left;
	element.style.width = region.width;
	element.style.height = region.height;
}

util.Panel3.prototype.prePositionAtCenter = function() {

	// Display the panel temporary so that we get the region
	var panel = util.getE(this.panelId);
	panel.style.top = '0px';
	panel.style.left = '0px';
	panel.style.display = 'block';
	panel.style.visibility = 'hidden';
	
	// util.showE(this.panelId);
	// util.hideEV(this.panelId);
	
	var panelRegion = yDom.getRegion(panel);
	
	// util.showObject(region);
	panel.style.display = 'none';
	panel.style.visibility = '';
	
	panelWidth = panelRegion.width;
	panelHeight = panelRegion.height;
	
	var viewportWidth = yDom.getViewportWidth();
	var viewportHeight = yDom.getViewportHeight();
	
	var topDistance = ((viewportHeight - panelHeight) / 2) - 30;
	var leftDistance = (viewportWidth - panelWidth) / 2;
	
	this.top = (topDistance > -1) ? topDistance : 0;
	this.left = (leftDistance > -1) ? leftDistance : 0;
}

util.Panel3.prototype.setCoverSizeUponResize = function(evt, self) {
	self.setCoverSize();
}

util.Panel3.prototype.setCoverSize = function() {
	
	var coverElement = util.getE(this.coverId);
	coverElement.style.width = yDom.getDocumentWidth() + 'px';
	coverElement.style.height = yDom.getDocumentHeight() + 'px';
}



//
//
// MoveControl class
//
//

util.MoveControl = function(baseId, moveEvent) {
	
	// Move control baseId is the element ID of the move control container div
	// Each image element ID in this container is a combination
	// of the baseID and move direction as follwos:
	// id="baseId:top"
	// id="baseId:up"
	// id="baseId:down"
	// id="baseId:bottom"
	
	// Note, the baseId may contain other colons ':'
	
	this.baseId = baseId;
	this.moveEvent = moveEvent;
	
	this.buttonsState = {
		top: {id:baseId + ':top', isDisabled:true, src:imgDb.moveTop.src, srcDis:imgDb.moveTopDis.src},
		up: {id:baseId + ':up', isDisabled:true, src:imgDb.moveUp.src, srcDis:imgDb.moveUpDis.src},
		down: {id:baseId + ':down', isDisabled:true, src:imgDb.moveDown.src, srcDis:imgDb.moveDownDis.src},
		bottom: {id:baseId + ':bottom', isDisabled:true, src:imgDb.moveBottom.src, srcDis:imgDb.moveBottomDis.src}
	}
}

util.MoveControl.prototype = {
	
	setState: function(selectedItemIndex, numberOfItems) {
		
		// Sets the move control button state (enabled/disabled) depending
		// of selectedItemIndex and numberOfItems.
		
		//
		// Set default state
		//
		
		var moveDisabled = {
			top: true,
			up: true,
			down: true,
			bottom: true
		};
		
		//
		// Set active state
		//
		
		if (selectedItemIndex >= 0 && numberOfItems > 1) {
			
			if (selectedItemIndex > 0) {
				moveDisabled.top = false;
				moveDisabled.up = false;
			}
			
			if (selectedItemIndex < (numberOfItems - 1)) {
				moveDisabled.down = false;
				moveDisabled.bottom = false;
			}
		}
		
		//
		// Set the buttons
		//
		
		var buttonsState = this.buttonsState;
		
		for (var prop in moveDisabled) {
			
			var isDisabled = moveDisabled[prop];
			
			var theButton = buttonsState[prop];
			
			if (isDisabled != theButton.isDisabled) {
				
				// Change the button state
				
				var img = util.getE(theButton.id);
				img.src = isDisabled ? theButton.srcDis : theButton.src;
				theButton.isDisabled = isDisabled;
				
				if (isDisabled) {
					// yEvent.removeListener(img, 'click', this.moveEvent);
					yEvent.removeListener(img, 'click', this.moveItem);
				}
				else {
					// yEvent.addListener(img, 'click', this.moveEvent);
					yEvent.addListener(img, 'click', this.moveItem, this);
				}
			}
		}
	},
	
	moveItem: function(evt, self) {
		
		var element = evt.target || evt.srcElement;
		var elementId = element.id;
		var direction = self.getMoveDirection(elementId);
		self.moveEvent(direction);
	},
	
	getMoveDirection: function(buttonElementId) {
		
		var dat = buttonElementId.split(':');
		var lastItemIndex = dat.length - 1;
		return dat[lastItemIndex];
	},
	
	setPosition: function(listElementId) {
		
		// Sets the absolute position of the move control
		// alert('setPosition');
		
		var moveElement = util.getE(this.baseId);
		var region = yDom.getRegion(listElementId);
		
		// util.showObject(region);
		
		moveElement.style.top = region.top + 'px';
		moveElement.style.left = (region.left - 46) + 'px';
		moveElement.style.display = 'block';
	}
}


//
//
// Language variable util function
//
//

function langVar(langVariablePath) {
	
	// Return language variable if it exists, else show an error.
	// The purpose of the langVar function is to locate any lang variable errors,
	// missing lang variables would be difficult to detect otherwise. The langVar
	// function may also be useful to create js_lang_modules.cfg automatically by
	// parsing all js files for "langVar(" ...

	// alert('langVariablePath: ' + langVariablePath);
	
	try {
		
		// Replace each dot "." in the langVariablePath with dot underscore "._"
		// because the language variables use an underscore in the js object to
		// prevent name conflicts for words such as "delete", "length", etc.
		
		langVariablePath = langVariablePath.replace(/\./g,'._');
		// alert('langVariablePath: ' + langVariablePath);
		var langVarValue = eval(langVariablePath);
		// alert('langVariablePath: ' + langVariablePath + '\nlangVarValue: ' + langVarValue);
		return langVarValue;
	}
	
	catch(ex) {
		alert('Missing language variable in js file: "' + langVariablePath + '"');
	}
}







//
//
// Execute upon load
//
//

// set userAgent
util.userAgent.init();



/*
	Hash class
*/

// Creates a hash object

/*
util.Hash = function(theArray, theKey) {
	// Each array entry is saved in an object, named o
	// To avoid any name conflicts we add h_ prefix to each content entry.
	// i.e. "Size" would become contents.h_size
	var hasKey = (theKey != null) ? true : false;
	
	var o = {};
	for (i = 0; i < theArray.length; i++) {
		var s = 'h_';
		s += hasKey ? theArray[i][theKey] : theArray[i];
		o[s.toLowerCase()] = true;
	}
	
	this.o = o;
	
	// util.showObject(this.o);
}

util.Hash.prototype.contains = function(txt) {
	
	var s = 'h_' + txt.toLowerCase();
	
	if (this.o[s] != null) {
		return true;
	}
	return false;
}
*/
	





