//
//
// importDataEditDb.js
//
//
var importDataEditDb = {
	panel: null,
	validator: null,
	activeItemIndex: -1,
	init: function() {
		var YE = YAHOO.util.Event;
		var panelObj = {
			panelId: 'import_data_edit_db:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: '-',
			left: 75,
			top: 110,
			zIndex: 40,
			isCover: true,
			isSticky: true,
			closeEvent: importDataEditDb.close
		};
		importDataEditDb.panel = new util.Panel3(panelObj);
		importDataEditDb.validator = new util.Validator();
		YE.addListener('import_data_edit_db:okay_btn', 'click', importDataEditDb.saveItem);
		YE.addListener('import_data_edit_db:cancel_btn', 'click', importDataEditDb.close);
	},
	open: function(itemIndex) {
		// Keep track of the active itemIndex
		importDataEditDb.activeItemIndex = itemIndex;
		if (importDataEditDb.panel == null) {
			importDataEditDb.init();
		}
		else {
			// Reset the validator
			importDataEditDb.validator.reset();
		}
		var theProfile = importData.v7profilesDb[itemIndex];
		var isMysql = theProfile.isMysql;
		var panelLabel = '';
		util.updateT('import_data_edit_db:profile_label', theProfile.label);
		if (isMysql) {
			panelLabel = langVar('lang_admin.import.change_database_name');
			util.updateT('import_data_edit_db:v7_mysql_db_name', theProfile.mysqlDatabaseName);
			util.setF('import_data_edit_db:v8_mysql_db_name', theProfile.newMysqlDatabaseName);
		}
		else {
			// Custom directory
			panelLabel = langVar('lang_admin.import.change_database_directory');
			util.updateT('import_data_edit_db:v7_db_directory', theProfile.databaseDirectory);
			util.setF('import_data_edit_db:v8_db_directory', theProfile.newCustomDatabaseDirectory);
		}
		util.showE('import_data_edit_db:mysql_name_section', isMysql);
		util.showE('import_data_edit_db:directory_section', !isMysql);
		importDataEditDb.panel.open({label:panelLabel});
	},
	close: function() {
		importDataEditDb.panel.close();
	},
	validateAndGetMysqlDatabaseName: function(v7profilesDb, v8profilesDb, itemIndex) {
		var validator = importDataEditDb.validator;
		var isCustomErrorMessage = false;
		var errorMessage = '';
		var theProfile;
		var i;
		var v8mysqlDatabaseName = validator.isValue('import_data_edit_db:v8_mysql_db_name');
		if (v8mysqlDatabaseName != '') {
			//
			// Check if the MySQL database name is unique among all version 8 and version 7 profiles
			//
			// Check for unique MySQL name among version 8 profiles
			for (i = 0; i < v8profilesDb.length; i++) {
				theProfile = v8profilesDb[i];
				// Ignore v8 profile if it becomes overriden by a v7 profile!
				if (!theProfile.profileBecomesOverriden && (theProfile.mysqlDatabaseName == v8mysqlDatabaseName)) {
					// Throw custom error
					isCustomErrorMessage = true;
					errorMessage = langVar('lang_admin.import.mysql_name_already_exists_in_v8');
					break;
				}
			}
			if (!isCustomErrorMessage) {
				// Check for unique MySQL name among version 7 profiles, except the active v7 profile
				for (i = 0; i < v7profilesDb.length; i++) {
					theProfile = v7profilesDb[i];
					// if not the active profile and if is MySQL
					if ((itemIndex != i) && theProfile.isMysql) {
						var v7mysqlDatabaseName = theProfile.mysqlDatabaseName;
						if (v7mysqlDatabaseName == v8mysqlDatabaseName) {
							// Throw custom error
							isCustomErrorMessage = true;
							errorMessage = langVar('lang_admin.import.mysql_name_already_exists_in_v7');
							break;
						}
					}
				}
			}
			if (isCustomErrorMessage) {
				// Throw custom error message
				validator.isCustom('import_data_edit_db:v8_mysql_db_name', errorMessage);
			}
		}
		return v8mysqlDatabaseName;
	},
	validateAndGetDatabaseDirectory: function(v7profilesDb, v8profilesDb, itemIndex) {
		var validator = importDataEditDb.validator;
		var isCustomErrorMessage = false;
		var errorMessage = '';
		var theProfile;
		var i;
		var v8databaseDirectory = validator.isValue('import_data_edit_db:v8_db_directory');
		if (v8databaseDirectory != '') {
			//
			// Check if the database directory is unique among all version 8 and version 7 internal databases
			//
			// Check for unique directory among version 8 profiles
			for (i = 0; i < v8profilesDb.length; i++) {
				theProfile = v8profilesDb[i];
				// Ignore v8 profile if it becomes overriden by a v7 profile!
				if (!theProfile.profileBecomesOverriden && (theProfile.customDatabaseDirectory == v8databaseDirectory)) {
					// Throw custom error
					isCustomErrorMessage = true;
					errorMessage = langVar('lang_admin.import.db_directory_already_exists_in_v8');
					break;
				}
			}
			if (!isCustomErrorMessage) {
				// Check for unique directory among version 7 profiles, except the active v7 profile
				for (i = 0; i < v7profilesDb.length; i++) {
					theProfile = v7profilesDb[i];
					// if not the active profile
					if (itemIndex != i) {
						// We can apply this check also to MySQL databases
						var v7DatabaseDirectory = theProfile.databaseDirectory;
						if (v7DatabaseDirectory == v8databaseDirectory) {
							// Throw custom error
							isCustomErrorMessage = true;
							errorMessage = langVar('lang_admin.import.db_directory_already_exists_in_v7');
							break;
						}
					}
				}
			}
			if (isCustomErrorMessage) {
				// Throw custom error message
				validator.isCustom('import_data_edit_db:v8_db_directory', errorMessage);
			}
		}
		return v8databaseDirectory;
	},
	saveItem: function() {
		var validator = importDataEditDb.validator;
		validator.reset();
		var itemIndex = importDataEditDb.activeItemIndex;
		var v7profilesDb = importData.v7profilesDb;
		var theProfile = v7profilesDb[itemIndex];
		var v8profilesDb = importData.v8profilesDb;
		var isMysql = theProfile.isMysql;
		var i;
		if (isMysql) {
			var v8mysqlDatabaseName = importDataEditDb.validateAndGetMysqlDatabaseName(v7profilesDb, v8profilesDb, itemIndex);
		} 
		else {
			// Custom database directory
			var v8databaseDirectory = importDataEditDb.validateAndGetDatabaseDirectory(v7profilesDb, v8profilesDb, itemIndex);
		}
		if (validator.allValid()) {
			// Save data to theProfile
			if (isMysql) {
				theProfile.newMysqlDatabaseName = v8mysqlDatabaseName;
			}
			else {
				theProfile.newCustomDatabaseDirectory = v8databaseDirectory;
			}
			// Update list item
			importDataUtil.updateOverrideDatabasesListItem(itemIndex);
			// Close the panel
			importDataEditDb.close();
		}
	}
};
//
// importDataUtil.js
//
var importDataUtil = {
	overrideDatabaseListBaseId: '',
	//
	//
	// Profiles list builder
	//
	//
	buildProfilesObjectList: function(profiles) {
		var container = util.getE('import_data:choose_objects:profiles:div');
		var table = util.createE('table', {cellSpacing:0, className:'import-data-list'});
		var tbody = util.createE('tbody');
		// Clear existing list
		util.removeChildElements(container);
		if (profiles.length > 0) {
			for (var i = 0; i < profiles.length; i++) {
				importDataUtil.buildProfilesObjectListRow(tbody, i, profiles[i]);
			}
			util.chainE(container, table, tbody);
		}
		else {
			// No profiles exist
			var tr = util.createE('tr');
			var td = util.createE('td');
			var text = langVar('lang_admin.import.no_profiles_exist');
			util.chainE(container, table, tbody, tr, td, text);
		}
	},
	buildProfilesObjectListRow: function(tbody, index, item) {
		var tr = util.createE('tr');
		var td1 = util.createE('td');
		var td2 = util.createE('td', {width: '30%'});
		var td3 = util.createE('td', {width: '70%'});
		var inputId = 'import_data_profile_object:' + index;
		var input = util.createE('input', {id:inputId, type:'checkbox'});
		var label = util.createE('label', {htmlFor:inputId});
		var labelText = util.createT(item.label);
		util.chainE(label, labelText);
		var td3Text = item.profileExistsInV8 ? 'Profile already exists!' : '&nbsp;';
		var td3Label = util.createT(td3Text);
		util.chainE(tbody, [tr, [td1, input], [td2, label], [td3, td3Label]]);
	},
	//
	//
	// Profiles databases list builder
	//
	//
	buildDatabasesObjectList: function(profiles) {
		var container = util.getE('import_data:choose_databases:div');
		var table = util.createE('table', {cellSpacing:0, className:'import-data-list'});
		var tbody = util.createE('tbody');
		// Clear existing list
		util.removeChildElements(container);
		for (var i = 0; i < profiles.length; i++) {
			var theProfile = profiles[i];
			if (theProfile.isImportProfile && theProfile.hasDatabase) {
				importDataUtil.buildDatabasesObjectListRow(tbody, i, theProfile);
			}
		}
		util.chainE(container, table, tbody);
	},
	buildDatabasesObjectListRow: function(tbody, index, item) {
		var tr = util.createE('tr');
		var td1 = util.createE('td', {width:'1%'});
		var td2 = util.createE('td');
		var inputId = 'import_data_profile_db_object:' + index;
		var input = util.createE('input', {id:inputId, type:'checkbox'});
		var label = util.createE('label', {htmlFor:inputId});
		var labelText = util.createT(item.label);
		util.chainE(label, labelText);
		util.chainE(tbody, [tr, [td1, input], [td2, label]]);
	},
	//
	//
	// Override database list builder
	//
	//
	buildOverrideDatabasesList: function(v7profilesDb) {
		// util.showObject(v7profilesDb);
		var container = util.getE('import_data:override_databases_list:div');
		// Get the unique baseId
		var baseId = importDataUtil.overrideDatabaseListBaseId;
		if (baseId == '') {
			// Issue new baseId
			baseId = util.getUniqueElementId();
			importDataUtil.overrideDatabaseListBaseId = baseId;
		}
		// Clear existing list
		util.removeChildElements(container);
		for (var i = 0; i < v7profilesDb.length; i++) {
			var theProfile = v7profilesDb[i];
			var isMysql = theProfile.isMysql;
			var isCustomDbDirectory = theProfile.isCustomDbDirectory;
			// Note, we check for isImportProfile because the warning is shown
			// regardless of an existing v7 database build.
			if (theProfile.isImportProfile && (isMysql || isCustomDbDirectory)) {
				// util.showObject(theProfile);
				// We use two tables per items because the details table may extend the available
				// width which may causes a hidden link for editing the database name or directory.
				var table = util.createE('table', {cellSpacing:0, className:'import-data-override-list'});
				var tbody = util.createE('tbody');
				var detailsTable = util.createE('table', {cellSpacing:0, className:'import-data-override-list-details'});
				var detailsTbody = util.createE('tbody');
				var errorTable = util.createE('table', {cellSpacing:0, className:'import-data-override-list-error'});
				var errorTbody = util.createE('tbody');
				importDataUtil.buildOverrideDatabasesListMainRow(tbody, baseId, i, theProfile);
				var databaseLabel = langVar('lang_admin.import.database_type');
				var databaseTypeLabel; 
				var v7RowLabel;
				var v7RowValue;
				var v8RowLabel;
				var v8RowValue;
				var v8RowValueElementId = baseId + ':v8_value:' + i;
				if (isMysql) {
					databaseTypeLabel = langVar('lang_admin.import.mysql');
					v7RowLabel = langVar('lang_admin.import.v7_name');
					v7RowValue = theProfile.mysqlDatabaseName;
					v8RowLabel = langVar('lang_admin.import.v8_name');
					v8RowValue = theProfile.newMysqlDatabaseName;
					errorMessage = '';
				}
				else {
					// isCustomDbDirectory
					databaseTypeLabel = langVar('lang_admin.import.internal');
					v7RowLabel = langVar('lang_admin.import.v7_directory');
					v7RowValue = theProfile.databaseDirectory;
					v8RowLabel = langVar('lang_admin.import.v8_directory');
					v8RowValue = theProfile.newCustomDatabaseDirectory;
				}
				importDataUtil.buildOverrideDatabasesListSubRow(detailsTbody, databaseLabel, databaseTypeLabel);
				importDataUtil.buildOverrideDatabasesListSubRow(detailsTbody, v7RowLabel, v7RowValue);
				importDataUtil.buildOverrideDatabasesListSubRow(detailsTbody, v8RowLabel, v8RowValue, v8RowValueElementId);
				importDataUtil.buildOverrideDatabasesListErrorMessageRow(errorTbody, baseId, i);
				util.chainE([container, [table, tbody], [detailsTable, detailsTbody], [errorTable, errorTbody]]);
				// Set actual error message, if any
				importDataUtil.updateOverrideDatabasesListItem(i);
			}
		}
	},
	buildOverrideDatabasesListMainRow: function(tbody, baseId, index, item) {
		var tr = util.createE('tr');
		var td1 = util.createE('td', {className:'image'});
		var td2 = util.createE('td', {className:'profile-label'});
		var td3 = util.createE('td', {className:'link'});
		var imgId = baseId + ':img:' + index;
		var img =  util.createE('img', {id:imgId, src:imgDb.overrideWarning.scr, width:24, height:24, alt:''});
		var profileText = util.createT(item.label);
		var anchorLabel = item.isMysql ? langVar('lang_admin.import.change_database_name') : langVar('lang_admin.import.change_database_directory');
		var anchorText = util.createT(anchorLabel);
		var anchorId = baseId + ':a:' + index;
		var anchor = util.createE('a', {id:anchorId, href:'javascript:;'});
		util.chainE(tbody, [tr, [td1, img], [td2, profileText], [td3, [anchor, anchorText]]]);
	},
	buildOverrideDatabasesListSubRow: function(tbody, rowLabel, rowValue, elementId) {
		// elementId is optional. It is only required for the v8 database name or directory as 
		// this value might become modified.
		var tr = util.createE('tr');
		var th = util.createE('th');
		var td = util.createE('td');
		if (elementId != null) {
			td.id = elementId;
		}
		var thText = util.createT(rowLabel + ': ');
		var tdText = util.createT(rowValue);
		util.chainE(tbody, [tr, [th, thText], [td, tdText]]);
	},
	buildOverrideDatabasesListErrorMessageRow: function(tbody, baseId, index, errorMessage) {
		var trElementId = baseId + ':error_row:' + index;
		var tr = util.createE('tr', {id:trElementId});
		var tdElementId = baseId + ':error_message:' + index;
		var td = util.createE('td', {id:tdElementId});
		var tdText = util.createT('-');
		util.chainE(tbody, [tr, [td, tdText]]);
	},
	updateOverrideDatabasesListItem: function(itemIndex) {
		// The function is invoked after building the item list and
		// after a database name or directory has been edited.
		// It updates the image and error message in the list item
		// depending of the database type and any duplicate database name
		// or database directory.
		var v7profilesDb = importData.v7profilesDb;
		var theProfile = v7profilesDb[itemIndex];
		var v8Value = '';
		var isErrorMessage = false;
		var errorMessage = '-';
		var isMysql = theProfile.isMysql;
		if (isMysql) {
			var v7MySqlDbName = theProfile.mysqlDatabaseName;
			v8Value = theProfile.newMysqlDatabaseName;
			if (v7MySqlDbName == v8Value) {
				isErrorMessage = true;
				errorMessage = 'Identical database names, version 8 will override the version 7 database';
			}
		}
		else {
			// Custom database directory
			var v7DatabasePathname = theProfile.databaseDirectory;
			v8Value = theProfile.newCustomDatabaseDirectory;
			if (v7DatabasePathname == v8Value) {
				isErrorMessage = true;
				errorMessage = 'Identical database directories, version 8 will override the version 7 database';
			}
		}
		// Set the image
		var baseId = importDataUtil.overrideDatabaseListBaseId;
		var img = util.getE(baseId + ':img:' + itemIndex);
		var imgSrc = isErrorMessage ? imgDb.overrideWarning.scr : imgDb.overrideOkay.scr;
		img.src = imgSrc;
		// Update v8 database name or directory value
		util.updateT(baseId + ':v8_value:' + itemIndex, v8Value);
		// Set error message
		util.updateT(baseId + ':error_message:' + itemIndex, errorMessage);
		util.showE(baseId + ':error_row:' + itemIndex, isErrorMessage);
	},
	//
	//
	// Final import page
	//
	//
	buildFinalImportList: function() {
		// alert('buildFinalImportList()');
		var container = util.getE('import_data:final:div');
		var table = util.createE('table', {cellSpacing:0, className:'import-data-list'});
		var tbody = util.createE('tbody');
		importData.itemsDat = [];
		var itemsDat = importData.itemsDat;
		var itemsDatIndex = 0; // Used for element Id's
		var i;
		var theProfile;
		// Clear existing list
		util.removeChildElements(container);
		if (importData.isImportProfiles) {
			var profiles = importData.v7profilesDb;
			//
			// Get the profiles
			//
			for (i = 0; i < profiles.length; i++) {
				theProfile = profiles[i];
				if (theProfile.isImportProfile) {
					itemsDatIndex = itemsDat.length;
					itemsDat[itemsDatIndex] = {type:'profile', reference:theProfile};
					importDataUtil.buildFinalImportListRow(tbody, itemsDatIndex, langVar('lang_admin.import.profile') + ':', theProfile.label);
				}
			}
			//
			// Get the databases
			//
			for (i = 0; i < profiles.length; i++) {
				theProfile = profiles[i];
				if (theProfile.isImportProfile && theProfile.isImportDatabase) {
					itemsDatIndex = itemsDat.length;
					itemsDat[itemsDatIndex] = {type:'database', reference:theProfile};
					// KHP-RC, we may need to refine the label for MySQL databases
					importDataUtil.buildFinalImportListRow(tbody, itemsDatIndex, langVar('lang_admin.import.database') + ':', theProfile.label);
				}
			}
		}
		if (importData.isImportSchedules) {
			itemsDatIndex = itemsDat.length;
			itemsDat[itemsDatIndex] = {type:'schedules'};
			importDataUtil.buildFinalImportListRow(tbody, itemsDatIndex, langVar('lang_admin.import.schedules') + ':', importData.v7numberOfSchedules);
		}
		if (importData.isImportUsers) {
			itemsDatIndex = itemsDat.length;
			itemsDat[itemsDatIndex] = {type:'users'};
			importDataUtil.buildFinalImportListRow(tbody, itemsDatIndex, langVar('lang_admin.import.users') + ':', importData.v7numberOfUsers);
		}
		util.chainE(container, table, tbody);
	},
	buildFinalImportListRow: function(tbody, itemsDatIndex, label1, label2) {
		var tr = util.createE('tr');
		var td1 = util.createE('td', {width:'10%'});
		var td2 = util.createE('td', {width:'10%'});
		// td3 is used to indicate importing state (Importing, Completed)
		var td3Id = 'import_data:final:state:' + itemsDatIndex;
		var td3 = util.createE('td', {id:td3Id, width:'80%', whiteSpace:'normal'});
		var text1 = util.createT(label1);
		var text2 = util.createT(label2);
		var text3 = util.createT('&nbsp;');
		util.chainE(tbody, [tr, [td1, text1], [td2, text2], [td3, text3]]);
	}
};
//
//
// 
// importDataStack (handles the actual import by sending import objects to the server)
//
//
//
var importDataStack = {
	isCancel: false, // is set to true if the user close the Wizard while importing,
					// in this case we stop importing any data
	importIndex: -1, // The import object which is currently handled on server side
	importId: '', // An Id of the current imported item. It is used to save the import data in sessions on the server side
	isErrors: false,
	start: function() {
		// Reset the importer
		importDataStack.isCancel = false;
		importDataStack.importIndex = -1;
		importDataStack.importId = '';
		importDataUtil.isErrors = false;
		// TEMP
		// util.showObject(importData.itemsDat);
		// return false;
		// Start importing items
		importDataStack.importItem();
	},
	importItem: function() {
		var itemsDat = importData.itemsDat;
		var itemIndexOfImportItem = importDataStack.importIndex + 1;
		var statuslineText = '&nbsp;';
		if (itemIndexOfImportItem < itemsDat.length) {
			importDataStack.importIndex = itemIndexOfImportItem;
			// If this is a database make sure that the profile
			// had no error upon import.
			// Send import item to server
			var importItem = itemsDat[itemIndexOfImportItem];
			var importType = importItem.type; // profile | database | schedules | users
			var theProfile;
			var skipImport = false;
			if (importType == 'database') {
				theProfile = importItem.reference;
				skipImport = theProfile.isError; // profile has not been imported so we can't import the database!
			}
			if (!skipImport) {
				// Indicate state
				importDataStack.showImportState(itemIndexOfImportItem, 'importing');
				// util.showObject(importItem);
				var theDate = new Date();
				var importId = 'import_' + theDate.getTime();
				importDataStack.importId = importId;
				var url = '?dp=admin_pages.import_data.import_item';
				var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
				dat += 'v.fp.import_id=' + importId;
				dat += '&v.fp.import_type=' + importType;
				dat += '&v.fp.item_index_of_import_item=' + itemIndexOfImportItem;
				if (importType == 'profile' || importType == 'database') {
					// Include profile item data from importData.v7profilesDb
					theProfile = importItem.reference;
					var profileLabel = theProfile.label;
					// util.showObject(theProfile);
					// Set v8overridesV7database, it will only have relevance if we override
					// an existing profile
					var v8overridesV7database = false;
					if (importType == 'profile') {
						// Check if we delete any existing version 8 database
						if (theProfile.profileExistsInV8 && theProfile.isImportDatabase) {
							if (theProfile.isMysql) {
								if (theProfile.mysqlDatabaseName == theProfile.newMysqlDatabaseName) {
									v8overridesV7database = true;
								}
							}
							else if (theProfile.isCustomDbDirectory) {
								if (theProfile.databaseDirectory == theProfile.newCustomDatabaseDirectory) {
									v8overridesV7database = true;
								}
							}
						}
						statuslineText = langVar('lang_admin.import.importing_profile');
						statuslineText = statuslineText.replace(/__PARAM__1/, profileLabel);
					}
					else {
						// importType == 'database'						
						statuslineText = langVar('lang_admin.import.importing_database');
						statuslineText = statuslineText.replace(/__PARAM__1/, profileLabel);
					}
					// dat += '&v.fp.v7_profile_name=' + encodeURIComponent(theProfile.name);
					dat += '&v.fp.v7_profile_pathname=' + encodeURIComponent(theProfile.pathname);
					dat += '&v.fp.v7_profile_label=' + encodeURIComponent(theProfile.label);
					dat += '&v.fp.profile_exists_in_v8=' + theProfile.profileExistsInV8;
					dat += '&v.fp.existing_v8_profile_name=' + encodeURIComponent(theProfile.existingV8profileName);
					dat += '&v.fp.new_v8_profile_name=' + encodeURIComponent(theProfile.newV8profileName);
					// dat += '&v.fp.is_import_database=' + theProfile.isImportDatabase;
					dat += '&v.fp.v8_overrides_v7_database=' + v8overridesV7database;
					dat += '&v.fp.v7_database_pathname=' + encodeURIComponent(theProfile.databaseDirectory);
					dat += '&v.fp.is_mysql=' + theProfile.isMysql;
					dat += '&v.fp.v7_mysql_database_name=' + encodeURIComponent(theProfile.mysqlDatabaseName);
					dat += '&v.fp.v8_mysql_database_name=' + encodeURIComponent(theProfile.newMysqlDatabaseName);
					dat += '&v.fp.is_custom_database_directory=' + theProfile.isCustomDbDirectory;
					dat += '&v.fp.v8_custom_database_directory=' + encodeURIComponent(theProfile.newCustomDatabaseDirectory);
				}
				else {
					dat +=  '&v.fp.v7_lai_pathname=' + encodeURIComponent(importData.pathname);
					if (importType == 'schedules') {
						statuslineText = langVar('lang_admin.import.importing_schedules');
					}
					else {
						dat +=  '&v.fp.current_user_username=' + encodeURIComponent(importData.currentUserUsername);
						statuslineText = langVar('lang_admin.import.importing_users');
					}
				}
				if (!importDataStack.isCancel) {
					util.serverPost(url, dat);
				}
			}
			else {
				importDataStack.showImportState(itemIndexOfImportItem, 'skip');
				// Continue with import
				importDataStack.importItem();
			}
		}
		else {
			// Import is complete
			// alert('Import complete, all items have been imported');
			statuslineText = !importDataStack.isErrors ? langVar('lang_admin.import.import_completed') : langVar('lang_admin.import.import_completed_with_errors');
			util.updateT('import_data:cancel_btn', langVar('lang_stats.btn.close'));
		}
		util.updateT('import_data:final:statusline', statuslineText);
	},
	importItemResponse: function(dat) {
		var importId = dat.importId;
		// alert('importItemResponse() - importId: ' + importId);
		// If valid response
		if ((importId == importDataStack.importId) && !importDataStack.isCancel) {
			var importType = dat.importType;
			if (importType == 'profile') {
				// Set new version 8 profile name for eventual later use upon database import
				var itemIndexOfImportItem = dat.itemIndexOfImportItem;
				var itemsDat = importData.itemsDat;
				var importItem = itemsDat[itemIndexOfImportItem];
				var theProfile = importItem.reference;
				theProfile.newV8profileName = dat.newV8profileName;
				// util.showObject(theProfile);
				// alert('dat.newV8profileName: ' + dat.newV8profileName);
			}
			// Check the importing state.
			// Wait 1.5 sec before checking the state
			setTimeout("importDataStack.getImportingState()", 1500);
		}
	},
	getImportingState: function() {
		var url = '?dp=admin_pages.import_data.get_importing_state';
		var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
		dat += 'v.fp.import_id=' + importDataStack.importId;
		util.serverPost(url, dat);
	},
	getImportingStateResponse: function(dat) {
		// alert('getImportingStateResponse()');
		if ((dat.importId == importDataStack.importId) && !importDataStack.isCancel) {
			if (dat.isComplete) {
				// Indicate state (complete | complete with error)
				// Note, we need to track any error in itemsDat
				// because if a profile fails then we don't import
				// any database.
				var isError = dat.isError;
				if (isError) {
					importDataStack.isErrors = true;
				}
				var importIndex = importDataStack.importIndex;
				var importItem = importData.itemsDat[importIndex];
				if (importItem.type == 'profile') {
					var theProfile = importItem.reference;
					theProfile['isError'] = isError;
				}
				var importState = isError ? 'error' : 'complete';
				var errorId = dat.errorId;
				importDataStack.showImportState(importIndex, importState, errorId);
				// alert('Import item complete. Indicate state');
				// Continue to import the next item
				importDataStack.importItem();
			}
			else {
				// Continue checking importing state
				setTimeout("importDataStack.getImportingState()", 1000);
			}
		}
	},
	showImportState: function(itemIndexOfImportItem, importState, errorId) {
		// errorId is optional!
		var importStateText = '';
		var className = '';
		switch (importState) {
			case 'importing':
				importStateText = langVar('lang_admin.import.importing');
				break;
			case 'complete':
				importStateText = langVar('lang_admin.import.complete');
				break;
			case 'error':
				importStateText = '<span style="color:Red">' + langVar('lang_admin.import.import_failed') + '</span><br />';
				importStateText += '<a href="?dp=alert&ei=' + errorId + '" target="_blank">' + langVar('lang_admin.import.click_here_to_view_alert') + '</a>';
				// className = 'import-data-error';
				break;
			case 'skip':
				importStateText = langVar('lang_admin.import.skipped_due_profile_error');
				className = 'import-data-error';
				break;
		}
		var containerElement = util.getE('import_data:final:state:' + itemIndexOfImportItem);
		if (className != '') {
			containerElement.className = className;
		}
		// util.updateT('import_data:final:state:' + itemIndexOfImportItem, importStateText);
		containerElement.innerHTML = importStateText;
	}
};
//
// admin import
//
var importData = {
	panel: null,
	validator: null,
	wizardPages: [ // contains the wizard pages but also any sub windows like loading_info
		'import_data:loading_info:page',
		'import_data:define_pathname:page',
		'import_data:choose_objects:page',
		'import_data:choose_databases:page',
		'import_data:override_objects_warning:page',
		'import_data:override_databases_warning:page',
		'import_data:final:page'
	],
	wizardPath: [], // Keeps the state of the wizard pages, i.e.: ['define_pathname', 'choose_objects', ...]
	pathname: '', // the version 7 LogAnalysisInfo directory
	isLoaded: false, // Set to true if initial data (v7profilesDb, v7numberOfSchedules, ...) are loaded
	v7profilesDb: [], // contains al version 7 profiles data
	v8profilesDb: [],
	v7numberOfSchedules: 0, // number of version 7 schedules
	v7numberOfUsers: 0, // number of version 7 users, the number does not include the current user and it does not include any root admin user
	isDuplicateUsers: false, // Indicates if version 8 already contains any version 7 username (current user username and root admin is excluded because they are not imported!)
	currentUserUsername: '', // the username of the current logged in user, it is required when importing users!
	isImportProfiles: false, // just used to check if any profile is selected so that we know when to enable the Next button
	isOverrideProfiles: false,
	isImportSchedules: false, 
	isImportUsers: false,
	isOverrideUsers: false,
	isOverrideDatabases: false, // This may also be true if no database is imported but is set because
								// the v7 and v8 profile have identical database data (same MySQL name or custom database directory)
	itemsDat: [] // contains the data which are finally imported
};
function initPage() {
	// Init help
	util.helpWindow.init('');
	initWizard();
	util.showE('form_section');
}
function initWizard() {
	var YE = YAHOO.util.Event;
	//
	// Init wizard panel
	//
	var panelObj = {
		panelId: 'import_data:panel',
		panelClassName: 'panel-50',
		panelHeaderLabel: langVar('lang_admin.import.import_wizard'),
		left: 20,
		top: 70,
		zIndex: 20,
		isCover: true,
		isSticky: true,
		closeEvent: closeWizard
	};
	importData.panel = new util.Panel3(panelObj);
	importData.validator = new util.Validator();
	YE.addListener('import_data:start_wizard_btn', 'click', openWizard);
	YE.addListener('import_data:browse_btn', 'click', browsePathname);
	YE.addListener('import_data:choose_objects:profiles:div', 'click', importProfilesActor);
	YE.addListener('import_data:choose_objects:schedules', 'click', importSchedulesActor);
	YE.addListener('import_data:choose_objects:users', 'click', importUsersActor);
	YE.addListener(['import_data:select_all_profiles_btn', 'import_data:deselect_all_profiles_btn'], 'click', selectDeselectAllProfiles);
	YE.addListener(['import_data:select_all_databases_btn', 'import_data:deselect_all_databases_btn'], 'click', selectDeselectAllDatabases);
	YE.addListener('import_data:override_databases_list:div', 'click', editDatabaseNameOrDirectory);
	YE.addListener('import_data:back_btn', 'click', goBack);
	YE.addListener('import_data:next_btn', 'click', goNext);
	YE.addListener('import_data:cancel_btn', 'click', closeWizard);
}
function openWizard() {
	// Reset the wizard
	util.updateT('import_data:final:statusline', '&nbsp;');
	util.updateT('import_data:cancel_btn', langVar('lang_stats.btn.cancel'));
	util.resetF('import_data:form');
	importData.wizardPath = [];
	importData.isLoaded = false; // We reload any data because the user could already have imported something
								// and hence we need to know the override info.
	importData.isImportProfiles = false;
	importData.isImportSchedules = false;
	importData.isImportUsers = false;
	// Set default pathname value
	util.setF('import_data:pathname', importData.pathname);
	setWizardPage('define_pathname');
	importData.panel.open();
}
function closeWizard() {
	// Stop importDataStack importing any data
	importDataStack.isCancel = true;
	importData.panel.close();
}
function getActivePageName() {
	var wizardPath = importData.wizardPath;
	return wizardPath[wizardPath.length - 1];
}
function setButtonState() {
	var wizardPath = importData.wizardPath;
	var activePageName = wizardPath[wizardPath.length - 1];
	var isEnbaledNext = true;
	var nextButtonLabel = langVar('lang_stats.btn.next') + ' >';
	if (activePageName == 'choose_objects') {
		isEnbaledNext = (importData.isImportProfiles || importData.isImportSchedules || importData.isImportUsers);
	}
	if (activePageName == 'final') {
		nextButtonLabel = langVar('lang_stats.btn.finish');
	}
	// Re-enable Next button because it could be disabled due loading state
	util.enableE('import_data:next_btn', isEnbaledNext);
	util.enableE('import_data:back_btn', (wizardPath.length > 1));
	util.updateT('import_data:next_btn', nextButtonLabel);
}
function setButtonImportingState() {
	// This state is set when import actually starts
	util.disableE('import_data:back_btn');
	util.disableE('import_data:next_btn');
}
function showLoadingInfo(showLoading) {
	var activePageName = getActivePageName();
	util.showE('import_data:loading_info:page', showLoading);
	util.showE('import_data:' + activePageName + ':page', !showLoading);
	if (showLoading) {
		util.disableE(['import_data:back_btn', 'import_data:next_btn']);
	}
	else {
		setButtonState();
	}
}
//
//
// Wizard - define v7 pathname
//
//
function checkoutPathnamePage() {
	// Validate the pathname
	var pathname = util.getF('import_data:pathname');
	var pathnamePattern = /^.{1,}LogAnalysisInfo[\\/]?$/;
	var isValidPathname = pathnamePattern.test(pathname);
	if (isValidPathname) {
		// We only load the data if they are not yet loaded or if the pathname changed
		if(importData.pathname == pathname && importData.isLoaded) {
			// Data already exist
			setWizardPage('choose_objects');
		}
		else {
			// Get the data
			showLoadingInfo(true);
			importData.pathname = pathname;
			var url = '?dp=admin_pages.import_data.check_pathname_and_data';
			var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
			dat += 'v.fp.pathname=' + encodeURIComponent(pathname);
			util.serverPost(url, dat);
		}
	}
	else {
		// show custom error message
		var pathnameErrorMsg = 'Please define a valid pathname, i.e: C:\\Program Files\\Sawmill\\LogAnalysisInfo';
		importData.validator.isCustom('import_data:pathname', pathnameErrorMsg);
		importData.validator.allValid();
	}
}
function checkoutPathnameAndDataResponse(dat) {
	function compareProfileLabels(a, b) {
		var labelA = a.label.toLowerCase();
		var labelB = b.label.toLowerCase();
		if (labelA < labelB) {return -1}
		if (labelA > labelB) {return 1}
		return 0;
	}
	// util.showObject(dat);
	if (dat.isValid) {
		importData.isLoaded = true;
		var v7profilesDb = dat.v7profilesDb;
		// Sort by profile label
		v7profilesDb.sort(compareProfileLabels);
		// Add following properties to v7profilesDb:
		// isImportProfile
		// isImportDatabase
		// newMysqlDatabaseName
		// newCustomDatabaseDirectory
		// newV8profileName
		for (var i = 0; i < v7profilesDb.length; i++) {
			var theProfile = v7profilesDb[i];
			theProfile['isImportProfile'] = false;
			theProfile['isImportDatabase'] = false;
			theProfile['newMysqlDatabaseName'] = theProfile.mysqlDatabaseName; // The new default name is equal the existing name
			// Set newCustomDatabaseDirectory, default is the existing custom directory if isCustomDbDirectory is true
			theProfile['newCustomDatabaseDirectory'] = theProfile.isCustomDbDirectory ? theProfile.databaseDirectory : '';
			theProfile['newV8profileName'] = ''; // We get the new name upon importing the profile item, which is required in case that we import a database as well.
			// util.showObject(v7profilesDb[i]);
		}
		// util.showObject(v7profilesDb);
		var v7numberOfSchedules = dat.v7numberOfSchedules;
		var v7numberOfUsers = dat.v7numberOfUsers
		importData.v7profilesDb = v7profilesDb;
		importData.v8profilesDb = dat.v8profilesDb;
		importData.v7numberOfSchedules = v7numberOfSchedules;
		importData.v7numberOfUsers = v7numberOfUsers;
		importData.isDuplicateUsers = dat.isDuplicateUsers;
		importData.currentUserUsername = dat.currentUserUsername;
		// Create hash for v8profilesDb
		util.createHash(importData.v8profilesDb, 'name');
		// Setup profiles list
		importDataUtil.buildProfilesObjectList(importData.v7profilesDb);
		// Setup import schedules
		util.updateT('import_data:choose_objects:schedules:number', '(' + v7numberOfSchedules + ')');
		util.enableE('import_data:choose_objects:schedules', (v7numberOfSchedules > 0));
		// Setup import users
		util.updateT('import_data:choose_objects:users:number', '(' + v7numberOfUsers + ')');
		util.enableE('import_data:choose_objects:users', (v7numberOfUsers > 0));
		// Go to next wizard page
		setWizardPage('choose_objects');
	}
	else {
		// Show pathname error message (Invalid pathname, path not found or not version 7 path) 
		showLoadingInfo(false);
		importData.validator.isCustom('import_data:pathname', dat.errorMsg);
		importData.validator.allValid();
	}
}
//
//
// Wizard - choose objects
//
//
function importProfilesActor(evt) {
	// We only check if a profile is selected or not to check for enable/disable Next button
	var isCheckedProfile = false;
	var v7profilesDb = importData.v7profilesDb;
	for (var i = 0; i < v7profilesDb.length; i++) {
		var isChecked = util.getF('import_data_profile_object:' + i);
		if (isChecked) {
			isCheckedProfile = true;
			break;
		}
	}
	importData.isImportProfiles = isCheckedProfile;
	setButtonState();
}
function selectDeselectAllProfiles() {
	var isSelectAllProfiles = (this.id == 'import_data:select_all_profiles_btn');
	var v7profilesDb = importData.v7profilesDb;
	for (var i = 0; i < v7profilesDb.length; i++) {
		util.setF('import_data_profile_object:' + i, isSelectAllProfiles);
	}
	importData.isImportProfiles = isSelectAllProfiles;
	setButtonState();
}
function importSchedulesActor() {
	importData.isImportSchedules = this.checked;
	setButtonState();
}
function importUsersActor() {
	importData.isImportUsers = this.checked;
	setButtonState();
}
function selectDeselectAllDatabases() {
	var isSelectAllDatabases = (this.id == 'import_data:select_all_databases_btn');
	// We simply get all checkboxes which are currently build
	var container = util.getE('import_data:choose_databases:div');
	var checkboxes = container.getElementsByTagName('input');
	for (var i = 0; i < checkboxes.length; i++) {
		checkboxes[i].checked = isSelectAllDatabases;
	}
}
function resetV8profilesDb() {
	// add/reset the "profileBecomesOverriden" property
	// in importData.v8profilesDb. We check this property
	// again upon checkoutChooseObjectsPage. It is required
	// when checking for duplicate database names or directories,
	// at this checking version 8 profiles can be ignored when
	// profileBecomesOverriden is true because the profile becomes
	// replaced with a version 7 profile.
	var v8profilesDb = importData.v8profilesDb;
	for (var i = 0; i < v8profilesDb.length; i++) {
		var theProfile = v8profilesDb[i];
		theProfile['profileBecomesOverriden'] = false;
	}
}
function checkoutChooseObjectsPage() {
	// Check what the user checked to import
	var isImportProfiles = importData.isImportProfiles;
	var isImportSchedules = importData.isImportSchedules;
	var isImportUsers = importData.isImportUsers;
	var numberOfImportProfilesWithHasDatabase = 0;
	var isOverrideProfiles = false;
	var isOverrideDatabases = false;
	if (isImportProfiles) {
		// Reset v8profilesDb
		resetV8profilesDb();
		// Check if we import a profile which has a database
		// and reset the isImportProfile and isImportDatabase properties.
		var v7profilesDb = importData.v7profilesDb;
		var v8profilesDb = importData.v8profilesDb;
		for (var i = 0; i < v7profilesDb.length; i++) {
			var isChecked = util.getF('import_data_profile_object:' + i);
			var theProfile = v7profilesDb[i];
			// util.showObject(theProfile);
			theProfile.isImportProfile = isChecked;
			theProfile.isImportDatabase = false;
			if (isChecked) {
				if (theProfile.hasDatabase) {
					numberOfImportProfilesWithHasDatabase++;
				}
				if (theProfile.profileExistsInV8) {
					// Mark the version 8 profiles so that we know
					// it becomes overriden.
					var v8profileName = theProfile.existingV8profileName;
					var theV8profile = v8profilesDb[util.h(v8profileName)];
					theV8profile['profileBecomesOverriden'] = true;
					isOverrideProfiles = true;
				}
				if (theProfile.isMysql || theProfile.isCustomDbDirectory) {
					// isOverrideDatabases is set regardless if the database is actually imported
					// because a user may want to use v7 and v8, which we don't know. To avoid any
					// conflicts we have to warn the user if v7 and v8 tries to share the same
					// database, it doesn't matter if the database is already built or not.
					isOverrideDatabases = true;
				}
			}
		}
	}
	// Set isOverrideProfiles, isOverrideUsers, isOverrideDatabases in global object for later use
	var isOverrideUsers = (importData.isImportUsers && importData.isDuplicateUsers);
	importData.isOverrideProfiles = isOverrideProfiles;
	importData.isOverrideUsers = isOverrideUsers;
	importData.isOverrideDatabases = isOverrideDatabases; 
	// alert('numberOfImportProfilesWithHasDatabase: ' + numberOfImportProfilesWithHasDatabase);
	if (numberOfImportProfilesWithHasDatabase > 0) {
		importDataUtil.buildDatabasesObjectList(v7profilesDb);
		setWizardPage('choose_databases');
	}
	else if (isOverrideProfiles || isOverrideUsers) {
		goToOverrideObjectsWarningPage();
	}
	else if (isOverrideDatabases) {
		goToOverrideDatabasesWarningPage();
	}
	else {
		goToFinalWizardPage();
	}
}
//
//
// Wizard - choose databases
//
//
function checkoutChooseDatabasesPage() {
	var v7profilesDb = importData.v7profilesDb;
	var isImportMySqlDatabase = false;
	var isCustomDbDirectory = false;
	for (var i = 0; i < v7profilesDb.length; i++) {
		var theProfile = v7profilesDb[i];
		if (theProfile.isImportProfile && theProfile.hasDatabase) {
			var isImportDatabase = util.getF('import_data_profile_db_object:' + i);
			theProfile.isImportDatabase = isImportDatabase;
		}
	}
	if (importData.isOverrideProfiles || importData.isOverrideUsers) {
		goToOverrideObjectsWarningPage();
	}
	else if (importData.isOverrideDatabases) {
		// isOverrideDatabases is already set upon the profiles object page because
		// we show the override warning also for un-build v7 databases!
		goToOverrideDatabasesWarningPage();
	}
	else {
		goToFinalWizardPage();
	}
}
//
//
// Override objects warning page
//
//
function goToOverrideObjectsWarningPage() {
	// alert('goToOverrideObjectsWarningPage()');
	var wizardLabel = '';
	var isOverrideProfiles = importData.isOverrideProfiles;
	var isOverrideUsers = importData.isOverrideUsers;
	if (isOverrideProfiles && isOverrideUsers) {
		wizardLabel = langVar('lang_admin.import.override_profiles_and_users_warning');
	}
	else if (isOverrideProfiles) {
		wizardLabel = langVar('lang_admin.import.override_profiles_warning');
	}
	else {
		wizardLabel = langVar('lang_admin.import.override_users_warning');
	}
	util.updateT('import_data:override_info:wizard_label', wizardLabel);
	util.showE('import_data:override_info:profiles', isOverrideProfiles);
	util.showE('import_data:override_info:users', isOverrideUsers);
	setWizardPage('override_objects_warning');
}
//
//
//
// Override databases warning page handling
//
//
//
function goToOverrideDatabasesWarningPage() {
	importDataUtil.buildOverrideDatabasesList(importData.v7profilesDb);
	setWizardPage('override_databases_warning');
}
function checkoutOverrideDatabasesWarningPage() {
	goToFinalWizardPage();
}
function editDatabaseNameOrDirectory(evt) {
	var element = evt.target || evt.srcElement;
	var tagName = element.nodeName;
	if (tagName == 'A') {
		// Get itemIndex from elementId
		var elementId = element.id;
		var dat = elementId.split(':');
		var itemIndex = parseInt(dat[2], 10);
		importDataEditDb.open(itemIndex);
	}
}
//
//
// Final wizard page
//
//
function goToFinalWizardPage() {
	// alert('goToFinalWizardPage()');
	// Build final import list
	importDataUtil.buildFinalImportList();
	// Set final wizard page
	setWizardPage('final');
}
//
// General wizard handling
//
function goBack() {
	// Activated when clicking the Back button
	var wizardPath = importData.wizardPath;
	var currentPageIndex = wizardPath.length - 1;
	var currentPageName = wizardPath[currentPageIndex];
	var previousPageName = wizardPath[currentPageIndex - 1];
	/*
	if (currentPageName == 'define_mysql_names') {
		// Remember the new mySQL names if any are defined
		// so that the user must not re-type any new name
		// when re-entering this page
		var v7profilesDb = importData.v7profilesDb;
		for (var i = 0; i < v7profilesDb.length; i++) {
			var theProfile = v7profilesDb[i];
			if (theProfile.isImportDatabase && theProfile.isMysql) {
				theProfile.newMysqlDatabaseName = util.getF('import_data_new_mysql_database_name:' + i);
			}
		}
	}
	*/
	// Remove current page from array
	wizardPath.splice(currentPageIndex, 1);
	// alert('goBack() - wizardPath: ' + wizardPath);
	util.hideE('import_data:' + currentPageName + ':page');
	util.showE('import_data:' + previousPageName + ':page');
	setButtonState();
}
function goNext() {
	// Activated when clicking the Next button
	var activePageName = getActivePageName();
	// alert('goNext() - currentPageName: ' + currentPageName);
	switch (activePageName) {
		case 'define_pathname':
			checkoutPathnamePage();
			break;
		case 'choose_objects':
			checkoutChooseObjectsPage();
			break;
		case 'choose_databases':
			checkoutChooseDatabasesPage();
			break;
		case 'override_objects_warning':
			if (importData.isOverrideDatabases) {
				goToOverrideDatabasesWarningPage();
			}
			else {
				goToFinalWizardPage();
			}
			break;
		case 'override_databases_warning':
			checkoutOverrideDatabasesWarningPage();
			break;
		case 'final':
			setButtonImportingState();
			importDataStack.start();
			break;
	}
}
function setWizardPage(pageName) {
	util.hideE(importData.wizardPages);
	var wizardPath = importData.wizardPath;
	wizardPath[wizardPath.length] = pageName;
	util.showE('import_data:' + pageName + ':page');
	setButtonState();
}
function browsePathname() {
	util.fileManagerWindow.open('import_data:pathname');
}
