//
//
// setup.js
//
//
var setup = {
	validator: null,
	wizardPages: [ // contains the wizard pages but also any sub windows like saving info
		'setup:welcome:page',
		'setup:license_agreement:page',
		'setup:licensing:page',
		'setup:root_admin:page',
		'setup:email_and_smtp_server:page',
		'setup:trial_selection:page',
		'setup:talkback:page',
		'setup:antivirus_warning:page',
		'setup:finish:page',
		'setup:saving:page'
	],
	wizardPath: [], // Keeps the state of the wizard pages, i.e.: ['welcome', 'license_agreement', ...]
	activeNextButtonLabel: '',
    expandCollapseLicenseKeyFieldBtn: null,
	// ACTIVE FORM DATA
	// Trial license
	trialIsActive: false,
	trialLicenseKey: '', 	// the license created by create_trial_license() on server side.
							// Note, create_trial_license() must be invoked only once, else we don't get a valid license key!
	isValidTrialLicenseKey: false,
	// trialLicenseErrorMessage: '',
	// Non-trial license key
    isCollapsedLicenseKey: true,
	licenseKey: '',
	isValidLicenseKey: false,
	licenseErrorMessage: '',
	trialLicensingTier: '',
	init: function() {
		// alert('init()');
		var YE = YAHOO.util.Event;
		setup.validator = new util.Validator();
		// Reset form data (this may be necessarry in case of browseer reload or browser back button operation
		util.resetF('setup:form');
		YE.addListener(['license_agreement_accept', 'license_agreement_no_accept'], 'click', setup.toggleAcceptLicenseAgreement);
		YE.addListener(['setup:trial_license_btn', 'setup:license_key_btn'], 'click', setup.toggleLicensing);
		YE.addListener('setup:trial_selection:table', 'click', setup.trialSelectionActor);
		var commandLinkOptions = {
			classNameEnabled: 'command-link-50',
			classNameDisabled: 'command-link-50-disabled'
		};	
        setup.expandCollapseLicenseKeyFieldBtn = new util.CommandLink('setup:expand_collapse_license_key_field_btn', setup.toggleLicenseKeyFieldHeight, true, commandLinkOptions);
        setup.expandCollapseLicenseKeyFieldBtn.disable();
		YE.addListener('setup:back_btn', 'click', setup.goBack);
		YE.addListener('setup:next_btn', 'click', setup.goNext);
		setup.setWizardPage('welcome');
	},
	resetErrors: function() {
		setup.validator.reset();
		util.hideE(['setup:trial_license_error_box', 'setup:license_key_error_box', 'setup:licensing_buy_info_box']);
	},
	//
	//
	// license agreement
	//
	//
	toggleAcceptLicenseAgreement: function() {
		// Enable/disable next button depending if user accepts license aggreemnet is handled within setButtonState()
		setup.setButtonState();
	},
	//
	//
	// licensing
	//
	//
	toggleLicensing: function() {
        // Switch between trial and license key
		// Reset validator
		setup.resetErrors();
		var isLicenseKey = (this.id == 'setup:license_key_btn');
		util.enableE('setup:license_key', isLicenseKey);
		if (isLicenseKey) {
			var element = util.getE('setup:license_key');
			element.focus();
		}
        // Handle expand/collapse license key button and text
        setup.expandCollapseLicenseKeyFieldBtn.enable(isLicenseKey);
        var textInfoElement = util.getE('setup:expand_collapse_license_key_field_info');
        var textInfoColor = isLicenseKey ? 'black' : 'silver';
        textInfoElement.style.color = textInfoColor;
	},
    toggleLicenseKeyFieldHeight: function() {
       // var btn = util.getE(setup:expand_collapse_license_key_field_btn);
        var textarea = util.getE('setup:license_key');
        var isCollapsedLicenseKey = setup.isCollapsedLicenseKey;
        textarea.rows = isCollapsedLicenseKey ? 13 : 2;
        var buttonLabel = isCollapsedLicenseKey ? langVar('lang_admin.licensing.collapse_license_field') : langVar('lang_admin.licensing.expand_license_field'); 
        util.updateT('setup:expand_collapse_license_key_field_btn', buttonLabel);
        setup.isCollapsedLicenseKey = !isCollapsedLicenseKey;
    },
	handleLicensing: function() {
		// Invoked when clicking Next on licensing page
		// var validator = setup.validator;
		setup.resetErrors();
		var trialIsActive = util.getF('setup:trial_license_btn');
		setup.trialIsActive = trialIsActive;
		if (trialIsActive) {
			if (setup.trialLicenseKey == '') {
				// Get a trial license key
				setup.getTrialLicenseKey();
			}
			else {
				// Trial license key already exists
				setup.validateLicensing();
			}
		}
		else {
			var licenseKey = util.getF('setup:license_key');
			if (licenseKey != '') {
				if (licenseKey != setup.licenseKey) {
					// Check if the license key is valid
					setup.checkLicenseKey(licenseKey);
				}
				else {
					// The license key has already be checked.
					setup.validateLicensing();
				}
			}
			else {
				// No license key defined
				setup.isValidLicenseKey = false;
				setup.licenseErrorMessage = langVar('lang_admin.licensing.no_license_key_message');
				setup.validateLicensing();
			}
		}
	},
	getTrialLicenseKey: function() {
		var url = '?dp=setup';
		var dat = 'v.fp.setup_directive=get_trial_license_key';
		util.serverPost(url, dat);
	},
	getTrialLicenseKeyResponse: function(dat) {
		// util.showObject(dat);
		setup.trialLicenseKey = dat.trialLicenseKey;
		setup.isValidTrialLicenseKey = dat.isValidTrialLicenseKey;
		setup.validateLicensing();
	},
	checkLicenseKey: function(licenseKey) {
		var url = '?dp=setup';
		var dat = 'v.fp.setup_directive=check_license_key';
		dat += '&v.fp.license_key=' + encodeURIComponent(licenseKey);
		util.serverPost(url, dat);
	},
	checkLicenseKeyResponse: function(dat) {
		setup.licenseKey = dat.licenseKey;
		setup.isValidLicenseKey = dat.isValidLicenseKey;
		setup.licenseErrorMessage = dat.licenseErrorMessage;
		setup.validateLicensing();
	},
	validateLicensing: function() {
		// Final licensing validation
		var trialIsActive = setup.trialIsActive;
		var isValidLicenseKey = trialIsActive ? setup.isValidTrialLicenseKey : setup.isValidLicenseKey;
		if (isValidLicenseKey) {
			var nextPage = setup.getNextPage();
			setup.setWizardPage(nextPage);
		}
		else {
			if (trialIsActive) {
				util.showE('setup:trial_license_error_box');
			}
			else {
				util.updateT('setup:license_key_error_text', setup.licenseErrorMessage);
				util.showE('setup:license_key_error_box');
			}
			util.showE('setup:licensing_buy_info_box');
		}
	},
	//
	//
	// root admin
	//
	//
	handleRootAdmin: function() {
		var validator = setup.validator;
		validator.reset();
		var username = validator.isValue('setup:username');
		var password = validator.isValue('setup:password');
		var password2 = validator.isValue('setup:password_2');
		if (password != '' && (password != password2)) {
			// Show custom error messsage
			var customErrorMessage = langVar('lang_stats.authentication.invalid_password2_message');
			validator.isCustom('setup:password_2', customErrorMessage);
		}
		if (validator.allValid()) {
			var nextPage = setup.getNextPage();
			setup.setWizardPage(nextPage);
		}
	},
	//
	//
	// email and SMTP server
	//
	//
	handleEmailAndSmtpServer: function() {
		// All values are optional, however, we validate the email address if not empty
		var validator = setup.validator;
		validator.reset();
		var emailAddress = util.getF('setup:email_address');
		if (emailAddress != '') {
			validator.isEmailAddress('setup:email_address');
		}
		if (emailAddress == '' || validator.allValid()) {
			var nextPage = setup.getNextPage();
			setup.setWizardPage(nextPage);
		}
	},
	//
	//
	//
	// trial selection
	//
	//
	//
	trialSelectionActor: function(evt) {
		var element = evt.target || evt.srcElement;
		var tagName = element.nodeName;
		var tdElement = null;
		if (tagName == 'TD') {
			tdElement = element;
		}
		else {
			// Check parent elements
			var parentElement = element.parentNode;
			while (parentElement != null) {
				tagName = parentElement.nodeName;
				if (tagName == 'TD') {
					tdElement = parentElement;
					break;
				}
				else {
					parentElement = parentElement.parentNode;
				}
			}
		}
		if (tdElement != null) {
			// alert('tdElement.id: ' + tdElement.id);
			var elementId = tdElement.id;
			if (elementId.indexOf('setup:trial_selection:licensing_tier:') != -1) {
				var dat = elementId.split(':');
				var licensingTier = dat[3];
				// Reset className of previus selected licensing features
				if (setup.trialLicensingTier != '') {
					var previousSelectedTd = util.getE('setup:trial_selection:licensing_tier:' + setup.trialLicensingTier);
					previousSelectedTd.className = '';
				}
				// Set the new licensing features
				// var td = util.getE('setup:trial_selection:licensing_tier:' + licensingTier);
				tdElement.className = 'active';
				util.setF('setup:trial_selection:licensing_tier_btn:' + licensingTier, true);
				setup.trialLicensingTier = licensingTier;
				// Enable the Next button
				util.enableE('setup:next_btn');
			}
		}
	},
	//
	//
	// finish
	//
	//
	finishSetup: function() {
		// alert('finishSetup()');
		util.hideE(['setup:finish:page', 'setup:back_btn', 'setup:next_btn']);
		util.showE('setup:saving:page');
		var isValidExistingLicense = pageInfo.isValidExistingLicense;
		var isValidExistingRootAdmin = pageInfo.isValidExistingRootAdmin;
		var promptForTrialTier = pageInfo.promptForTrialTier;
		var trialIsActive = setup.trialIsActive;
		// Variables we send to server side
		var licenseKey = '';
		var username = '';
		var password = '';
		var emailAddress = util.getF('setup:email_address');
		var smtpServer = util.getF('setup:smtp_server');
		var smtpUsername = util.getF('setup:smtp_username');
		var smtpPassword = util.getF('setup:smtp_password');
		var trialLicensingTier = '';
		var talkback = util.getF('setup:agree_talkback_btn');
		if (!isValidExistingLicense) {
			licenseKey = trialIsActive ? setup.trialLicenseKey : setup.licenseKey ;
		}
		if (!isValidExistingRootAdmin) {
			username = util.getF('setup:username');
			password = util.getF('setup:password');
		}
		if (trialIsActive && promptForTrialTier) {
			trialLicensingTier = setup.trialLicensingTier;
		}
		var url = '?dp=setup';
		var dat = 'v.fp.setup_directive=finish';
		dat += '&v.fp.license_key=' + encodeURIComponent(licenseKey);
		dat += '&v.fp.username=' + encodeURIComponent(username);
		dat += '&v.fp.password=' + encodeURIComponent(password);
		dat += '&v.fp.email_address=' + encodeURIComponent(emailAddress);
		dat += '&v.fp.smtp_server=' + encodeURIComponent(smtpServer);
		dat += '&v.fp.smtp_username=' + encodeURIComponent(smtpUsername);
		dat += '&v.fp.smtp_password=' + encodeURIComponent(smtpPassword);
		dat += '&v.fp.trial_licensing_tier=' + trialLicensingTier;
		dat += '&v.fp.talkback=' + talkback;
		util.serverPost(url, dat);
	},
	finishSetupResponse: function() {
		// alert('finishSetupResponse()');
		location.replace('?dp=index');
	},
	//
	//
	// general wizard pages behavior
	//
	//
	setButtonState: function() {
		var wizardPath = setup.wizardPath;
		var activePageName = wizardPath[wizardPath.length - 1];
		var isEnbaledNext = true;
		var isEnbaledBack = (activePageName != 'welcome');
		var nextButtonLabel = langVar('lang_stats.btn.next') + ' >';
		if (activePageName == 'license_agreement') {
			isEnbaledNext = util.getF('license_agreement_accept');
		}
		else if (activePageName == 'trial_selection') {
			isEnbaledNext = (setup.trialLicensingTier != '');
		}
		else if (activePageName == 'finish') {
			nextButtonLabel = langVar('lang_stats.btn.finish');
		}
		util.enableE('setup:next_btn', isEnbaledNext);
		util.enableE('setup:back_btn', isEnbaledBack);
		if (setup.activeNextButtonLabel != nextButtonLabel) {
			util.updateT('setup:next_btn', nextButtonLabel);
			setup.activeNextButtonLabel = nextButtonLabel;
		}
	},
	goBack: function() {
		// Activated when clicking the Back button
		var wizardPath = setup.wizardPath;
		var currentPageIndex = wizardPath.length - 1;
		var currentPageName = wizardPath[currentPageIndex];
		var previousPageName = wizardPath[currentPageIndex - 1];
		// Remove current page from array
		wizardPath.splice(currentPageIndex, 1);
		// alert('goBack() - wizardPath: ' + wizardPath);
		util.hideE('setup:' + currentPageName + ':page');
		util.showE('setup:' + previousPageName + ':page');
		setup.setButtonState();
	},
	goNext: function() {
		// Activated when clicking the Next or Finish button
		var activePageName = setup.getActivePageName();
		switch (activePageName) {
			// Use case for pages where we require validation,
			// else use default.
			case 'licensing':
				setup.handleLicensing();
				break;
			case 'root_admin':
				setup.handleRootAdmin();
				break;
			case 'email_and_smtp_server':
				setup.handleEmailAndSmtpServer();
				break;
			case 'finish':
				setup.finishSetup();
				break;
			default:
				var nextPage = setup.getNextPage();
				setup.setWizardPage(nextPage);
				break;
		}
	},
	setWizardPage: function(pageName) {
		var wizardPath = setup.wizardPath;
		wizardPath[wizardPath.length] = pageName;
		util.hideE(setup.wizardPages);
		util.showE('setup:' + pageName + ':page');
		setup.setButtonState();
	},
	getActivePageName: function() {
		var wizardPath = setup.wizardPath;
		return wizardPath[wizardPath.length - 1];
	},
	getNextPage: function() {
		var activePage = setup.getActivePageName();
		var nextPage = '';
		var isValidExistingLicense = pageInfo.isValidExistingLicense;
		var isValidExistingRootAdmin = pageInfo.isValidExistingRootAdmin;
		var promptForTrialTier = pageInfo.promptForTrialTier;
		var isWindows = pageInfo.isWindows;
		var trialIsActive = setup.trialIsActive;
		// Create the page sequence
		// (We always re-create the sequence from scratch because we don't know if i.e. trial is active or not)
		var pageSequence = [];
		pageSequence[pageSequence.length] = 'welcome';
		pageSequence[pageSequence.length] = 'license_agreement';
		if (!isValidExistingLicense) {
			pageSequence[pageSequence.length] = 'licensing';
		}
		if (!isValidExistingRootAdmin) {
			pageSequence[pageSequence.length] = 'root_admin';
		}
		pageSequence[pageSequence.length] = 'email_and_smtp_server';
		if (promptForTrialTier && !isValidExistingLicense && trialIsActive) {
			pageSequence[pageSequence.length] = 'trial_selection';
		}
		pageSequence[pageSequence.length] = 'talkback';
		if (isWindows) {
			pageSequence[pageSequence.length] = 'antivirus_warning';
		}
		pageSequence[pageSequence.length] = 'finish';
		for (var i = 0; i < pageSequence.length; i++) {
			if (pageSequence[i] == activePage) {
				nextPage = pageSequence[i+1];
			}
		}
		return nextPage;
	}
};
YAHOO.util.Event.onDOMReady(setup.init);
