//
// rolesSRCAD.js, Roles - Save Report Changes Access Details panel
//

var rolesSRCAD = {
	
	panel: null,
	
	init: function() {
		
		var YE = YAHOO.util.Event;
		
		//
		// Init the panel
		//
		
		var panelObj = {
			panelId: 'srcad:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_admin.roles.saving_scope'),
			left: 300,
			top: 160,
			zIndex: 20,
			isCover: true,
			isSticky: true,
			closeEvent: rolesSRCAD.closePanel
		};
		
		rolesSRCAD.panel = new util.Panel3(panelObj);
		
		YE.addListener('srcad:okay', 'click', rolesSRCAD.saveAccessDetails);
		YE.addListener('srcad:cancel', 'click', rolesSRCAD.closePanel);
	},
	
	openPanel: function(featureName, isUnlimitedGrants, items) {
		
		if (!roles.accessDetails.saveReportChangesToProfile.isView) {
			util.setF('srcad:save_report_changes_to_user_info_btn', true);
		}
		else {
			util.setF('srcad:save_report_changes_to_profile_btn', true);
		}
		
		rolesSRCAD.panel.open();
	},
	
	saveAccessDetails: function() {
		
		var isSaveToProfile = util.getF('srcad:save_report_changes_to_profile_btn');
		
		if (isSaveToProfile != roles.accessDetails.saveReportChangesToProfile.isView) {
			
			// The user changed the Save Report Changes Access Details
			
			// Update the save_report_changes_to_profile checkbox in role display
			var featureId = roles.accessDetails.saveReportChangesToProfile.featureId;
			util.setF(featureId + ':view', isSaveToProfile);
			
			roles.accessDetails.saveReportChangesToProfile.isView = isSaveToProfile;
			
			roles.isModifiedFeatures = true;
			
			// Update Display
			rolesUtil.updateSaveReportChangesAccessDetailsDisplay();
		}
		
		rolesSRCAD.closePanel();
	},
	
	closePanel: function() {
		
		rolesSRCAD.panel.close();
	}
}
