//
//
// forgotPassword.js
//
//

var forgotPassword = function() {
	
	var YE = YAHOO.util.Event;
	var validator;
	
	function init() {
		
		validator = new util.Validator();
		YE.addListener('forgot_password:username', 'keypress', processFormViaEnterKey);
		YE.addListener('forgot_password:submit_btn', 'click', processForm);
	}
	
	function processFormViaEnterKey(evt) {
		
		var keyCode = (evt.which) ? evt.which : evt.keyCode;
		
		if (keyCode == 13 || keyCode == 3) {
			processForm();
		}
	}
	
	function processForm() {
		
		validator.reset();
		var username = validator.isValue('forgot_password:username');
		
		if (validator.allValid()) {
			
			util.hideE(['forgot_password:error_message', 'forgot_password:form']);
			util.showE('forgot_password:loading');
			
			var url = '?dp=authentication';
			var base_url = window.location.protocol + '//' + window.location.host + '/';
			
			var dat = 'v.fp.is_forgot_password_form_processing=true&';
			dat += 'v.fp.username=' + encodeURIComponent(username) +  '&';
			dat += 'v.fp.base_url=' + encodeURIComponent(base_url);
			
			// console.log(base_url);
			util.serverPost(url, dat);
		}
	}
	
	function processFormResponse(dat) {
		
		util.hideE('forgot_password:loading');
		
		// errorMessage only exists if we show the form again.
		if (dat.errorMessage != '') {
			
			util.updateT('forgot_password:error_message', dat.errorMessage);
			util.showE(['forgot_password:error_message', 'forgot_password:form']);
		}
		
		// show generalMessage regardless if there is an errorMessage
		if (dat.generalMessage != '') {
			// Note, generalMessage may contain HTML tags, so use innerHTML
			var element = util.getE('forgot_password:general_message');
			element.innerHTML = dat.generalMessage;
			
			util.showE('forgot_password:general_message');
		}
		
		// util.showE('forgot_password:return_btn');
	}
	
	//
	//
	// Return global properties and methods
	//
	//
	
	return {
		init:init,
		processFormResponse: processFormResponse
	}
}();

YAHOO.util.Event.onDOMReady(forgotPassword.init);
