//
//
// reportEditor.js
//
//

var reportEditor = {
	
	panel: null,
	// validator: null,
	tabs: null,
	
	
	init: function() {
		
		// reportEditor.validator = new util.Validator();
		
		//
		// Init the Editor panel
		//
		
		var panelObj = {
			panelId: 'report_editor:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_admin.report_editor.edit_report_properties'),
			left: 330,
			top: 140,
			zIndex: 20,
			isCover: true,
			isSticky: true,
			closeEvent: reportEditor.closePanel
		};
		
		reportEditor.panel = new util.Panel3(panelObj);
		
		// Init tabs
		var tabIds = ['display_options', 'filters', 'header_footer'];
		reportEditor.tabs = new util.Tabs3('report_editor:tabs', tabIds, reportEditor.display.tabActivated);
		reportEditor.tabs.setSequence(tabIds, 'display_options');
		
		
		//
		// Add events
		//
		
		var YE = YAHOO.util.Event;
		YE.addListener('report_editor:filter_expression:show_available_fields_btn', 'click', reportsUtil.viewAvailableReportFilterFields.open);
		YE.addListener('report_editor:filter_expression:view_help_btn', 'click', util.helpWindow.openGeneralHelp);
		
		YE.addListener('report_editor:remove_saved_filter_items_btn', 'click', reportEditor.removeSavedFilterItems);
	
		YE.addListener('report_editor:okay_btn', 'click', reportEditor.saveItem);
		YE.addListener('report_editor:cancel_btn', 'click', reportEditor.closePanel);
	},
	
	display: {
		
		tabActivated: function(tabId) {
			
			if (!util.isObject(tabId)) { // isObject has be addded due an IE problem, see customizeRE.js for details
				reportEditor.display.setTabPanel(tabId);
			}
		},
		
		setTabPanel: function(tabId) {
			
			// alert('setTabPanel(): ' + tabId);
			
			reportEditor.tabs.setActiveTab(tabId);
			
			// tabId is: display_options | header_footer | filters
			util.hideE(['report_editor:display_options:panel', 'report_editor:filters:panel', 'report_editor:header_footer:panel']);
			util.showE('report_editor:' + tabId + ':panel');
		}
	},
	
	openPanel: function() {
		
		// Reset form elements
		util.resetF('report_editor:form');
		
		// Update the form
		reportEditor.updateForm();
		
		// Set default tab panel
		reportEditor.display.setTabPanel('display_options');
		
		reportEditor.panel.open();
	},
	
	closePanel: function() {
		
		reportEditor.panel.close();
		// Close view filter fields panel in case that is open
		reportsUtil.viewAvailableReportFilterFields.close();
	},
	
	updateForm: function() {
		
		// Read data from reports.activeItemDat
		
		var activeItemDat = reports.activeReportItemDat;
		
		util.setF('report_editor:show_header_bar', activeItemDat.show_header_bar);
		util.setF('report_editor:sync_graph_axis_with_relative_date', activeItemDat.sync_graph_axis_with_relative_date);
		util.setF('report_editor:description', activeItemDat.description);
		util.setF('report_editor:date_filter', activeItemDat.date_filter);
		util.setF('report_editor:filter_expression', activeItemDat.filter_expression);
		util.setF('report_editor:header', activeItemDat.header);
		util.setF('report_editor:footer', activeItemDat.footer);
		
		// Update filter items
		var isFilterItems = (activeItemDat.filter_items.length > 0);
		var filterItemsLabel = isFilterItems ? langVar('lang_admin.report_editor.exists') : langVar('lang_stats.btn.none');
		util.updateT('report_editor:saved_filter_items_info', filterItemsLabel);
		util.showE('report_editor:remove_saved_filter_items_btn', isFilterItems);
	},
	
	removeSavedFilterItems: function() {
		
		reports.activeReportItemDat.filter_items = [];
		util.updateT('report_editor:saved_filter_items_info', langVar('lang_stats.btn.none'));
		util.hideE('report_editor:remove_saved_filter_items_btn');
	},
	
	saveItem: function() {
		
		// Write data to reports.activeItemDat
		var activeItemDat = reports.activeReportItemDat;
		
		activeItemDat.show_header_bar = util.getF('report_editor:show_header_bar');
		activeItemDat.sync_graph_axis_with_relative_date = util.getF('report_editor:sync_graph_axis_with_relative_date');
		activeItemDat.description = util.getF('report_editor:description');
		activeItemDat.date_filter = util.getF('report_editor:date_filter');
		activeItemDat.filter_expression = util.getF('report_editor:filter_expression');
		activeItemDat.header = util.getF('report_editor:header');
		activeItemDat.footer = util.getF('report_editor:footer');
		
		reportEditor.closePanel();
	}
};


