var logFormatsList = function() {

    var YE = YAHOO.util.Event,
        YD = YAHOO.util.Dom;

    //
    // Return global properties and methods
    //

    function list(isLite, containerElementId, showAllLabel) {

        // Creates a new list object

        this.isLite = isLite;
        this.containerElement = util.getE(containerElementId);
        this.showAllLabel = showAllLabel;
        this.selectedRow = null; // Reference to selected tr element
        this.baseId = util.getUniqueElementId();

        // YE.addListener(this.containerElement, 'click', this.rowSelect, this);
        YE.delegate(this.containerElement, "click", this.rowSelect, "tr", this);
    }

    list.prototype = {

//      getIsReady: function() {
//          return this.isReady;
//      },

        createList: function(logFormatDb, filterByLogDataType) {

            // This creates a new log format list
            // filterByLogDataType is used to filter syslog_required and syslog formats

            // Reset selected
            this.selectedRow = null;

            // Clean up list
            util.removeChildElements(this.containerElement);

            // Sort logFormatDb by metaTypeLabel
            logFormatDb.sort(this.compareMetaTypeLabels);

            var table = util.createE('table', {className: 'multiple-match-list'}),
                tbody = util.createE('tbody'),
                tr = null,
                indexCell = null,
                typeCell = null,
                labelCell = null,
                i = 0,
                j = 1,
                id = '',
                item = null;

            for (i = 0; i < logFormatDb.length; i++) {

                item = logFormatDb[i];

                if (filterByLogDataType == '' ||
                    filterByLogDataType == item.type) {

                    id = this.baseId + ':' + item.id;
                    tr = util.createE('tr', {id: id});
                    indexCell = this.getIndexCell(j + '.');
                    typeCell = this.getGeneralCell(item.metaTypeLabel);
                    labelCell = this.getLabelCell(item.labels);
                    util.chainE(tbody, [tr, indexCell, typeCell, labelCell]);
                    j += 1;
                }
            }

            // alert('this.isLite: ' + this.isLite);

            if (!this.isLite) {

                // Add Show all row
                id = this.baseId + ':__SHOW__ALL__';
                tr = util.createE('tr', {id: id});
                indexCell = this.getIndexCell('&nbsp;');
                labelCell = this.getShowAllLabelCell();
                util.chainE(tbody, [tr, indexCell, labelCell]);
            }

            util.chainE(this.containerElement, table, tbody);
        },

        rowSelect: function(evt, matchedEl, containerEl, self) {

            // alert('row selected matchedEl.id: ' + matchedEl.id);

            if (self.selectedRow != null) {
                self.setRow(self.selectedRow, '');
            }

            // Make new row selected
            self.setRow(matchedEl, 'selected');
            self.selectedRow = matchedEl;
        },

        setRow: function(rowElement, className) {

            var thElements = rowElement.getElementsByTagName('TH'),
                tdElements = rowElement.getElementsByTagName('TD'),
                i = 0;

            thElements[0].className = className;

            // number of td elements may be different due Show All row,
            // so we use a loop for it
            for (i = 0; i < tdElements.length; i++) {
                tdElements[i].className = className;
            }
        },

        getSelectedId: function() {

            // Returns the selected log format id or empty string if
            // no log format has been selected
            var selectedLogFormatId = '',
                id = '',
                dat = [];

            if (this.selectedRow != null) {

                id = this.selectedRow.id;
                dat = id.split(':');
                selectedLogFormatId = dat[1];
            }

            return selectedLogFormatId;
        },

        getIndexCell: function(label) {

            var th = util.createE('th'),
                text = util.createT(label);

            util.chainE(th, text);
            return th;
        },

        getGeneralCell: function(label) {

            var td = util.createE('td'),
                text = util.createT(label);

            util.chainE(td, text);
            return td;
        },

        getLabelCell: function(labels) {

            var td = util.createE('td', {width: '80%'}),
                text = '',
                br = null,
                i = 0,
                numLabels = labels.length;

            // Sort labels
            labels.sort();

            for (i = 0; i < numLabels; i++) {

                text = util.createT(labels[i]);
                util.chainE(td, text);

                if (i + 1 < numLabels) {

                    // Add br tag
                    br = util.createE('br');
                    util.chainE(td, br);
                }
            }

            return td;
        },

        getShowAllLabelCell: function() {

            var td = util.createE('td', {colSpan: 2}),
                em = util.createE('em'),
                text = util.createT(this.showAllLabel);

            util.chainE(td, em, text);
            return td;
        },

        compareMetaTypeLabels: function(a, b) {
            var labelA = a.metaTypeLabel.toLowerCase();
            var labelB = b.metaTypeLabel.toLowerCase();
            if (labelA < labelB) {return -1}
            if (labelA > labelB) {return 1}
            return 0;
        }
    }

    return {
        list: list
    }
}();