//
// newReport.js
//


var newReport = {
	
	// initial values are set upon newReport.init()
	// and are overriden by specific data upon a new request
	
	webBrowserSessionId: '',
	reportName: '',
	isCalendar: false,
	dateFilter: '',
	commandLineFilter: '',
	commandLineFilterComment: '',
	filterId: '',
	reportInfoId: '',
	isUpdateReportInfo: false,
	directives: { // use Salang variable naming style for directives so that the property name becames a node name when assembling the URL
		source_report_info_id: '',
		action: '', // reset_row_numbers | set_row_number | sort | pivot_table | breakdown | clear_breakdown | customize_report_element
		report_element_name: '',
		starting_row: 0,
		ending_row: 0,
		number_of_rows: 0,
		sort_by: '',
		sort_direction: '',
		pivot_table: {
			report_field: '',
			number_of_rows: '',
			sort_by: '',
			sort_direction: '',
			show_averages_row: false
		},
		breakdown: { // we look up the breakdown item and any additional filter value in the raw report element
			raw_report_element_id: '',
			raw_row_number: 0
		},
		session_page_paths: {
			is_page_path: false,
			page_path: '', // page name of session_page_paths
			raw_report_element_id: '', // session_path_paths option if activated via link (get page_path on server side from raw report element 
			row: '',
			predecessor_successor_name: ''
		}
		
		// drill_down_report_field: '',
		// drill_down_number_of_rows: ''
	},
	
	
	init: function() {
		
		// alert('newReport.js - init()');
		
		// set/update data for new report requests
		newReport.webBrowserSessionId = reportInfo.webBrowserSessionId;
		newReport.reportName = reportInfo.reportName;
		newReport.dateFilter = reportInfo.dateFilter;
		newReport.filterId = reportInfo.filterId;
		newReport.commandLineFilter = reportInfo.commandLineFilter;
		newReport.commandLineFilterComment = reportInfo.commandLineFilterComment;
	},
	
	setDateFilter: function(df) {
		
		// alert('setDateFilter:' + df);
		
		newReport.dateFilter = df;
		newReport.isUpdateReportInfo = true;
		newReport.directives.source_report_info_id = reportInfo.reportInfoId;
		newReport.directives.action = 'reset_row_numbers';
	
		newReport.request();
	},
	
	clearDateFilter: function() {
		newReport.clearDateFilterOrGlobalFilter(true, false);
	},
	
	clearGlobalFilter: function() {
		newReport.clearDateFilterOrGlobalFilter(false, true);
	},
	
	clearAllFilters: function() {
		newReport.clearDateFilterOrGlobalFilter(true, true);
	},
	
	clearDateFilterOrGlobalFilter: function(isClearDateFilter, isClearGlobalFilter) {
		
		if (isClearDateFilter) {newReport.dateFilter = '';}
		if (isClearGlobalFilter) {newReport.filterId = '';}
		
		newReport.isUpdateReportInfo = true;
		newReport.directives.source_report_info_id = reportInfo.reportInfoId;
		newReport.directives.action = 'reset_row_numbers';
		
		newReport.request();
	},

	setMacro: function(evt) {
		
		YAHOO.util.Event.preventDefault(evt);
		
		// alert('setMacro() - id:' + this.id);
		var elementId = this.id;
		var dat = elementId.split(':');
		var macroItemIndex = parseInt(dat[1], 10);
		
		var marcosDb = reportInfo.macros;
		var macroItem = marcosDb[macroItemIndex];
		
		// util.showObject(macroItem);
		
		if (macroItem['rn'] != null) {
			newReport.reportName = macroItem.rn;
		}
		
		if (macroItem['df'] != null) {
			newReport.dateFilter = macroItem.df;
		}
		
		if (macroItem['fi'] != null) {
			// Override filterId and command line filter
			newReport.filterId = macroItem.fi;
			newReport.commandLineFilter = macroItem.f;
			newReport.commandLineFilterComment = macroItem.fc;
		}
		
		newReport.request();
	},

	sortColumn: function(shortReportElementId, columnId) {
		
		var h = util.h;
		var reportElements = reportInfo.reportElements;
		var reportElement = reportInfo.reportElements[h(shortReportElementId)];

		var reColumns = reportInfo.reportElementColumns;
		var queryFieldsDb = reportInfo.queryFieldsDb;
		
		// alert('shortReportElementId: ' + shortReportElementId);
		// util.showObject(reportElement);
		
		var activeSortBy = reportElement.sortBy;
		var activeSortDirection = reportElement.sortDirection;
		
		// get activated sortBy data
		var sortBy = reColumns[shortReportElementId][columnId];
		var sortDirection;
		
		if (sortBy != activeSortBy) {
			
			// Sort text ascending and numerical columns descending			
			sortDirection = queryFieldsDb[h(sortBy)].isAggregatingField ? 'descending' : 'ascending';
		}
		else {
			
			sortDirection = (activeSortDirection == 'descending') ? 'ascending' : 'descending';
		}
		
		// alert('activeSortDirection: ' + activeSortDirection + '\nthe new sortDirection: ' + sortDirection);
		
		// Show a warning for log_detail repport if it is not yet sorted 
		// and if the number of total rows is greater than 1,000,000.
		
		// alert('activeSortBy: ' + activeSortBy);
		// alert('reportElement.totalRows: ' + reportElement.totalRows);
		
		if (reportElement.reportElementType == 'log_detail' &&
			activeSortBy == '' &&
			reportElement.totalRows > 1000000 &&
			!reportInfo.hideLogDetailSortingMessage) {
			
			logDetailSortingMsg.openViaColumnsSort(true, reportElement.name, sortBy, sortDirection);
		}
		else {
			
			// Sort right away
			newReport.sortColumnContinued(reportElement.name, sortBy, sortDirection);
		}
	},
	
	sortColumnContinued: function(reportElementName, sortBy, sortDirection) {
		
		// Called from sortColumn or via loDetailSortingMsg.js
		newReport.isUpdateReportInfo = true;
		
		var d = newReport.directives;
		d.source_report_info_id = reportInfo.reportInfoId;
		d.action = 'sort';
		d.report_element_name = reportElementName;
		d.sort_by = sortBy;
		d.sort_direction = sortDirection;
		
		// util.showObject(d);
		
		newReport.request();
	},
	
	setRowNumber: function(shortReportElementId, startingRow, endingRow, number_of_rows) {
		
		newReport.isUpdateReportInfo = true;
		
		var d = newReport.directives;
		d.source_report_info_id = reportInfo.reportInfoId;
		d.action = 'set_row_number';
		d.report_element_name = reportInfo.reportElements[util.h(shortReportElementId)].name;
		d.drill_down_number_of_rows = 1;
		d.starting_row = startingRow;
		d.ending_row = endingRow;
		d.number_of_rows = number_of_rows;
		
		// util.showObject(d);
		
		newReport.request();
	},
	
	setBreakdown: function(rowId) {
		
		// Get the rowID
		// var td = this.parentNode;
		// var tr = td.parentNode;
		// var rowId = tr.id;
		var h = util.h;

		var dat = rowId.split(':');
		var sid = dat[0];
		var rowNumber = dat[2];
		
		// alert('breakdownControl itemActivated(), rowID: ' + rowId);
		
		var reportElements = reportInfo.reportElements;
		
		newReport.isUpdateReportInfo = true;
		
		var directives = newReport.directives;
		directives.source_report_info_id = reportInfo.reportInfoId;
		directives.action = 'breakdown';
		directives.report_element_name = reportElements[h(sid)].name;
		directives.breakdown.raw_report_element_id = reportElements[h(sid)].id;
		directives.breakdown.raw_row_number = rowNumber;
		
		newReport.request();
	},
	
	clearBreakdown: function(element) {
		
		var elementId = element.id;
		var dat = elementId.split(':');
		var sid = dat[0];
		var reportElements = reportInfo.reportElements;
		
		newReport.isUpdateReportInfo = true;
		
		var directives = newReport.directives;
		directives.source_report_info_id = reportInfo.reportInfoId;
		directives.action = 'clear_breakdown';
		directives.report_element_name = reportElements[util.h(sid)].name;
		
		newReport.request();
	},
	
	setPagePathViaKey: function(evt) {
		
		var element = evt.target || evt.srcElement;
		var theKeyCode = (evt.which) ? evt.which : evt.keyCode;
	
		if (theKeyCode == 13 || theKeyCode == 3) {
			newReport.setPagePath(element.id);
		}
	},
	
	setPagePathViaButton: function() {
		
		newReport.setPagePath(this.id);
	},
	
	setPagePath: function(elementId) {
			
		var dat = elementId.split(':');
		var sid = dat[0];
		
		// Check if a page name is given
		var pagePath = util.getF(sid + ':page_path_field');
		
		// alert('pagePath: ' + pagePath);
		
		if (pagePath != '') {
		
			var reportElements = reportInfo.reportElements;
			
			newReport.isUpdateReportInfo = true;
			
			var directives = newReport.directives;
			directives.source_report_info_id = reportInfo.reportInfoId;
			directives.action = 'session_page_paths';
			directives.report_element_name = reportElements[util.h(sid)].name;
			directives.session_page_paths.is_page_path = true;
			directives.session_page_paths.page_path = pagePath;
			
			newReport.request();
		}
		else {
			alert('Please define a page.');
		}
	},
	
	setPagePathViaLink: function(evt) {
		
		var element = evt.target || evt.srcElement;
		var elementId = element.id;
		
		if (elementId.indexOf(':row:') != -1) {
			
			var h = util.h;
			
			// Get the actual page path from the raw report element
			var dat = elementId.split(':');
			var sid = dat[0];
			var row = dat[2];
			var predecessorSuccessorName = dat[3];
			
			var reportElements = reportInfo.reportElements;
			
			newReport.isUpdateReportInfo = true;
			
			var directives = newReport.directives;
			directives.source_report_info_id = reportInfo.reportInfoId;
			directives.action = 'session_page_paths';
			directives.report_element_name = reportElements[h(sid)].name;
			directives.session_page_paths.is_page_path = false;
			directives.session_page_paths.raw_report_element_id = reportElements[h(sid)].id;
			directives.session_page_paths.row = row;
			directives.session_page_paths.predecessor_successor_name = predecessorSuccessorName;
			
			newReport.request();
		}
	},
	
	getReportByMenuItem: function(e) {
		
		// alert('getReportByMenuItem() - id: ' + this.id);
		
		YAHOO.util.Event.preventDefault(e);
				
		var elementId = this.id;
		var dat = elementId.split(':');
		var menuItemId = dat[2];
		var menuItem = reportsMenuDb[menuItemId];
		var reportName;
		var isCalendar;
		
		if (menuItem.type == 'report') {
			reportName = menuItem.name;
			isCalendar = false;
		}
		else {
			// menuItem.type is calendar
			reportName = '';
			isCalendar = true;
		}
		
		newReport.reportName = reportName;
		newReport.isCalendar = isCalendar;
		
		// util.showObject(newReport);
		
		//
		// Check zoom control for dateFilter and/or filterId
		//
		
		if (!zoomControl.isZoomItems || isCalendar) {
			
			// alert('newReport.dateFilter: ' + newReport.dateFilter);
	
			if (isCalendar && zoomControl.dateFilter != '') { // if is calendar
				// add the new dateFilter
				newReport.dateFilter = zoomControl.dateFilter;
			}
	
			/*
			if (zoomControl.filterId != '') {
				// add the new filter
				newReport.filterId = zoomControl.filterId;
			}
			*/
			
			// util.showObject(newReport);
			
			newReport.request();
		}
		else {
			
			// There are active zoom items, so we first generate the filter in the background
			// to get a date_filter and/or filterId and then request the report via
			// getReportByMenuItemAfterZoomControlResponse()
			
			newReport.setLoadingState();
			
			// zoomControl.createZoomFilter(0);
			zoomControl.zoomRegular();
		}
	},
	
	getReportByMenuItemViaZoomRegular: function(dateFilter, filterId) {
		
		if (dateFilter != '') {
			// add the new dateFilter
			newReport.dateFilter = dateFilter;
		}

		if (filterId != '') {
			// add the new filter
			newReport.filterId = filterId;
		}
		
		// util.showObject(newReport);
		newReport.request();
	},
	
	getReportByCustomizeReportElement: function() {
		
		// A report element has been customized, we get a new report
		// where the changes are already applied in the web browser session report
		var skipResetRowNumbers = true;
		newReport.request(skipResetRowNumbers);
	},

	request: function(skipResetRowNumbers) {
		
		// skipResetRowNumbers is optional, it is only required
		// when a report is requested via getReportByCustomizeReportElement()
		// because we must not reset the row numbers with CRE.
		// So in all other cases skipResetRowNumbers is false
		
		if (arguments.length == 0) {
			var skipResetRowNumbers = false;
		}
		
		// alert('request() - skipResetRowNumbers: ' + skipResetRowNumbers);
		// alert('request() - newReport.dateFilter: ' + newReport.dateFilter);
		
		newReport.setLoadingState();
		
		// alert('report.js request() calls request_report.cfv');
		
		var url = '?dp=statistics.dynamic_reports.request_report';
		url += '&p=' + reportInfo.profileName;
		
		var isUpdateReportInfo = newReport.isUpdateReportInfo;
		
		var dat = 'v.fp.page_token=' + reportInfo.pageToken;
		dat += '&v.fp.report_info_id=';
		dat += '&v.fp.report_name=' + newReport.reportName;
		dat += '&v.fp.is_calendar=' + newReport.isCalendar;
		dat += '&v.fp.date_filter=' + newReport.dateFilter;
		dat += '&v.fp.command_line_filter=' + newReport.commandLineFilter;
		dat += '&v.fp.command_line_filter_comment=' + newReport.commandLineFilterComment;
		dat += '&v.fp.filter_id=' + newReport.filterId;
		dat += '&v.fp.is_update_report_info=' + isUpdateReportInfo;
		dat += '&v.fp.caller_is_report_page=true';
		dat += '&v.fp.web_browser_session_id=' + newReport.webBrowserSessionId;
		dat += '&v.fp.skip_reset_row_numbers=' + skipResetRowNumbers;

		
		//
		// add any directives (for update_report_info())
		//
		
		if (isUpdateReportInfo) {

			var directives = newReport.directives;
			
			for (var prop in directives) {
				
				switch (prop) {
					
					case 'pivot_table':
					
						var pivotDirectives = directives.pivot_table;
						for (var pivotProp in pivotDirectives) {
							dat += '&v.fp.directives.pivot_table.' + pivotProp + '=' + pivotDirectives[pivotProp];
						}
					
						break;
					
					case 'breakdown':
						
						var breakdownDirectives = directives.breakdown;
						for (var breakdownProp in breakdownDirectives) {
							dat += '&v.fp.directives.breakdown.' + breakdownProp + '=' + breakdownDirectives[breakdownProp];
						}
					
						break;
						
					case 'session_page_paths':
					
						var sessionPagePathsDirectives = directives.session_page_paths;
						for (var sessionPagePathsProp in sessionPagePathsDirectives) {
							dat += '&v.fp.directives.session_page_paths.' + sessionPagePathsProp + '=' + sessionPagePathsDirectives[sessionPagePathsProp];
						}
						
						break;
						
					default:
					
						dat += '&v.fp.directives.' + prop + '=' + directives[prop];
						
					break;
				}
				
				
				/*
				if (prop != 'pivot_table') {
				
					dat += '&v.fp.directives.' + prop + '=' + directives[prop];
				}
				else {
					
					var pivotDirectives = directives.pivot_table;
					
					for (var pivotProp in pivotDirectives) {
						
						dat += '&v.fp.directives.pivot_table.' + pivotProp + '=' + pivotDirectives[pivotProp];
					}
				}
				*/
			}
		}
		
		// alert(dat);

		
		//
		// add expanded menu groups
		//
		
		for (var i = 0; i < reportsMenuDb.length; i++) {
			var item = reportsMenuDb[i];
			if (item.type == 'group' && item.isExpanded) {
				dat += '&v.fp.expanded_menu_groups.' + i + '=' + item.name;
			}
		}
		
		/*
		var menuGroups = reportInfo.expandedMenuGroups;
		var count = 0;
		for (var prop in menuGroups) {
			if (menuGroups[prop] == true) {
				dat += '&v.fp.expanded_menu_groups.' + count + '=' + prop;
				count++;
			}
		}
		*/
		
		util.serverPost(url, dat);
	},
	
	requestResponse: function(dat) {
		
		// alert('requestResponse: ' + dat + '\ndat.isReadyReport: ' + dat.isReadyReport);
		
		// TEMP DISABLED
		// alert('requestResponse() - DISABLED');
		// return false;
		
		// util.showObject(dat);
		
		// add new report data reportInfo!
		newReport.reportInfoId = dat.reportInfoId;
		newReport.reportJobId = dat.reportJobId;
		
		if (newReport.webBrowserSessionId == '') {
			
			// No webBrowserSessionId exists yet, so it has been set in request_report.cfv
			newReport.webBrowserSessionId = dat.webBrowserSessionId;
		}
		
		// preset URL
		newReport.presetUrl(dat.pid, dat.isReadyReport);
	},
	
	
	presetUrl: function(reportTaskId, isReadyReport) {
		
		// util.showObject(newReport.info);
	
		var url = '?dp=statistics.dynamic_reports.preset_url';
		url += '&p=' + reportInfo.profileName;

		var dat = 'v.fp.page_token=' + reportInfo.pageToken;
		dat += '&v.fp.report_name=' + newReport.reportName;
		dat += '&v.fp.is_calendar=' + newReport.isCalendar;
		dat += '&v.fp.date_filter=' + encodeURIComponent(newReport.dateFilter);
		dat += '&v.fp.command_line_filter=' + encodeURIComponent(newReport.commandLineFilter);
		dat += '&v.fp.command_line_filter_comment=' + encodeURIComponent(newReport.commandLineFilterComment);
		dat += '&v.fp.filter_id=' + newReport.filterId;
		dat += '&v.fp.report_info_id=' + newReport.reportInfoId;
		dat += '&v.fp.report_job_id=' + newReport.reportJobId;
		dat += '&v.fp.report_task_id=' + reportTaskId;
		dat += '&v.fp.is_ready_report=' + isReadyReport;
		dat += '&v.fp.caller_is_report_page=true';
		dat += '&v.fp.web_browser_session_id=' + newReport.webBrowserSessionId;
		util.serverPost(url, dat);
	},
	
	presetUrlResponse: function() {
		
		// alert('report.js presetUrlResponse()');
		
		var url = location.protocol + '//' + location.host + location.pathname + '?dp=reports';		
		url += '&p=' + reportInfo.profileName;
		
		if (!newReport.isCalendar) {
			url += '&rn=' + newReport.reportName;
		}
		else {
			url += '&calendar=true';
		}
	
		if (newReport.dateFilter != '') {
			url += '&df=' + encodeURIComponent(newReport.dateFilter);
		}
		
		if (newReport.filterId != '') {
			url += '&fi=' + newReport.filterId;
		}
		
		if (newReport.commandLineFilter != '') {
			url += '&f=' + encodeURIComponent(newReport.commandLineFilter);
		}
		
		if (newReport.commandLineFilterComment != '') {
			url += '&fc=' + encodeURIComponent(newReport.commandLineFilterComment);
		}
		
		if (newReport.reportInfoId != '') {
			url += '&rii=' + newReport.reportInfoId;
		}
		
		// if (newReport.webBrowserSessionId != '') {
		// There must be always a clientUrl.webBrowserSessionId,
		// so we don't need to check if it is empty
		
		url += '&wbsi=' + newReport.webBrowserSessionId;
		
		location.href = url;
	},
	
	setLoadingState: function() {
		
		// hide zoomInfo
		zoomInfo.close();
		
		// hide gui
		
		// hide reports toolbar anchor elements but
		// keep displaying the toolbar bg
		
		util.hideE('report_toolbar_section');
		util.hideE('reports_menu_and_report_section');
		
		// hide reports menu background
		var body = util.getE('html:body');
		body.className = '';
	}
}
