//
// saveAsNewReport.js 
//
//

var saveAsNewReport = {
	
	panel: null,
	validator: null,
	
	dat: null,
	/*
	dat contains fresh data such as report label, report description, etc.
	dat object
	dat: {
		reportLabel: '',
		reportDescription: '',
		reportLabelsDb: ['Report 1', 'Report 2', ...],
		reportGroupsDb: [{name:group1, label:Group 1}, {name:group2, label:Group 2}, ...]
	}

	*/
	
	init: function() {
		
		saveAsNewReport.validator = new util.Validator();
	
		var panelObj = {
			panelId: 'sanr:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_stats.save_as_new_report.save_as_new_report'),
			left: 250,
			top: 45,
			zIndex: 20,
			isCover: true,
			closeEvent: saveAsNewReport.close
		};
		
		saveAsNewReport.panel = new util.Panel3(panelObj);
		saveAsNewReport.validator = new util.Validator();
				
		/*
		var tabSequence = ['general', 'report_description'];
		saveAsNewReport.tabs = new util.Tabs3('sanr:tabs', tabSequence, saveAsNewReport.tabActivated);
		saveAsNewReport.tabs.setSequence(tabSequence, 'general');
		*/
		
		var YE = YAHOO.util.Event;
		
		YE.addListener('sanr:report_groups_list', 'change', saveAsNewReport.reportGroupListActor);

		YE.addListener('sanr:save_date_btn', 'click', saveAsNewReport.toggleSaveDate);
		YE.addListener('sanr:save_filters_btn', 'click', saveAsNewReport.toggleSaveFilters);
	
		YE.addListener('sanr:add_edit_report_description_btn', 'click', saveAsNewReport.toggleReportDescription);
		
		YE.addListener('sanr:save_btn', 'click', saveAsNewReport.saveReport);
		YE.addListener('sanr:cancel_btn', 'click', saveAsNewReport.close);
	},
	
	/*
	setLoadingInfo: function(showLoadingInfo) {
		
		util.showE('sanr:loading_info', showLoadingInfo);
		util.showE('sanr:form', !showLoadingInfo);
	},
	*/
	
	open: function() {
		
		if (!saveAsNewReport.panel) {
			
			// Init panel
			saveAsNewReport.init();
			
			// Get fresh report data
			saveAsNewReport.getReportDat();
			report.simpleProgress.showLoading();
			
			// saveAsNewReport.setLoadingInfo(true);
		}
		else {
			// Data already exists
			saveAsNewReport.updateForm();
			saveAsNewReport.validator.reset();
			saveAsNewReport.panel.open();
		}
	},
	
	close: function() {
		saveAsNewReport.panel.close();
	},
	
	/*
	tabActivated: function(tabId) {
		
		// KHP-RC, revise tabActivated problem as described in creControl.js
		
		if (!util.isObject(tabId)) { // isObject has be addded due the above described IE problem
		
			saveAsNewReport.setTabPanel(tabId);
		}
	},
	
	setTabPanel: function(tabId) {
				
		// util.hideE(['sanr:general:panel', 'sanr:filters:panel', 'sanr:report_description:panel']);
		util.hideE(['sanr:general:panel', 'sanr:report_description:panel']);
		util.showE('sanr:' + tabId + ':panel');
		saveAsNewReport.tabs.setActiveTab(tabId);
	},
	*/
	
	/*
	updateSaveButtonState: function() {
		
		// We allow to save a Macro only if one of the actions is checked.
		// var makeEnabled = util.getF('saveAsNewReportopen_report_btn') || util.getF('saveAsNewReportapply_date_btn') || util.getF( 'saveAsNewReportapply_filters_btn'); 
		// util.enableE('saveAsNewReportok_btn', makeEnabled);
	},
	*/
	
	getReportDat: function() {
		
		var url = '?dp=statistics.save_as_new_report.get_report_dat';
		url += '&p=' + reportInfo.profileName;
		
		var dat = 'v.fp.page_token=' + reportInfo.pageToken + '&';
		dat += 'v.fp.report_name=' + newReport.reportName;

		util.serverPost(url, dat);
	},
	
	getReportDatResponse: function(dat) {
		
		// alert('getReportDatResponse()');
		
		saveAsNewReport.dat = dat;
		
		// Populate report groups list
		var reportGroupsDb = dat.reportGroupsDb;
		util.populateSelect('sanr:report_groups_list', reportGroupsDb, 'name', 'label');
		
		saveAsNewReport.updateForm();
		report.simpleProgress.stop();
		saveAsNewReport.panel.open();
	},
	
	updateDateSection: function() {
		
		var dateFilterInfo = reportInfo.dateFilterInfo;
		var isGlobalDateFilter = dateFilterInfo.isGlobalDateFilter;
		var isFixedDate = dateFilterInfo.isFixedDate;
		var isValidDateFilterSyntax = dateFilterInfo.isValidDateFilterSyntax;
		var isOutOfRange = dateFilterInfo.isOutOfRange;
		var isRelativeDateFilter = dateFilterInfo.isRelativeDateFilter;
		
		// Set checked state, regardless if a date filter is active or not
		util.setF('sanr:save_date_btn', false);
		
		if (isRelativeDateFilter) {
			util.setF('sanr:save_relative_date_btn', true);
		}
		else {
			util.setF('sanr:save_absolute_date_btn', true);
		}
		
		var isEnabledDate = isGlobalDateFilter && !isFixedDate && isValidDateFilterSyntax && !isOutOfRange;
		var isEnabledDateOptions = isEnabledDate && isRelativeDateFilter;
		
		util.enableE('sanr:save_date_btn', isEnabledDate);
		util.enableE(['sanr:save_relative_date_btn', 'sanr:save_absolute_date_btn'], isEnabledDateOptions);
	},
	
	updateForm: function() {
		
		// Reset/set form data
		
		// saveAsNewReport.setTabPanel('general');
		// saveAsNewReport.setLoadingInfo(false);
		
		var dat = saveAsNewReport.dat;
		
		var newReportLabel = dat.reportLabel + ' ' + langVar('lang_stats.save_as_new_report.new');
		
		util.setF('sanr:report_label', newReportLabel);
		
		//
		// Handle reports menu
		//
		
		util.setF('sanr:show_in_dynamic_reports_btn', true);
		util.setF('sanr:show_in_static_reports_btn', false);
		
		util.setF('sanr:report_groups_list', '');
		util.setF('sanr:new_report_group_label', '');
		util.hideE('sanr:new_report_group_label_section');
		
		
		//
		// Handle Date
		//
		
		var isDateTimeSupport = reportInfo.isDateTimeSupport;
		
		if (isDateTimeSupport) {
			saveAsNewReport.updateDateSection();
		}
		
		util.showE('sanr:save_date_section', isDateTimeSupport);
		
		//
		// Handle filters
		//
		
		var isActiveFilters = (reportInfo.filterId != '' || reportInfo.commandLineFilter != '');
		util.setF('sanr:save_filters_btn', isActiveFilters);
		util.setF('sanr:save_structured_filters_btn', true);
		util.enableE(['sanr:save_filters_btn', 'sanr:save_structured_filters_btn', 'sanr:save_hidden_filters_btn'], isActiveFilters);
		
		//
		// Handle report description
		//
		
		var reportDescription = dat.reportDescription;
		var showDescriptionBtnLabel = (reportDescription == '') ? langVar('lang_stats.save_as_new_report.add_report_description') : langVar('lang_stats.save_as_new_report.edit_report_description');
		
		util.updateT('sanr:add_edit_report_description_btn', showDescriptionBtnLabel);
		util.setF('sanr:report_description', reportDescription);
		
		util.showE('sanr:add_edit_report_description_btn');
		util.hideE('sanr:report_description_section');
	},
	
	
	reportGroupListActor: function() {
		
		var groupName = util.getF('sanr:report_groups_list');
		var isCreateNewGroup = (groupName == '__CREATE__NEW_GROUP__');
		util.showE('sanr:new_report_group_label_section', isCreateNewGroup);
	},
	
	toggleSaveDate: function() {
		
		util.enableE(['sanr:save_absolute_date_btn', 'sanr:save_relative_date_btn'], this.checked);
	},
	
	toggleSaveFilters: function() {
		
		util.enableE(['sanr:save_structured_filters_btn', 'sanr:save_hidden_filters_btn'], this.checked);
	},
	
	toggleReportDescription: function() {
		
		util.hideE('sanr:add_edit_report_description_btn');
		util.showE('sanr:report_description_section');
	},
	
	saveReport: function() {
		
		var validator = saveAsNewReport.validator;
		validator.reset();
		
		var reportLabel = validator.isValue('sanr:report_label');
		
		var reportGroupListValue = util.getF('sanr:report_groups_list');
		var saveInReportGroup = (reportGroupListValue != '');
		var isNewReportGroup = (reportGroupListValue == '__CREATE__NEW_GROUP__');
		var reportGroupName = (saveInReportGroup && !isNewReportGroup) ? reportGroupListValue : '';
		var reportGroupLabel = '';
		
		if (isNewReportGroup) {
			reportGroupLabel = validator.isValue('sanr:new_report_group_label');
		}
		
		if (validator.allValid()) {
			
			var saveDateFilter = false;
			var dateFilter = '';
			var saveFilters = util.getF('sanr:save_filters_btn');
			var saveStructuredFilters = util.getF('sanr:save_structured_filters_btn');
			
			if (reportInfo.isDateTimeSupport && util.getF('sanr:save_date_btn')) {
				
				// KHP-RC, check if we save the absolute date or relative date
				saveDateFilter = true;
				dateFilter = reportInfo.dateFilter;
			}
			
			var reportDescription = util.getF('sanr:report_description');
			
		
			var url = '?dp=statistics.save_as_new_report.save_new_report';
			url += '&p=' + reportInfo.profileName;
		
			var dat = 'v.fp.page_token=' + reportInfo.pageToken;
			dat += '&v.fp.report_job_id=' + reportInfo.reportJobId;
			dat += '&v.fp.report_info_id=' + reportInfo.reportInfoId;
			dat += '&v.fp.ori_report_name=' + reportInfo.reportName;
			
			dat += '&v.fp.new_report_label=' + reportLabel;
			dat += '&v.fp.show_in_dynamic_reports=' + util.getF('sanr:show_in_dynamic_reports_btn');
			dat += '&v.fp.show_in_static_reports=' + util.getF('sanr:show_in_static_reports_btn');
			dat += '&v.fp.save_in_report_group=' + saveInReportGroup;
			dat += '&v.fp.is_new_report_group=' + isNewReportGroup;
			dat += '&v.fp.report_group_name=' + encodeURIComponent(reportGroupName);
			dat += '&v.fp.report_group_label=' + encodeURIComponent(reportGroupLabel);
			
			dat += '&v.fp.save_date_filter=' + saveDateFilter;
			dat += '&v.fp.date_filter=' + encodeURIComponent(dateFilter);
			
			dat += '&v.fp.save_filters=' + saveFilters;
			dat += '&v.fp.save_structured_filters=' + saveStructuredFilters;
			dat += '&v.fp.filter_id=' + reportInfo.filterId;
			dat += '&v.fp.command_line_filter=' + reportInfo.commandLineFilter;
			dat += '&v.fp.command_line_filter_comment=' + reportInfo.commandLineFilterComment;
			
			dat += '&v.fp.report_description=' + encodeURIComponent(reportDescription);
			
			util.serverPost(url, dat);
		}
	},
	
	saveReportResponse: function(dat) {
		
		// alert('saveReportResponse()');
		
		saveAsNewReport.close();
		
		if (dat.showInDynamicReports) {
			
			// Reload the report so that the new report is shown in the reports menu
			location.reload(true);
		}
	}
}
