//
//
// availableExprFields.js - Show available expression fields panel class
//
//

var AvailableExprFields = function(obj) {
	
	this.panelId = obj.panelId;
	this.tbodyId = obj.tbodyId;
	this.panelLabel = obj.panelLabel;
	
	this.left = obj.left ? obj.left : 16;

	// availableFields format is:
	// [
	// {label: "years", name: "date_time"},
	// {label: "city", name: "location"},
	// ...
	// ]
	this.availableExpressionFieldsDb = obj.availableExpressionFieldsDb;

	this.panel = null;
	this.isOpenPanel = false; // We need this flag because close() could be invoked although the panel is not open.
	
	this.__init();
};

AvailableExprFields.prototype = {
	
	__init: function() {
		
		var panelObj = {
			panelId: this.panelId,
			panelClassName: 'panel-50',
			panelHeaderLabel: this.panelLabel,
			left: this.left,
			top: 5,
			zIndex: 40,
			isSticky: true,
			isCover: false
		};
		
		this.panel = new util.Panel3(panelObj);
		
		//
		// build the available fields list
		//
		
		this.__createList();
	},
	
	__createList: function() {
		
		// Create new list
		var tbody = util.getE(this.tbodyId);
		
		// Clean up list in case that one already exists
		util.removeChildElements(tbody);
		
		var items = this.availableExpressionFieldsDb;
		for (var i = 0; i < items.length; i++) {
			var item = items[i];
			this.__createListRow(tbody, item.label, item.name);
		}
	},
	
	__createListRow: function(tbody, label1, label2) {
			
		var tr = util.createE('tr');
		var td1 = util.createE('td');
		var td2 = util.createE('td');
		var text1 = util.createT(label1);
		var text2 = util.createT(label2);
		
		util.chainE(tbody, [tr, [td1, text1], [td2, text2]]);
	},
	
	updateList: function(availableExpressionFieldsDb) {
		
		// replaces any existing list with a new one
		this.availableExpressionFieldsDb = availableExpressionFieldsDb;
		this.__createList();
	},
	
	open: function() {
		
		var top = 160;
		var verticalMargin = 20;
		
		// get top position for the panel element so that it fits in viewport
		var viewportHeight = YAHOO.util.Dom.getViewportHeight();
		
		var panelElement = util.getE(this.panelId);
		panelElement.style.visibility = 'hidden';
		panelElement.style.display = 'block';
		
		var region = YAHOO.util.Dom.getRegion(panelElement);
		var panelElementHeight = region.height;

		// alert('height: ' + panelElementHeight);
		panelElement.style.display = 'none';
		panelElement.style.visibility = 'visible';
		
		while (((top + panelElementHeight + verticalMargin) > viewportHeight) && top > verticalMargin) {
			top = top - 1;
		}
		
		// alert('top: ' + top);
		
		this.panel.open({top:top});
		this.isOpenPanel = true;
	},
	
	close: function() {
		
		if (this.isOpenPanel) {
			this.panel.close();
			this.isOpenPanel = false;		}
	}
};
