//
//
// creSessionFields.js
// This handles session fields for sessions_overview, session_paths and session_page_paths report elements,
// it is only used in Config/Reports
//
//

var creSessionFields = function() {

	//
	//
	// Return global properties and methods
	//
	//
	
	var allFieldsValid = false; // allFieldsValid is used in reportElement.js to verify for valid session fields
	
	var sessionFields = {
		// All session fields with supported report element type
		session_user_field: {sessions_overview:true, session_paths:true},
		session_date_time_field: {sessions_overview:true, session_page_paths:true},
		session_id_field: {sessions_overview:true, session_paths:true, session_page_paths:true},
		session_duration_field: {sessions_overview:true},
		session_events_field: {sessions_overview:true},
		session_entrances_field: {sessions_overview:true, session_page_paths:true},
		session_exits_field: {sessions_overview:true, session_page_paths:true},
		session_sequence_number_field: {session_paths:true},
		session_page_field: {session_paths:true, session_page_paths:true}};
	
	var validator = null;
		
	
	function init() {
		
		validator = new util.Validator();

		// Populate the session field lists with queryFieldsDb
		var a = [{name:'', label:'--- ' + langVar('lang_stats.btn.select') + ' ---'}],
			databaseFieldsDb = reports.databaseFieldsDb,
			element,
			fieldName;
			
		// util.showObject(databaseFieldsDb);
		
		// populate the lists
		for (fieldName in sessionFields) {
			
			element = util.getE('cre_obj:' + fieldName);
			util.populateSelect(element, a, 'name', 'label');
			util.extendSelect(element, databaseFieldsDb, 'name', 'label');
		}
	}
	
	function updateForm(reportElementDb) {
		
		// alert('creSessionFields.updateForm()');
		// util.showObject(reportElementDb);
		
		var boxElementId,
			fieldElementId,
			fieldName,
			fieldValue,
			reportElementType = reportElementDb.type;
			
		validator.reset();
			
		for (fieldName in sessionFields) {
			
			boxElementId = 'cre_obj:' + fieldName + ':box';
			fieldElementId = 'cre_obj:' + fieldName;
			
			if (sessionFields[fieldName][reportElementType]) {
				
				fieldValue = reportElementDb[fieldName];
				
				// Show the row and set the select element
				util.showE(boxElementId);
				util.setF(fieldElementId, fieldValue);
			}
			else {
				// Hide the session field row
				util.hideE(boxElementId);
			}
		}
	}
	
	function saveChanges(reportElementDb) {
		
		// As there are no default session fields we need to validate
		// session field existence.
		
		var fieldName,
			fieldElementId,
			reportElementType = reportElementDb.type;
		
		validator.reset();
		// creSessionFields.allFieldsValid = false;
		allFieldsValid = false;
		
		for (fieldName in sessionFields) {
			
			if (sessionFields[fieldName][reportElementType]) {
				
				fieldElementId = 'cre_obj:' + fieldName;
				
				// Save and validate the field
				reportElementDb[fieldName] = validator.isValue(fieldElementId);
			}
		}
	
		
		if (validator.allValid()) {
			allFieldsValid = true;
		}
	}
	
	function getAllFieldsValid() {
		// return creSessionFields.allFieldsValid;
		// alert('getAllFieldsValid() - allFieldsValid: ' + allFieldsValid);
		return allFieldsValid;
	}
	
	function getSessionFields() {
		return sessionFields;
	}
	
	return {
		getAllFieldsValid: getAllFieldsValid,
		init: init,
		updateForm: updateForm,
		saveChanges: saveChanges,
		getSessionFields: getSessionFields
	}
}();





