//
// progress.js
//

// Note, progress also displays action infos
// such as Loading document, etc., without
// the progress meter section.
// We don't make this a class due referencing problems upon server calls!

var progress = function() {
	
	var YE = YAHOO.util.Event;
	var YD = YAHOO.util.Dom;
	
	var GD = {
		
		pageToken: '', // actual pageToken is set in progress HTML
	
		//
		// Initialization variables set in callee
		//
		
		// decimalDivider: '.',
		isCancelTaskPermission: false,
		profileName: '',
		
		// calleeListener
		// calleeListener is a function in the callee which is called upon progress state change so that the callee
		// can take any further action.
		// The states which are send to the callee are:
		// 		report_progress_complete
		//		database_progress_complete
		// 		database_task_not_active
		
		calleeListener: null,
		
		// Buttons
		toggleDetailsBtn: null,
		cancelTaskBtn: null,
		refreshBtn: null,
	
		//
		// Variables set by methods
		//
		
		progressType: '', // report | database | snapon | simple
		// progressIsVisible: false,
		mainLabel: '', 	// The main label used in progress header
		updateMainLabel: true, // If true this updates the mainLabel when we get server side progress info, 
								// else it is fixed to the given mainLabel on the client side
		mainInfo: '', // The text between progress header and the busy bar, only set on client side
		updateMainInfo: true, // If true this clears the mainInfo when we get server side progress info
		
		taskId: '',
		reportJobId: '',
		// The progressId is send from the client and resend from the server 
		// so that we can ignore out of date requests, i.e. upon refreshProgress
		progressId: '',
		
		processingDetailsExists: false,
		processingDetailsIsVisible: false,
		cancelTaskIsActive: false,
		refreshPageIsActive: false,
		
		isPanel: false, // Defines if displayed as panel
		
		isGetProgressStateActivity: false,

		initWarningsCompleted: false,
        activeNumOfWarnings: 0,
        warningsIsActive: false
	};
	
	//
	// Methods
	//
	
	function init(obj) {
		
		// This inits all required progress parameters. It is invoked from the progress callee.
		
		GD.pageToken = progressPageToken;
		// GD.decimalDivider = obj.decimalDivider;
		GD.isCancelTaskPermission = obj.isCancelTaskPermission;
		GD.profileName = obj.profileName;
		GD.calleeListener = obj.calleeListener;
		GD.isPanel = obj.isPanel || false;
		
		var commandLinkOptions = {
			classNameEnabled: 'command-link-50',
			classNameDisabled: 'command-link-50-disabled'
		};	
		
		GD.toggleDetailsBtn = new util.CommandLink('progress:toggle_processing_details_btn', toggleProcessingDetails, false, commandLinkOptions);
		GD.cancelTaskBtn = new util.CommandLink('progress:cancel_taks_btn', cancelTask, false, commandLinkOptions);
		GD.refreshBtn = new util.CommandLink('progress:refresh_btn', refreshPage, false, commandLinkOptions);
		
		YE.addListener('progress:task_canceled_close_btn', 'click', closeProgressPanelAfterCanceledTask);
		
		
		/*
		if (GD.isCancelTaskPermission) {
			
			YE.addListener('progress:cancel_taks_btn', 'click', cancelTask);
		}
		else {
			util.hideE('progress:cancel_taks_btn');
		}
		*/
		
		// YE.addListener('progress:refresh_btn', 'click', progress.refreshPage);
		// YE.addListener('progress:show_processing_details_btn', 'click', showProcessingDetails);
		// YE.addListener('progress:hide_processing_details_btn', 'click', hideProcessingDetails);
	}

	function initWarnings() {

		var warningsElem = util.getE('progress:warnings'),
            warningsTextElem = util.getE('progress:warning_text_blocks');
;
		if (!GD.isPanel) {
			// Limit width of warning element
			warningsElem.style.width = '580px';
		}

        YE.addListener('progress:toggle_warnings', 'click', toggleWarnings);
        YE.addListener('progress:collapse_warnings', 'click', collapseWarnings);

		warningsElem.style.display = 'block';
		GD.initWarningsCompleted = true;
        GD.warningsIsActive = true;
	}
	
	function close() {
		
		// This hides the progress panel
		util.hideE('progress:panel');
	}
	
	function reset() {
		
		// reset the labels and progress meter
		/*
		util.updateT('progress:step_number', '&nbsp;');
		util.hideE(['progress:header_buttons', 'progress:body', 'progress:details', 'progress:details:container']);
		
		// Remove any task labels
		updateTaskLabels();
		
		GD.progressIsVisible = false;
		*/
	}
	
	function updateButtonState() { // NEW
		
		// This sets the toggle details, cancel task and refresh
		// enabled/disabled state.
		
		var enableToggleDetails = false;
		var enableCancelTask = false;
		var enableRefresh = false;
		
		if (!GD.refreshPageIsActive) {
		
			if (GD.progressType == 'database' && 
				GD.taskId != '' &&
				GD.processingDetailsExists) {
			
				enableToggleDetails = true;
			}
			
			if (GD.isCancelTaskPermission &&
				!GD.cancelTaskIsActive &&
				GD.progressType != 'simple' &&
				GD.taskId != '') {
			
				enableCancelTask = true;
			}
			
			if (GD.progressType != 'simple' &&
				!GD.cancelTaskIsActive) {
			
				enableRefresh = true;
			}
		}
		
		GD.toggleDetailsBtn.enable(enableToggleDetails);
		GD.cancelTaskBtn.enable(enableCancelTask);
		GD.refreshBtn.enable(enableRefresh);
	}
	
	function setProgressDisplay() {
		
		// This sets the initial progress display
		var type = GD.progressType;
		var isSimpleProgress = type == 'simple';
		var isDatabaseProgress = type == 'database';
		var isReportProgress = type == 'report';
		
		var progressElement = util.getE('progress:panel');
		var progressElementHeader = util.getE('progress:panel:header');
		var isPanel = GD.isPanel;
		
		progressElement.className = !isPanel ? 'progress-page' : 'progress-panel';
		progressElementHeader.className = !isPanel ? 'progress-page-header' : 'progress-panel-header';
		
		if (isPanel) {
			setPanelPosition(progressElement);
		}
		
		util.showEV('progress:toggle_processing_details_btn', isDatabaseProgress);
		// Reset processing details
		util.hideE('progress:details');
		GD.processingDetailsIsVisible = false;
		
		// Set mainLabel and mainInfo text
		util.updateT('progress:main_label', GD.mainLabel);
		var showMainInfo = GD.mainInfo != '';
		if (showMainInfo) {
			util.updateT('progress:main_info', GD.mainInfo);
		}
		util.showE('progress:main_info', showMainInfo);
		
		
		util.hideE('progress:task_canceled_section');
		util.showE('progress:main_body_section');
			
		progressElement.style.display = 'block';
	}
	
	function startProgress(obj) {
		
		// Note, startProgress may be called muliple times, i.e. when canceling the task
		// or when changing from database progress to report progress.
		GD.progressType = obj.progressType;
		GD.taskId = obj.taskId || ''; // optional
		GD.reportJobId = obj.reportJobId || ''; // optional, only required if progressType is report
		GD.mainLabel = obj.mainLabel;
		GD.updateMainLabel = obj.updateMainLabel;
		GD.mainInfo = obj.mainInfo;
		GD.updateMainInfo = obj.updateMainInfo;
		
		// updateTaskLabels(langVar('lang_stats.progress.receiving_progress_information'));
		setProgressDisplay();
		
		if (GD.progressType != 'simple') {
		
			// Issue a new progressId
			var d = new Date();
			var progressId = '_' + d.getTime();
			GD.progressId = progressId;
			
			if (GD.progressType == 'report' ||
				GD.taskId != '') {
				getProgressState();
			}
			else {
				
				getTaskState();
			}
			
			updateButtonState();
		}
	}
	
	function getTaskState() {
		
		// This gets the task_id of a snapon or database operation.
		// It also checks if the task is yet active or if there is any 
		// error message
	
		// alert('getTaskState()');
		
		// util.showObject({cancelTaskIsActive:GD.cancelTaskIsActive}, 'getTaskState()');

		if (!GD.cancelTaskIsActive) {
		
			var url = '?dp=progress.get_task_state';
			url += '&p=' + GD.profileName;
			
			var dat = 'v.fp.page_token=' + GD.pageToken;
			dat += '&v.fp.progress_type=' + GD.progressType;
			
			util.serverPost(url, dat);
		}
	}
	
	function getTaskStateResponse(dat) {
		
		// util.showObject({cancelTaskIsActive:GD.cancelTaskIsActive}, 'getTaskStateResponse()');
		
		if (!GD.cancelTaskIsActive) {
		
			GD.taskId = dat.taskId;
			
			// alert('getTaskStateResponse() taskId: ' + dat.taskId);
			
			if (dat.isActiveTask) {
				
				// get progress state
				getProgressState();
			}
			else {
				
				// Call callee with 'database_task_not_active' or 'snapon_task_not_active'
				
				var info = (GD.progressType == 'database') ? 'database_task_not_active' : 'snapon_task_not_active';
				GD.calleeListener(info);
			}
		}
	}
	
	function getProgressState() {
		
		// alert('getProgressState()');
		// util.showObject({}, 'getProgressState()');
		
		// Issue a new channelId
		
		// util.showObject({cancelTaskIsActive:GD.cancelTaskIsActive}, 'getProgressState()');
		
		if (!GD.cancelTaskIsActive) {
			
			// Set isGetProgressStateActivity
			GD.isGetProgressStateActivity = true;
		
			// util.showObject({request:'---------> ' + GD.progressId});
			
			var url = '?dp=progress.get_progress_state';
			url += '&p=' + GD.profileName;
			
			var dat = 'v.fp.page_token=' + GD.pageToken;
			dat += '&v.fp.progress_type=' + GD.progressType;
			dat += '&v.fp.task_id=' + GD.taskId;
			dat += '&v.fp.report_job_id=' + GD.reportJobId;
			dat += '&v.fp.progress_id=' + GD.progressId;
			
			util.serverPost(url, dat);
		}
	}
	
	function getProgressStateResponse(dat) {
		
		// Ignore response in case that the task has been canceled.
		// Only handle requests where the progressId's matches, other requests
		// are simply out of date and ignored.
		
		// Set isGetProgressStateActivity
		GD.isGetProgressStateActivity = true;
		
		
		// Reset
		GD.processingDetailsExists = false;
		
		// util.showObject({RESPONSE:'<---- ' + dat.progressId});

		if (!GD.cancelTaskIsActive &&
			dat.progressId == GD.progressId) {
			
			var progressState = dat.progressState;
			
		
			switch (progressState) {
				
				case 'progress':
				
					// util.showE(['progress:step_label', 'progress:step_description']);
				
					var progressInfo = dat.progress;
					
					// util.showObject(progressInfo.activeSubtasks);
					
					updateDisplay(progressInfo);
					
					// get progress state data
					setTimeout('progress.getProgressState()', 1200);
				
					break;
					
				case 'progress_prediction':
				
					// alert('progress prediction');					
					// get progress state data
					setTimeout('progress.getProgressState()', 1200);
				
					break;
				
				case 'complete':
				
					// updateProgressMeter(100);
					
					// Call callee with calleeInfo 'report_progress_complete' or 'database_progress_complete'
					
					// ToDo - what about snapon?
					var calleeInfo = (GD.progressType == 'report') ? 'report_progress_complete' : 'database_progress_complete';
					GD.calleeListener(calleeInfo);
				
					break;
					
				case 'error':
					
					// Currently not active, the error is fired
					// by a Salang error() message right away in get_progress_state.cfv!
					// alert('ERROR: Database build is not ready and task is not anymore active!');
					alert('getProgressStateResponse() error');
					break;
			}
			
			updateButtonState();
		}
	}
	
	function cancelTask() {
		
		// alert('cancelTask()');
		
		// We set cancelTaskIsActive to true so that there is no
		// progress action while we confirm cancelTask
		
		// Note that the task may complete while the user cancles the task,
		// though this will be indicated anyway by the cancelTaskResponse.
		
		// We freeze progress by setting cancelTaskIsActive
		GD.cancelTaskIsActive = true;
		
		if (confirm(langVar('lang_stats.progress.confirm_cancel_task_message'))) {
		
			// util.hideE('progress:header_buttons');
			// reset();
			
			updateButtonState();
			util.updateT('progress:main_info', langVar('lang_stats.progress.canceling_task_info'));
			util.hideE(['progress:task_labels', 'progress:details']);
			util.showE('progress:main_info');
			
			var url = '?dp=progress.cancel_task';
			url += '&p=' + GD.profileName;
			
			var dat = 'v.fp.page_token=' + GD.pageToken;
			dat += '&v.fp.task_id=' + GD.taskId;
			
			util.serverPost(url, dat);			
		}
		else {
			
			// The task is actually not canceled, so we need to resolve progress.
			GD.cancelTaskIsActive = false;
		}
	}
	
	function cancelTaskResponse(dat) {
		
		// Update - we ignore the cancelTaskResponse message
		// util.updateT('progress:step_label', dat.msg);
		
		var calleeInfo = '';
		
		if (!dat.isError) {
			
			// Show that the task has been canceled
			util.hideE('progress:main_body_section');
			util.showE('progress:task_canceled_close_btn', GD.isPanel);
			util.showE('progress:task_canceled_section');
		}
		else {
			
			// An error occured, respectively the task already completed.
			// We show an error message but then proceed as progress would
			// have been completed.
			
			alert(dat.errorMessage);
			
			// ToDo - revise calleeInfo for snapon
			if (GD.progressType == 'report') {
				calleeInfo = 'report_progress_complete';
			}
			else {
				calleeInfo = 'database_progress_complete';
			}
			
			GD.calleeListener(calleeInfo);
		}
	}
	
	function closeProgressPanelAfterCanceledTask() {
		
		// This case only occurs in Config in Database Info, Update or Build Database.
		// We simply reload the currrent page 
		progress.close();
		location.reload();
	}
	
	function refreshPage() {
		
		if (!GD.refreshPageIsActive) {
			
			// Reset isGetProgressStateActivity
			GD.isGetProgressStateActivity = false;
			
			// Lock refreshPage for 5 seconds
			GD.refreshPageIsActive = true;
			setTimeout('progress.finalRefreshPageCheck()', 5000);
			
			// util.hideE('progress:header_buttons');
			// util.showObject({REFRESH:'REFRESH REFRESH REFRESH REFRESH'});
			
			//startProgress() is only fired if we don't notice
			//any getProgressState() activity until finalRefreshPageCheck
			//fires.
		}
	}
	
	function finalRefreshPageCheck() {
		
		if (!GD.isGetProgressStateActivity) {
			
			// There was no getProgressState() activity, so we actually
			// restart progress.
			startProgress();
		}
	
		GD.refreshPageIsActive = false;
		// util.showE('progress:header_buttons');
	}
	
	function toggleProcessingDetails() {
		
		var makeVisible = !GD.processingDetailsIsVisible;
		util.showE('progress:details', makeVisible);
		var buttonTxt = makeVisible ? langVar('lang_stats.progress.hide_details') : langVar('lang_stats.progress.show_details');
		util.updateT('progress:toggle_processing_details_btn', buttonTxt);
		GD.processingDetailsIsVisible = makeVisible;
	}
	
	/*
	
	function showProcessingDetails() {
		
		util.hideE('progress:show_processing_details_btn');
		util.showE('progress:details:container');
		util.showE('progress:hide_processing_details_btn');
	}
	
	function hideProcessingDetails() {
		
		util.hideE('progress:hide_processing_details_btn');
		util.hideE('progress:details:container');
		util.showE('progress:show_processing_details_btn');
	}
	*/
	
	function createProcessingDetailRow(rowIndex) {
		
		var tr = document.createElement('tr');
		var th = document.createElement('th');
		th.id = 'progress:processing_detail:th:' + rowIndex;
		var td = document.createElement('td');
		td.id = 'progress:processing_detail:td:' + rowIndex;
		
		tr.appendChild(th);
		tr.appendChild(td);
		
		return tr;
	}
	
	function updateProcessingDetails(processingDetails) {
		
		var tbody = util.getE('progress:details:container');
		var allRows = tbody.getElementsByTagName('tr');
		var numberOfExistingRows = allRows.length;
		var numberOfRequiredRows = processingDetails.length;
		var i;
		var tr;
		
		// Check number of rows
		if (numberOfExistingRows != numberOfRequiredRows) {
			
			if (numberOfRequiredRows > numberOfExistingRows) {
				// add rows
				for (i = numberOfExistingRows; i < numberOfRequiredRows; i++) {
					tr = createProcessingDetailRow(i);
					tbody.appendChild(tr);
				}
			}
		}
		
		// Update row values
		for (i = 0; i < processingDetails.length; i++) {
			var item = processingDetails[i];
			util.updateT('progress:processing_detail:th:' + i, item.label + ':');
			util.updateT('progress:processing_detail:td:' + i, item.value);
		}
		
		// Set processingDetailsExists
		if (numberOfRequiredRows > 0) {
			GD.processingDetailsExists = true;
		}
	}
	
	/*
	function updateProgressMeter(meterPosition) {
		
		var meterPositionDisplay = meterPosition.toFixed(2);
		
		var meterBar = util.getE('progress:meter_bar');
		var meterBarLength = meterPosition * 3 // progress meterPosition is 1-100, bar length = 300px	
		meterBar.style.width = meterBarLength + 'px';
		
		util.updateT('progress:meter_value', meterPositionDisplay + ' %');
	}
	*/
	
	function updateTaskLabels(a) {
		
		// a is undefined, a single string or an array with strings
		
		var container = util.getE('progress:task_labels');
		
		// Remove any task labels
		util.removeChildElements(container);
		
		if (a != null) {
			
			if (!util.isArray(a)) {
				// Single label, put it into an array
				a = [a];
			}
		}
		else {
			a = [];
		}
		
		var numberOfLabels = a.length;
		
		if (numberOfLabels > 0) {
			
			var tbody = util.createE('tbody');
			
			for (var i = 0; i < numberOfLabels; i++) {
	
				var tr = util.createE('tr');
				var th = util.createE('th');
				var text = util.createT(a[i]);
				util.chainE(tbody, tr, th, text);
			}
			
			util.chainE(container, tbody);
		}
	}
	
	function updateDisplay(dat) {
		
		var progressType = GD.progressType;
		
		/*
		var stepNumberLabel = langVar('lang_stats.progress.step_number_info');
		stepNumberLabel = stepNumberLabel.replace(/__PARAM__1/, dat.currentStep);
		stepNumberLabel = stepNumberLabel.replace(/__PARAM__2/, dat.numberOfSteps);
		*/
		
		var stepLabel = dat.stepLabel;
		var stepDescription = dat.stepDescription;
		var warnings = dat.warnings;
		var taskLabels = [];
		
		if (GD.updateMainLabel) {
			// Update the main label
			util.updateT('progress:main_label', dat.mainLabel);
		}
		
		if (GD.updateMainInfo) {
			
			// Simply hide the mainInfo because it is out of date and
			// cannot be updated from server side.
			util.hideE('progress:main_info');
		
			// Don't repeat this step
			GD.updateMainInfo = false
		}
		
		// util.updateT('progress:step_number', stepNumberLabel);
		// util.updateT('progress:step_label', stepLabel);
		// util.updateT('progress:step_description', stepDescription);
		util.updateT('progress:total_time_elapsed', dat.totalTimeElapsed);
		
		if (stepLabel.length > 1) {
			taskLabels[taskLabels.length] = stepLabel;
		}
		
		if (stepDescription.length > 1) {
			taskLabels[taskLabels.length] = stepDescription;
		}
	
		//
		// Add subtasks to taskLabels
		//
		
		var activeSubtasks = dat.activeSubtasks;
		for (var i = 0, max = activeSubtasks.length; i < max; i++) {
			
			var subTaskItem = activeSubtasks[i];
			var subTaskLabel = subTaskItem.label;
			var numOfTasks = subTaskItem.numOfTasks;
			
			if (numOfTasks > 1) {
				
				// Show number of tasks as suffix
				subTaskLabel = subTaskLabel + ' (' + numOfTasks + '\u00D7)';
			}
			
			taskLabels[taskLabels.length] = subTaskLabel;
		}
		
		updateTaskLabels(taskLabels);
		
		// updateProgressMeter(dat.meterPosition);
		
		if (progressType == 'database') {updateProcessingDetails(dat.processingDetails);}
		
		
		// alert('GD.progressIsVisible: ' + GD.progressIsVisible);
		/*
		if (!GD.progressIsVisible) {
			
			// Show progress meter, etc.
			util.showE('progress:body');
			
			if (progressType == 'database') {
			 	util.showE('progress:details');
			}
			
			GD.progressIsVisible = true;
		}
		*/

		if (warnings.length == 0) {

            // No warnings'
            if (GD.warningsIsActive) {

                // No more warnings, hide warnings
                util.hideE('progress:warnings');
                GD.warningsIsActive = false;
            }
		}
        else {

            // util.showObject(dat.warnings);
            updateWarningsDisplay(dat.warnings);

            if (!GD.warningsIsActive) {

                if (!GD.initWarningsCompleted) {
                    initWarnings();
                }
                else {
                    util.showE('progress:warnings');
                    GD.warningsIsActive = true;
                }
            }
        }

        /*
        initWarningsCompleted: false,
                activeNumOfWarnings: 0,
                warningsIsActive: false,
                warningsIsExpanded: false
        */
	}

	function updateWarningsDisplay(warnings) {

		// This creates the warning text block and updates the number
        // of warnings

		var container = util.getE('progress:warning_text_blocks'),
			i = 0,
			mainDiv = util.createE('div', {padding:0, margin:0}),
			subDiv = null,
			text = '',
            numOfWarnings = warnings.length;

		util.removeChildElements(container);

		for (i = 0; i < numOfWarnings; i++) {

			subDiv = util.createE('div', {className: 'warnings-text'});
			text = util.createT(warnings[i]);

			util.chainE(mainDiv, subDiv, text);
		}

		util.chainE(container, mainDiv);

        if (GD.activeNumOfWarnings != numOfWarnings) {
            util.updateT('progress:number_of_warnings', '(' + numOfWarnings + ')');
            GD.activeNumOfWarnings = numOfWarnings;
        }
	}

    function toggleWarnings() {
        var elem = util.getE('progress:warning_text_blocks'),
            showWarnings = (elem.style.display == 'none');

        // alert('showWarnings: ' + showWarnings);
        setWarningsDisplay(showWarnings);
    }

    function collapseWarnings() {
        setWarningsDisplay(false);
    }

    function setWarningsDisplay(showWarnings) {

        var img = util.getE('progress:toggle_warnings_img');
        img.src = showWarnings ? imgDb.progressArrowDown.src : imgDb.progressArrowRight.src;

        util.showE('progress:warning_text_blocks', showWarnings);
        util.showE('progress:collapse_warnings', showWarnings);
    }
	
	function setPanelPosition(element) {
		
		element.style.visiblity = 'hidden';
		element.style.display = 'block';
	
		var region = YD.getRegion(element);
		var elementWidth = region.width;
		
		var viewportWidth = YD.getViewportWidth();
		var viewportHeight = YD.getViewportHeight();
		
		element.style.left = Math.round(viewportWidth / 2 - elementWidth / 2) + 'px';
		element.style.top = Math.round(viewportHeight / 4) + 'px';
		
		// element.style.left = 0;
		// element.style.top = 0;
		
		element.style.display = 'none';
		element.style.visiblity = 'visible';
	}
	
	//
	//
	// Return global properties and methods
	//
	//
	
	return {
		init: init,
		startProgress: startProgress,
		getTaskStateResponse: getTaskStateResponse,
		getProgressState: getProgressState,
		getProgressStateResponse: getProgressStateResponse,
		cancelTask: cancelTask,
		cancelTaskResponse: cancelTaskResponse,
		closeProgressPanelAfterCanceledTask: closeProgressPanelAfterCanceledTask,
		close: close,
		refreshPage: refreshPage,
		finalRefreshPageCheck: finalRefreshPageCheck,
		toggleProcessingDetails: toggleProcessingDetails,
        toggleWarnings: toggleWarnings,
        collapseWarnings: collapseWarnings
	}
}();
