//
// scrollUtil.js
//

var scrollUtil = {};

scrollUtil.Scroller = (function() {
		
	// dependencies
	var YE = YAHOO.util.Event,
		YD = YAHOO.util.Dom,
		Constr;
	
	// constructor
	Constr = function(frameElementId, scrolledElementId, scrollHandler) {

        this.frameElementId = frameElementId;
		this.frameElement = null;
        this.frameElemementTop = 0;
        this.frameElementBottom = 0;
        this.frameElementHeight = 0;

        this.scrolledElementId = scrolledElementId;
        this.scrolledElement = null;
		this.scrollHandler = scrollHandler;

        // If isStandby is true we record scroll event properties
        // but don't fire the scrollHandler.
        // The system goes automatically in isStandby when the
        // scrollHandler is fired. The callee must invoke
        // restartListening() to reset isStandby to false.

        this.isStandby = false;

        // Up to date scroll properties
        this.verticalScrollLevel = 0.0; // float in range 0-100, 0 = scrolled to top, 100 = scrolled to bottom
        this.isScrollingDown = false;

        YE.addListener(window, 'resize', this._sizeChanged, this);
	};
	
	Constr.prototype = {

        _setBasicProperties: function() {

            // alert('_setBasicProperties()');

            if (!this.frameElement) {
                this.frameElement = util.getE(this.frameElementId);
                this.scrolledElement = util.getE(this.scrolledElementId);
            }

            var region = YD.getRegion(this.frameElement);
            
            // this.frameElementTop = region.top;
            this.frameElementBottom = region.bottom;
            this.frameElementHeight = region.height;

//            console.log('_setBasicProperties - frameElementTop: ' + this.frameElementTop);
//            console.log('_setBasicProperties - frameElementBottom: ' + this.frameElementBottom);
//            console.log('_setBasicProperties - frameElementHeight: ' + this.frameElementHeight);
        },
		
		activate: function() {

			YE.addListener(this.frameElementId, 'scroll', this._scrollActivated, this);

            // Reset scroll properties
            this.verticalScrollLevel = 0;
            this.isScrollingDown = false;

            this.isStandby = false;
		},

		deactivate: function() {

             YE.removeListener(this.frameElementId, 'scroll', this._scrollActivated);
		},

        restartListening: function() {

            this.isStandby = false;
        },

//        _setToStandby: function() {
//
//           alert('_setToStandby()');
//            this.isStandby = true;
//        },

        _getVerticalScrollLevel: function() {

            // Get scrolled Element properties
            var region = YD.getRegion(this.scrolledElement),
                // scrolledTop = region.top,
                scrolledBottom = region.bottom,
                scrolledHeight = region.height,
                scrolledHiddenHeight = scrolledHeight - this.frameElementHeight, // hidden parts on top and bottom
                scrolledHiddenHeightOnBottom = scrolledBottom - this.frameElementBottom,
                scrolledHiddenHeightOnTop = scrolledHiddenHeight - scrolledHiddenHeightOnBottom,
                verticalScrollLevel = 100 * (scrolledHiddenHeightOnTop / scrolledHiddenHeight);

            return verticalScrollLevel;
        },
		
		_scrollActivated: function(evt, self) {

            // Starts scrolling
          
            // Set basic properties if not yet set
            if (self.frameElementHeight === 0) {
                self._setBasicProperties();
            }

            var verticalScrollLevel = self._getVerticalScrollLevel();

            // console.log('_scrollActivated - this.verticalScrollLevel: ' + this.verticalScrollLevel);
            // console.log('_scrollActivated - verticalScrollLevel: ' + verticalScrollLevel);

            // Set up to date scroll properties
            self.isScrollingDown = (verticalScrollLevel > self.verticalScrollLevel);
            self.verticalScrollLevel = verticalScrollLevel;

//            console.log('_scrollActivated - self.isStandby: ' + self.isStandby);
//            console.log('_scrollActivated - isScrollingDown: ' + self.isScrollingDown);

            // Fire scroll handler if not in isStandby
            // and if verticalScrollLevel is greater than 20
            // and if scrolling down
            if (!self.isStandby &&
                verticalScrollLevel > 20 &&
                self.isScrollingDown) {

                // Set to standby
                self.isStandby = true;

                // Fire scrollHandler
                self.scrollHandler(verticalScrollLevel);
            }
		},

//        _getIsStandby: function() {
//
//            alert('this.isStandby: ' + this.isStandby);
//        },

        _sizeChanged: function(evt, self) {
            // Element size changed, reset basic properties
            self._setBasicProperties();
        },
		
		getScrollInfo: function() {

            // Get a fresh verticalScrollLevel because it
            // could have changed due adding data by the
            // scrollHandler.
            // The isScrollingDown value is up to date
            // and should not be changed here.

            var verticalScrollLevel = this._getVerticalScrollLevel();
            this.verticalScrollLevel = verticalScrollLevel;
			
			var obj = {
                isScrollingDown: this.isScrollingDown,
                verticalScrollLevel: verticalScrollLevel
            };

            return obj;
		}
	};
	
	// return Constr
	return Constr;
	
}());