/*
	log analysis info version 1.4

	Usage: put this tag anywhere in the <body> of an HTML page:

	<script defer=true language="javascript" type="text/javascript" src="/js/log_analysis_info.js"></script>

	Note that this will result in a one by one invisible pixel, so if it causes
	misalignment in the page, it can be placed at the very bottom (before </body>),
	or anywhere else where it will really be invisible.

	Set doTagging to "true" to switch from screen info to page tagging.
*/

var taggingServer = ""; // e.g. var taggingServer = "http://10.0.1.1:8988";
var doTagging = false;
var taggingRef = "";

/*
	The following functions for detecting Flash are adapted from
	http://code.google.com/p/doctype/wiki/ArticleDetectFlash
*/

function getFlashVersionNumber(desc) {
	var matches = desc.match(/[\d]+/g);
	matches.length = 3;  // To standardize IE vs FF
	return matches.join('.');
}

function getFlashVersion() {

	var hasFlash = false;
	var flashVersion = '';

	if (navigator.plugins && navigator.plugins.length) {
		var plugin = navigator.plugins['Shockwave Flash'];
		if (plugin) {
			hasFlash = true;
			if (plugin.description) {
				flashVersion = getFlashVersionNumber(plugin.description);
			}
		}

		if (navigator.plugins['Shockwave Flash 2.0']) {
			hasFlash = true;
			flashVersion = '2.0.0.11';
		}

	} else if (navigator.mimeTypes && navigator.mimeTypes.length) {
		var mimeType = navigator.mimeTypes['application/x-shockwave-flash'];
		hasFlash = mimeType && mimeType.enabledPlugin;
		if (hasFlash) {
			flashVersion = getFlashVersionNumber(mimeType.enabledPlugin.description);
		}

	} else {
		try {
			// Try 7 first, since we know we can use GetVariable with it
			var ax = new ActiveXObject('ShockwaveFlash.ShockwaveFlash.7');
			hasFlash = true;
			flashVersion = getFlashVersionNumber(ax.GetVariable('$version'));
		} catch (e) {
			// Try 6 next, some versions are known to crash with GetVariable calls
			try {
				var ax = new ActiveXObject('ShockwaveFlash.ShockwaveFlash.6');
				hasFlash = true;
				flashVersion = '6.0.21'; // First public version of Flash 6
			} catch (e) {
				try {
					// Try the default activeX
					var ax = new ActiveXObject('ShockwaveFlash.ShockwaveFlash');
					hasFlash = true;
					flashVersion = getFlashVersionNumber(ax.GetVariable('$version'));
				} catch (e) {
					// No flash
				}
			}
		}
	}

	if (!hasFlash) { flashVersion = 0; }
	return flashVersion;
}

function getTaggingSrc() {

	var src = taggingServer + '/sm_taginfo.gif?';

// Java slows down the load, so don't do this.
//	var ip = '0.0.0.0';
//	var host = '';
//	if (self.java) {
//		var ipStr = new java.net.InetAddress.getLocalHost().toString();
//		host = ipStr.substring(ipStr.indexOf('/') + 1);
//		ip = ipStr.substring(0, ipStr.indexOf('/'));
//	}

	var colonIndex = location.protocol.indexOf(":");
	if (colonIndex == -1) { colonIndex = location.protocol.length; }
	var protocol = location.protocol.substring(0, colonIndex);

// Doesn't work in all browsers and results are misleading if it doesn't.
//	document.write('<script type="text/javascript"> var jsver = 1.0; </script> <script language="Javascript1.1"> jsver = 1.1; </script> <script language="Javascript1.2"> jsver = 1.2; </script> <script language="Javascript1.3"> jsver = 1.3; </script> <script language="Javascript1.4"> jsver = 1.4; </script> <script language="Javascript1.5"> jsver = 1.5; </script> <script language="Javascript1.6"> jsver = 1.6; </script> <script language="Javascript1.7"> jsver = 1.7; </script> <script language="Javascript1.8"> jsver = 1.8; </script>');

	var query = 'client_date_time=' + new Date();
	query += '|width=' + screen.width;
	query += '|height=' + screen.height;
	query += '|depth=' + screen.colorDepth;
//	query += '|client_ip=' + ip;
//	query += '|client_host=' + host;
	query += '|server_host=' + location.host;
	query += '|page=' + location.pathname;
	query += '|query=' + location.search;
	query += '|protocol=' + protocol;
	query += '|user_agent=' + navigator.userAgent;
	query += '|referrer=' + document.referrer;
	query += '|flash_version=' + getFlashVersion();
//	query += '|js_version=' + jsver;

	if (taggingRef != '') {query += '|ref=' + taggingRef;}
	if (clientId != '') { query += '|lavc=' + clientId; }

	src += escape(query);

	return src;
}

function logAnalysisInfo() {

	if (lavcString == -1) {

		// check whether we can set cookies
		document.cookie = "lavc=0";
		var tempClientCookie = document.cookie.toString();

		if (tempClientCookie.indexOf("lavc=0") != -1) {

			// set lavc cookie
			var nowDate = new Date();
			var t = nowDate.getTime();
			var n = Math.random() * 100000;
			n = Math.round(n);
			clientId = t + '' + n;

			nowDate.setFullYear(nowDate.getFullYear() + 20);
			var expiresDate = nowDate.toUTCString();

			document.cookie = "lavc=" + clientId + "; expires=" + expiresDate;

			// alert('cookie has been set to: ' + document.cookie.toString() + '\nclientId: ' + clientId);
		}
	}
	else {
		// read lavc cookie value
		var lavcStart = lavcString + 5;
		var lavcEnd = clientCookie.indexOf(";", lavcStart);
		if (lavcEnd == -1) { lavcEnd = clientCookie.length; }
		clientId = clientCookie.substring(lavcStart, lavcEnd);

		// alert('clientCookie String already exists: ' + clientCookie + '\nwe got clientId: ' + clientId);
	}

	// alert('screen width: ' + screen.width + '\nscreen height: ' + screen.height + '\ncolor depth: ' + screen.colorDepth + '\nclientId: ' + clientId);

	var src = '/log_analysis_screen_info.gif?';
	src += 'width=' + screen.width;
	src += '&height=' + screen.height;
	src += '&depth=' + screen.colorDepth;
	if (clientId != '') {src += '&lavc=' + clientId;}

	if (document.getElementById) {

		var body_ref = document.getElementsByTagName('body')[0];
		var img = document.createElement('img');
		img.width = 1;
		img.height = 1;
		img.alt = "";

		if (doTagging) {
			img.src = getTaggingSrc();
		}
		else {
			img.src = src;
		}

		body_ref.appendChild(img);
	}
	else {

		var img = '<img width="1" height="1" alt="" src="';

		if (doTagging) {
			img += getTaggingSrc() + '">';
		}
		else {
			img += src + '">';
		}

		document.write(img);
	}
}

var clientCookie = document.cookie.toString();
var lavcString = clientCookie.indexOf("lavc=");
var clientId = "";

logAnalysisInfo();
