//
// rolesUtil.js, utility functions for roles.js
//
var rolesUtil = {
	updatePermissionCell: function(featureId, permissionType, isChecked, isDisabled) {
		// isDisabled is an optional argument!
		var td = util.getE(featureId + ':' + permissionType + ':td');
		// td.className = isChecked ? 'active' : '';
		var input = util.getE(featureId + ':' + permissionType);
		input.checked = isChecked;
		if (isDisabled != null) {
			input.disabled = isDisabled;
		}
		//
		// Handle Access Details
		//
		if (permissionType == 'edit') {
			var accessDetails = roles.accessDetails;
			if (featureId == accessDetails.scheduler.featureId || featureId == accessDetails.users.featureId) {
				// alert('show hide access details div\'s');
				var isUnlimtedGrants = true;
				if (featureId == accessDetails.scheduler.featureId) {
					isUnlimtedGrants = accessDetails.scheduler.isUnlimitedGrants;
				}
				else {
					isUnlimtedGrants = accessDetails.users.isUnlimitedGrants;
				}
				var showUnlimitedGrants = (isChecked && isUnlimtedGrants);
				var showLimitedGrants = (isChecked && !isUnlimtedGrants);
				/*
				var s = 'featureId: ' + featureId;
				s += '\nisChecked: ' + isChecked;
				s += '\nisUnlimtedGrants: ' + isUnlimtedGrants;
				s += '\nshowUnlimitedGrants: ' + showUnlimitedGrants;
				s += '\nshowLimitedGrants: ' + showLimitedGrants;
				alert(s);
				*/
				util.showE(featureId + ':unlimited_grants:div', (isChecked && isUnlimtedGrants));
				util.showE(featureId + ':limited_grants:div', (isChecked && !isUnlimtedGrants));
			}
		}
	},
	setPermissionByLabelEvent: function() {
		// Invoked by clicking on a feature label
		// If none or not all permissions are checked then check all permissions
		// If all are checked then un-check all permissions
		// alert('setPermissionByLabelEvent: ' + this.id);
		var featureMap = roles.featureMap;
		roles.isModifiedFeatures = true;
		var elementId = this.id;
		var dat = elementId.split(':');
		var featureId = dat[0];
		var featureMapItem = featureMap[util.h(featureId)];
		var hasEdit = featureMapItem.hasEdit;
		var hasAdd = featureMapItem.hasAdd;
		var hasDelete = featureMapItem.hasDelete;
		//
		// Check the current state, if all are checked
		//
		var checkedState = [];
		checkedState[0] = util.getF(featureId + ':view');
		if (hasEdit) {checkedState[checkedState.length] = util.getF(featureId + ':edit');}
		if (hasAdd) {checkedState[checkedState.length] = util.getF(featureId + ':add');}
		if (hasDelete) {checkedState[checkedState.length] = util.getF(featureId + ':delete');}
		var allAreChecked = true;
		var atLeastOneIsChecked = false;
		for (var i = 0; i < checkedState.length; i++) {
			if (checkedState[i] == true) {
				atLeastOneIsChecked = true;
			}
			else {
				allAreChecked = false;
			}
		}
		//
		// Set new checkbox state depending on atLeastOneIsChecked and allAreChecked 
		// 
		var isSelectAll = !atLeastOneIsChecked || (atLeastOneIsChecked && !allAreChecked);
		//
		// We create a pseudo featureItem object which is used
		// to update the permissions of this feature via setFeaturePermissions
		//
		// alert('atLeastOneIsChecked: ' + atLeastOneIsChecked + '\nallAreChecked: ' + allAreChecked + '\nisSelectAll: ' + isSelectAll);
		var isDisabled = false;
		rolesUtil.updatePermissionCell(featureId, 'view', isSelectAll, isDisabled);
		// Set disabled state for edit, add, delete
		isDisabled = !isSelectAll;
		if (hasEdit) {rolesUtil.updatePermissionCell(featureId, 'edit', isSelectAll, isDisabled);}
		if (hasAdd) {rolesUtil.updatePermissionCell(featureId, 'add', isSelectAll, isDisabled);}
		if (hasDelete) {rolesUtil.updatePermissionCell(featureId, 'delete', isSelectAll, isDisabled);}
		// Handle Save Report Changes
		if (featureMapItem.name == 'save_report_changes') {
			rolesUtil.handleSaveReportChangesPermissionEvent(isSelectAll);
		}
	},
	setPermissionByEvent: function(featureId, permissionType, isChecked) {
		// invoked by clicking on a checkbox
		var featureMap = roles.featureMap;
		roles.isModifiedFeatures = true;
		var elementId = this.id;
		var isChecked = this.checked;
		var dat = elementId.split(':');
		var featureId = dat[0];
		var permissionType = dat[1];
		var featureMapItem = featureMap[util.h(featureId)];
		var category = featureMapItem.category;
		var isAdminProfilesFeature = (category == 'admin' && featureMapItem.name == 'profiles') ? true : false;
		// util.showObject(featureMapItem);
		// var hasView = featureMapItem.hasView;
		var hasEdit = featureMapItem.hasEdit;
		var hasAdd = featureMapItem.hasAdd;
		var hasDelete = featureMapItem.hasDelete;
		//
		// update the checked feature cell (className change)
		//
		rolesUtil.updatePermissionCell(featureId, permissionType, isChecked, false);
		//
		// update any depending feature cell
		//
		var isDisabled;
		if (permissionType == 'view') {
			// rolesUtil.updateFeatureLabelCell(featureId, isChecked);
			if (!isAdminProfilesFeature) {
				// enable edit and delete checkboxes
				if (hasEdit) {
					isDisabled = !isChecked;
					rolesUtil.updatePermissionCell(featureId, 'edit', false, isDisabled);
				}
				if (hasAdd) {
					isDisabled = true;
					rolesUtil.updatePermissionCell(featureId, 'add', false, isDisabled);
				}
				if (hasDelete) {
					isDisabled = true;
					rolesUtil.updatePermissionCell(featureId, 'delete', false, isDisabled);
				}
			}
			else {
				// isAdminProfilesFeature
				isDisabled = !isChecked;
				rolesUtil.updatePermissionCell(featureId, 'add', false, isDisabled);
				rolesUtil.updatePermissionCell(featureId, 'delete', false, isDisabled);
			}
			// Handle Save Report Changes
			if (category == 'reports' && featureMapItem.name == 'save_report_changes') {
				rolesUtil.handleSaveReportChangesPermissionEvent(isChecked);
			}
		}
		else if (permissionType == 'edit') {
			isDisabled = !isChecked;
			if (hasAdd) {
				rolesUtil.updatePermissionCell(featureId, 'add', false, isDisabled);
			}
			if (hasDelete) {
				rolesUtil.updatePermissionCell(featureId, 'delete', false, isDisabled);
			}
		}
	},
	handleSaveReportChangesPermissionEvent: function(isCheckedSaveReportChanges) {
		// Invoked via setPermissionByEvent() or setPermissionByLabelEvent()
		// Update global accessDetails for Save Report Changes
		roles.accessDetails.saveReportChanges.isView = isCheckedSaveReportChanges;
		// Update Save Report Changes row info display
		rolesUtil.updateSaveReportChangesAccessDetailsDisplay();
	},
	setFeaturePermissions: function(featureMap, featureItem, isEnterprise) {
		// Set all permissions of the featureItem and handle correct enabled/disabled state
		// Also handle the access details (Scheduler and Users) here!
		// Note, we ignore the enabled/diables state, we only care for the checkboxe state.
		// We enable/disable the checkboxes via setFeaturePermissionsDisabledState
		var featureId = featureItem.id;
		var featureMapItem = featureMap[util.h(featureId)];
		var category = featureMapItem.category;
		var featureName = featureMapItem.name;
		// var handleSchedulerDetails = false;
		// var handleUsersDetails = false;
		var handleAccessDetails = (category == 'admin' && (featureName == 'scheduler' || featureName == 'users'));
		var isAdminProfiles = (category == 'admin' && featureName == 'profiles');
		// TEMP
		/*
		if (featureName == 'save_report_changes') {
			alert('setFeaturePermissions() for save_report_changes item');
		}
		*/
		if (handleAccessDetails) {
			// Set data in global role object
			roles.accessDetails[featureName].isUnlimitedGrants = featureItem.isUnlimitedGrants;
			roles.accessDetails[featureName].items = util.cloneObject(featureItem.items);
		}
		var isCheckedView = featureItem.isView;		
		if (isCheckedView) {
			// rolesUtil.updateFeatureLabelCell(featureId, true);
			rolesUtil.updatePermissionCell(featureId, 'view', true, false);
			var hasEdit = featureMapItem.hasEdit;
			var hasAdd = featureMapItem.hasAdd;
			var hasDelete = featureMapItem.hasDelete;
			var isCheckedEdit = false;
			var isDisabled;
			if (hasEdit) {
				isCheckedEdit = featureItem.isEdit;
				isDisabled = false;
				// Update Scheduler and Access Details
				if (isCheckedEdit && handleAccessDetails) {
					// If this is not unlimted grants we need to update
					// the limited grants div
					if (!featureItem.isUnlimitedGrants) {
						rolesUtil.updateLimitedGrantsDiv(featureName);
					}
					// rolesUtil.setInfoCell(featureName);
				}
				if (handleAccessDetails) {
					// alert('updatePermissionCell: ' + featureId);
				}
				rolesUtil.updatePermissionCell(featureId, 'edit', isCheckedEdit, isDisabled);
			}
			if (hasAdd) {
				var isCheckedAdd = featureItem.isAdd;
				isDisabled = !isAdminProfiles ? !isCheckedEdit : false;
				rolesUtil.updatePermissionCell(featureId, 'add', isCheckedAdd, isDisabled);
			}
			if (hasDelete) {
				var isCheckedDelete = featureItem.isDelete;
				isDisabled = !isAdminProfiles ? !isCheckedEdit : false;
				rolesUtil.updatePermissionCell(featureId, 'delete', isCheckedDelete, isDisabled);
			}
		}
		//
		// Handle Access Details for save_report_changes and save_report_changes_to_profile in global accessDetails object
		//
		if (category == 'reports' && featureName == 'save_report_changes') {
			// alert('setFeaturePermissions() for save_report_changes item - GLOBAL VARIABLE SET TO: ' + isCheckedView);
			roles.accessDetails.saveReportChanges.isView = isCheckedView;
		}
		else if (category == 'reports' && featureName == 'save_report_changes_to_profile') {
			// alert('setFeaturePermissions() - saveReportChangesToProfile.isView: ' + isCheckedView);
			roles.accessDetails.saveReportChangesToProfile.isView = isCheckedView;
		}
	},
	resetFeaturePermissions: function() {
		// Sets all features to its initial state
		var featureMap = roles.featureMap;
		for (var i = 0; i < featureMap.length; i++) {
			var featureMapItem = featureMap[i];
			var featureId = featureMapItem.id;
			// var category = featureMapItem.category;
			// rolesUtil.updateFeatureLabelCell(featureId, false);
			rolesUtil.updatePermissionCell(featureId, 'view', false, false);
			if (featureMapItem.hasEdit) {
				rolesUtil.updatePermissionCell(featureId, 'edit', false, true);
			}
			if (featureMapItem.hasAdd) {
				rolesUtil.updatePermissionCell(featureId, 'add', false, true);
			}
			if (featureMapItem.hasDelete) {
				rolesUtil.updatePermissionCell(featureId, 'delete', false, true);
			}
		}
		// Reset access details
		rolesUtil.resetAccessDetails('scheduler');
		rolesUtil.resetAccessDetails('users');
	},
	addPermissionCell: function(tr, featureId, permissionType, showPermission) {
		var td = document.createElement('td');
		td.id = featureId + ':' + permissionType + ':td';
		if (showPermission) {
			var input = document.createElement('input');
			input.type = 'checkbox';
			input.id = featureId + ':' + permissionType;
			YAHOO.util.Event.addListener(input, 'click', rolesUtil.setPermissionByEvent);
			td.appendChild(input);
		}
		else {
			var txt = document.createTextNode(' ');
			td.appendChild(txt);
		}
		tr.appendChild(td);
	},
	addListHeaderCell: function(tr, label, className) {
		var th = document.createElement('th');
		if (className != '') {
			th.className = className;
		}
		var strong = util.createE('strong');
		var text = util.createT(label);
		util.chainE(tr, th, strong, text);
	},
	addListHeaderRow: function(tbody, label, numberOf) {
		// alert('addListHeaderRow()');
		var tr = document.createElement('tr');
		rolesUtil.addListHeaderCell(tr, label, 'label');
		rolesUtil.addListHeaderCell(tr, '', '');
		tbody.appendChild(tr);
	},
	initFeatures: function(isEnterprise) {
		//
		//
		// creates featureMap hash and builds all feature checkboxes from the featureMap
		//
		//
		var featureMap = roles.featureMap;
		util.createHash(featureMap, 'id');
		var mainFeatureCategories = ['admin', 'reports', 'config', 'field_categories', 'miscellaneous', 'network_api'];
		for (var i = 0; i < mainFeatureCategories.length; i++) {
			var category = mainFeatureCategories[i];		
			var tbody = document.createElement('tbody');
			var j;
			if (category == 'field_categories') {
				// Show field category items in reports tab
				tableElementId = 'reports:features:container';
				// Add field category header row if there is any enabled field category
				for (j = 0; j < featureMap.length; j++) {
					if (featureMap[j].category == 'field_categories') {
						rolesUtil.addListHeaderRow(tbody, langVar('lang_admin.roles.report_fields_by_category'));
						break;
					}
				}
			}
			else if (category == 'network_api') {
				// Show network api features in miscellaneous tab
				tableElementId = 'miscellaneous:features:container';
				rolesUtil.addListHeaderRow(tbody, langVar('lang_admin.roles.network_api_features'));
			}
			else {
				tableElementId = category + ':features:container';
			}
			var table = util.getE(tableElementId);
			for (j = 0; j < featureMap.length; j++) {
				var item = featureMap[j];
				if (item.category == category) {
					var featureId = item.id;
					var label = item.label;
					var tr = document.createElement('tr');
					//
					// add feature cell
					//
					var td = document.createElement('td');
					td.className = 'label';
					//td.id = featureId + ':feature:label:td';
					var a = document.createElement('a');
					a.id = featureId + ':feature:label:a';
					a.href = 'javascript:;';
					var featureTxt = document.createTextNode(label);
					a.appendChild(featureTxt);
					td.appendChild(a);
					tr.appendChild(td);
					YAHOO.util.Event.addListener(a, 'click', rolesUtil.setPermissionByLabelEvent);
					//
					// add access/view cell
					//
					rolesUtil.addPermissionCell(tr, featureId, 'view', true);
					//
					// add edit, add and delete cell
					//
					if (category == 'admin' || category == 'config') {
						rolesUtil.addPermissionCell(tr, featureId, 'edit', item.hasEdit);
						rolesUtil.addPermissionCell(tr, featureId, 'add', item.hasAdd);
						rolesUtil.addPermissionCell(tr, featureId, 'delete', item.hasDelete);
					}
					//
					// add info cell if category is admin or reports
					//
					if (category == 'admin' || category == 'reports') {
						var td = document.createElement('td');
						// td.id = featureId + ':info:td';
						td.className = 'info-text';
						var featureName = item.name;
						if (category == 'admin' && (featureName == 'scheduler' || featureName == 'users')) {
							rolesUtil.buildAccessDetails(td, featureId, featureName, isEnterprise);
							// Remember the featureId in global role object
							roles.accessDetails[featureName].featureId = featureId;
						}
						else if (category == 'reports' && featureName == 'save_report_changes') {
							rolesUtil.buildSaveReportChangesAccessDetails(td);
							// Remember the featureId in global role object
							roles.accessDetails.saveReportChanges.featureId = featureId;
						}
						else if (category == 'reports' && featureName == 'save_report_changes_to_profile') {
							// The save_report_changes_to_profile row is always hidden. We use the checkbox
							// for access like other checkboxes, though we handle it through a sub-window
							// in the save_report_changes row. So we check/uncheck this checkbox via 
							// javascript only.
							tr.style.display = 'none';
							// Remember the featureId in global role object
							roles.accessDetails.saveReportChangesToProfile.featureId = featureId;
						}
						else {
							// Add &nbsp;
							var infoText = document.createTextNode('\u00a0'); // creates &nbsp;
							td.appendChild(infoText);
						}
						tr.appendChild(td);
					}
					tbody.appendChild(tr);
				}
			}
			table.appendChild(tbody);
		}
	},
	//
	//
	//
	// Access Details handling (Scheduler and Users)
	//
	//
	//
	accessDeatilsButtonActivated: function() {
		// alert('accessDeatilsButtonActivated() - id: ' + this.id);
		var elementId = this.id;
		var dat = elementId.split(':');
		var featureId = dat[0];
		var featureName = roles.featureMap[util.h(featureId)].name;
		var accessDetails = roles.accessDetails[featureName];
		// alert('accessDeatilsButtonActivated - featureName: ' + featureName);
		rolesAD.openPanel(featureName, accessDetails.isUnlimitedGrants, accessDetails.items);
	},
	buildAccessDetailsLabel: function(text, className) {
		var span = document.createElement('span');
		if (className != '') {span.className = className;}
		var text = document.createTextNode(text);
		span.appendChild(text);
		return span;
	},
	buildAccessDetails: function(td, featureId, featureName, isEnterprise) {
		// We create two div's, one for unlimited grants and
		// one for limited grants.
		// UNLIMITED GRANTS DIV:
		// <div id="f2:unlimited_grants:div"
		// LIMITED GRANTS DIV:
		// <div id="f2:limited_grants:div"
		// <ul id="f2:limited_grants:ul" --> ul containder for access details (action names or role names)
		var isScheduler = (featureName == 'scheduler');
		//
		// Handle unlimited access
		//
		var div = document.createElement('div');
		div.id = featureId + ':unlimited_grants:div';
		div.className = 'rbac-access-details-btn';
		var br = document.createElement('br');
		var mainLabelClassName = isEnterprise ? 'rbac-access-details-btn' : ''; // This className simulates a link which we don't want in Pro
		var mainLabelSpan = rolesUtil.buildAccessDetailsLabel(langVar('lang_admin.roles.unlimited_grants'), mainLabelClassName);
		var subLabel = isScheduler ? ' ' + langVar('lang_admin.roles.accesses_all_profiles_and_actions') : ' ' + langVar('lang_admin.roles.accesses_all_profiles_and_roles');
		var subLabelSpan = rolesUtil.buildAccessDetailsLabel(subLabel, 'rbac-access-details-btn-sublabel');
		div.appendChild(mainLabelSpan);
		div.appendChild(br);
		div.appendChild(subLabelSpan);
		//
		// Handle limited access (This div will only be used in Enterprise, so we keep it in Pro to make it simpler for reset functions, etc.)
		//
		var limitedDiv = document.createElement('div');
		limitedDiv.id = featureId + ':limited_grants:div';
		limitedDiv.className = 'rbac-access-details-btn';
		var limitedMainLabel = isScheduler ? langVar('lang_admin.roles.limited_grants_with_actions') + ':' : langVar('lang_admin.roles.limited_grants_with_roles') + ':'; 
		var limitedMainLabelSpan = rolesUtil.buildAccessDetailsLabel(limitedMainLabel, 'rbac-access-details-btn');
		var ul = document.createElement('ul');
		ul.id = featureId + ':limited_grants:ul';
		ul.className = 'rbac-access-details-btn';
		// ul.style.margin = '0px';
		// ul.style.padding = '0px';
		limitedDiv.appendChild(limitedMainLabelSpan);
		limitedDiv.appendChild(ul);
		td.appendChild(div);
		td.appendChild(limitedDiv);
		if (isEnterprise) {
			YAHOO.util.Event.addListener([div, limitedDiv], 'click', rolesUtil.accessDeatilsButtonActivated);
		}
	},
	resetAccessDetails: function(featureName) {
		// Hide the access details div's
		var featureId =  roles.accessDetails[featureName].featureId;
		// alert('featureName: ' + featureName + '\nfeatureId: ' + featureId);
		var divId = featureId + ':unlimited_grants:div';
		var limitedDivId = featureId + ':limited_grants:div';
		util.hideE([divId, limitedDivId]);
	},
	updateLimitedGrantsDiv: function(featureName) {
		// alert('updateLimitedGrantsDiv: ' + featureName);
		var isScheduler = (featureName == 'scheduler');
		var accessDetails = roles.accessDetails[featureName];
		var featureId = accessDetails.featureId;
		var items = accessDetails.items;
		var ul = util.getE(featureId + ':limited_grants:ul');
		// Clean up ul element
		while (ul.lastChild != null) {
			var childElement = ul.lastChild;
			ul.removeChild(childElement);
		}
		// Define the array from which we get the access details labels
		var labelLookup = isScheduler ? roles.schedulerActionsDb : roles.accessDetailsRolesDb;
		var li;
		var name;
		var lookupItem;
		var label;
		var text;
		var numberOfItemsInList = 0;
		if (items.length > 0) {
			for (var i = 0; i < items.length; i++) {
				name = items[i];
				lookupItem = labelLookup[util.h(name)];
				// Make sure that the lookupItem exists (it may not in case of deleted roles!)
				if (lookupItem != null) {
					li = document.createElement('li');
					li.className = 'rbac-access-details-btn';
					// li.style.margin = '0px';
					// li.style.padding = '0px';
					label = lookupItem.label;
					text = document.createTextNode(label);
					li.appendChild(text);
					ul.appendChild(li);
					numberOfItemsInList++;
				}
			}
		}
		if (numberOfItemsInList == 0) {
			li = document.createElement('li');
			li.className = 'rbac-access-details-btn';
			li.style.listStyle = 'none';
			li.style.color = 'Red';
			label = isScheduler ? langVar('lang_admin.roles.no_action_defined') : langVar('lang_admin.roles.no_role_defined_or_available');
			text = document.createTextNode(label);
			li.appendChild(text);
			ul.appendChild(li);
		}
	},
	//
	//
	// Save Report Changes Access Details handling
	//
	//
	saveReportChangesAccessDetailsActor: function() {
		// User clicked on saveReportChangesDetails button
		// alert('saveReportChangesAccessDetailsActor()');
		rolesSRCAD.openPanel();
	},
	updateSaveReportChangesAccessDetailsDisplay: function() {
		// This updates the info cell depending on the global roles.accessDetails.saveReportChanges
		// and roles.accessDetails.saveReportChangesToProfile paramters
		// alert('updateSaveReportChangesAccessDetailsDisplay() - roles.accessDetails.saveReportChanges.isView: ' + roles.accessDetails.saveReportChanges.isView);
		// util.showObject(roles.accessDetails);
		var div1Id = 'f:save_report_changes:div';
		var div2Id = 'f:save_report_changes_to_profile:div';
		var isSaveReportChanges = roles.accessDetails.saveReportChanges.isView;
		var isSaveReportChangesToProfile = roles.accessDetails.saveReportChangesToProfile.isView;
		util.hideE([div1Id, div2Id]);
		if (isSaveReportChanges && isSaveReportChangesToProfile) {
			util.showE(div2Id);
		}
		else if (isSaveReportChanges) {
			util.showE(div1Id);
		}
	},
	buildSaveReportChangesAccessDetails: function(td) {
		// We create two div's, one for Save Changes To User Only
		// and one for Save Changes To Profile
		// Save Report Changes To User DIV:
		// <div id="f2:save_report_changes:div"
		// Save Report Changes To Profile DIV:
		// <div id="f2:save_report_changes_to_profile:div"
		function buildDivWithLabel(id, label, subLabel) {
			var div = util.createE('div', {id:id, className:'rbac-access-details-btn', width:'240px'});
			var br = util.createE('br');
			var span1 = util.createE('span', {className:'rbac-access-details-btn'});
			var text1 = util.createT(label);
			var span2 = util.createE('span', {className: 'rbac-access-details-btn-sublabel'});
			var text2 = util.createT(subLabel);
			util.chainE([div, [span1, text1], br, [span2, text2]]);
			return div;
		}
		var div1 = buildDivWithLabel(
			'f:save_report_changes:div',
			langVar('lang_admin.roles.saving_scope_is_user'),
			langVar('lang_admin.roles.saving_scope_is_user_info_1')
		);
		var div2 = buildDivWithLabel(
			'f:save_report_changes_to_profile:div',
			langVar('lang_admin.roles.saving_scope_is_profile'),
			langVar('lang_admin.roles.saving_scope_is_profile_info_1')
		);
		util.chainE([td, div1, div2]);
		YAHOO.util.Event.addListener([div1, div2], 'click', rolesUtil.saveReportChangesAccessDetailsActor);
	},
	//
	//
	// Miscellaneous Utilities
	//
	//
	getActiveFormFeatures: function(isEnterprise) {
		//
		// Create features array from active form features
		// 
		var featureMap = roles.featureMap;
		var features = [];
		for (var i = 0; i < featureMap.length; i++) {
			var featureMapItem = featureMap[i];
			var featureId = featureMapItem.id;
			var isView = util.getF(featureId + ':view');
			if (isView) {
				var category = featureMapItem.category;
				var featureName = featureMapItem.name;
				var o = {};
				o.id = featureId;
				o.isView = true;
				if (featureMapItem.hasEdit) {
					o.isEdit = util.getF(featureId + ':edit');
				}
				if (featureMapItem.hasAdd) {
					o.isAdd = util.getF(featureId + ':add');
				}
				if (featureMapItem.hasDelete) {
					o.isDelete= util.getF(featureId + ':delete');
				}
				if (category == 'admin' && (featureName == 'scheduler' || featureName == 'users')) {
					var accessDetails = roles.accessDetails[featureName];
					// util.showObject(accessDetails);
					o.isUnlimitedGrants = accessDetails.isUnlimitedGrants;
					o.items = util.cloneObject(accessDetails.items);
					// util.showObject(o);
				}
				// TEMP
				// if (featureName == 'save_report_changes') {
				//	util.showObject(o);
				// }
				features[features.length] = o;
			}
		}
		return features;
	},
	updateAccessDetailsRolesDb: function(rolesDb) {
		// Creates a new up to date list accessDetailsRolesDb list
		// which is used to create the access details roles list
		roles.accessDetailsRolesDb = [];
		for (var i = 0; i < rolesDb.length; i++) {
			var itemDat = rolesDb[i].dat;
			roles.accessDetailsRolesDb[i] = {name: itemDat.node_name, label: itemDat.label};
		}
		util.createHash(roles.accessDetailsRolesDb, 'name');
	},
	getNewRoleNodeName: function(rolesDb, deletedRolesDb) {
		// Returns a new unique node name which does not match
		// any existing or deleted node name in the format role_1, role_2, role_3, ...
		//
		// Create a node name lookup
		//
		var usedNodeNames = {};
		var nodeName;
		var i;
		for (i = 0; i < rolesDb.length; i++) {
			nodeName = rolesDb[i].dat.node_name;
			nodeName = '_' + nodeName.toLowerCase();
			usedNodeNames[nodeName] = true;
		}
		for (i = 0; i < deletedRolesDb.length; i++) {
			nodeName = deletedRolesDb[i];
			nodeName = '_' + nodeName.toLowerCase();
			usedNodeNames[nodeName] = true;
		}
		//
		// Create new node name
		//
		var newNodeName = '';
		var isUniqueNodeName = false;
		var count = 1;
		while (!isUniqueNodeName) {
			newNodeName = 'role_' + count;
			if (usedNodeNames['_' + newNodeName] == null) {
				isUniqueNodeName = true;
			}
			count++;
		}
		// alert('newNodeName: ' + newNodeName);
		return newNodeName;
	}
}
//
// rolesAD.js, Roles - Access Details Panel
//
var rolesAD = {
	panel: null,
	// active form data
	featureName: '',
	isUnlimitedGrants: true,
	init: function() {
		var YE = YAHOO.util.Event;
		//
		// Init the panel
		//
		var panelObj = {
			panelId: 'ad:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: '-',
			left: 300,
			top: 160,
			zIndex: 20,
			isCover: true,
			isSticky: true,
			closeEvent: rolesAD.closePanel
		};
		var a = ['ad:scheduler:unlimited:btn', 'ad:scheduler:limited:btn', 'ad:users:unlimited:btn', 'ad:users:limited:btn'];
		rolesAD.panel = new util.Panel3(panelObj);
		YE.addListener(a, 'click', rolesAD.toggleGrantsEvent);
		YE.addListener('roles:ad:okay', 'click', rolesAD.saveAccessDetails);
		YE.addListener('roles:ad:cancel', 'click', rolesAD.closePanel);
	},
	toggleGrantsEvent: function() {
		var id = this.id;
		var dat = id.split(':');
		var featureName = dat[1];
		var isUnlimitedGrants = (dat[2] == 'unlimited');
		rolesAD.toggleGrants(featureName, isUnlimitedGrants);
	},
	toggleGrants: function(featureName, isUnlimitedGrants) {
		// var featureName = rolesAD.featureName;
		// alert('featureName: ' + featureName + '\nisUnlimitedGrants: ' + isUnlimitedGrants);
		rolesAD.isUnlimitedGrants = isUnlimitedGrants;
		var selectElement = util.getE('ad:' + featureName + ':select');
		selectElement.disabled = isUnlimitedGrants;
		if (isUnlimitedGrants) {
			selectElement.selectedIndex = -1;
		}
	},
	createList: function(featureName, isUnlimitedGrants, items) {
		var selectElementId = 'ad:' + featureName + ':select';
		var listSource = (featureName == 'scheduler') ? roles.schedulerActionsDb : roles.accessDetailsRolesDb;
		util.populateSelect(selectElementId, listSource, 'name', 'label');
		if (!isUnlimitedGrants) {
			for (var i = 0; i < items.length; i++) {
				util.setF(selectElementId, items[i]);
			}
		}
	},
	openPanel: function(featureName, isUnlimitedGrants, items) {
		// items are any active actions or roles if isUnlimitedGrants=false
		rolesAD.featureName = featureName;
		// rolesAD.isUnlimitedGrants = isUnlimitedGrants; IS ALREADY SET BY toggleGrants!
		// Reset panel
		util.hideE(['ad:scheduler', 'ad:users']);
		util.showE('ad:' + featureName);
		var isScheduler = (featureName == 'scheduler');
		var defaultSelectedName = isUnlimitedGrants ? 'unlimited' : 'limited';
		util.setF('ad:' + featureName + ':' + defaultSelectedName + ':btn', true);
		rolesAD.toggleGrants(featureName, isUnlimitedGrants);
		// create the list
		rolesAD.createList(featureName, isUnlimitedGrants, items);
		var panelLabel = isScheduler ? langVar('lang_admin.roles.scheduler_access_details') : langVar('lang_admin.roles.users_access_details');
		rolesAD.panel.open({label:panelLabel});
	},
	saveAccessDetails: function() {
		var featureName = rolesAD.featureName;
		var isUnlimitedGrants = rolesAD.isUnlimitedGrants;
		// global access object to which we save the data
		var accessDetails = roles.accessDetails[featureName];
		var featureId = accessDetails.featureId;
		/*
		var s = 'saveAccessDetails()';
		s += '\nfeatureId: ' + featureId;
		s += '\nfeatureName: ' + featureName;
		s += '\nisUnlimitedGrants: ' + isUnlimitedGrants;
		alert(s);
		*/
		accessDetails.isUnlimitedGrants = isUnlimitedGrants;
		accessDetails.items = [];
		// Update the list in Admin panel
		rolesUtil.resetAccessDetails(featureName);
		if (!isUnlimitedGrants) {
			// Get selected values
			var select = util.getE('ad:' + featureName +  ':select');
			var options = select.options;
			for (var i = 0; i < options.length; i++) {
				if (options[i].selected == true) {
					accessDetails.items[accessDetails.items.length] = options[i].value;
				}
			}
			// alert('items: ' + accessDetails.items);
			// Update the list in Admin panel
			rolesUtil.updateLimitedGrantsDiv(featureName);
			util.showE(featureId + ':limited_grants:div');
		}
		else {
			// Update the list in Admin panel
			util.showE(featureId + ':unlimited_grants:div');
		}
		roles.isModifiedFeatures = true;
		rolesAD.closePanel();
	},
	closePanel: function() {
		rolesAD.panel.close();
	}
}
//
// rolesSRCAD.js, Roles - Save Report Changes Access Details panel
//
var rolesSRCAD = {
	panel: null,
	init: function() {
		var YE = YAHOO.util.Event;
		//
		// Init the panel
		//
		var panelObj = {
			panelId: 'srcad:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_admin.roles.saving_scope'),
			left: 300,
			top: 160,
			zIndex: 20,
			isCover: true,
			isSticky: true,
			closeEvent: rolesSRCAD.closePanel
		};
		rolesSRCAD.panel = new util.Panel3(panelObj);
		YE.addListener('srcad:okay', 'click', rolesSRCAD.saveAccessDetails);
		YE.addListener('srcad:cancel', 'click', rolesSRCAD.closePanel);
	},
	openPanel: function(featureName, isUnlimitedGrants, items) {
		if (!roles.accessDetails.saveReportChangesToProfile.isView) {
			util.setF('srcad:save_report_changes_to_user_info_btn', true);
		}
		else {
			util.setF('srcad:save_report_changes_to_profile_btn', true);
		}
		rolesSRCAD.panel.open();
	},
	saveAccessDetails: function() {
		var isSaveToProfile = util.getF('srcad:save_report_changes_to_profile_btn');
		if (isSaveToProfile != roles.accessDetails.saveReportChangesToProfile.isView) {
			// The user changed the Save Report Changes Access Details
			// Update the save_report_changes_to_profile checkbox in role display
			var featureId = roles.accessDetails.saveReportChangesToProfile.featureId;
			util.setF(featureId + ':view', isSaveToProfile);
			roles.accessDetails.saveReportChangesToProfile.isView = isSaveToProfile;
			roles.isModifiedFeatures = true;
			// Update Display
			rolesUtil.updateSaveReportChangesAccessDetailsDisplay();
		}
		rolesSRCAD.closePanel();
	},
	closePanel: function() {
		rolesSRCAD.panel.close();
	}
}
//
//
// roles.js
//
//
// var itemsDb = [];  // items work array
// var itemsDbBackup = []; // items array in the state when first loaded or last saved, it is used upon Undo Changes
var roles = {
	isEnterprise: false,
	activeUserNodeName: '',
	usersDb: [], // [{name:"user_1", username:"user 1"}, ...] contains user node name with username, required for the list labels where we indicate "(by user 1)"
	featureMap: [],
	rolesDb: [],
	rolesDbBackup: [],
	rolesUsedInUsersDb: {}, // KHP-RC, get roles which are used in users.cfg
	schedulerActionsDb: [],
	accessDetailsRolesDb: [], 	// Keeps the roles which are shown in Access Details, it is created from rolesDb
								// {"id":"i1", "name":"role_1", "label": "role 1"}, ... 
								// id is the itemId in rolesDb and name is the node name of a role in rolesDb
	deletedRolesDb: [], // Keeps the node names of any deleted role, i.e. ['role_1', 'role_12']
	theList: null,
	validator: null,
	// isModifiedRoles: false,
	isModifiedFeatures: false, // is set in rolesUtil.js and rolesAD.js if features of a single role are modified
	saveChangesBtn: null,
	newRoleBtn: null,
	deleteBtn: null,
	duplicateBtn: null,
	undoAllChangesBtn: null,
	tabs: null,
	activeTabId: null, // admin | reports | config
	noItemFormIsActive: false,
	activeCreatedByUser: '', // keeps the active createdByUser value because it is not a form field
	// We keep the active Scheduler, User and Save Report Changes access details as global object while a role is edited
	accessDetails: {
		scheduler: {
			featureId: '', // featureId is set once upon init only
			isUnlimitedGrants: true,
			items: [] // contains active action names
		},
		users: {
			featureId: '', // featureId is set once upon init only
			isUnlimitedGrants: true,
			items: [] // contains active role names
		},
		saveReportChanges: {
			featureId: '', // featureId is set once upon init only
			isView: false
		},
		saveReportChangesToProfile: {
			featureId: '', // featureId is set once upon init only
			isView: false
		}
	}
}
/**
*
*
* 
* init functions
*
*
*
*/
function init(isEnterprise) {
	//
	// Main init routine
	//
	// alert('init roles.js');
	roles.validator = new util.Validator();
	//
	// init toolbar buttons
	//
	roles.saveChangesBtn = new util.ToolbarButton('save_changes', saveChanges, toolbarButtonsDb);		
	roles.newRoleBtn = new util.ToolbarButton('new_role', newRole, toolbarButtonsDb);
	roles.duplicateBtn = new util.ToolbarButton('duplicate', duplicateRole, toolbarButtonsDb);
	roles.deleteBtn = new util.ToolbarButton('delete', deleteRole, toolbarButtonsDb);
	roles.undoAllChangesBtn = new util.ToolbarButton('undo_all_changes', undoAllChanges, toolbarButtonsDb);
	//
	// Ignore/Disable buttons according RBAC
	//
	var permissions = pageInfo.permissions;
	if (permissions.isEdit) {
		if (!permissions.isAdd) {
			roles.newRoleBtn.disableAndIgnore();
			roles.duplicateBtn.disableAndIgnore();
		}
		if (!permissions.isDelete) {
			roles.deleteBtn.disableAndIgnore();
		}
		// Register isModifiedPageHandler in adminConfig.js
		// (We don't check for modifications if there is no edit 
		// permission because there is no Save button anyway!)
		adminConfig.getIsModifiedPageHandler = getIsModifiedPage;
	}
	else {
		roles.saveChangesBtn.disableAndIgnore();
		roles.newRoleBtn.disableAndIgnore();
		roles.duplicateBtn.disableAndIgnore();
		roles.deleteBtn.disableAndIgnore();
		roles.undoAllChangesBtn.disableAndIgnore();
	}
	// Init help
	util.helpWindow.init('');
	//
	// init tabs
	//
	var tabList = ['admin:role_tab', 'reports:role_tab', 'config:role_tab', 'miscellaneous:role_tab'];
	roles.tabs = new util.Tabs2(tabList, roleTabActivated);
	//
	// Create theList object
	//
	roles.theList = new listcontroller.List(
		{
		containerElementId: 'item_list_body',
		itemEvent: itemActivated
		}
	);
	//
	// init form controls
	//
	if (isEnterprise) {
		YAHOO.util.Event.addListener('role_label', 'keyup', updateListAndFormLabel);
	}
}
function initMainDisplay() {
	// alert('initMainDisplay()');
	util.hideE(['form_section', 'roles_form', 'no_item_form', 'loading_info', 'saving_info']);
	var firstItemId = roles.theList.getFirstItemId();
	// alert('initMainDisplay() - firstItemId: ' + firstItemId);
	var isItem = (firstItemId != null) ? true : false;
	if (isItem) {
		// select the first item
		setRoleItem(firstItemId);
		displayNoItemForm(false);
	}
	else {
		// no item exists
		displayNoItemForm(true);
	}
	util.showE('form_section');
	setRoleTab('admin');
}
function getRolesData() {
	if (!pageInfo.exitActive) {
		var url = '?dp=admin_pages.roles.get_data';
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		util.serverPost(url, dat);
	}
}
function getRolesDataResponse(dat) {
	// alert('getRolesDataResponse(): ' + dat);
	// temp
	// return false;
	if (!pageInfo.exitActive) {
		var rolesDb = dat.rolesDb;
		roles.activeUserNodeName = dat.activeUserNodeName;
		roles.usersDb = dat.usersDb;
		roles.featureMap = dat.featureMap;
		roles.rolesDb = rolesDb;
		roles.rolesDbBackup = util.cloneObject(dat.rolesDb);
		roles.schedulerActionsDb = dat.schedulerActionsDb;
		roles.rolesUsedInUsersDb = dat.rolesUsedInUsersDb;
		util.createHash(roles.usersDb, 'name');
		util.createHash(roles.schedulerActionsDb, 'name');
		// util.showObject(roles.featureMap);
		var isEnterprise = (pageInfo.licensingTier == 'enterprise');
		roles.isEnterprise = isEnterprise;
		init(isEnterprise);
		roles.theList.init(roles.rolesDb);
		rolesUtil.initFeatures(isEnterprise);
		if (isEnterprise) {
			// Create roles.accessDetailsRolesDb for access detail list
			rolesUtil.updateAccessDetailsRolesDb(rolesDb);
			// Init access details panel
			rolesAD.init();
		}
		// Init Save Profile Changes Access Details panel
		rolesSRCAD.init();
		initMainDisplay();
		// Set final toolbar state
		roles.saveChangesBtn.enable();
		roles.undoAllChangesBtn.enable();
		roles.newRoleBtn.enable();
		updateToolbarButtons(); // handles Duplicate and Delete
		util.showE('form_section');
		adminConfig.setItemListSize();
		YAHOO.util.Event.addListener(window, 'resize', adminConfig.setItemListSize);
		pageInfo.initComplete = true;
	}
}
/**
*
*
* 
* display functions
*
*
*
*/
function displayNoItemForm(isDisplayNoItemForm) {
	if (isDisplayNoItemForm) {
		util.hideE('roles_form');
		util.showE('no_item_form');
	}
	else {
		util.hideE('no_item_form');
		util.showE('roles_form');
	}
	roles.noItemFormIsActive = isDisplayNoItemForm;
}
function updateToolbarButtons() {
	var isItems = roles.theList.isItems();
	roles.deleteBtn.enable(isItems);
	roles.duplicateBtn.enable(isItems);
}
function roleTabActivated() {
	// alert('roleTabActivated(): ' + this.id);
	var elementId = this.id;
	var dat = elementId.split(':');
	var tabId = dat[0];
	setRoleTab(tabId);
}
function setRoleTab(tabId) {
	// alert('setRoleTab(): ' + tabId);
	roles.tabs.setActiveTab(tabId + ':role_tab');
	util.hideE(['admin:features:panel', 'reports:features:panel', 'config:features:panel', 'miscellaneous:features:panel']);
	util.showE(tabId + ':features:panel');
	roles.activeTabId = tabId;
}
function setRoleItem(itemId) {
	roles.theList.selectItem(itemId);
	updateForm();
	// Reset isModifiedFeatures
	roles.isModifiedFeatures = false;
}
/**
*
*
* 
* form handling functions
*
*
*
*/
function itemActivated(itemId) {
	if (validateActiveItem()) {
		setRoleItem(itemId);
	}
}
function newRole() {
	if (validateActiveItem()) {
		var theList = roles.theList;
		var newItemId = theList.getNewItemId();
		var label = langVar('lang_admin.general.new_role');
		var newNodeName = rolesUtil.getNewRoleNodeName(roles.rolesDb, roles.deletedRolesDb);
		var o = {
			id: newItemId,
			type: '',
			label: label,
			dat: {
				node_name: newNodeName,
				label: label,
				created_by_user: roles.activeUserNodeName,
				features: []
			}
		}
		theList.newItem(o);
		// Update roles.accessDetailsRolesDb
		if (roles.isEnterprise) {rolesUtil.updateAccessDetailsRolesDb(roles.rolesDb);}
		setRoleItem(newItemId);
		updateToolbarButtons();
	}
}
function duplicateRole() {
	if (validateActiveItem()) {
		var theList = roles.theList;
		// Get new node name
		var newNodeName = rolesUtil.getNewRoleNodeName(roles.rolesDb, roles.deletedRolesDb);
		// Clone item
		var clonedItemId = theList.cloneItem();
		// Give the cloned item a new node name and correct created_by_user value
		theList.setItemDatValue(clonedItemId, 'node_name', newNodeName);
		theList.setItemDatValue(clonedItemId, 'created_by_user', roles.activeUserNodeName);
		// Update roles.accessDetailsRolesDb
		if (roles.isEnterprise) {rolesUtil.updateAccessDetailsRolesDb(roles.rolesDb);}
		setRoleItem(clonedItemId);
	}
}
function deleteRole() {
	// var itemIdToDelete = theList.getSelectedItemId();
	// If this role is used in users then confirm delete!
	var item = roles.theList.getSelectedItem();
	var itemId = item.id;
	var itemNodeName = item.dat.node_name;
	// alert('deleteRole(): ' + itemId);
	var roleIsUsedInUsers = (roles.rolesUsedInUsersDb['_' + itemNodeName] != null) ? true : false;
	// var isDelete = roleIsUsedInUsers ? confirm(
	var msg = langVar('lang_admin.roles.confirm_delete_role_is_used_in_users');
	if (!roleIsUsedInUsers || confirm(msg)) {
		//
		// Add node name of deleted item to deletedRolesDb
		//
		var deletedRolesDb = roles.deletedRolesDb;
		deletedRolesDb[deletedRolesDb.length] = itemNodeName;
		// Update roles list in Users Details
		if (roles.isEnterprise) {
			// rolesUtil.initSimpeFeaturesInUsersDetails();
		}
		//
		// Delete the item
		//
		var nextItemIdToBeSelected = roles.theList.deleteItem();
		// Update roles.accessDetailsRolesDb
		if (roles.isEnterprise) {rolesUtil.updateAccessDetailsRolesDb(roles.rolesDb);}
		//
		// select the next item
		//
		if (nextItemIdToBeSelected != null) {
			// reset the validator in case that the deleted an item with error indication
			roles.validator.reset();
			setRoleItem(nextItemIdToBeSelected);
		}
		else {
			// All items have been deleted
			// alert('Last item has been deleted, no more items to select.');
			displayNoItemForm(true);
			updateToolbarButtons();
		}
	}
}
function updateListAndFormLabel() {
	// Only used in Enterprise
	setTimeout('setListAndFormLabel()', 300);
}
function setListAndFormLabel() {
	var theList = roles.theList;
	var label = util.getF('role_label');
	if (label == '') {
		label = '-';
	}
	// We need to check if the role is from another user
	var item = theList.getSelectedItem(); 
	var createdByUser = item.dat.created_by_user;
	if (createdByUser != roles.activeUserNodeName) {
		var usersDb = roles.usersDb;
		var username = (usersDb[util.h(createdByUser)] != null) ? usersDb[util.h(createdByUser)].username : langVar('lang_admin.roles.unknown_user');
		var byUserLabel = ' (' + langVar('lang_admin.general.by_user') + ')';
		byUserLabel = byUserLabel.replace(/__PARAM__1/, username);
		label += byUserLabel;
	}
	// util.updateT('item_form_label', label);
	theList.updateListLabel(label);
	// We also need to update the label in accessDetailsRolesDb
	if (roles.isEnterprise) {
		var item = theList.getSelectedItem();
		var nodeName = item.dat.node_name;
		var accessDetailsItem = roles.accessDetailsRolesDb[util.h(nodeName)];
		accessDetailsItem.label = label;
	}
}
function updateForm() {
	// alert('updateForm()');
	var isEnterprise = roles.isEnterprise;
	if (isEnterprise) {
		// Reset access details
		// Values for the active role are set by setFeaturePermissions
		roles.accessDetails.scheduler.isUnlimitedGrants = true;
		roles.accessDetails.scheduler.items = [];
		roles.accessDetails.users.isUnlimitedGrants = true;
		roles.accessDetails.users.items = [];
	}
	rolesUtil.resetFeaturePermissions();
	var item = roles.theList.getSelectedItem();
	var itemDat = item.dat;
	roles.activeCreatedByUser = itemDat.created_by_user;
	var features = itemDat.features;
	// util.showObject(itemDat);
	//
	// Handle role label
	//
	var roleLabel = itemDat.label;
	if (isEnterprise) {
		util.setF('role_label', roleLabel);
	}
	else {
		util.updateT('item_form_label', roleLabel);
	}
	// Reset global saveReportChanges and saveReportChangesToProfile settings
	roles.accessDetails.saveReportChanges.isView = false;
	roles.accessDetails.saveReportChangesToProfile.isView = false;
	//
	// Update features
	//
	var featureMap = roles.featureMap;
	for (var i = 0; i < features.length; i++) {
		var featureItem = features[i];
		rolesUtil.setFeaturePermissions(featureMap, featureItem, isEnterprise);
	}
	// Update Save Report Changes row info display (must occur after setFeaturePermissions()!)
	rolesUtil.updateSaveReportChangesAccessDetailsDisplay();
	if (roles.noItemFormIsActive) {
		displayNoItemForm(false);
	}
}
function validateActiveItem() {
	// Only validate if isEdit permission and if items
	var theList = roles.theList;
	if (pageInfo.permissions.isEdit && theList.isItems()) {
		// We only validate the item if the label or features have been modified
		var isEnterprise = roles.isEnterprise;
		var isModifiedFeatures = roles.isModifiedFeatures;
		// get original item
		var oriItem = roles.theList.getSelectedItem();
		var oriItemDat = oriItem.dat;
		var oriLabel = oriItemDat.label;
		var newLabel;
		var isModifiedLabel = false;
		if (isEnterprise) {
			// newLabel = util.getF('role_label');
			// newLabel = util.trim(newLabel);
			// isModifiedLabel = (oriLabel.toLowerCase() != newLabel.toLowerCase());
			isModifiedLabel = true; // We need to validate the label in case of duplicate or new role!
		}
		else {
			newLabel = oriLabel;
		}
		// alert('isModifiedLabel: ' + isModifiedLabel);
		if (isModifiedLabel || isModifiedFeatures) {
			//
			// Validate
			//
			var validator = roles.validator;
			validator.reset();
			var o = {};
			o.node_name = oriItemDat.node_name;
			if (isModifiedLabel) {
				o.label = validator.isValue('role_label');
				o.label = validator.isUnique('role_label', theList.getLookupItems('label'));
			}
			else {
				o.label = oriLabel;
			}
			o.created_by_user = roles.activeCreatedByUser;
			//
			// Get the features
			//
			var features = [];
			if (isModifiedFeatures) {
				// Get features from active form
				features = rolesUtil.getActiveFormFeatures(isEnterprise);
			}
			else {
				// Features are not modified, clone the existing once
				features = util.cloneObject(oriItemDat.features);
			}
			o.features = features;
			if (validator.allValid()) {
				theList.saveItem(o);
				// TEMP DEBUG
				/*
				var modifiedItemInList = roles.theList.getSelectedItem();
				var modifiedFeatures = modifiedItemInList.dat.features;
				for (var i = 0; i < modifiedFeatures.length; i++) {
					if (modifiedFeatures[i].id == 'f1') {
						util.showObject(modifiedFeatures[i]);
					}
				}
				*/
				return true;
			}
		}
		else {
			return true;
		}
		return false;
	}
	// No isEdit permission or no items
	return true;
}
function saveChanges() {
	if (validateActiveItem()) {
		var theList = roles.theList;
		var isModified = theList.getIsModified();
		// alert('saveChanges() - isModified: ' + isModified);
		if (isModified) {
			util.hideE('form_section');
			util.showE('saving_info');
			var isEnterprise = roles.isEnterprise;
			var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
			var i;
			// var deletedRolesPath = 'v.fp.deleted_roles';
			//
			//
			// Handle deleted roles
			//
			//
			var deletedRolesDb = roles.deletedRolesDb;
			if (deletedRolesDb.length > 0) {
				for (i = 0; i < deletedRolesDb.length; i++) {
					dat += 'v.fp.deleted_roles.' + deletedRolesDb[i] + '=true&';
				}
			}
			else {
				dat += 'v.fp.deleted_roles=&';
			}
			//
			//
			//
			//
			// Handle roles
			//
			//
			//
			//
			var rolesDb = roles.rolesDb;
			// Create a roles lookup to check if any role defined in access details still exists (Enterprise only)
			var rolesLookup = {};
			if (isEnterprise) {
				for (i = 0; i < rolesDb.length; i++) {
					var lookupNodeName = '__' + rolesDb[i].dat.node_name;
					rolesLookup[lookupNodeName] = true;
				}
			}
			// util.showObject(rolesLookup);
			if (rolesDb.length > 0) {
				var featureMap = roles.featureMap;
				for (i = 0; i < rolesDb.length; i++) {
					var itemDat = rolesDb[i].dat;
					var roleName = itemDat.node_name;
					var roleLabel = itemDat.label;
					var createdByUser = itemDat.created_by_user;
					var features = itemDat.features;
					var rolePath = 'v.fp.roles.' + roleName;
					var featuresPath = rolePath + '.features';
					dat += rolePath + '.label=' + util.getEncodedURIComponent(roleLabel) + '&';
					dat += rolePath + '.created_by_user=' + util.getEncodedURIComponent(createdByUser) + '&';
					if (features.length > 0) {
						for (var j = 0; j < features.length; j++) {
							var featureItem = features[j];
							var featureId = featureItem.id;
							var featureMapItem = featureMap[util.h(featureId)];
							var categoryName = featureMapItem.category;
							var featureName = featureMapItem.name;
							var hasEdit = featureMapItem.hasEdit;
							var hasAdd = featureMapItem.hasAdd;
							var hasDelete = featureMapItem.hasDelete;
							var featureItemPath = featuresPath + '.' + categoryName + '.' + featureName;
							dat += featureItemPath + '.view=' + featureItem.isView + '&';
							if (hasEdit) {
								dat += featureItemPath + '.edit=' + featureItem.isEdit + '&';
							}
							if (hasAdd) {
								dat += featureItemPath + '.add=' + featureItem.isAdd + '&';
							}
							if (hasDelete) {
								dat += featureItemPath + '.delete=' + featureItem.isDelete + '&';
							}
							var isScheduler = (categoryName == 'admin' && featureName == 'scheduler');
							var isUsers = (categoryName == 'admin' && featureName == 'users');
							if (isScheduler || isUsers) {
								var numOfAccessDetailsItemsAdded = 0;
								var isUnlimitedGrants = featureItem.isUnlimitedGrants;
								var accessDetailsItems = featureItem.items;
								var accessDetailsItemsName = isScheduler ? 'actions' : 'roles';
								var accessDetailsPath = featureItemPath + '.' + accessDetailsItemsName;
								dat += featureItemPath + '.unlimited_grants=' + isUnlimitedGrants + '&';
								if (!isUnlimitedGrants && (accessDetailsItems.length > 0)) {
									// If we handle users we have to make sure that the role item
									// still exists because it could have been deleted.
									for (var k = 0; k < accessDetailsItems.length; k++) {
										var accessDetailsItemName = accessDetailsItems[k];
										if (isScheduler || (rolesLookup['__' + accessDetailsItemName] != null)) {
											dat += accessDetailsPath + '.' + accessDetailsItemName + '=true&';
											numOfAccessDetailsItemsAdded++;
										}
									}
								}
								if (numOfAccessDetailsItemsAdded == 0) {
									// No access detail items
									dat += accessDetailsPath + '=&';
								}
							}
						}
					}
					else {
						dat += featuresPath + '=&'; 
					}
				}
			}
			else {
				dat += 'v.fp.roles=&';
			}
			dat = dat.replace(/&$/, '');
			//
			//
			// Post data
			//
			//
			var url = '?dp=admin_pages.roles.save_data';
			util.serverPost(url, dat);
		}
		else {
			alert(langVar('lang_stats.general.no_changes_to_save'));
		}
	}
}
function saveChangesResponse() {
	// Reset data
	roles.rolesDbBackup = util.cloneObject(roles.rolesDb);
	roles.deletedRolesDb = [];
	roles.theList.resetIsModified();
	util.hideE('saving_info');
	util.showE('form_section');
}
function undoAllChanges() {
	// alert('undoAllChanges()');
	roles.rolesDb = util.cloneObject(roles.rolesDbBackup);
	roles.deletedRolesDb = [];
	// Update roles list in Users Details
	if (roles.isEnterprise) {
		// rolesUtil.initSimpeFeaturesInUsersDetails();
	}
	// alert('rolesDb length after cloning rolesDbBackup: ' + rolesDb.length);
	roles.theList.init(roles.rolesDb);
	initMainDisplay();
	updateToolbarButtons();
}
function getIsModifiedPage() {
	// Note, isModified will be false if only the active item has been edited
	// but has an error, hence we also check "if (!validateActiveItem() ..."
	if (!validateActiveItem() || roles.theList.getIsModified()) {
		return true;
	}
	return false;
}
