//
// newFieldWizardPage.js
//
var fieldsDb = []; // contains node names and labels of all fields
var logFiltersDb = []; //  contains node names and labels of all log filters
var reportsDb = []; //  contains node names and labels of all reports
// var xrefFieldsDb = []; // contains the field names which will be part of the cross reference group of the new field
var reportsMenuDb = []; // contains the report_menu node names
var newFieldWizardPage = {
	init: function() {
		YAHOO.util.Event.addListener('start_wizard_btn', 'click', newFieldWizard.open);
		// Init help
		util.helpWindow.init('');
		// init the wizard
		newFieldWizard.init();
		// get new field wizard data
		newFieldWizardPage.getNewFieldWizardData();
	},
	getNewFieldWizardData: function() {
		var url = '?dp=config_pages.new_field_wizard.get_nfw_data';
		url += '&p=' + pageInfo.profileName;
var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		util.serverPost(url, dat);
	},
	getNewFieldWizardDataResponse: function(dat) {
		fieldsDb = dat.fieldsDb;
		logFiltersDb = dat.logFiltersDb;
		reportsDb = dat.reportsDb;
		// xrefFieldsDb = dat.xrefFieldsDb;
		reportsMenuDb = dat.reportsMenuDb;
		util.showE('form_section');
	}
};
//
// newFieldWizardUtil.js
//
var newFieldWizardUtil = {
	setLogFieldType: function() {
		// initiated from list only
		var isHirarchicalType = util.getF('log_field_type') == 'hierarchical' ? true : false;
		util.showE('hierarchical_section', isHirarchicalType);
	},
	toggleDisplayFormatType: function() {
		var displayFormatType = util.getF('display_format_type');
		var isCustomFormat = (displayFormatType == 'custom');
		util.showE('custom_display_format_type_section', isCustomFormat);
	},
	createItemsArray: function(theArray, theKey) {
		var a = [];
		for (var i = 0; i < theArray.length; i++) {
			var s = theArray[i][theKey];
			a[i] = s
		}
		return a;
	}
};
//
// newFieldWizard.js
//
// var f; // used to collect wizard form data
var newFieldWizard = {
	panel: null,
	validator: null,
	activePage: '',
	activeNextButtonLabel: '',
	pages: [
		'field_name_page',
		'log_field_page',
		'db_field_page',
		'report_field_page',
		'log_filter_page',
		'report_page'
	],
	path: [], // keeps the path of the wizard pages
	fDat: {},
	fieldNames: [],
	fieldLabels: [],
	logFilterNames: [],
	logFilterLabels: [],
	reportNames: [],
	reportLabels: [],
	reportMenuNames: [],
	fieldHasAlreadyBeenCreated: false,
	init: function() {
		newFieldWizard.validator = new util.Validator();
		var panelObj = {
			panelId: 'nfw:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_admin.new_field_wizard.new_field_wizard'),
			left: 40,
			top: 70,
			zIndex: 20,
			isCover: true,
			isSticky: true,
			closeEvent: newFieldWizard.cancel
		};
		newFieldWizard.panel = new util.Panel3(panelObj);
		var YE = YAHOO.util.Event;
		YE.addListener('nfw:next_btn', 'click', newFieldWizard.goNext);
		YE.addListener('nfw:back_btn', 'click', newFieldWizard.goBack);
		YE.addListener('nfw:cancel_btn', 'click', newFieldWizard.cancel);
		YE.addListener('log_field_type', 'change', newFieldWizardUtil.setLogFieldType);
		YE.addListener('display_format_type', 'change', newFieldWizardUtil.toggleDisplayFormatType);
		// init OptionInfo
		optionInfo.init();
	},
	open: function() {
		util.hideE(['wizard_intro_section', 'wizard_complete_section', 'start_wizard_btn']);
		// create comperator hash tables, we do this upon each wizard
		// start because new fields could just have been added
		newFieldWizard.fieldNames = newFieldWizardUtil.createItemsArray(fieldsDb, 'name');
		newFieldWizard.fieldLabels = newFieldWizardUtil.createItemsArray(fieldsDb, 'label');
		newFieldWizard.logFilterNames = newFieldWizardUtil.createItemsArray(logFiltersDb, 'name');
		newFieldWizard.logFilterLabels = newFieldWizardUtil.createItemsArray(logFiltersDb, 'label');
		newFieldWizard.reportNames = newFieldWizardUtil.createItemsArray(reportsDb, 'name');
		newFieldWizard.reportLabels = newFieldWizardUtil.createItemsArray(reportsDb, 'label');
		newFieldWizard.reportMenuNames = newFieldWizardUtil.createItemsArray(reportsMenuDb, 'name');
		newFieldWizard.fDat = {};
		newFieldWizard.activePage = '';
		newFieldWizard.path = [];
		util.resetF('nfw:form');
		util.hideE('custom_display_format_type_section');
		// hide all wizard pages
		util.hideE(newFieldWizard.pages);
		// hide lof_field hierachical section
		util.hideE('hierarchical_section');
		newFieldWizard.setNext('field_name_page');
		// util.showE('wizard_section');
		newFieldWizard.panel.open();
	},
	close: function() {
		if (optionInfo.isOpen) {
			optionInfo.close();
		}
		newFieldWizard.panel.close();
	},
	cancel: function() {
		newFieldWizard.close();
		newFieldWizard.setNewFieldWizardPage();
	},
	setNewFieldWizardPage: function() {
		// Invoked upon cancel or when a new field has been created
		if (newFieldWizard.fieldHasAlreadyBeenCreated) {
			util.showE('wizard_complete_section');
		}
		else {
			util.showE('wizard_intro_section');
		}
		util.showE('start_wizard_btn');
	},
	goBack: function() {
		var wizardPath = newFieldWizard.path;
		var currentPageIndex = wizardPath.length - 1;
		var currentPage = wizardPath[currentPageIndex];
		var previousPage = wizardPath[currentPageIndex - 1];
		util.hideE(currentPage);
		util.showE(previousPage);
		wizardPath.splice(currentPageIndex, 1);
		newFieldWizard.activePage = previousPage;
		newFieldWizard.setButtonState();
	},
	goNext: function() {
		var validator = newFieldWizard.validator;
		validator.reset();
		var nextPage = '';
		var fDat = newFieldWizard.fDat;
		switch (newFieldWizard.activePage) {
			case 'field_name_page':
				// util.showObject(newFieldWizard.fieldLabels);
				fDat.general = {};
				fDat.general.label = validator.isValue('field_label');
				fDat.general.label = validator.isUnique('field_label', newFieldWizard.fieldLabels);
				nextPage = 'log_field_page';
				break;
			case 'log_field_page':
				fDat.log_field = {};
				fDat.log_field.label = fDat.general.label;
				fDat.log_field.type = validator.isValue('log_field_type');
				if (fDat.log_field.type == 'hierarchical') {
					// hierarchy_dividers input field is limited to two characters, so no length validation is required
					fDat.log_field.hierarchy_dividers = validator.isValue('hierarchy_dividers', false); // second argument false does not trim white space!
					fDat.log_field.left_to_right = util.getF('left_to_right');
					fDat.log_field.leading_divider = util.getF('leading_divider');
				}
				// index/subinex, if empty set them to 0, else validate for valid integer
				var index = util.getF('index');
				var subindex = util.getF('subindex');
				fDat.log_field.index = (index == '' || index == 0) ? 0 : validator.isInteger('index');
				fDat.log_field.subindex = (subindex == '' || subindex == 0) ? 0 : validator.isInteger('subindex');
				fDat.log_field.case_sensitive = util.getF('case_sensitive');
				nextPage = 'db_field_page';
				break;
			case 'db_field_page':
				// Note, database field type is always string, numerical fields are not possible within new field wizard.
				fDat.database_field = {};
				fDat.database_field.label = fDat.general.label;
				fDat.database_field.type = 'string';
				var suppress_top = validator.isInteger('suppress_top', 0);
				var suppress_bottom = validator.isInteger('suppress_bottom', 0);
				if (util.isInteger(suppress_top, 0) && util.isInteger(suppress_bottom, 0)) {
					if (parseInt(suppress_bottom, 10) < parseInt(suppress_top, 10)) {
						validator.isCustom('suppress_bottom', langVar('lang_admin.database_fields.invalid_supress_bottom_msg'));
					}
				}
				fDat.database_field.suppress_top = suppress_top;
				fDat.database_field.suppress_bottom = suppress_bottom;
				fDat.database_field.derivation_method = 'log_field';
				fDat.database_field.aggregation_method = 'none';			
				fDat.database_field.category = '';
				nextPage = 'report_field_page';
				break;
			case 'report_field_page':
				fDat.report_field = {};
				fDat.report_field.label = fDat.general.label;
				fDat.report_field.column_label = util.getF('column_label');
				fDat.report_field.column_info = '';
				// handle subitems_level
				var log_field_type = fDat.log_field.type;
				if (log_field_type != 'flat' && log_field_type != 'agent') {
					var subitems_level;
					if (util.getF('subitems_type:bottom_level')) {
						subitems_level = -1;
					}
					else if (util.getF('subitems_type:hierarchical')) {
						subitems_level = 0;
					}
					else {
						// specific subitems_level
						subitems_level = validator.isInteger('subitems_level', 1);
					}
					fDat.report_field.subitems_level = subitems_level;
				}
				// handle display_format_type
				var displayFormatType = util.getF('display_format_type');
				var customDisplayFormatType = '';
				if (displayFormatType == 'string') {
					displayFormatType = '';
				}
				else if (displayFormatType == 'custom') {
					customDisplayFormatType = util.getF('custom_display_format_type');
					if (customDisplayFormatType == '') {
						// No custom format type defined. We auto-fix it by setting displayFormatType to empty value
						displayFormatType = '';
					}
				}
				fDat.report_field.display_format_type = displayFormatType;
				fDat.report_field.custom_display_format_type = customDisplayFormatType;
				nextPage = 'log_filter_page';
				break;
			case 'log_filter_page':
				fDat.log_filter = {};
				fDat.log_filter.label = validator.isValue('log_filter_label');
				fDat.log_filter.label = validator.isUnique('log_filter_label', newFieldWizard.logFilterLabels);
				nextPage = 'report_page';
				break;
			case 'report_page':
				fDat.report = {};
				fDat.report.label = validator.isValue('report_label');
				fDat.report.label = validator.isUnique('report_label', newFieldWizard.reportLabels);
				fDat.reports_menu = {};
				fDat.reports_menu.show_in_dynamic_reports = util.getF('show_in_dynamic_reports');
				fDat.reports_menu.show_in_static_reports = util.getF('show_in_static_reports');
				break;
		}
		if (validator.allValid()) {
			if (nextPage != '') {
				newFieldWizard.setNext(nextPage);
			}
			else {
				//
				// This is the last wizard page, save the new field.
				//
				newFieldWizard.saveNewField();
			}
		}
	},
	setNext: function(page) {
		// alert('setNext: ' + page);
		// reset errors
		newFieldWizard.validator.reset();
		// hide active page
		if (newFieldWizard.activePage != '') {
			util.hideE(newFieldWizard.activePage);
		}
		newFieldWizard.activePage = page;
		var wizardPath = newFieldWizard.path;
		wizardPath[wizardPath.length] = page;
		newFieldWizard.setButtonState();
		// update page label
		// util.updateT('wizard_page_label', newFieldWizard.pages[page.toUpperCase()].label);
		// In case that the log filter label or report label is empty give it
		// the field label as default value.
		var fDat = newFieldWizard.fDat;
		if (page == 'log_filter_page' && util.getF('log_filter_label') == '') {
			util.setF('log_filter_label', fDat.general.label);
		}
		else if (page == 'report_page' && util.getF('report_label') == '') {
			util.setF('report_label', fDat.general.label);
		}
		if (page == 'report_field_page') {
			// show hide subitems_level
			var log_field_type = fDat.log_field.type;
			var showSubitemsLevel = (log_field_type != 'flat' && log_field_type != 'agent');
			util.showE('subitems_level_section', showSubitemsLevel);
		}
		util.showE(page);
	},
	setButtonState: function() {
		var wizardPath = newFieldWizard.path;
		var makeBackEnabled = (wizardPath.length > 1);
		util.enableE('nfw:back_btn', makeBackEnabled);
		var nextButtonLabel = (newFieldWizard.activePage != 'report_page') ? langVar('lang_stats.btn.next') + ' >' : langVar('lang_stats.btn.finish');
		if (newFieldWizard.activeNextButtonLabel != nextButtonLabel) {
			util.updateT('nfw:next_btn', nextButtonLabel);
		}
	},
	saveNewField: function() {
		// alert('saveNewField()');
		// return false;
		newFieldWizard.close();
		// util.hideE('form_section');
		util.showE('saving_info');
		var fDat = newFieldWizard.fDat;
		//
		// get and assign the node names
		//
		fDat.general.field_name = util.labelToUniqueNodeName(fDat.general.label, newFieldWizard.fieldNames, 'field');
		fDat.log_filter.name = util.labelToUniqueNodeName(fDat.log_filter.label, newFieldWizard.logFilterNames, 'filter');
		fDat.report.name = util.labelToUniqueNodeName(fDat.report.label, newFieldWizard.reportNames, 'report');
		fDat.general.report_menu_name = util.labelToUniqueNodeName(fDat.report.label, newFieldWizard.reportMenuNames, 'report_menu');
		//
		// assign depending field names
		//
		fDat.database_field.log_field = fDat.general.field_name;
		fDat.report_field.database_field = fDat.general.field_name;
		fDat.reports_menu.report = fDat.report.name;
		var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
		var pattern = /\W/; // The pattern /\W/ is equal [^a-zA-Z0-9_]
		for (var rootProp in fDat) {
			var rootPath = 'v.fp.' + rootProp;
			var fValues = fDat[rootProp];
			for (var prop in fValues) {
				var itemValue = fValues[prop];
				if (pattern.test(itemValue)) {
					itemValue = encodeURIComponent(itemValue);
				}
				var path = rootPath + '.' + prop;
				dat += path + '=' + itemValue + '&';
			}
		}
		// add the cross references
		// var path = 'v.fp.cross_reference_group';
		// add the new field to cross reference group
		// dat += path + '.' + fDat.general.field_name + '=&';
		// add all other numerical fields to cross reference group
		//for (var i = 0; i < xrefFieldsDb.length; i++) {
		//	dat += path + '.' + xrefFieldsDb[i] + '=&';
		//}
		dat = dat.replace(/&$/, '');
		var url = '?dp=config_pages.new_field_wizard.save_new_field';
		url += '&p=' + pageInfo.profileName;
		util.serverPost(url, dat);
		pageInfo.saveActive = true;
	},
	saveNewFieldResponse: function() {
		newFieldWizard.fieldHasAlreadyBeenCreated = true;
		var fDat = newFieldWizard.fDat;
		// add new data to Dbs in case that another field becomes created
		fieldsDb[fieldsDb.length] = {name: fDat.general.field_name, label: fDat.general.label};
		logFiltersDb[logFiltersDb.length] = {name: fDat.log_filter.name, label: fDat.log_filter.label};
		reportsDb[reportsDb.length] = {name: fDat.report.name, label: fDat.report.label};
		reportsMenuDb[reportsMenuDb.length] = {name: fDat.general.report_menu_name};
		newFieldWizard.setNewFieldWizardPage();
		util.hideE('saving_info');
		// util.showE('form_section');
	}
};
