//
// snaponParametersWizard namespace
//
var snaponParametersWizard = function() {
	var YE = YAHOO.util.Event,
	    panel = null,
        parametersForm = [],
        indexOfLastPage = -1, // The index of the snapon label page
	    currentPageIndex = -1,
	    activeNextButtonLabel = '';
	function init() {
		var panelObj = {
			panelId: 'snapon_parameters:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_admin.snapons.snapon_parameters'),
			left: 316,
			top: 160,
			zIndex: 20,
			isCover: true,
			// isSticky: true,
			closeEvent: snaponParametersWizard.cancel
		};
		panel = new util.Panel3(panelObj);
		YE.addListener('snapon_parameters:back_btn', 'click', goBack);
		YE.addListener('snapon_parameters:next_btn', 'click', goNext);
		YE.addListener('snapon_parameters:cancel_btn', 'click', cancel);
	}
	function openPanel(dat, defaultSnaponLabel, attachedSnaponLabelsLookupArg) {
		// util.showObject(dat);
		if (!panel) {init();}
		parametersForm = dat.parametersForm;
		// Add last label wizard page to parameters
		indexOfLastPage = parametersForm.length;
		var lastPage = {
			elementIdPrefix: '',
			// label:langVar('lang_admin.snapons.snapon_name'),
			description:langVar('lang_admin.snapons.please_define_a_snapon_name'),
			parameters: [{
				name: 'snapon_name',
				type: 'string',
				parameterValue: defaultSnaponLabel,
				validationType: 'snapon_label',
				formElementLabel: langVar('lang_admin.snapons.snapon_name'),
				formElementType: 'text',
				description: '',
				formElementWidth: '380'
			}]
		};
		parametersForm[indexOfLastPage] = lastPage;
		// Init snaponParameters
		var obj = {
            containerElementId: 'snapon_parameters:form',
            nextButtonElementId: 'snapon_parameters:next_btn',
			parametersForm: parametersForm,
			logFields: dat.logFields,
			databaseFields: dat.databaseFields,
			reportFields: dat.reportFields,
			reports: dat.reports,
			reportGroups: dat.reportGroups,
			attachedSnaponLabelsLookup: attachedSnaponLabelsLookupArg
		};
        snaponParameters.init(obj);
		// Reset currentPageIndex
		currentPageIndex = -1;
		// Start with the first wizard page
		setPage(0);
		panel.open();
	}
	function cancel() {
		panel.close();
		snapons.cancelViaParamtersPanel();
	}
	//
	// Page control
	//
	function goBack() {
		if (currentPageIndex > 0) {
			setPage(currentPageIndex - 1);
		}
	}
	function goNext() {
		// Go to next page
		// Validate current wizard page
		if (snaponParameters.getIsValidWizardPage(currentPageIndex)) {
			if (currentPageIndex < indexOfLastPage) {
				setPage(currentPageIndex + 1);
			}
			else {
				// The user clicked Finish
				// Proceed with snapon.startSnaponOperation()
				panel.close();
				// Get snaponLabel and remove last wizardPage (the snaponLabel) from
				// parametersForm because the snaponLabel is send as separate value.
				var a = parametersForm.splice(indexOfLastPage, 1);
				var deletedPageItem = a[0];
				var snaponLabel = deletedPageItem.parameters[0].finalValue;
				// Process node names for all label parameters, if any.
				snaponParameters.handleLabelParameterNodeNames();
				// Start the snapon operation
				snapons.startSnaponOperation(snaponLabel, parametersForm);
			}
		}		
	}
	function setPage(pageIndex) {
		// Hide the current page
		if (currentPageIndex != -1) {
			util.hideE('snapon_parameters_page:' + currentPageIndex);
		}
		// Update wizard page title and description
		// var pageItem = parametersForm[pageIndex];
		// util.updateT('snapon_parameters:title', pageItem.label);
		// util.updateT('snapon_parameters:description', pageItem.description);
		// Show new page
		util.showE('snapon_parameters_page:' + pageIndex);
		currentPageIndex = pageIndex;
		updateButtonState();
	}
	function updateButtonState() {
		var isBack = (currentPageIndex > 0);
		var nextButtonLabel = (currentPageIndex < indexOfLastPage) ? langVar('lang_stats.btn.next') : langVar('lang_stats.btn.finish');
		util.enableE('snapon_parameters:back_btn', isBack);
		if (activeNextButtonLabel != nextButtonLabel) {
			// Update next button label
			util.updateT('snapon_parameters:next_btn', nextButtonLabel);
			activeNextButtonLabel = nextButtonLabel;
		}
	}
	//
	// Return global properties and methods
	//
	return {
		openPanel: openPanel,
		cancel: cancel
	}
}();
//
// snapons
//
// This is the snapons namespace
var snapons = function() {
	var YE = YAHOO.util.Event;
	var confirmPanel = null;
	var availableSnapons = [];
	var attachedSnapons = [];
	var isLockedSnaponForm = true; // No selection allowed
	var busyPanel = null;
	// Active snapon data/mode, only valid for snapon operations
	// activated on the current form.
	var activeSnapon = {
		elementId: '',
		isAvailableSelected: false,
		isAttachedSelected: false,
		index: -1, // index referes to the index in availableSnapons array or attachedSnapons array
		snaponName: '',
		attachedSnaponName: '',
		newAttachedSnaponName: '',
		newAttachedSnaponLabel: '',
		count: -1
	};
	// keep progress data in progressObj so that we show the same data
	// when moving from simpleProgress to server side progress
	var progressObj = {
		progressType: '',
		taskId: '',
		mainLabel: '',
		updateMainLabel: false,
		mainInfo: '',
		updateMainInfo: false
	};
	//
	// Private properties and methods
	//
	function init() {
		var panelObj;
		if (!pageInfo.exitActive && confirmPanel == null) {
			// Init help
			util.helpWindow.init('');
			//
			// Init main form
			//
			YE.addListener(['snapons:available_snapons_list', 'snapons:attached_snapons_list'], 'click', snaponSelectActor); 
			YE.addListener('snapons:attach_snapon_btn','click', checkSnaponParameters);
			YE.addListener('snapons:detach_snapon_btn','click', confirmDetachSnapon);
			//
			// Init confirm panel
			//
			panelObj = {
				panelId: 'confirm_snapon_operation:panel',
				panelClassName: 'panel-50',
				panelHeaderLabel: '-',
				left: 316,
				top: 160,
				zIndex: 20,
				isCover: true,
				closeEvent: snapons.cancelDetachSnapon
			};
			confirmPanel = new util.Panel3(panelObj);
			YE.addListener('confirm_snapon_operation:yes_btn', 'click', detachSnapon);
			YE.addListener('confirm_snapon_operation:no_btn', 'click', cancelDetachSnapon);
			// Create simple progress panel
			busyPanel = new util.BusyPanel();
			//
			// init progress.js
			//
			progress.init({
				// decimalDivider: pageInfo.decimalDivider,
				isCancelTaskPermission: pageInfo.permissions.isCancelTask,
				profileName: pageInfo.profileName,
				calleeListener: progressListener,
				isPanel: true
			});
		}
	}
	function getSnaponData() {
		var url = '?dp=config_pages.snapons.get_snapon_data';
		url += '&p=' + pageInfo.profileName;
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		util.serverPost(url, dat);
	}
	function getSnaponDataResponse(dat) {
		if (!pageInfo.exitActive) {
			// util.showObject(dat);
			availableSnapons = dat.availableSnapons;
			attachedSnapons = dat.attachedSnapons;
			util.createHash(availableSnapons, 'snaponName');
			isActiveSnaponOperation = dat.isActiveSnaponOperation;
			init();
			buildAvailableSnaponList();
			buildAttachedSnaponList();
			lockSnaponForm(isActiveSnaponOperation);			
			util.showE('form_section');
			if (isActiveSnaponOperation) {
				// Start progress display
				progress.startProgress({
						progressType: 'snapon',
						mainLabel: langVar('lang_stats.database.snapon_operation_active'),
						updateMainLabel: true,
						mainInfo: langVar('lang_stats.progress.receiving_progress_information'),
						updateMainInfo: true
				});
			}
		}
	}
	/*
	function confirmSnaponOperation() {
		// Disable all snapon controls
		lockSnaponForm(true);
		var snaponItem;
		var label = langVar('lang_stats.btn.confirm');
		var text;
		if (activeSnapon.isAvailableSelected) {
			snaponItem = availableSnapons[activeSnapon.index];
			text = langVar('lang_admin.snapons.attach_param_1');
		}
		else {
			snaponItem = attachedSnapons[activeSnapon.index];
			text = langVar('lang_admin.snapons.detach_param_1');
		}
		text = text.replace(/__PARAM__1/, snaponItem.label);
		util.updateT('confirm_snapon_operation:text', text);
		confirmPanel.open({label:label});
	}
	*/
	function confirmDetachSnapon() {
		// Disable all snapon controls
		lockSnaponForm(true);
		var label = langVar('lang_stats.btn.confirm'),
			snaponItem = attachedSnapons[activeSnapon.index],
			text = langVar('lang_admin.snapons.detach_param_1');
		text = text.replace(/__PARAM__1/, snaponItem.label);
		util.updateT('confirm_snapon_operation:text', text);
		confirmPanel.open({label:label});
	}
	function detachSnapon() {
		confirmPanel.close();
		// Detaching, no paremeter input check required
		startSnaponOperation();
	}
	function cancelDetachSnapon() {
		confirmPanel.close();
		lockSnaponForm(false);
	}
	function checkSnaponParameters() {
		// Get snapon parameters
		lockSnaponForm(true);
		busyPanel.showCustom(langVar('lang_admin.snapons.checking_snapon_parameters'));
		var url = '?dp=config_pages.snapons.check_snapon_parameters';
		url += '&p=' + pageInfo.profileName;
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		dat += '&v.fp.snapon_name=' + activeSnapon.snaponName;
		util.serverPost(url, dat);
	}
	function checkSnaponParametersResponse(dat) {
		// Open snapon parameters wizard
		// util.showObject(dat);
		// Get default snapon label
		var activeSnaponLabel = availableSnapons[activeSnapon.index].label;
		var defaultSnaponLabel = activeSnaponLabel;
		var attachedSnaponLabelsLookup = {};
		for (var i = 0, l = attachedSnapons.length; i < l; i++) {
			var label = '_' + attachedSnapons[i].label;
			attachedSnaponLabelsLookup[label] = true;
		}
		var count = 2;
		while (attachedSnaponLabelsLookup['_' + defaultSnaponLabel] != null) {
			defaultSnaponLabel = activeSnaponLabel + ' ' + count;
			count++;
		}
		busyPanel.stop();
		snaponParametersWizard.openPanel(dat, defaultSnaponLabel, attachedSnaponLabelsLookup);
	}
	function cancelViaParamtersPanel() {
		// This cancels the snapon operation, called from snaponParamters.js.
		lockSnaponForm(false);
	}
	function getParametersDat(parametersForm) {
		var dat = '';
		var parametersCount = 0;
		for (var i = 0, l = parametersForm.length; i < l; i++) {
			var parametersFormItem = parametersForm[i];
			var parameters = parametersFormItem.parameters;
			for (var j = 0, paramtersL = parameters.length; j < paramtersL; j++) {
				var parameterItem = parameters[j];
				var validationType = parameterItem.validationType;
				dat += '&v.fp.parameters.' + parametersCount + '.parameter_name=' + parameterItem.name;
				dat += '&v.fp.parameters.' + parametersCount + '.final_value=' + parameterItem.finalValue;
				// Add node_name in parameters node if validationType is "*_label"
				if (validationType == 'field_label' ||
					validationType == 'report_label' ||
					validationType == 'report_group_label') {
					dat += '&v.fp.parameters.' + parametersCount + '.final_node_name=' + parameterItem.finalNodeName;
				}
				parametersCount++;
			}
		}
		return dat;
	}
	function startSnaponOperation(newSnaponLabelArg, parametersForm) {
		// startSnaponOperation is also called from snaponParamters.js.
		// parametersForm is optional, it is only available when invoked from snaponParamters.js.
		// alert('startSnaponOperation()');
        // util.showObject(parametersForm);
		var isAvailableSelected = activeSnapon.isAvailableSelected;
		var snaponItem;
		var mainLabel = '';
		var mainInfo = '';
		if (isAvailableSelected) {
			snaponItem = availableSnapons[activeSnapon.index];
			mainLabel = langVar('lang_stats.progress.major_task.attaching_snapon');
			mainInfo = langVar('lang_admin.snapons.attaching_param_1');
		}
		else {
			snaponItem = attachedSnapons[activeSnapon.index];
			mainLabel = langVar('lang_stats.progress.major_task.detaching_snapon');
			mainInfo = langVar('lang_admin.snapons.detaching_param_1');
		}
		mainInfo = mainInfo.replace(/__PARAM__1/, snaponItem.label);
		// Set/reset progress object, this progress object
		// will also be used when starting actual snapon progress
		progressObj.progressType = 'simple';
		progressObj.taskId = '';
		progressObj.mainLabel = mainLabel;
		progressObj.updateMainLabel = false;
		progressObj.mainInfo = mainInfo;
		progressObj.updateMainInfo = false;
		progress.startProgress(progressObj);
		var url = '?dp=config_pages.snapons.start_snapon_operation';
		url += '&p=' + pageInfo.profileName;
		var newSnaponLabel = isAvailableSelected ? newSnaponLabelArg : '';
		activeSnapon.newAttachedSnaponLabel = newSnaponLabel;
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		dat += '&v.fp.is_attach_snapon=' + isAvailableSelected;
		dat += '&v.fp.snapon_name=' + activeSnapon.snaponName;
		dat += '&v.fp.attached_snapon_name=' + activeSnapon.attachedSnaponName;
		dat += '&v.fp.new_attached_snapon_label=' + encodeURIComponent(newSnaponLabel);
		if (isAvailableSelected) {
			// Handle parameters
			dat += getParametersDat(parametersForm);
		}
		util.serverPost(url, dat);
	}
	function startSnaponOperationResponse(dat) {
		if (dat.errorMessage == '') {
			// The snapon operation has been invoked, check the task state.
			// Reset counter
			activeSnapon.newAttachedSnaponName = dat.newAttachedSnaponName;
			activeSnapon.count = 0;
			// util.showObject(activeSnapon);
			checkSnaponOperationState(dat.taskId);
		}
		else {
			// Show alert panel
			// ToDo, show alert panel
			alert(dat.errorMessage);
		}
	}
	function checkSnaponOperationState(taskId) {
		// This checks if the current snapon operation completed
		// or if we need to show progress.
		// Set counter
		activeSnapon.count = activeSnapon.count + 1;
		var url = '?dp=config_pages.snapons.check_snapon_operation_state';
		url += '&p=' + pageInfo.profileName;
		var isAvailableSelected = activeSnapon.isAvailableSelected;
		var snaponNameToBeChecked = isAvailableSelected ? activeSnapon.newAttachedSnaponName : activeSnapon.attachedSnaponName;
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		dat += '&v.fp.snapon_name_to_be_checked=' + snaponNameToBeChecked;
		dat += '&v.fp.is_attach_snapon=' + isAvailableSelected;
		dat += '&v.fp.task_id=' + taskId;
		util.serverPost(url, dat);
	}
	function checkSnaponOperationStateResponse(dat) {
		// alert('checkSnaponOperationStateResponse()');
		// util.showObject(dat);
		var errorMessage;
		if (dat.taskCompleted) {
			// Reset Snapons form
			// util.hideE('snapons:snapon_operation_info');
			// busyPanel.stop();
			progress.close();
			// alert('Task completed');
			completeSnaponOperation();
		}
		else if (activeSnapon.count < 10) {
			// Re-check task state and if task completed.
			// No delay is required here because it is done on the server side anyway
			checkSnaponOperationState(dat.taskId);
		}
		else if (dat.isActiveTask) {
			// Start progress display
			// util.hideE('snapons:snapon_operation_info');
			// busyPanel.stop();
			// alert('Start snapon progress for task_id: )' + dat.taskId);
			// Note, progressObj is used from simpleProgress, we only
			// need to set the taskId
			progressObj.progressType = 'snapon';
			progressObj.taskId = dat.taskId;
			progress.startProgress(progressObj);
		}
		else {
			// ToDo, revise error handling
			// util.hideE('snapons:snapon_operation_info');
			// busyPanel.stop();
			progress.close();
			errorMessage = (dat.errorMessage != '') ? dat.errorMessage : langvar('lang_admin.snapons.snapon_operation_failed');
			alert(errorMessage);
		}
	}
	function completeSnaponOperation() {
		var commentElement;
		// Update the attached snapons array and list
		// Deselect current selected
		deselectSnaponItem();
		if (activeSnapon.isAvailableSelected) {
			// Add item
			var o = {};
			o.attachedSnaponName = activeSnapon.newAttachedSnaponName;
			o.snaponName = activeSnapon.snaponName;
			o.label = activeSnapon.newAttachedSnaponLabel;
			attachedSnapons[attachedSnapons.length] = o;
		}
		else {
			// Remove item
			attachedSnapons.splice(activeSnapon.index, 1);
		}
		// Reset activeSnapon
		resetActiveSnaponObject();
		// Rebuild the attached list
		buildAttachedSnaponList();
		// Clear comment
		commentElement = util.getE('snapons:comment');
		commentElement.innerHTML = '';
		lockSnaponForm(false);
	}
	//
	// progress listener
	//
	function progressListener(senderState) {
		// This is called from progress
		// alert('progressListener() - senderState: ' + senderState);
		// ToDo, revise progressListener
		progress.close();
		if (activeSnapon.index > -1) {
			// A snapon operation initited on the current form completed
			completeSnaponOperation();
		}
		else {
			// A snapon operation was already active upon load,
			// so we need to get fresh snapon data.
			getSnaponData();
		}
	}
	//
	// Handle button state
	//
	function lockSnaponForm(makeLocked) {
		// This locks/unlocks list selection and sets the appropriate button state
		// Set global
		isLockedSnaponForm = makeLocked;
		if (makeLocked) {
			util.disableE('snapons:attach_snapon_btn');
			util.disableE('snapons:detach_snapon_btn');
		}
		else {
			setButtonState()
		}
	}
	function setButtonState() {
		util.enableE('snapons:attach_snapon_btn', activeSnapon.isAvailableSelected);
		util.enableE('snapons:detach_snapon_btn', activeSnapon.isAttachedSelected);
	}
	//
	//
	// List handling
	//
	//
	function snaponSelectActor(evt) {
		// Invoked upon snapon list click
		// alert('snaponSelectActor()');
		var commentElement;
		var	commentText;
		var	dat;
		var element;
		var elementId;
		var	isAvailableSelected;
		var	itemIndex;
		if (!isLockedSnaponForm) {
			var element = evt.target || evt.srcElement;
			if (element.nodeName == 'LI') {
				var elementId = element.id;
				if (elementId != activeSnapon.elementId) {
					// alert('elementId: ' + elementId);
					dat = elementId.split(':');
					itemIndex = parseInt(dat[2]);
					// Deselect any selected snapon item
					deselectSnaponItem();
					// Reset activeSnapon
					resetActiveSnaponObject();
					// Make current item selected
					isAvailableSelected = (elementId.indexOf('available_snapon:') != -1);
					activeSnapon.elementId = elementId;
					activeSnapon.index = itemIndex;
					activeSnapon.isAvailableSelected = isAvailableSelected;
					activeSnapon.isAttachedSelected = !isAvailableSelected;
					if (isAvailableSelected) {
						activeSnapon.snaponName = availableSnapons[itemIndex].snaponName;
						activeSnapon.attachedSnaponName = '';
						commentText = availableSnapons[itemIndex].comment;
					}
					else {
						activeSnapon.snaponName = attachedSnapons[itemIndex].snaponName;
						activeSnapon.attachedSnaponName = attachedSnapons[itemIndex].attachedSnaponName;
						// We need to lookup the comment in availableSnapons via the snaponName
						// alert('snaponName: ' + activeSnapon.snaponName);
						commentText = availableSnapons[util.h(activeSnapon.snaponName)].comment;
					}
					element.className = 'selected';
					// Handle comment
					commentElement = util.getE('snapons:comment');
					if (commentText == '') {
						commentText = '<span style="color:gray">' + langVar('lang_admin.snapons.no_comment') + '</span>';
					}
					commentElement.innerHTML = commentText;			
				}
				else {
					// Snapon is already selected, deselect it
					deselectSnaponItem();
					// Reset activeSnapon
					resetActiveSnaponObject();
				}
				// Update button state
				setButtonState();
			}
		}
	}
	function deselectSnaponItem() {
		if (activeSnapon.elementId != '') {
			var element = util.getE(activeSnapon.elementId);
			element.className = '';
			// Clear comment
			var commentElement = util.getE('snapons:comment');
			commentElement.innerHTML = '';
		}
	}
	//
	//
	// List builder handling
	//
	//
	function buildList(items, ulElementId, idPrefix) {
		var ul = util.getE(ulElementId);
		util.removeChildElements(ul);
		for (var i = 0, j = items.length; i < j; i++) {
			var item = items[i];
			var elementId = idPrefix + ':li:' + i;
			var li = util.createE('li', {id:elementId});
			var label = util.createT(item.label);
			util.chainE(ul, li, label);
		}
	}
	function buildAvailableSnaponList() {
		buildList(availableSnapons, 'snapons:available_snapons_list', 'available_snapon');
	}
	function buildAttachedSnaponList() {
		buildList(attachedSnapons, 'snapons:attached_snapons_list', 'attached_snapon');
	}
	//
	//
	// Utilities
	//
	//
	function resetActiveSnaponObject() {
		activeSnapon.elementId = '';
		activeSnapon.isAvailableSelected = false;
		activeSnapon.isAttachedSelected = false;
		activeSnapon.index = -1;
		activeSnapon.snaponName = '';
		activeSnapon.attachedSnaponName = '';
		activeSnapon.newAttachedSnaponName = '';
		newAttachedSnaponLabel = '',
		activeSnapon.count = 0;
	}
	/*
	function getNewSnaponLabel() {
		var label = availableSnapons[activeSnapon.index].label;
		var new_label = label;
		// Create lookup of existing labels
		var o = {};
		for (var i = 0; i < attachedSnapons.length; i++) {
			var s = '_' + attachedSnapons[i].label;
			o[s] = true;
		}
		var count = 2;
		while (o['_' + new_label]) {
			new_label = label + ' ' + count;
			count++;
		}
		// alert(new_label);
		return new_label;
	}
	*/
	//
	//
	// Return global properties and methods
	//
	//
	return {
		getSnaponData: getSnaponData,
		getSnaponDataResponse: getSnaponDataResponse,
		cancelDetachSnapon: cancelDetachSnapon,
		checkSnaponParametersResponse: checkSnaponParametersResponse,
		cancelViaParamtersPanel: cancelViaParamtersPanel,
		startSnaponOperation: startSnaponOperation,
		startSnaponOperationResponse: startSnaponOperationResponse,
		checkSnaponOperationStateResponse: checkSnaponOperationStateResponse,
		progressListener: progressListener
	}
}();
