//
// renameProfile.js
//


var renameProfile = {
	
	panel: null,
	validator: null,
	
	sourceProfileLabel: '',
	sourceProfileName: '',
	existingProfileLabels: [],
	existingProfileNames: [],	
	
	// database data of the source profile
	receivedDatabaseData: false,
	databaseServerType: '',
	databaseName: '',
	isRealTimeProcessing: false,
	initialBuildDone: false,
	
	// new profile data
	newProfileName: '',
	newProfileLabel: '',
	
	init: function() {
		
		var YE = YAHOO.util.Event;
		
		var panelObj = {
			panelId: 'rename_profile:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_admin.profiles.rename_profile_title'),
			// left: 100,
			// top: 50,
			zIndex: 20,
			isCover: true,
			closeEvent: renameProfile.close
		};
		
		renameProfile.panel = new util.Panel3(panelObj);
		renameProfile.validator = new util.Validator();
		
		YE.addListener('rename_profile:profile_label', 'keyup', renameProfile.setOkButtonState);
		YE.addListener('rename_profile:ok_btn', 'click', renameProfile.renameAndSaveProfile);
		YE.addListener('rename_profile:cancel_btn', 'click', renameProfile.close);
	},
	
	open: function(profileName) {
		
		if (!renameProfile.panel) {
			renameProfile.init();
		}
		
		var theProfile = profiles.GD.profilesDb[util.h(profileName)];
		
		var profileLabel = theProfile.label;
		var profileInfoText = langVar('lang_admin.profiles.rename_profile_info') + ':';
		profileInfoText = profileInfoText.replace(/__PARAM__1/, profileLabel);
		
		util.updateT('rename_profile:info_text', profileInfoText);
		
		util.setF('rename_profile:profile_label', profileLabel);
		
		// Disable OK button
		util.disableE('rename_profile:ok_btn');
		// util.disableE('rename_profile:cancel_btn');
		
		// Set/reset global data
		renameProfile.sourceProfileLabel = profileLabel;
		renameProfile.sourceProfileName = theProfile.name;
		renameProfile.receivedDatabaseData = false;
		
		// Reset existingProfileLabels and existingProfileNames
		renameProfile.existingProfileLabels = [];
		renameProfile.existingProfileNames = [];
		
		renameProfile.panel.prePositionAtCenter();
		renameProfile.panel.open();
		
		// Get fresh database data of the source profile
		renameProfile.getDatabaseData();
		
		// var inputElement = util.getE('rename_profile:profile_label');
		// inputElement.focus();
	},
	
	close: function() {
		
		renameProfile.validator.reset();
		renameProfile.panel.close();
	},
	
	getDatabaseData: function() {
		
		var profileName = renameProfile.sourceProfileName;
		
		var url = '?dp=admin_pages.profiles.rename_get_db_info_data';
		url += '&p=' + profileName;
		
		var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
		dat += 'v.fp.profile_name=' + profileName;
		
		util.serverPost(url, dat);
	},
	
	getDatabaseDataResponse: function(dat) {

		// util.showObject(dat);
		// Make sure that we got the data for the current profile
		if (dat.profileName == renameProfile.sourceProfileName) {
		
			if (dat.errorMessage == '') {
				
				renameProfile.receivedDatabaseData = true;
				
				// Set database variables for later use
				renameProfile.databaseServerType = dat.databaseServerType;
				renameProfile.databaseName = dat.databaseName;
				renameProfile.isRealTimeProcessing = dat.isRealTimeProcessing;
				renameProfile.databaseIsReadyForReporting = dat.databaseIsReadyForReporting;
				renameProfile.initialBuildDone = dat.initialBuildDone;
				
				// util.enableE('rename_profile:cancel_btn');
			}
			else {
				
				// Show error message and close window
				alert(dat.errorMessage);
				renameProfile.close();
			}
		}
	},

	setOkButtonState: function() {
		
		var newProfileLabel = util.getF('rename_profile:profile_label');
		var makeEnabled = (newProfileLabel != '' && (renameProfile.sourceProfileLabel != newProfileLabel));
		util.enableE('rename_profile:ok_btn', makeEnabled);
	},

	renameAndSaveProfile: function() {
		
		var validator = renameProfile.validator;
		
		var existingProfileLabels = renameProfile.existingProfileLabels;
		var existingProfileNames = renameProfile.existingProfileNames;
		
		var sourceProfileName = renameProfile.sourceProfileName;
		
		if (existingProfileLabels.length == 0) {
			
			// Get existingProfileLabels and existingProfileNames,
			// except for the current profile which becomes deleted upon rename.
			var profilesDb = profiles.GD.profilesDb;
			for (var i = 0; i < profilesDb.length; i++) {
				var profileItem = profilesDb[i];
				
				if (profileItem.name != sourceProfileName) {
				
					existingProfileLabels[i] = profileItem.label;
					existingProfileNames[i] = profileItem.name;
				}
			}
		}
		
		// util.showObject(existingProfileLabels);
		// util.showObject(existingProfileNames);
			
		var newProfileLabel = validator.isValue('rename_profile:profile_label');
		newProfileLabel = validator.isUnique('rename_profile:profile_label', existingProfileLabels);
		
		var newProfileName = util.labelToUniqueNodeName(newProfileLabel, existingProfileNames, 'profile');
		
		renameProfile.newProfileName = newProfileName;
		renameProfile.newProfileLabel = newProfileLabel;
				
		// alert('newProfileName: ' + newProfileName);
		
		if (validator.allValid()) {
			
			if (newProfileName == sourceProfileName) {
				
				// alert('newProfileName is equal sourceProfileName');
				
				// The profile node name does not change, only the case (i.e. profile1 > PROFILE1) changed,
				// this case doesn't require any database action because we only rename the label of the profile.
				// Proceed with renaming the profile on server side
				renameProfile.renameAndSaveProfileFinal('');
			}
			else {
			
				// If we received up to date database data
				
				if (renameProfile.receivedDatabaseData) {
					
					// Allow to rename the database if it is an external server
					// and if the database is not yet build, else we just show a
					// warning message that the database name has to be modified
					// manually.
					// we 
					// Note, we allow to rename Oracle if no database exists
					
					var databaseServerType = renameProfile.databaseServerType;
					
					if (databaseServerType == 'internal_sql') {
						
						// Proceed with renaming the profile on server side
						renameProfile.renameAndSaveProfileFinal('');
					}
					else {
						
						// External database server
						
						if (renameProfile.databaseIsReadyForReporting || renameProfile.initialBuildDone) {
							
							// We don't allow renaming of the external database server
							
							// Show an info that the external database server must be renamed manually
							var externalDbMsg = langVar('lang_admin.profiles.cannot_rename_external_database');
							externalDbMsg = externalDbMsg.replace(/__PARAM__1/, renameProfile.databaseName);
							
							if (confirm(externalDbMsg)) {
								// Proceed with renaming the profile on server side
								renameProfile.renameAndSaveProfileFinal('');
							}
						}
						else {
							
							// No database exists yet, show rename database window
							renameProfileDb.open(sourceProfileName, renameProfile.databaseName, newProfileName, newProfileLabel);
						}
					}
				}
				else {
					
					// No response from the server, try again and show an error message
					renameProfile.getDatabaseData();
					alert(langVar('lang_admin.profiles.rename_profile_connection_failed'));
				}
			}
		}
	},
	
	renameAndSaveProfileFinal: function(newDatabaseName) {
		
		// This function is also called from the rename database window!
		// newDatabaseName is an empty string unless it is a new database name for external db servers
		
		// alert('newDatabaseName: ' + newDatabaseName);
		
		renameProfile.close();
		util.hideE('profiles:profiles_list');
		util.showE('saving_info');
		
		var url = '?dp=admin_pages.profiles.rename_profile';
		// We need to set the source_profile_name as -p option so that
		// database_sql_query knows what profile to use.
		url += '&p=' + renameProfile.sourceProfileName;

var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		dat += '&v.fp.source_profile_name=' + renameProfile.sourceProfileName;
		dat += '&v.fp.new_profile_name=' + renameProfile.newProfileName;
		dat += '&v.fp.new_profile_label=' + encodeURIComponent(renameProfile.newProfileLabel);
		
		dat += '&v.fp.new_database_name=' + encodeURIComponent(newDatabaseName);
				
		util.serverPost(url, dat);
	},
	
	renameAndSaveProfileFinalResponse: function(dat) {
		
		// util.showObject(dat);
		
		var errorMessage = dat.errorMessage;
				
		// Update profilesDb and profiles display
		profiles.addNewProfilesDb(dat.profilesDb);
		profiles.updateProfilesDisplay();
			
		if (errorMessage != '') {
			alert(errorMessage);
		}		
	}
};
