//
// renameProfileDb.js
//


var renameProfileDb = {
	
	panel: null,
	validator: null,
	
	sourceProfileName: '',
	sourceProfileDatabaseName: '',
	newProfileName: '',
	
	init: function() {
		
		var YE = YAHOO.util.Event;
		
		var panelObj = {
			panelId: 'rename_profile_db:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_admin.profiles.rename_profile_database_title'),
			// left: 100,
			// top: 50,
			zIndex: 30,
			isCover: true,
			closeEvent: renameProfileDb.close
		};
		
		renameProfileDb.panel = new util.Panel3(panelObj);
		renameProfileDb.validator = new util.Validator();
		
		var dbNameButtons = ['rename_profile_db:use_profile_name_btn', 'rename_profile_db:keep_existing_name_btn', 'rename_profile_db:define_custom_name_btn'];
		
		YE.addListener(dbNameButtons, 'click', renameProfileDb.toggleDbNameSwitch);
		YE.addListener('rename_profile_db:ok_btn', 'click', renameProfileDb.rename);
		YE.addListener('rename_profile_db:cancel_btn', 'click', renameProfileDb.close);
	},
	
	open: function(sourceProfileName, sourceProfileDatabaseName, newProfileName, newProfileLabel) {
		
		if (!renameProfileDb.panel) {
			renameProfileDb.init();
		}
		
		renameProfileDb.sourceProfileName = sourceProfileName;
		renameProfileDb.sourceProfileDatabaseName = sourceProfileDatabaseName;
		renameProfileDb.newProfileName = newProfileName;
		
		// Set Db info
		var infoText = langVar('lang_admin.profiles.rename_profile_database_info');
		infoText = infoText.replace(/__PARAM__1/, '<strong>' + newProfileLabel + '</strong>');
		var containerElement = util.getE('rename_profile_db:rename_db_info');
		containerElement.innerHTML = infoText;
		
		// Set use profile name label
		var useProfileNameText = langVar('lang_admin.profiles.use_profile_name_for_db_name');
		useProfileNameText = useProfileNameText.replace(/__PARAM__1/, '<strong>' + newProfileName + '</strong>');
		var useProfileNameContainer = util.getE('rename_profile_db:use_profile_name_label');
		useProfileNameContainer.innerHTML = useProfileNameText;
		
		var keepExistingNameText = langVar('lang_admin.profiles.keep_existing_name_for_db_name');
		keepExistingNameText = keepExistingNameText.replace(/__PARAM__1/, '<strong>' + sourceProfileDatabaseName + '</strong>');
		var keepExistingNameContainer = util.getE('rename_profile_db:keep_existing_name_label');
		keepExistingNameContainer.innerHTML = keepExistingNameText;
		
		// Set default radio button and field values depending on source profile names
		
		if (sourceProfileName == sourceProfileDatabaseName) {
			util.setF('rename_profile_db:use_profile_name_btn', true);
		}
		else {
			util.setF('rename_profile_db:keep_existing_name_btn', true);
		}		
		
		util.setF('rename_profile_db:database_name', '');
		renameProfileDb.toggleDbNameSwitch();
		
		renameProfileDb.panel.prePositionAtCenter();
		renameProfileDb.panel.open();
	},
	
	close: function() {
		
		renameProfileDb.validator.reset();
		renameProfileDb.panel.close();
	},
	
	toggleDbNameSwitch: function() {
		
		var isCustomDatabaseName = util.getF('rename_profile_db:define_custom_name_btn');
		util.enableE('rename_profile_db:database_name', isCustomDatabaseName);
		
		// Reset validator if we switch to non-custom database name
		if (!isCustomDatabaseName) {
			renameProfileDb.validator.reset();
		}
	},
	
	getIsUniqueDatabaseName: function(newDatabaseName) {
		
		var sourceProfileName = renameProfileDb.sourceProfileName;
		var profilesDb = profiles.GD.profilesDb;
		var reservedDatabaseNames = [];
		var isUniqueDatabaseName = true;
		
		for (var i = 0; i < profilesDb.length; i++) {
			
			var profileItem = profilesDb[i];
			var profileName = profileItem.name;
			
			if (profileName != sourceProfileName) {
				
				if (profileName == newDatabaseName || profileItem.databaseName == newDatabaseName) {
					
					// util.showObject(profileItem);
					isUniqueDatabaseName = false;
					break;
				}
			}
		}
		
		return isUniqueDatabaseName;
	},

	rename: function() {
		
		var validator = renameProfileDb.validator;
		validator.reset();
		
		var newDatabaseName = '';
		var isValidated = false;
		
		// If we don't keep the existing name
		if (!util.getF('rename_profile_db:keep_existing_name_btn')) {
			
			var databaseName = '';
			
			if (util.getF('rename_profile_db:use_profile_name_btn')) {
				
				// We use the new profile node name as new database name
				
				databaseName = renameProfileDb.newProfileName;
				
				if (databaseName != renameProfileDb.sourceProfileDatabaseName) {
					
					// alert('databaseName: ' + databaseName);
					
					// We still need to check if the new profile node name isn't already used as database name
					if (renameProfileDb.getIsUniqueDatabaseName(databaseName)) {
						
						// The databaseName is valid, assign it to newDatabaseName
						isValidated = true;
						newDatabaseName = databaseName;
					}
					else {
						// Show alert
						alert(langVar('lang_admin.database.database_name_already_exists'));
					}
				}
				else {
					
					// Unlikely but possible, the new profile node name matches the existing database name
					isValidated = true;
				}
			}
			else {
				
				// Custom database name
				databaseName = validator.isValue('rename_profile_db:database_name');
				
				if (databaseName != '' && (databaseName == renameProfileDb.sourceProfileDatabaseName)) {
				
					// We keep the existing name, which has been defined manually
					isValidated = true;
				}
				else {
					
					if (databaseName != '') {
						
						// Check for unique database name. The database name should be different than any existing profile name
						// or database name, even if the same name is used in a different database server type.
						
						if (renameProfileDb.getIsUniqueDatabaseName(databaseName)) {
							
							// The databaseName is valid, assign it to newDatabaseName
							newDatabaseName = databaseName;
							isValidated = true;
						}
						else {
							
							// Throw custom error message
							validator.isCustom('rename_profile_db:database_name', langVar('lang_admin.database.database_name_already_exists'));
						}
					}
					
					if (validator.allValid()) {
						isValidated = true;					
					}
				}
			}
		}
		else {
			// Keep existing database name
			isValidated = true;
		}
		
		
		if (isValidated) {
		
			renameProfileDb.close();
			renameProfile.renameAndSaveProfileFinal(newDatabaseName);
		}
	}
};
