//
// userSettings
//


var userSettings = function() {
	
	// alert('userSettings()');
	
	var YE = YAHOO.util.Event;
	var validator = null;
	
	var GD = { // Global data are populated/set upon initial page load
		
		passwordValidationRules: {}, // contains password validation rules as in preferences.cfg, it is used by passwordUtil.js
		defaultDividerLabels: [],
		permissions: {},
		usernameItems: [],
		
		languageInPreferences: '',
	
		// We keep ori data to check for any changes
		username: '',
		emailAddress: '',
		language: '',
		numberThousandsDivider: '',
		numberDecimalDivider: ''
	};
	
	var changePasswordActivated = false;
	
	function init() {
		
		if (pageInfo.permissions.isEdit) {
		
			validator = new util.Validator();
			
			if (GD.permissions.password.edit || 
				GD.permissions.emailAddress.edit ||
				GD.permissions.languageOptions.edit) {
			
				var saveChangesBtn = new util.ToolbarButton('save_changes', userSettings.saveChanges, toolbarButtonsDb);
				saveChangesBtn.enable();
				
				if (GD.permissions.password.edit) {
			
					YE.addListener(['user_settings:change_password_btn', 'user_settings:cancel_change_password_btn'], 'click',  userSettings.toggleChangePassword);
				}
				
				if (GD.permissions.languageOptions.edit) {
					YE.addListener('user_settings:language', 'change',  userSettings.languageActor);
				}
			}
			
			// init OptionInfo
			optionInfo.init();
		}
		
		// Init help
		util.helpWindow.init('');
	}

	function getUserSettingsData() {
		
		if (!pageInfo.exitActive) {
		
			var url = '?dp=admin_pages.user_settings.get_user_settings_data';
			var dat = 'v.fp.page_token=' + pageInfo.pageToken;
			util.serverPost(url, dat);
		}
	}
	
	function getUserSettingsDataResponse(dat) {
	
		if (!pageInfo.exitActive) {
			
			// util.showObject(dat);
			
			// Set received dat in globbal D
			for (var prop in GD) {
				GD[prop] = dat[prop];
			}
			
			//util.showObject(GD);
			
			init();
			
			if (GD.permissions.password.view) {
			
				util.setF('user_settings:username', GD.username);
				util.showE('user_settings:username_section');
				
				if (GD.permissions.password.edit) {
					
					util.setF('user_settings:password', '');
					util.setF('user_settings:password_2', '');
				
					util.hideE('user_settings:password_section');
					util.showE('user_settings:change_password_section');
				}
			}
			
			if (GD.permissions.emailAddress.view) {
				
				util.setF('user_settings:email_address', GD.emailAddress);
				util.showE('user_settings:email_address_section');
				
				if (!GD.permissions.emailAddress.edit) {
					util.disableE('user_settings:email_address');
				}
			}
			
			
			if (GD.permissions.languageOptions.view) {
				
				// Create hash for languge in defaultDividerLabels
				util.createHash(GD.defaultDividerLabels, 'language');
				
				util.setF('user_settings:language', GD.language);
				util.setF('user_settings:number_thousands_divider', GD.numberThousandsDivider);
				util.setF('user_settings:number_decimal_divider', GD.numberDecimalDivider);
				
				if (!GD.permissions.languageOptions.edit) {
					util.disableE(
						['user_settings:language',
						'user_settings:number_thousands_divider',
						'user_settings:number_decimal_divider']
					);
				}
				
				util.showE('user_settings:language_options_section');
			}
			
			util.showE('user_settings:form');
			util.showE('form_section');
		}
	}
	
	function toggleChangePassword() {
		
		var makeActive = !changePasswordActivated;
		
		util.showE('user_settings:password_section', makeActive);
		util.showE('user_settings:change_password_section', !makeActive);
		
		if (!makeActive) {
			// Reset any form error
			util.hideE('user_settings:general_error_section');
			validator.reset();
		}
		
		changePasswordActivated = makeActive;
	}
	
	function languageActor() {
		
		// The language changed, update the select element label 
		// of number_thousands_divider and number_decimal_divider
		// so that the first list item shows the language specific
		// default dividers.
		function updateOptionText(elementId, label) {
			var element = util.getE(elementId);
			element.options[0].text = label;
		}
		
		var currentLanguage = util.getF('user_settings:language');
		if (currentLanguage == '') {
			// No user language defined, use default of preferences
			currentLanguage = GD.languageInPreferences;
		}
		// util.showObject(GD.defaultDividerLabels[util.h(language)]);
		var dividerItem = GD.defaultDividerLabels[util.h(currentLanguage)];
		updateOptionText('user_settings:number_thousands_divider', dividerItem.defaultThousandDividerLabel);
		updateOptionText('user_settings:number_decimal_divider', dividerItem.defaultDecimalDividerLabel);
	}
	
	function saveChanges() {
		
		validator.reset();
		
		var isNewUsername = false;
		var isNewEmailAddress = false;
		var isNewLanguage = false;
		var isModifiedDivider = false;
		var username = '';
		var password = '';
		var emailAddress = '';
		var language = '';
		var numberThousandsDivider = '';
		var numberDecimalDivider = '';
		
		// Get username, only root-admin is allowed to edit username
		if (pageInfo.isRootAdmin) {
			
			var isCaseSensitive = true;
			username = validator.isValue('user_settings:username');
			username = validator.isUnique('user_settings:username', GD.usernameItems, isCaseSensitive);
			isNewUsername = (username != GD.username);
		}
		
		// Validate emailAddress
		if (GD.permissions.emailAddress.edit) {
			
			emailAddress = util.getF('user_settings:email_address');
			
			if (emailAddress != '') {
				validator.isEmailAddress('user_settings:email_address');
			}
			
			isNewEmailAddress = (emailAddress != GD.emailAddress);
		}
		
		// Get language options
		if (GD.permissions.languageOptions.edit) {
			
			language = util.getF('user_settings:language');
			numberThousandsDivider = util.getF('user_settings:number_thousands_divider');
			numberDecimalDivider = util.getF('user_settings:number_decimal_divider');
			
			isNewLanguage = (language != GD.language);
			
			if (numberThousandsDivider != GD.numberThousandsDivider ||
				numberDecimalDivider != GD.numberDecimalDivider) {
			
				isModifiedDivider = true;
			}
		}
		
		// Validate password
		if (changePasswordActivated) {
			
			password = validator.isValue('user_settings:password');
			var password2 = validator.isValue('user_settings:password_2');
			var customErrorMessage = '';
			
			if (password != '') {
				
				if (pageInfo.isRootAdmin) {
					
					if (password != password2) {
						
						// Show custom error messsage
						var customErrorMessage = langVar('lang_stats.authentication.invalid_password2_message');
						validator.isCustom('user_settings:password_2', customErrorMessage);
					}
				}
				else {
					
					// Non-root-admin password validation according password validation rules

					// util.showObject(GD.passwordValidationRules);
					
					// Check password by passwordValidation
					var passwordCheck = passwordUtil.validatePassword(GD.passwordValidationRules, password);
					
					// util.showObject(myAccount.passwordValidationRules);
					// util.showObject(passwordCheck);
					
					if (!passwordCheck.isValid) {
					
						customErrorMessage = passwordCheck.errorMessage;
						validator.isCustom('user_settings:password', customErrorMessage);
					}
					else if (password != password2) {
						
						// alert(newPassword + '\n' + newPassword2);
						customErrorMessage = langVar('lang_stats.authentication.invalid_password2_message');
						validator.isCustom('user_settings:password_2', customErrorMessage);
					}
				}
			}
		}
		
		if (isNewUsername || 
			changePasswordActivated ||
			isNewEmailAddress ||
			isNewLanguage ||
			isModifiedDivider) {
			
			if (validator.allValid()) {
				
				var msg = langVar('lang_stats.user_settings.auto_logout_info');
				
				if ((!isNewUsername && !changePasswordActivated) || 
						confirm(msg)) {

					util.hideE('form_section');
					util.showE('saving_info');
					
					var url = '?dp=admin_pages.user_settings.save_user_settings';
					var dat = 'v.fp.page_token=' + pageInfo.pageToken;
					dat += '&v.fp.is_new_username=' + isNewUsername;
					dat += '&v.fp.is_new_password=' + changePasswordActivated;
					dat += '&v.fp.is_new_email_address=' + isNewEmailAddress;
					dat += '&v.fp.is_new_language=' + isNewLanguage; 
					dat += '&v.fp.is_modified_divider=' + isModifiedDivider;
					dat += '&v.fp.username=' + encodeURIComponent(username);
					dat += '&v.fp.password=' + encodeURIComponent(password);
					dat += '&v.fp.email_address=' + encodeURIComponent(emailAddress);
					dat += '&v.fp.language=' + language;
					dat += '&v.fp.number_thousands_divider=' + encodeURIComponent(numberThousandsDivider);
					dat += '&v.fp.number_decimal_divider=' + encodeURIComponent(numberDecimalDivider);
					
					util.serverPost(url, dat);
				}
			}
		}
		else {
			alert(langVar('lang_stats.general.no_changes_to_save'));
		}
	}
	
	function saveChangesResponse(dat) {
		
		if (dat.errorMessage == '') {
			
			if (dat.isNewUsername || dat.isNewPassword) {
				
				// Re-login required!
				// location.href = '?dp=logout'; --> Does not succed to call logout, due authentication state not authenticated!
				location.href = '?dp=login';
			}
			else if (dat.isNewLanguage) {
				
				// The language changed, reload required
				location.reload(true);
			}
			else {
				
				// Some other data changed, keep current page,
				// though we need to update the GD variables
				
				if (dat.isNewEmailAddress) {
					GD.emailAddress = util.getF('user_settings:email_address');
				}
				
				if (dat.isModifiedDivider) {
					GD.numberThousandsDivider = util.getF('user_settings:number_thousands_divider');
					GD.numberDecimalDivider = util.getF('user_settings:number_decimal_divider');
				}
				
				util.hideE('saving_info');
				util.showE('form_section');
			}
		}
		else {
			
			// Password error
			alert(dat.errorMessage);
			util.updateT('user_settings:general_error', dat.errorMessage);
			util.showE('user_settings:general_error_section');
		
			util.hideE('saving_info');
			util.showE('form_section');
		}
	}
	
	//
	//
	// Return global properties and methods
	//
	//
	
	return {
		toggleChangePassword: toggleChangePassword,
		languageActor: languageActor,
		getUserSettingsData: getUserSettingsData,
		getUserSettingsDataResponse: getUserSettingsDataResponse,
		saveChanges: saveChanges,
		saveChangesResponse: saveChangesResponse
	}
	
}();
