//
//
// usersAM.js (handles the users Access Manager Panel
//
//

var usersAM = {
	
	panel: null,
	tabs: null,
	isNewAccessPair: false,
	activeAccessItemIndex: 0, // The index of the active access pair in users.activeAccess.
						// The index is only relevant when isNewAccessPair is false.
	activeCreatedByUser: '',
	
	init: function() {
		
		var YE = YAHOO.util.Event;
		
		//
		// Init the panel
		//
		
		var panelObj = {
			panelId: 'users:am:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: '-',
			left: 300,
			top: 160,
			zIndex: 20,
			isCover: true,
			isSticky: true,
			closeEvent: usersAM.close
		};
		
		usersAM.panel = new util.Panel3(panelObj);
		
		//
		// Init the tabs
		//
	
		usersAM.tabs = new util.Tabs2(['users:am:profiles:tab', 'users:am:roles:tab'], usersAM.tabActivated);
		
		//
		//
		// Init form controls
		//
		//
		
		var isRootAdmin = pageInfo.isRootAdmin;
		var isUnlimitedGrants = users.isUnlimitedGrants;
		var isLimitedGrants = (!isRootAdmin && !isUnlimitedGrants);
		
		//
		//
		// Handle roles list first so that we can populate a profilesLookup if isLimitedGrants
		//
		//
		
		var rolesDb = users.rolesDb;
		var profilesDb = users.profilesDb;
		
		var rolesList = [];
		var profilesList = [];
		var profilesLookup = {};
		var isAllProfilesPermission = false;
		
		if (!isLimitedGrants) {
			
			rolesList = rolesDb;
			isAllProfilesPermission = true;
		}
		else {
			
			for (var i = 0; i < rolesDb.length; i++) {
				
				var roleItem = rolesDb[i];
				
				if (roleItem.isPermission) {
					
					rolesList[rolesList.length] = {name:roleItem.name, label:roleItem.label};
					
					if (roleItem.isAllProfiles) {
						
						isAllProfilesPermission = true;
					}
					else {
						
						// Remember any profile listed in profiles in profilesLookup
						for (var j = 0; j < roleItem.profiles.length; j++) {
							profilesLookup['_' + roleItem.profiles[j]] = true;
						}
					}
				}
			}
		}
		
		//
		//
		// Create profiles list
		//
		//
		
		if (isAllProfilesPermission) {
			profilesList[0] = {name: '__ALL__PROFILES__', label: langVar('lang_admin.users.all_profiles_accesses')};
		}
		
		for (var i = 0; i < profilesDb.length; i++) {
			
			var profileItem = profilesDb[i];
			var profileName = profileItem.name;
			
			if (isAllProfilesPermission || (profilesLookup['_' + profileName] != null)) {
				
				// We add a space to profile labels so that there is some offset from the All Profiles label
				var profileLabel = isAllProfilesPermission ? ' ' + profileItem.label : profileItem.label;
				profilesList[profilesList.length] = {name: profileName, label: profileLabel}; 
			}
		}
		
		util.populateSelect('users:am:profiles:select', profilesList, 'name', 'label');
		util.populateSelect('users:am:roles:select', rolesList, 'name', 'label');
		
		YE.addListener('users:am:okay', 'click', usersAM.saveAccessPair);
		YE.addListener('users:am:cancel', 'click', usersAM.close);
	},
	
	
	open: function(itemIndex, accessItem, activeTabIsRoles, isNewAccessPair) {
		
		// isNewAccessPair is true when Access Manager is opened via the New Access Pair button
		
		usersAM.isNewAccessPair = isNewAccessPair;
		
		// reset the form
		util.resetF('users_am_form');
		
		//
		//
		// Set form values according accessItem
		//
		//
		
		usersAM.activeAccessItemIndex = itemIndex;
		usersAM.isNewAccessPair = isNewAccessPair;
		usersAM.activeCreatedByUser = accessItem.created_by_user;
		
		var isAllProfiles = accessItem.all_profiles;
		var profiles = accessItem.profiles;
		var roles = accessItem.roles;
		var i;
		// var selectOptions;
		
		if (!isAllProfiles) { 
		
			// var profilesSelect = util.getE('users:am:profiles:select');
			for (i = 0; i < profiles.length; i++) {
				util.setF('users:am:profiles:select', profiles[i]);
			}
		}
		else {
			// Check the All profiles radio button
			// util.setF('users:am:all_profiles_btn', true);
			
			// Select All Profiles entry
			var profilesSelect = util.getE('users:am:profiles:select');
			// alert('profilesSelect: ' + profilesSelect);
			profilesSelect.selectedIndex = 0;
			// profilesSelect.options[0].selected = true;
		}
		
		for (i = 0; i < roles.length; i++) {
			util.setF('users:am:roles:select', roles[i]);
		}
		
		// Preset tabs
		var tabId = activeTabIsRoles ? 'users:am:roles:tab' : 'users:am:profiles:tab';
		usersAM.tabs.setActiveTab(tabId);
		usersAM.setDisplay(activeTabIsRoles);
		
		// Open panel
		var panelLabel = !isNewAccessPair ? langVar('lang_admin.users.edit_access_pair') : langVar('lang_admin.users.new_access_pair');
		usersAM.panel.open({label: panelLabel});
	},
	
	addNewAccessPair: function() {
		
		var itemIndex = 0; // is not relevant when adding a new item
		var isNewAccessPair = true;
		var activeTabIsRoles = false;
		var newAccessItem = {
			all_profiles: false,
			profiles: [],
			roles: []
			// created_by_user: users.activeUserNodeName
		};
		
		usersAM.open(itemIndex, newAccessItem, activeTabIsRoles, isNewAccessPair);
	},
	
	setDisplay: function(activeTabIsRoles) {
		
		if (activeTabIsRoles) {
			util.hideE('users:am:profiles:section');
			util.showE('users:am:roles_section');
		}
		else {
			util.hideE('users:am:roles_section');
			util.showE('users:am:profiles:section');
		}
	},
	
	tabActivated: function() {
		
		var tabId = this.id;
		var activeTabIsRoles = (tabId == 'users:am:roles:tab');
		usersAM.tabs.setActiveTab(tabId);
		usersAM.setDisplay(activeTabIsRoles);
	},
	
	getIsValidAccessPair: function(profiles, roles) {
		
		// Only used if there are no unlimited grants. It is
		// only relevant if there are different profiles with different role permissions,
		// i.e. different profile manager roles are assigned to different profiles.
		
		var allValid = true;
		var isValidRoleProfileRelation;
		var rolesDb = users.rolesDb;
		var profilesDb = users.profilesDb;
		var info = '';
		
		for (var i = 0; i < roles.length; i++) {
	
			var roleName = roles[i];
			var theRoleInDb = rolesDb[util.h(roleName)];
			var isAllProfiles = theRoleInDb.isAllProfiles;
			
			for (var j = 0; j < profiles.length; j++) {
				
				var profileName = profiles[j];
				
				isValidRoleProfileRelation = false;
				
				if (isAllProfiles) {
					isValidRoleProfileRelation = true;
				}
				else {
					// Check if the profile exists in theRoleInDb.profiles
					
					for (var k = 0; k < theRoleInDb.profiles.length; k++) {
						
						if (theRoleInDb.profiles[k] == profileName) {
							isValidRoleProfileRelation = true;
							break;
						}
					}
				}
				
				// We add any invalid profile/role relations to info
				// and show them in an alert.
				
				if (!isValidRoleProfileRelation) {
					
					allValid = false;
			
					var roleLabel = theRoleInDb.label;
					var profileLabel = profilesDb[util.h(profileName)].label;
				
					info += profileLabel + ' - ' + roleLabel + '\n';
				}
			}
		}
		
		if (!allValid) {

			alert(langVar('lang_admin.users.profiles_roles_assignment_conflict_msg') + '\n' + info);
		}
		
		return allValid;
	},
	
	saveAccessPair: function() {
		
		
		var profilesSelect = util.getE('users:am:profiles:select');
		
		var profilesOptions = profilesSelect.options;
		
		var isAllProfiles = ((profilesOptions[0].value == '__ALL__PROFILES__') && profilesOptions[0].selected);
		var profiles = [];
		var roles = [];
		var i;
		
		// alert('isAllProfiles: ' + isAllProfiles);
		
		if (!isAllProfiles) {

			for (i = 0; i < profilesOptions.length; i++) {
				if (profilesOptions[i].selected) {
					profiles[profiles.length] = profilesOptions[i].value;
				}
			}
		}
		
		var rolesSelect = util.getE('users:am:roles:select');
		var options = rolesSelect.options;
		for (i = 0; i < options.length; i++) {
			if (options[i].selected) {
				roles[roles.length] = options[i].value;
			}
		}
		
		var isValidAccessPair = (pageInfo.isRootAdmin || users.isUnlimitedGrants) ? true : usersAM.getIsValidAccessPair(profiles, roles);
		
		if (isValidAccessPair) {
		
			var accessItem;
			var accessItemIndex = 0;
			var activeAccess = users.activeAccess;
			
			var numberOfAccessItems = activeAccess.length;
			
			if (!usersAM.isNewAccessPair) {
				
				// Update the existing access object
				accessItemIndex = usersAM.activeAccessItemIndex;
				
				accessItem = activeAccess[accessItemIndex];
				accessItem.all_profiles = isAllProfiles;
				accessItem.profiles = profiles;
				accessItem.roles = roles;
				
				// Update the single row in access list
				usersUtil.updateAccessRow(accessItemIndex, accessItem, numberOfAccessItems);
			}
			else {
				
				// Add a new access item object
				
				numberOfAccessItems += 1;
				
				var accessItem = {
					all_profiles: isAllProfiles,
					profiles: profiles,
					roles: roles,
					created_by_user: users.activeUserNodeName
				};
				
				// Add new item to users.activeAccess
				accessItemIndex = activeAccess.length;
				activeAccess[accessItemIndex] = accessItem;
				
				// util.showObject(activeAccess);
				
				// Create a new row
				var tbody = util.getE('users:access:tbody');
				usersUtil.createAccessRow(tbody, accessItemIndex);
				
				
				// If the list already shows a delete button (final numberOfAccessItems > 2)
				// then we only need to update the last row, else we update all rows.
				
				if (numberOfAccessItems > 2) {
					// Update single row
					usersUtil.updateAccessRow(accessItemIndex, accessItem, numberOfAccessItems);
				}
				else {
					// Update all rows so that we get the delete button in every row
					for (i = 0; i < numberOfAccessItems; i++) {
						usersUtil.updateAccessRow(i, activeAccess[i], numberOfAccessItems);
					}
				}
			}
			
			// Close the panel
			usersAM.close();
		}
	},

	close: function() {
		
		usersAM.panel.close();
	}
}
