//
//
// licensing.js
//
//

var licensing = {
	
	validator: null,
	
	init: function() {
		
		licensing.validator = new util.Validator();
		
		util.setF('authentication:license_key', '');
		util.enableE(['authentication:license_key', 'authentication:submit_license']);
		
		YAHOO.util.Event.addListener('authentication:submit_license', 'click', licensing.submitLicense);
	},
	
	submitLicense: function() {
				
		var validator = licensing.validator;
		var licenseKey = validator.isValue('authentication:license_key');
		
		if (validator.allValid()) {
			
			util.disableE(['authentication:license_key', 'authentication:submit_license']);
			
			var url = '?dp=authentication';
			var dat = 'v.fp.license_key=' + encodeURIComponent(licenseKey);
			
			util.serverPost(url, dat);
		}
	},
	
	submitLicenseResponse: function(dat) {
		
		if (dat.isValid) {
			// alert('submitLicenseResponse() - VALID');
			location.reload(true);
		}
		else {
			alert(dat.errorMessage);
			util.enableE(['authentication:license_key', 'authentication:submit_license']);
		}
	}
};

