//
// mapDrive.js
//

var mapDrive = {
	
	panel: null,
	validator: null,
	
	defaultPathname: '',
	
	init: function() {
		
		var YE = YAHOO.util.Event;
		
		var panelObj = {
			panelId:"map_drive:panel",
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_admin.file_manager.map_drive_label'),
			right: 40,
			top: 40,
			width: 600,
			zIndex: 20,
			isCover: true,
			closeEvent: mapDrive.close
		};
				
		mapDrive.panel = new util.Panel3(panelObj);
		mapDrive.validator = new util.Validator();
		
		YE.addListener(['map_drive:drive_btn', 'map_drive:connect_to_password_protected_btn'], 'click', mapDrive.toggleNetworkShare);

		YE.addListener('map_drive:ok_btn', 'click', mapDrive.apply);
		YE.addListener('map_drive:cancel_btn', 'click', mapDrive.close);
	},
	
	
	open: function() {
		
		if (!mapDrive.panel) {
			mapDrive.init();
		}
		
		mapDrive.hideFileManagerOverflow(true);
		mapDrive.panel.open();
	},
	
	close: function() {
		
		mapDrive.validator.reset();
		mapDrive.hideFileManagerOverflow(false);
		mapDrive.panel.close();
	},
	
	
	toggleNetworkShare: function() {
		
		var isDrive = (this.id == 'map_drive:drive_btn');
		mapDrive.validator.reset();
		util.showE(['map_drive:drive_sample:tr', 'map_drive:drive:tr'], isDrive);
		util.showEV(['map_drive:username_otional_label', 'map_drive:password_otional_label'], isDrive);
	},
	
	
	apply: function() {
		
		var validator = mapDrive.validator;
		
		validator.reset();
		
		var isDrive = util.getF('map_drive:drive_btn');
		
		
		var obj = {};
		obj.is_drive = isDrive;
		obj.drive = isDrive ? validator.isValue('map_drive:drive') : '';
		obj.share = validator.isValue('map_drive:share');
		obj.username = isDrive ? util.getF('map_drive:username') : validator.isValue('map_drive:username');
		obj.password = isDrive ? util.getF('map_drive:password') : validator.isValue('map_drive:password');
		
		if (validator.allValid()) {
			
			//
			// Set un-escaped default pathname for response
			//
			
			mapDrive.defaultPathname = isDrive ? obj.drive : obj.share;
			
			//
			// Send form data
			//
			
			var url = '?dp=file_manager.map_drive';
			var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
			
			var pattern = /\\/g;
			
			for (var prop in obj) {
				
				var datValue = obj[prop];
				
				if (pattern.test(datValue)) {
					datValue = datValue.replace(/\\/g, '__HexEsc__5C');
				}
				
				dat += 'v.fp.' + prop + '=' + encodeURIComponent(datValue) + '&';
			}
			
			dat = dat.replace(/&$/, '');
			
			util.serverPost(url, dat);
		}
	},
	
	applyResponse: function() {
		
		// alert('applyResponse()');
		mapDrive.close();
		
		var isMapDriveCallee = true;
		fileManager.getDefinedDirectory(mapDrive.defaultPathname, isMapDriveCallee);
	},
	
	hideFileManagerOverflow: function(isHide) {
		
		// Fixes Firefox overflow problem (no focus cursor in forms above div's if overflow is scroll or auto).
		var div1 = util.getE('directory_tree:container');
		var div2 = util.getE('directory_files_list:container');
		var overflowValue = isHide ? 'hidden' : 'scroll';
		div1.style.overflow = overflowValue;
		div2.style.overflow = overflowValue;
	}
};

