//
//
//
// newProfileWizardUtil.js
//
//
//


var newProfileWizardUtil = function() {
	
	var YE = YAHOO.util.Event;
	var YD = YAHOO.util.Dom;
	
	var GD = {
		haveMYSQL: true,
		haveODBC: true,
		isActiveInfoBox: false,
		activePageName: '',
		activeInfoBoxHeight: 0
	};

	function init(haveMYSQL, haveODBC) {

		GD.haveMYSQL = haveMYSQL;
		GD.haveODBC = haveODBC;
	}
	
	function updateMoreInfoSystem(activePageName) {
		
		// This shows/hides the More Info button depending on
		// the active wizard page and it resets any active
		// info section.
		
		// alert('updateMoreInfoSystem() - activePageName: ' + activePageName);
		
		GD.activePageName = activePageName;
		
		// Remove active info section
		if (GD.isActiveInfoBox) {
			removeInfoSection();
		}
		
		// Check if we show the More Info button
		var isMoreInfoBtn = (activePageName == 'log_source_page' ||
			(activePageName == 'db_server_page' && (GD.haveMYSQL || GD.haveODBC)) ||
			activePageName == 'db_performance_page' ||
			activePageName == 'log_format_options_page');
		
		util.showE('show_more_info_btn', isMoreInfoBtn);
	}

	function toggleInfoSection() {
		
		if (!GD.isActiveInfoBox) {
			
			// var element = evt.target || evt.srcElement;
			// var elementId = element.id;
			// element.style.display = 'none';
			
			// alert('elementId: ' + this.id);
			// this.style.display = 'none';
		
			showInfoSection();
		}
		else {
			removeInfoSection();
		}
		
		// Remove button focus
		this.blur();
	}
	
	function showInfoSection() {
		
		// alert('setInfoSection() - showElement: ' + showElement);
		
		// Hide the info button
		// this.style.display = 'none';
		// infoButtonId = this.id;
		
		var infoSectionElementId = '';
		
		switch (GD.activePageName) {
			
			case 'log_source_page':
				infoSectionElementId = 'log_source_info_box';
				break;
			
			case 'db_server_page' :
				infoSectionElementId = 'db_server_info_box';
				break;
				
			case 'db_performance_page' :
				infoSectionElementId = 'db_performance_info_box';
				break;
				
			case 'log_format_options_page' :
				infoSectionElementId = 'numerical_fields_info_box';
				break;
		}
		
		// Clone the original element because
		// because we set a fixed height.
		
		var oriInfoBox = util.getE(infoSectionElementId);
		var infoBox = util.getE('cloned_info_box');
		var infoBoxParent;
		
		// Clean up any previous info box
		if (infoBox != null) {
			infoBoxParent = infoBox.parentNode;
			infoBoxParent.removeChild(infoBox);
		}
		
		// Get a clone of oriInfoBox and give it a new ID
		infoBox = oriInfoBox.cloneNode(true);
		infoBox.id = 'cloned_info_box';
		
		// Add "Read less" button at bottom of the cloned infoBox
		// var readLessDiv = getReadLessDiv();
		// infoBox.appendChild(readLessDiv);
		
		
		// Get parent element of oriInfoBox,
		// this is where we insert the cloned infoBox
		infoBoxParent = oriInfoBox.parentNode;
		
		// Insert the div
		infoBoxParent.insertBefore(infoBox, oriInfoBox);
		
		// Get actual height of info box
		infoBox.style.position = 'absolute';
		infoBox.style.top = 0;
		// Set left position to right + left padding of the wizard-body
		// plus the width of a possible scrollbar (~16px) so that we get 
		// the final displayed width!
		infoBox.style.left = '64px'; // 2*24 + 16
		infoBox.style.visibility = 'hidden';
		infoBox.style.display = 'block';
		
		var region = YD.getRegion(infoBox);
		var infoBoxHeight = region.height;
		
		// util.showObject(region);
		
		// Prepare infoBox for animation
		infoBox.style.position = 'static';
		infoBox.style.height = '0';
		infoBox.style.visibility = 'visible';
		
		// Animate the info box
		
		var attributes = {
			// width: { from: 0, to: 700 },
			height: { from: 0, to: infoBoxHeight }
		};
		
		var infoAnim = new YAHOO.util.Anim(infoBox, attributes);
		infoAnim.duration = 0.3;
		// infoAnim.method = YAHOO.util.Easing.easeOutStrong;
		infoAnim.animate();
		
		util.updateT('show_more_info_btn', langVar('lang_stats.btn.less_info'));
		
		// Set global data
		GD.isActiveInfoBox = true;
		GD.activeInfoBoxHeight = infoBoxHeight;
	}
	
	function removeInfoSection() {
		
		// Remove read less event listener
		// YE.removeListener('read_less_btn', 'click', removeInfoSection);
		
		// Removes the cloned info box element.
		// Note, we delete 'cloned_info_box' before
		// displaying another one. Otherewise animation
		// doesn't work.
		var infoBox = util.getE('cloned_info_box');
		
		// Animate the info box
		
		var height = GD.infoBoxHeight;
			
		var attributes = {
			height: { from: GD.infoBoxHeight, to: 0 }
		};
		
		var infoAnim = new YAHOO.util.Anim(infoBox, attributes);
		infoAnim.duration = 0.2;
		// infoAnim.method = YAHOO.util.Easing.easeOutStrong;
		infoAnim.animate();
		
		// Update button text
		util.updateT('show_more_info_btn', langVar('lang_stats.btn.more_info'));
		
		// Show read more button
		// var readMoreBtn = util.getE(GD.activeInfoButtonId);
		// readMoreBtn.style.display = 'inline';
		
		GD.isActiveInfoBox = false;
		// GD.activeInfoButtonId = '';
		GD.activeInfoBoxheight = 0;
	}

	//
	// Return global properties and methods
	//
	
	return {
		init: init,
		updateMoreInfoSystem: updateMoreInfoSystem,
		toggleInfoSection: toggleInfoSection
	}
}();
