//
//
// columnsInfo.js
// 
//

var columnsInfo = {
	
	// columnsInfo generates a columnsInfo display for all columns
	// for which a columnInfo exists, independent of the actual report element
	// from where the columnInfo panel has been opened.
	
	panel: null,
	baseId: '',
	// active state
	isOpen: false,
	columnNames: [],
	
	init: function() {
		
		columnsInfo.baseId = util.getUniqueElementId();
	
		var panelObj = {
			panelId:"columns_info:panel",
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_stats.btn.columns_info'),
			left: 70,
			top: 80,
			zIndex: 40,
			isCover: false,
			closeEvent: columnsInfo.close
		};
		
		columnsInfo.panel = new util.Panel3(panelObj);
		
		//
		// Get the columnNames for which a columnInfo exists and create the menu
		//
		
		var columnNames = columnsInfo.columnNames;
		var queryFieldsDb = reportInfo.queryFieldsDb;
		var menuItemsContainer = util.getE('columns_info:menu');
		
		for (var i = 0; i < queryFieldsDb.length; i++) {
			var queryFieldItem = queryFieldsDb[i];
			
			if (queryFieldItem.columnInfo != '') {
				
				var name = queryFieldItem.name;
				var label = queryFieldItem.label;
				var index = columnNames.length;
				columnNames[index] = name;
				columnsInfo.createMenuItem(menuItemsContainer, index, label);
			}
		}
		
		// Select first columnn
		columnsInfo.showColumnInfo(columnNames[0]);
		
		var YE = YAHOO.util.Event;
		YE.addListener('columns_info:menu', 'click', columnsInfo.menuItemActor);
		YE.addListener('columns_info:close_btn', 'click', columnsInfo.close);
	},
	
	open: function() {
		
		// alert('shortReportElementId: ' + shortReportElementId);
		
		if (!columnsInfo.panel) {
			columnsInfo.init();
		}
		
		if (!columnsInfo.isOpen) {
			columnsInfo.panel.open();
		}
	},
	
	close: function() {
		
		columnsInfo.isOpen = false;
		columnsInfo.panel.close();
	},
	
	menuItemActor: function(evt) {
		
		// Clicked on menu item
		var element = evt.target || evt.srcElement;
		var elementId = element.id;
		
		// alert('menuItemActor: ' + elementId);
		
		if (elementId.indexOf(columnsInfo.baseId + ':') != -1) {
			var dat = elementId.split(':');
			var index = parseInt(dat[1], 10);
			var columnName = columnsInfo.columnNames[index];
			columnsInfo.showColumnInfo(columnName);
		}
	},
	
	showColumnInfo: function(columnName) {
		
		// alert('showColumnInfo: ' + columnName);
		var queryFieldItem = reportInfo.queryFieldsDb[util.h(columnName)];
		var label = queryFieldItem.label;
		var columnInfo = queryFieldItem.columnInfo;
		var container = util.getE('columns_info:text');
		container.innerHTML = '<strong>' + label + '</strong><br />' + columnInfo;
	},
	
	createMenuItem: function(container, index, label) {
		
		var elementId = columnsInfo.baseId + ':' + index;
		var a = util.createE('a', {id:elementId, href:'javascript:;'});
		var text = util.createT(label);
		
		util.chainE(container, a, text);
	}
}
