//
// report.js
//


// reserved variables which are declared in html page!
// var reportInfo = {};
// var lang = {};

var report = {
	
	// toggleReportsMenuBtn: null,
	datePickerBtn: null,
	globalFilterBtn: null,
	macrosBtn: null,
	// emailReportBtn: null,
	printerFriendlyBtn: null,
	// databaseInfoBtn: null,
	toolsBtn: null,
	
	isTableOrLogDetailReportElement: true,
	
	busyPanel: null,
	
	init: function() {
		
		// util.showObject(reportInfo);
		// console.log('report.init()');
		
		var YE = YAHOO.util.Event;
		
		// Init admin drop down menu
		util.initAdminDropDownMenu();
		util.initBreadCrumbNav();
		
		var reportElements = reportInfo.reportElements;
		
		// create a hash to access the report elements by sid (short_report_element_id)
		util.createHash(reportElements, 'sid');
		
		// create reportFields hash
		util.createHash(reportInfo.queryFieldsDb, 'name');
		
		
		//
		//
		// init report elements
		//
		//
		
		for (var i = 0; i < reportElements.length; i++) {
			
			var o = reportElements[i];
			var reportElementId = o.id;
			var shortReportElementId = o.sid;
			var reportElementType = o.reportElementType;
			
			//
			//
			// init rows
			//
			//
			
			if (reportElementType == 'table' || reportElementType == 'log_detail') {
				
				report.isTableOrLogDetailReportElement = true;
				
				if (o.totalRows > 0) {
				
				 	if (o.totalRows > 10) {
				 		
						report.rowNumbers.build(shortReportElementId, reportElementType, o.startingRow, o.endingRow, o.numberOfRows, o.totalRows);
					}
					
					//
					// init row selection
					//
					
					
					// Assign a single tbody event for row selection, zoom selection and breakdown
					var tBodyId = shortReportElementId + ':tbody';
					YE.addListener(tBodyId, 'click', report.rowSelection.rowActivated);
					
					
					//
					// init any breakdown links
					//
					
					/*
					
					KHP 05/Aug/2008
					DISABLED because we also handle breakdown via rowSelection.rowActivated()
					
					var tableElement = util.getE(shortReportElementId + ':table');
					var aElements = tableElement.getElementsByTagName('a');
					for (var j = 0; j < aElements.length; j++) {
						var breakDownAnchor = aElements[j];
						// We don't wont to add any listener to page links,
						// so we only add the listener where href="javascript:;"
						if (breakDownAnchor.href == 'javascript:;') {
							YE.addListener(breakDownAnchor, 'click', newReport.setBreakdown);
						}
					}
					*/
				}
			}
			else if (reportElementType == 'session_paths') {
				
				// Build the session_paths tree
				sessionPaths.init(shortReportElementId);
				
				YE.addListener(shortReportElementId + ':session_paths_tree', 'click', sessionPaths.itemActivated);
				YE.addListener(shortReportElementId + ':session_paths_tree:reset', 'click', sessionPaths.reset);

				// 2008-11-29 - GMF - Add mouseover highlighting to the Reset/Collapse All link.
				YE.addListener(shortReportElementId + ':session_paths_tree:reset', 'mouseover', sessionPaths.highlightTextOn);
                YE.addListener(shortReportElementId + ':session_paths_tree:reset', 'mouseout', sessionPaths.highlightTextOff);
			}
			else if (reportElementType == 'session_page_paths') {
				
				if (o.totalRows > 10) {
					report.rowNumbers.build(shortReportElementId, reportElementType, 1, o.endingRow, o.endingRow, o.totalRows);
				}
				
				YE.addListener(shortReportElementId + ':page_path_field', 'keypress', newReport.setPagePathViaKey);
				YE.addListener(shortReportElementId + ':show_path_btn', 'click', newReport.setPagePathViaButton);
				YE.addListener(shortReportElementId + ':lookup_pages_btn', 'click', sessionPagePathsLookup.openLookup);
				YE.addListener(shortReportElementId + ':tbody', 'click', newReport.setPagePathViaLink);
			}
			
			//
			// set reportInfo.isReportElementFilters
			//
			
			if (o.isReportElementFilter) {
				reportInfo.isReportElementFilters = true;
			}
		}
		
		
		//
		// init report element columns
		//
		
		report.columns.init();
		
		
		//
		// init Calendar
		//
		if (reportInfo.isCalendar) {
			calendarControl.init();
		}
			
		
		// Set newReport properties
		newReport.init();
		
		
		//
		// Misc. events
		//
		
		// The document contains the report.
		// Handle menu state and update zoom events, etc.
			
		YE.addListener('add_build_in_report_filters_btn', 'click', zoomControl.toggleAddBuildInReportFilters);
	
		
		// Create reports menu
		reportsMenu.init(true/* isDynamicReport */);
		
		//
		// init clear filter buttons
		//
		
		var isDateFilter = (reportInfo.dateFilter != '') ? true : false;
		var isGlobalFilter = (reportInfo.filterId != '') ? true : false;
		
		if (isDateFilter) {
			YE.addListener('report:clear_date_btn', 'click', newReport.clearDateFilter);
		}
		
		if (isGlobalFilter) {
			YE.addListener('report:clear_filters_btn', 'click', newReport.clearGlobalFilter);
		}
		
		if (isDateFilter && isGlobalFilter) {
			YE.addListener('report:clear_date_and_filters_btn', 'click', newReport.clearAllFilters);
		}
		
		// Init toolbar
		report.initToolbar();
		
		// init simple progress
		report.busyPanel = new util.BusyPanel();
	},
	
	initToolbar: function() {
		
		var YE = YAHOO.util.Event;
		
		// report.toggleReportsMenuBtn = new util.ToolbarButton('toggle_reports_menu', display.toggleSidebar, toolbarButtonsDb);
		report.datePickerBtn = new util.ToolbarButton('date_picker', datePicker.open, toolbarButtonsDb);
		report.globalFilterBtn = new util.ToolbarButton('global_filter', globalFilter.open, toolbarButtonsDb);
		report.macrosBtn = new util.ToolbarButton('macros', toggleReportsDropDownMenu, toolbarButtonsDb);
		report.toolsBtn = new util.ToolbarButton('miscellaneous_report_tools', toggleReportsDropDownMenu, toolbarButtonsDb);
		
		// report.emailReportBtn = new util.ToolbarButton('email_report', emailReport.open, toolbarButtonsDb);
		report.printerFriendlyBtn = new util.ToolbarButton('printer_friendly', report.printerFriendlyReport, toolbarButtonsDb);
		// report.databaseInfoBtn = new util.ToolbarButton('database_info', databaseInfo.open, toolbarButtonsDb);
		
		// report.toggleReportsMenuBtn.enable();
		
		// Set toolbar permissions
		var permissions = reportInfo.permissions;
		
		var isCalendar = reportInfo.isCalendar;
		var isDatePickerBtn = !isCalendar && permissions.datePicker && !reportInfo.noDateRange;
		var isGlobalFilterBtn = !isCalendar && permissions.globalFilter;
		var isMacrosBtn = !isCalendar && permissions.macros;
		var isPrinterFriendlyBtn = !isCalendar;
		
		var isEmailReportBtn = !isCalendar && permissions.sendReportByEmail;
		var isSaveReportChangesBtn = !isCalendar && permissions.saveReportChanges;
		var isSaveAsNewReportBtn = !isCalendar && permissions.saveAsNewReport;
		
		// var isDatabaseInfoBtn = !isCalendar && permissions.databaseInfo;
		var isUpdateDatabaseBtn = !isCalendar && permissions.updateDatabase;
		var isBuildDatabaseBtn = !isCalendar && permissions.buildDatabase;
		
		if (isDatePickerBtn) {report.datePickerBtn.enable();} else {report.datePickerBtn.disableAndIgnore();}
		if (isGlobalFilterBtn) {report.globalFilterBtn.enable();} else {report.globalFilterBtn.disableAndIgnore();}
		// if (isEmailReportBtn) {report.emailReportBtn.enable();} else {report.emailReportBtn.disableAndIgnore();}
		if (isPrinterFriendlyBtn) {report.printerFriendlyBtn.enable();} else {report.printerFriendlyBtn.disableAndIgnore();}
		// if (isDatabaseInfoBtn) {report.databaseInfoBtn.enable();} else {report.databaseInfoBtn.disableAndIgnore();}
		
		// We show the Miscellaneous drop down menu if one the miscellaneous tools is active
		var isMiscellaneousBtn = !isCalendar && (isEmailReportBtn || isSaveReportChangesBtn || isSaveAsNewReportBtn || isUpdateDatabaseBtn || isBuildDatabaseBtn);
		
		if (isMacrosBtn) {
			report.macrosBtn.enable();
			// Add drop down functionality
			util.dropDownMenu.add('toolbar:macros', 'reports_toolbar:drop_down:macros');
			
			// Add events to macro menu
			YE.addListener('reports_toolbar:drop_down:create_new_macro_btn', 'click', macroItem.open);
			YE.addListener('reports_toolbar:drop_down:manage_macros_btn', 'click', manageMacros.open);
			
			// Update macros list
			report.macros.updateList();
		}
		else {
			report.macrosBtn.disableAndIgnore();
		}
		
		if (isMiscellaneousBtn) {
			
			report.toolsBtn.enable();
			// Add drop down functionality
			util.dropDownMenu.add('toolbar:miscellaneous_report_tools', 'reports_toolbar:drop_down:tools');
			
			if (isEmailReportBtn) {
				YE.addListener('reports_toolbar:drop_down:email_report_btn', 'click', emailReport.open);
			}
			
			if (isSaveReportChangesBtn) {
				
				// Enable button if session specific data exist (we don't really know that, so we always enable the button).
				// Though we disable Save Report Changes if the report does not contain any standard report element
							
				if (report.isTableOrLogDetailReportElement) {
					YE.addListener('reports_toolbar:drop_down:save_report_changes_btn', 'click', saveReportControl.saveChangesActor);
				}
				else {
					// Disable the SaveReportChangesBtn
					var saveReportChangesAElement = util.getE('reports_toolbar:drop_down:save_report_changes_btn');
					saveReportChangesAElement.className = 'disabled';
				}
			}
			
			if (isSaveAsNewReportBtn) {
				YE.addListener('reports_toolbar:drop_down:save_as_new_report_btn', 'click', saveAsNewReport.open);
			}
			
			/*
			if (isDatabaseInfoBtn) {
				YE.addListener('reports_toolbar:drop_down:database_info_btn', 'click', databaseInfo.open);
			}
			*/
			
			if (isUpdateDatabaseBtn) {
				YE.addListener('reports_toolbar:drop_down:update_database_btn', 'click', databaseUtil.updateDatabase);
			}
			
			if (isBuildDatabaseBtn) {
				YE.addListener('reports_toolbar:drop_down:build_database_btn', 'click', databaseUtil.buildDatabase);
			}
		}
		else {
			report.toolsBtn.disableAndIgnore();
		}
		
		// Init help button
		util.helpWindow.init('?dp+docs.user_guide.index');
	},
	
	macros: {
		
		updateList: function() {
			
			// Updates the macros drop down menu upon init
			// or when new Macros are created
			
			var i;
			
			var macrosDb = reportInfo.macros;
			
			var ul = util.getE('reports_toolbar:drop_down:macros');
			
			// Clean up existing list items, except the first 2 items
			var liItems = ul.getElementsByTagName('li');
			var numberOfItemsToDelete = liItems.length - 2;
			for (i = 0; i < numberOfItemsToDelete; i++) {
				var liItemToDelete = ul.lastChild;
				ul.removeChild(liItemToDelete);
			}
			
			for (i = 0; i < macrosDb.length; i++) {
				
				var item = macrosDb[i];
				
				var li = util.createE('li');
				
				var anchorId = 'report_macros_anchor:' + i;
				var href = report.macros.getMacroHref(item);
				var a = util.createE('a', {id:anchorId, href:href});
				
				YAHOO.util.Event.addListener(a, 'click', newReport.setMacro);
				
				var text = util.createT(item.label);
				
				util.chainE(ul, li, a, text);
			}
		},
		
		getMacroHref: function(item) {
			
			var profileName = reportInfo.profileName;
			var reportName = item.rn ? item.rn : reportInfo.reportName;
			
			// util.showObject(item);
			// alert('item.df: ' + item['df']);
			
			var dateFilter = (item['df'] != null) ? item.df : reportInfo.dateFilter;
			
			// alert('dateFilter: ' + dateFilter);
			
			var filterId = '';
			var commandLineFilter = '';
			var commandLineFilterComment = '';
			
			if (item['fi'] != null) {
				filterId = item.fi;
				commandLineFilter = item.f;
				commandLineFilterComment = item.fc;
			}
			else {
				filterId = reportInfo.filterId;
				commandLineFilter = reportInfo.commandLineFilter;
				commandLineFilterComment = reportInfo.commandLineFilterComment;
			}
			
			var href = '?dp=reports&p=' + profileName;
			href += '&rn=' + reportName;
		
			if (dateFilter != '') {
				href += '&df=' + dateFilter;
			}
			
			if (filterId != '') {
				href += '&fi=' + filterId;
			}
			
			if (commandLineFilter != '') {
				href += '&f=' + commandLineFilter;
				
				if (commandLineFilterComment != '') {
					href += '&fc=' + commandLineFilterComment;
				}
			}
			
			return href;
		}
	},
	
	printerFriendlyReport: function() {
		
		var url = '?dp=printer_friendly_report';
		url += '&p=' + reportInfo.profileName;
		url += '&rn=' + reportInfo.reportName;
		url += '&rji=' + reportInfo.reportJobId;
		
		var YD = YAHOO.util.Dom;
		var width = YD.getViewportWidth() - 40;
		var height = YD.getViewportHeight() - 40;
		var features = 'width=' + width + ',height=' + height + ',menubar=yes,toolbar=yes,status=yes,scrollbars=yes,resizable=yes';
		
		var theWindow = window.open(url, 'printer_friendly_report', features);
		theWindow.focus();
	},
	
	columns: {
		
		init: function() {
			
			var YE = YAHOO.util.Event;
			
			var reportElements = reportInfo.reportElements;
			
			var reColumns = reportInfo.reportElementColumns;
		
			for (var shortReportElementId in reColumns) {
				
				var reportElement = reportElements[util.h(shortReportElementId)];
				
				var totalRows = reportElement.totalRows;
				var reportElementType = reportElement.reportElementType;
				// var isLogDetail = (reportElementType != 'log_detail') ? false : true;
						
				// Add sort event if report element has more than 0 rows
				// var addSortEvent = (!isLogDetail && totalRows > 0);
				var addSortEvent = (totalRows > 0);
				var isColumnInfo = false;
				
				var theColumns = reColumns[shortReportElementId];
				var queryFieldsDb = reportInfo.queryFieldsDb;
			
				for (var columnId in theColumns) {
					
					// alert('columnId: ' + columnId);
					
					var reportFieldName = theColumns[columnId];
					var queryField = queryFieldsDb[util.h(reportFieldName)];
					// alert('reportFieldName: ' + reportFieldName);
					
					if (queryField.columnInfo != '') {
						// alert('columnInfo of field ' + reportFieldName + ': ' + queryField.columnInfo);
						isColumnInfo = true;
					}
					
					if (addSortEvent) {
				
						var elementId = shortReportElementId + ':' + columnId;
						YE.addListener(elementId, 'click', report.columns.columnActor);
					}
				}
				
				if (isColumnInfo) {
					
					// The row contains at least one column with a columnInfo.
					// Show columnInfo icon and add columnInfo event
					util.hideE(shortReportElementId + ':index_col:space');
					util.showE(shortReportElementId + ':index_col:show_column_info_img');
					
					var indexThElementId = shortReportElementId + ':index_col:show_column_info_btn';
					
					YE.addListener(indexThElementId, 'click', report.columns.columnActor);
				}
			}
		},
		
		columnActor: function() {
			
			// A column has been clicked
			
			// alert('Clicked column ' + this.id);
			
			var id = this.id;
			var dat = id.split(':');
			var shortReportElementId = dat[0];
			var columnId = dat[1];
			
			if (columnId != 'index_col') {
				
				newReport.sortColumn(shortReportElementId, columnId);
			}
			else {
				columnsInfo.open();
			}
		}
	},

	rowNumbers: {
		
		sequence: [10,20,50,100,200,500],
		
		setRowNumber: function() {
			
			var id = this.id;
			var dat = id.split(':');
			var shortReportElementId = dat[1];
			var startingRow = 1;
			var endingRow = dat[2];
			var numberOfRows = endingRow;
			
			newReport.setRowNumber(shortReportElementId, startingRow, endingRow, numberOfRows);
		},
		
		setRowRange: function() {
			
			var id = this.id;
			var dat = id.split(':');
			var shortReportElementId = dat[1];
			var startingRow = dat[2];
			var endingRow = dat[3];
			var numberOfRows = reportInfo.reportElements[util.h(shortReportElementId)].numberOfRows;
			
			newReport.setRowNumber(shortReportElementId, startingRow, endingRow, numberOfRows);
		},
			
		setCustomRowRange: function() {
			
			var calleeId = this.id;
			var dat = calleeId.split(':');
			var shortReportElementId = dat[1];
			
			var startingRow = util.getF('custom_row_range:' + shortReportElementId + ':starting_row');
			var endingRow = util.getF('custom_row_range:' + shortReportElementId + ':ending_row');
			
			var isValidRange = false;
			
			if (util.isInteger(startingRow) && util.isInteger(endingRow)) {
				
				startingRow = parseInt(startingRow, 10);
				endingRow = parseInt(endingRow, 10);
				var totalRows = reportInfo.reportElements[util.h(shortReportElementId)].totalRows;
				
				if (startingRow > 0 && startingRow <= endingRow && endingRow <= totalRows) {
					isValidRange = true;
				}
			}
			
			if (isValidRange) {
				
				var numberOfRows = endingRow - startingRow + 1;
				newReport.setRowNumber(shortReportElementId, startingRow, endingRow, numberOfRows);
			}
			else {
				alert(langVar('lang_stats.row_numbers.invalid_row_numbers_message'));
			}
		},
		
		toggleCustomRowRange: function() {
			
			// alert('toggleCustomRowRange()');
			
			var calleeId = this.id;
			var dat = calleeId.split(':');
			var shortReportElementId = dat[1];
			
			var element = util.getE('custom_row_range:' + shortReportElementId + ':panel');
			element.style.display = (element.style.display == 'none') ? 'block' : 'none';
		},
		
		build: function(shortReportElementId, reportElementType, startingRow, endingRow, numberOfRows, totalRows) {
			
			var container = util.getE('rows_number_container:' + shortReportElementId);
			
			var div = util.createE('div', {paddingTop:'4px', paddingBottom:'4px'}); // Padding must match the containing anchor element padding!
			
			var divId = 'custom_row_range:' + shortReportElementId + ':panel';
			var div2 = util.createE('div', {id:divId, paddingTop:'5px', paddingBottom:'7px', display:'none'});
	
			if (reportElementType == 'table' || reportElementType == 'log_detail') {
				report.rowNumbers.buildPreviousNextButtonsBar(div, shortReportElementId, startingRow, endingRow, numberOfRows, totalRows);
			}
			report.rowNumbers.buildNumberButtonsBar(div, shortReportElementId, startingRow, endingRow, totalRows);
			report.rowNumbers.buildCustomRowRangeBar(div2, shortReportElementId, startingRow, endingRow);
		
			util.chainE([container, div, div2]);
		},
		
		buildPreviousNextButtonsBar: function(div, shortReportElementId, startingRow, endingRow, numberOfRows, totalRows) {
			
			if (startingRow != 1) {
				
				// Add a previous rows button
				var previousEndingRow = startingRow - 1;
				var previousStartingRow = (startingRow - numberOfRows >= 1) ? startingRow - numberOfRows : 1;
				report.rowNumbers.buildPreviousNextButton(div, shortReportElementId, previousStartingRow, previousEndingRow, false);
			}
			
			if (endingRow != totalRows) {
				
				// Add a next rows button
				var nextStartingRow = endingRow + 1;
				var nextEndingRow = (endingRow + numberOfRows <= totalRows) ? endingRow + numberOfRows : totalRows;
				report.rowNumbers.buildPreviousNextButton(div, shortReportElementId, nextStartingRow, nextEndingRow, true);
			}
			
			//
			// Add a spacer
			//
			
			var span = util.createE('span', {paddingRight:'24px'});
			var spanText = util.createT('&nbsp;');
			util.chainE(div, span, spanText);
		},
		
		buildPreviousNextButton: function(div, shortReportElementId, startingRow, endingRow, isNext) {
			
			var id = 'row_range_btn:' + shortReportElementId + ':' + startingRow + ':' + endingRow;
			// var title = 'Show row ' + startingRow + ' - ' + endingRow;
			var title = langVar('lang_stats.row_numbers.show_row_from_to');
			title = title.replace(/__PARAM__1/, startingRow);
			title = title.replace(/__PARAM__2/, endingRow);
			var label = startingRow + ' - ' + endingRow;
			
			// var td = util.createE('td', {padding:'0px'});
			var a = util.createE('a', {id:id, href:'javascript:;', title:title});
			
			if (util.userAgent.isIE) {
				// fixes IE hover quirks
				a.style.height = '1%';
			}
			
			var text = util.createT(label);
			
			// Add the image
			var dat = isNext ? imgDb.rowsNext : imgDb.rowsPrev;
			var img = util.createE('img', {src:dat.src, width:dat.width, height:dat.height, title:'', alt:'', marginRight:'2px', marginLeft:'2px'});
			
			YAHOO.util.Event.addListener(a, 'click', report.rowNumbers.setRowRange);
			
			if (isNext) {
				
				util.chainE(div, [a, text, img]);
			}
			else {
				
				util.chainE(div, [a, img, text]);
			}
		},
		
		buildNumberButtonsBar: function(div, shortReportElementId, startingRow, endingRow, totalRows) {
			
			var sequence = report.rowNumbers.sequence;
			var lastSetRowNumber;
			var isActive = true; // All row buttons are always active!
			
			for (var i = 0; i < sequence.length; i++) {
				
				var numberOfRows = sequence[i];
				
				if (numberOfRows <= totalRows) {
					
					lastSetRowNumber = numberOfRows;
					// isActive = (numberOfRows != endingRow);
					
					report.rowNumbers.buildNumberButton(div, shortReportElementId, numberOfRows, numberOfRows, isActive);
				}
				else {
					
					// add All Rows button if appropriate
					
					var maxRowNumber = sequence[sequence.length - 1];
					
					if (totalRows > lastSetRowNumber && totalRows <= maxRowNumber) {
	
						report.rowNumbers.buildNumberButton(div, shortReportElementId, totalRows, totalRows, isActive);
					}
					
					break;
				}
			}
			
			//
			// Add button to toggle manual row number editor
			//
			
			var id = 'toggle_custom_row_range:' + shortReportElementId;
			var title = langVar('lang_stats.row_numbers.custom_row_range');
					
			var a = util.createE('a', {id:id, href:'javascript:;', title:title});
			var text = util.createT('[...]');
			
			YAHOO.util.Event.addListener(a, 'click', report.rowNumbers.toggleCustomRowRange);
			
			util.chainE(div, a, text);
		},
		
		buildNumberButton: function(div, shortReportElementId, numberOfRows, numberOfRowsLabel, isActive) {
			
			// numberOfRows is always a rows sequence value, i.e. 10, 20, 40, ...
			// numberOfRowsLabel may be the totals Row value, i.e. 43, 44, 206, ...
			
			var id = 'row_number_btn:' + shortReportElementId + ':' + numberOfRows;
			// var title = 'Show row 1 - ' + numberOfRowsLabel;
			var title = langVar('lang_stats.row_numbers.show_row_1_up_to');
			title = title.replace(/__PARAM__1/, numberOfRowsLabel);
			
			// var td = util.createE('td', {padding:'0px'});
			var a = util.createE('a', {id:id, href:'javascript:;', title:title});
			
			if (util.userAgent.isIE) {
				// fixes IE hover quirks
				a.style.height = '1%';
			}
			
			var text = util.createT(numberOfRowsLabel);
			
			if (isActive) {
				YAHOO.util.Event.addListener(a, 'click', report.rowNumbers.setRowNumber);
			}
			
			util.chainE(div, a, text);
		},
		
		buildCustomRowRangeBar: function(div, shortReportElementId, startingRow, endingRow) {
			
			var text = util.createT(langVar('lang_stats.row_numbers.row') + ': ');
			var id = 'custom_row_range:' + shortReportElementId + ':starting_row';
			var input = util.createE('input', {id:id, type:'text', value:startingRow, width:'60px'});
			var text2 = util.createT(' - ');
			var id2 = 'custom_row_range:' + shortReportElementId + ':ending_row';
			var input2 = util.createE('input', {id:id2, type:'text', value:endingRow, width:'60px', marginRight:'7px'});
			var buttonId = 'custom_row_range:' + shortReportElementId + ':btn';
			var button = util.createE('input', {id:buttonId, type:'button', value:langVar('lang_stats.btn.apply'), fontSize: '1em'});
			
			YAHOO.util.Event.addListener(button, 'click', report.rowNumbers.setCustomRowRange);
			
			util.chainE([div, text, input, text2, input2, button]);
		}
	},
	
	
	rowSelection: {
		
		
		// Note, row selction handles row selection, zoom item selection and breakdown links and page links.
		// A click on a page link (anchor, img or span element) should be simply ignored.
		
		rowsDb: {}, // keeps the row-Ids and row state of activated rows, i.e.:
		
		/*
		selectedRows: {
			
			're0:row:1': {
				oriClassName: '', className of row if not selected and not zoomed
				isSelect: true,
				isZoom: false
				
			},
			
			're1:row:17': {
				oriClassName: ''
				isSelect: false,
				isZoom: true
			}
		}	
		*/
		
		rowActivated: function(evt) {
			
			var element = evt.target || evt.srcElement;
			// var elementId = element.id;
			
			
			var tdClassName = '';
			var anchorElement = null;
			var isAnchorElementClick = false;
			
			var tagName = element.nodeName;
			
			// alert('rowActivated()' + '\nelementId: ' + element.id + '\ntagName: ' + tagName);
			
			while (tagName != 'TR') {
				
				// Check if this is a click on an anchor element or td element
				
				if (tagName == 'A') {
					anchorElement = element;
					isAnchorElementClick = true;
				}
				else if (tagName == 'TD') {
					tdClassName = element.className;
				}
			
				element = element.parentNode;
				tagName = element.nodeName;
				
				// alert('tagName: ' + tagName);
			}
			
			var rowId = element.id;
			
			
			if (isAnchorElementClick) {
				
				//
				//
				// Handle breakdown or page link (page link is simply ignored
				//
				//
				
				if (anchorElement.href == 'javascript:;') {
					
					// This must be a breakdown link, so we breakdown to the item
					// alert(' breakdown link');
					newReport.setBreakdown(rowId);
				}
			}
			else if (rowId != '') {
				
				//
				//
				// Handle row or zoom icon selection
				//
				//
				
				// alert('rowId: ' + rowId + '\ntdClassName: ' + tdClassName + '\ntr backgroundColor: ' + element.style.backgroundColor);
				var isZoomItem = (tdClassName == 'zoom');
				var rowsDb = report.rowSelection.rowsDb;
				var isSelect;
				var isZoom;
				
				if (rowsDb[rowId]) {
					
					var currentItem = rowsDb[rowId];
					
					if (isZoomItem) {
						
						isZoom = !currentItem.isZoom;
						report.rowSelection.updateTrAndRowItemZoom(element, currentItem, isZoom);
						
						zoomControl.addRemoveZoomItem(rowId, isZoom);
					}
					else {
						isSelect = !currentItem.isSelect;
						report.rowSelection.updateTrAndRowItemSelect(element, currentItem, isSelect);
					}
				}
				else {
					
					// Row item is not yet in database, add it now
					// isSelect = !isZoomItem;
					// isZoom = isZoomItem;
					var oriClassName = element.className;
					rowsDb[rowId] = {oriClassName:oriClassName, isSelect:false, isZoom:false};
					
					if (isZoomItem) {
						report.rowSelection.updateTrAndRowItemZoom(element, rowsDb[rowId], true);
						zoomControl.addRemoveZoomItem(rowId, true);
					}
					else {
						report.rowSelection.updateTrAndRowItemSelect(element, rowsDb[rowId], true);
					}
				}
			}
		},
		
		resetZoomItems: function() {
			
			// Resests and deselects all zoomed items. It is invoked from zoom control
			
			var rowsDb = report.rowSelection.rowsDb;
			
			for (var prop in rowsDb) {
				
				var rowItem = rowsDb[prop];
				
				if (rowItem.isZoom) {
						
					var trElement = util.getE(prop); // prop is equal the tr element id
					
					report.rowSelection.updateTrAndRowItemZoom(trElement, rowItem, false);
				}
			}
		},
		
		updateTrAndRowItemZoom: function(trElement, rowItem, isZoom) {
			
			// Sets the tr element and rowItem object to the given arguments
			rowItem.isZoom = isZoom;
			
			/*
			alert('trElement.nodeName: ' + trElement.nodeName);
			
			// Get the image element
			var td = trElement.firstChild;
			
			alert('td.nodeName: ' + td.nodeName);
			*/
			
			var images = trElement.getElementsByTagName('img');
			var img = images[0];
			
			// alert('img.nodeName: ' + img.nodeName);
			
			img.src = isZoom ? imgDb.zoomSelectActive.src : imgDb.zoomSelect.src;
		},
		
		updateTrAndRowItemSelect: function(trElement, rowItem, isSelect) {
			
			// Sets the tr element and rowItem object to the given arguments
			rowItem.isSelect = isSelect;
			
			var oriClassName = rowItem.oriClassName;
			var newClassName = '';
			
			if (isSelect) {
				newClassName = (oriClassName == '') ? 'standard-re-row-select' : oriClassName + ' standard-re-row-select';
			}
			else {
				newClassName = oriClassName;
			}
			
			trElement.className = newClassName;
		}
	}
};

function toggleReportsDropDownMenu() {
	
	// This is a fake function. The actual toolbar item is a drop down.
	// alert('toggleReportsDropDownMenu()');
	// KHP-RC, revise if we can remove this fake function.
}
