//
// databaseUtil - a collection of database server validation utilities
//

var databaseUtil = function() {

	function getIsValidDatabaseName(serverType, databaseName) {

		// This validates the databaseName. We assume that the server side
		// uses quoted database names, which means almost any string is allowed.
		// So this covers basic validation required for quoted and unquoted
		// database names.

		var isValid = false,
			errorMessage = '';

		switch (serverType) {

			case 'mysql':

				if (databaseName.length > 64) {
					errorMessage = langVar('lang_admin.database.mysql_max_length_msg');
				}
				else if (/[\.\/\\]/.test(databaseName)) {
					errorMessage = langVar('lang_admin.database.mysql_invalid_char_msg');
				}
				else {
					isValid = true;
				}

				break;

			case 'odbc_mssql':

				if (databaseName.length > 128) {
					errorMessage = langVar('lang_admin.database.mssql_max_length_msg');
				}
				else {
					isValid = true;
				}

				break;
		}

		return {isValid:isValid, errorMessage:errorMessage};
	}

	// Return global properties and methods

	return {
		getIsValidDatabaseName: getIsValidDatabaseName
	}

}();
	
