//
// databaseInfo
//
var databaseInfo = function() {
	var GD = {
		databaseInfoIsVisible: false
	}
	function init() {
		util.showE('loading_info');
		// init progress.js
		progress.init({
			// decimalDivider: pageInfo.decimalDivider,
			isCancelTaskPermission: pageInfo.permissions.isCancelTask,
			profileName: pageInfo.profileName,
			calleeListener: databaseInfo.progressListener,
			isPanel: true
		});
		getDatabaseInfoData();
	}
	function getDatabaseInfoData() {
		var url = '?dp=templates.util.database_info.get_database_info_data';
		url += '&p=' + pageInfo.profileName;
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		dat += '&v.fp.client_response_function=databaseInfo.getDatabaseInfoDataResponse';
		util.serverPost(url, dat);
	}
	function getDatabaseInfoDataResponse(dat) {
		databaseInfoUtil.updateDatabaseInfo(dat);
		var isRealTimeProcessing = dat.isRealTimeProcessing;
		var isActiveSnaponOperation = dat.isActiveSnaponOperation;
		var databaseIsBuilding = dat.databaseIsBuilding;
		var initialBuildDone = dat.initialBuildDone;
		var databaseIsReadyForReporting = dat.databaseIsReadyForReporting;
		var showNoDatabaseBuildInfo = !isRealTimeProcessing  ? (!databaseIsBuilding && !initialBuildDone) : !databaseIsReadyForReporting;
		util.showE('database_info:no_database_build_info', showNoDatabaseBuildInfo);
		if (!GD.databaseInfoIsVisible) {
			util.hideE('loading_info');
			util.showE('database_info_box');
			GD.databaseInfoIsVisible = true;
		}
		if (!isRealTimeProcessing &&
			(isActiveSnaponOperation || databaseIsBuilding)) {
			// Hide current operation in database info
			util.hideE('database_info:current_operation_section');
			var progressType;
			var mainLabel;
			// Show progress
			if (isActiveSnaponOperation) {
				progressType = 'snapon';
				mainLabel = langVar('lang_stats.database.snapon_operation_active');
			}
			else {
				progressType = 'database';
				mainLabel = langVar('lang_stats.database.database_operation_active');
			}
			progress.startProgress({
				progressType: progressType,
				mainLabel: mainLabel,
				updateMainLabel: true,
				mainInfo: langVar('lang_stats.progress.receiving_progress_information'),
				updateMainInfo: true
			});
		}
		else {
			// Refresh database info data every 5 seconds
			setTimeout('databaseInfo.getDatabaseInfoData()', 5000);
		}
	}
	function progressListener() {
		progress.close();
		util.hideE('database_info_box');
		util.showE('loading_info');
		GD.databaseInfoIsVisible = false;
		getDatabaseInfoData();
	}
	//
	// Return global properties and methods
	//
	return {
		init: init,
		getDatabaseInfoData: getDatabaseInfoData,
		getDatabaseInfoDataResponse: getDatabaseInfoDataResponse,
		progressListener: progressListener
	}
}();
// KHP 31/Aug/2011 - moved onDOMReady to HTML so that init only runs when user has access rights
// YAHOO.util.Event.onDOMReady(databaseInfo.init);
