//
//
// login.js
//
//
// var pageInfo.originUrlSearchString = ''; This varibale is set within the login page
var login = {
	validator: null,
	isActiveChangePasswordForm: false, // Is set to true if we if login requires to change the password
	passwordValidationRules: {}, // object is set when we get a password_expired response upon login
	init: function() {
		var YE = YAHOO.util.Event;
		login.validator = new util.Validator();
		YE.addListener(['username', 'password', 'new_password', 'new_password_2'], 'keypress', login.processFormViaEnterKey);
		YE.addListener('login_button', 'click', login.processForm);
		// YE.addListener('login:forgot_your_password_btn', 'click', login.toggleForgotYourPassword);
		// Set cookie to check for cookie support on server side
		document.cookie = 'js=1';
		if (pageInfo.isAutoLogin) {
			// Login automatically
			login.processLogin(pageInfo.username, pageInfo.password);
		}
	},
	processFormViaEnterKey: function(evt) {
		var keyCode = (evt.which) ? evt.which : evt.keyCode;
		if (keyCode == 13 || keyCode == 3) {
			login.processForm()
		}
	},
	processForm: function() {
		if (!login.isActiveChangePasswordForm) {
			login.processRegularLogin();
		}
		else {
			login.processNewPassword();
		}
	},
	processRegularLogin: function() {
		validator = login.validator;
		validator.reset();
		var username = validator.isValue('username');
		var password = validator.isValue('password');
		if (validator.allValid()) {
			util.hideE('login_form_section');
			util.showE('login_processing_info');
			login.processLogin(username, password);
		}
	},
	processLogin: function(username, password) {
		// This processes the regular and auto login 
		var url = '?dp=authentication';
		var dat = 'v.fp.is_login_form_processing=true&';
		dat += 'v.fp.username=' + encodeURIComponent(username) + '&';
		dat += 'v.fp.password=' + encodeURIComponent(password);
		util.serverPost(url, dat);
	},
	processLoginResponse: function(dat) {
		// dat.responseCode is: logged_in | error | password_expired
		// alert('processLoginResponse() - dat.defaultURLQueryString: ' + dat.defaultURLQueryString);
		// util.showObject(dat);
		var responseCode = dat.responseCode;
		if (responseCode == 'logged_in') {
			var queryString = location.search;
			// alert('queryString: ' + queryString);
			// Clean URL from "&volatile.session_timed_out=true"
			if (queryString.indexOf("&volatile.session_timed_out=true") != -1) {
				queryString = queryString.replace(/&volatile.session_timed_out=true/, "");
			}
			if (queryString == '' || queryString.indexOf('?dp=login') != -1 || queryString.indexOf('?dp=logout') != -1) {
				// Use the default URL query string of RBAC user grants if any
				if (dat.defaultURLQueryString == '') {
					queryString = '?dp=index';
				}
				else {
					queryString = dat.defaultURLQueryString;
				}
			}
			// Set cookie for the case that it hasn't been set via HTTP
			var authCookies = dat.authCookies;
			if (authCookies.length > 0) {
				for (var i = 0; i < authCookies.length; i++) {
					var item = authCookies[i];
					var theCookie = item.name + '=' + item.value;
					theCookie += '; path=' + item.path;
					// alert('We also set the cookie: ' + theCookie);
					document.cookie = theCookie;
				}
			}
			location.replace(queryString);
		}
		else {
			// error or password_expired
			var errorMessage = dat.errorMessage;
			if (responseCode == 'password_expired') {
				// alert('Password Expired');
				util.showE('new_password_section');
				login.isActiveChangePasswordForm = true;
				login.passwordValidationRules = dat.passwordValidationRules;
			}
			util.updateT('login:error_message', errorMessage);
			util.hideE('login:enter_password_info');
			util.showE('login:error_message');
			util.hideE('login_processing_info');
			util.showE('login_form_section');
		}
	},
	//
	// Expired password handling
	//
	processNewPassword: function() {
		validator = login.validator;
		validator.reset();
		var username = validator.isValue('username');
		var password = validator.isValue('password');
		//
		// Validate new password.
		//
		var newPassword = validator.isValue('new_password');
		var newPassword2 = validator.isValue('new_password_2');
		if (newPassword != '') {
			var passwordCheck = passwordUtil.validatePassword(login.passwordValidationRules, newPassword);
			var customErrorMessage;
			if (!passwordCheck.isValid) {
				customErrorMessage = passwordCheck.errorMessage;
				validator.isCustom('new_password', customErrorMessage);
			}
			else if (newPassword != newPassword2) {
				// alert(newPassword + '\n' + newPassword2);
				customErrorMessage = langVar('lang_stats.authentication.invalid_retyped_password');
				validator.isCustom('new_password_2', customErrorMessage);
			}
		}
		if (validator.allValid()) {
			util.hideE('login_form_section');
			util.showE('login_processing_info');
			var url = '?dp=authentication';
			var dat = 'v.fp.is_new_password_form_processing=true&';
			dat += 'v.fp.username=' + encodeURIComponent(username) + '&';
			dat += 'v.fp.password=' + encodeURIComponent(password) + '&';
			dat += 'v.fp.new_password=' + encodeURIComponent(newPassword);
			util.serverPost(url, dat);
		}
	},
	processNewPasswordResponse: function(dat) {
		// alert('processNewPasswordResponse()');
		// util.showObject(dat);
		if (dat.responseCode == 'logged_in') {
			location.replace(dat.finalUrlSearchString);
		}
		else {
			// An error occured
			util.updateT('login:error_message', dat.errorMessage);
			util.showE('login:error_message');
			util.hideE('login_processing_info');
			util.showE('login_form_section');
		}
	}
	/*
	toggleForgotYourPassword: function() {
		var e = util.getE('login:forgot_your_password_info');
		e.style.display = e.style.display == 'none' ? 'block' : 'none';
		// remove focus
		this.blur();
	}
	*/
};
YAHOO.util.Event.onDOMReady(login.init);
