//
// nodeEditor
//
//function expand(s) {
//  alert("expand(s)");
//  return false;
//} // expand()
//
//function addSubnodesResponse() {
// alert("addSubnodesResponse()");
//} // addSubnodesResponse()
var nodeEditor = {
	pathReferences: {}, // keeps any path reference, i.e. re0_9, re0_9_1_2, the pathReference name is the short report element ID followed by the path
	target_base_id_selected: "",
	expand: function(nodePath) {
//alert("expand(): nodepath=" + nodePath);
		var url = '?dp=node_editor.get_subnodes';
		var dat = 'v.fp.node_path=' + nodePath;
		util.serverPost(url, dat);
		return false;
	},
	//
	// nodeEditor.highlightTextOn/Off()
	//
	// Purpose: This highlights or unhighlights "this" element
	//
	highlightTextOn: function() {
//alert("highlightTextOn()");
//alert("classNameBeforeHighlight: " + classNameBeforeHighlight);
		this.classNameBeforeHighlight = this.className;
		this.className = this.className + "_highlighted";
//		this.firstChild.className = "highlighted";
//		this.className = "highlighted";
	},
	highlightTextOff: function() {
		this.className = this.classNameBeforeHighlight;
//		this.className = "unhighlighted";
//		this.firstChild.className = "";
	},
	//
	// nodeEditor.collapse()
	//
	// Purpose: This collapses a editor node
	//
	// Parameters: nodePath: the node to collapse
	//
	collapse: function(nodePath) {
		// Get the node with .'s changed to _DOT_
		var nodepath_converted = nodePath.replace(new RegExp(/[.]/g), "_DOT_");
		// Make the <tr> invisible to hide the expansion
		var expandedTRElement = util.getE(nodepath_converted + ":expandedtr");
		expandedTRElement.style.display = "none";
		// Clear the expanded element
		var expandedNodeElement = util.getE(nodepath_converted + ":expanded");
		while (expandedNodeElement.hasChildNodes())
			expandedNodeElement.removeChild(expandedNodeElement.firstChild);
		// Change the A element to [+]
		var aElement = util.getE(nodepath_converted + ":expand");
		if (aElement) {
			aElement.innerHTML = '<a href="#" onclick="return nodeEditor.expand(\'' + nodePath + '\')">[+]</a>';
		}
		return false;
	}, //==== nodeEditor.collapse() ====//
	//
	// nodeEditor.editTopNodePath()
	//
	// Purpose: This edits the path of the top node (the one we're displaying)
	//
	// Parameters: none
	//
	editTopNodePath: function() {
		// Hide the <span> showing the top node path
		var topNodePathSpan = util.getE("top_node_path_span");
		topNodePathSpan.style.display = 'none';
		// Show the <input> field for editing the top node path
		var topNodePathField = util.getE("top_node_path_field");
		topNodePathField.style.display = '';
		topNodePathField.focus();
		topNodePathField.select();
		// Show the Save button
		var saveButtonElement = document.getElementById("save_button");
		saveButtonElement.style.display = '';
		return false;
	}, //==== nodeEditor.editTopNodePath() ====//
	//
	// nodeEditor.valueTDElementClick()
	//
	// Purpose: This handles a click in the "value" cell of a node
	//
	// Parameters: none
	//
	valueTDElementClick: function(e) {
		var target = YAHOO.util.Event.getTarget(e, false);
		// Get the base id for the node whose value was clicked
		var target_base_id = target.id.replace(new RegExp(/:.*$/), "");
		// Get the <span> containing the value
		var valueSpanElement = document.getElementById(target_base_id + ":valuespan");
		// Get the <field> containing the editable value, and set it to the displayed value
		var valueFieldElement = document.getElementById(target_base_id + ":valuefield");
		valueFieldElement.value = valueSpanElement.innerHTML;
		// Make the displayed value invisible.
		valueSpanElement.style.display = 'none';
		// Make the editable value visible, and focus/select it
		valueFieldElement.style.display = '';
		valueFieldElement.focus();
		valueFieldElement.select();
		// Show the Save button
		var saveButtonElement = document.getElementById("save_button");
		saveButtonElement.style.display = '';
	}, //==== nodeEditor.valueTDElementClick() ====//
	//
	// nodeEditor.verifyDelete()
	//
	// Purpose: This verifies deletion of a node
	//
	// Parameters: none
	//
	verifyDelete: function(e) {
		var selectedNodePath = nodeEditor.target_base_id_selected.replace(new RegExp(/_DOT_/g), ".");
		var answer = confirm("Delete the node '" + selectedNodePath + "'?");
		return answer;
	}, //==== nodeEditor.verifyDelete() ====//
	//
	// nodeEditor.renameButtonClick()
	//
	// Purpose: This handles a click on the Rename button
	//
	// Parameters: none
	//
	renameButtonClick: function(e) {
		// Get the base ID of the selected node
		var selectedNodeID = nodeEditor.target_base_id_selected;
		// Get the <span> containing the name
		var nameSpanElement = document.getElementById(selectedNodeID + ":namespan");
		// Get the <field> containing the editable value, and set it to the displayed value
		var nameFieldElement = document.getElementById(selectedNodeID + ":namefield");
		nameFieldElement.value = nameSpanElement.innerHTML;
		// Make the displayed value invisible.
		nameSpanElement.style.display = 'none';
		// Make the editable value visible, and focus/select it
		nameFieldElement.style.display = '';
		nameFieldElement.focus();
		nameFieldElement.select();
		// Show the Save button
		var saveButtonElement = document.getElementById("save_button");
		saveButtonElement.style.display = '';
//		alert("rename");
		return false;
	}, //==== nodeEditor.renameButtonClick() ====//
	//
	// nodeEditor.nameTDElementClick()
	//
	// Purpose: This handles a click in the "name" cell of a node
	//
	// Parameters: none
	//
	nameTDElementClick: function(e) {
		var target = YAHOO.util.Event.getTarget(e, false);
		// Get the base id for the node whose value was clicked
		var target_base_id = target.id.replace(new RegExp(/:.*$/), "");
//alert("name click: " + target_base_id);
		// Unselect any currently selected cell
//alert("0document.target_base_id_selected: " + nodeEditor.target_base_id_selected);
		if (nodeEditor.target_base_id_selected != "") {
	                var nameTDElement = document.getElementById(nodeEditor.target_base_id_selected + ":nametd");
			nameTDElement.className = "name_cell";
		}
		// Select the clicked cell		
		var nameTDElement = document.getElementById(target_base_id + ":nametd");
		nameTDElement.className = "name_cell_selected";
		nodeEditor.target_base_id_selected = target_base_id;
		// Show the node operator buttons
		var nodeButtons = document.getElementById("node_buttons");
		nodeButtons.style.display = "";
		// Remember the selected item in the form
		var targetBaseIdSelectedElement = document.getElementById("target_base_id_selected");
		targetBaseIdSelectedElement.value = target_base_id;
//alert("document.target_base_id_selected: " + document.target_base_id_selected);
	}, //==== nodeEditor.nameTDElementClick() ====//
	//
	// nodeEditor.expandNodeResponse()
	//
	// Purpose: This expands a node
	//
	// Parameters: dat: the structure created by get_subnodes.cfv, containing information about the node.
	//
	expandNodeResponse: function(dat) {
                var subnodes = dat.subnodes;
		var nodepath_converted = dat.expandedNodePath.replace(new RegExp(/[.]/g), "_DOT_");
		var expandedNodeElement = util.getE(nodepath_converted + ":expanded");
		// Make the <tr> visible to show the expansion
		var expandedTRElement = util.getE(nodepath_converted + ":expandedtr");
		expandedTRElement.style.display = "";
		// Create the <table> element to contain all subnodes
		var tableElement = document.createElement('table');
		tableElement.className = 'node_table';
		tableElement.id = nodepath_converted + ':table';
		expandedNodeElement.appendChild(tableElement);
		// Loop through all subitems
		for (var i = 0; i < subnodes.length; i++) {
			var subnode = subnodes[i];
			var fullname_converted = subnode.fullname.replace(new RegExp(/[.]/g), "_DOT_");
			var fullname_converted2 = subnode.fullname.replace(new RegExp(/[.]/g), "__PERIODD__");
			// Create the <tr> element for the this subnode
			var trElement = document.createElement('tr');
			tableElement.appendChild(trElement);
			// Create the <td> element for the expand/collapse cell
			var expandTDElement = document.createElement('td');
			expandTDElement.className = "expand_icon_td";
			trElement.appendChild(expandTDElement);
			// If this node has subnodes, add a [+] icon to expand it
			if (subnode.has_subnodes) {
				var aElement = document.createElement('a');
				aElement.className = "expand_icon";
				aElement.href = '?dp=templates.node_editor.index';
				aElement.innerHTML = '<a href="#" onclick="return nodeEditor.expand(\'' + subnode.fullname + '\')">[+]</a>';
				aElement.id = fullname_converted + ":expand";
				expandTDElement.appendChild(aElement);
			}
			// Create the <td> element with the node name
			var nameTDElement = document.createElement('td');
			nameTDElement.className = "name_cell";
			nameTDElement.id = fullname_converted + ":nametd";
			trElement.appendChild(nameTDElement);
			// Create the <span> containing the uneditable name
			var nameSpanElement = document.createElement('span');
			nameSpanElement.id = fullname_converted + ":namespan";
	                var nameTxtElement = document.createTextNode(subnode.name);
			nameSpanElement.appendChild(nameTxtElement);
			nameTDElement.appendChild(nameSpanElement);
			// Create the <input> containing the editable name, and make it invisible
			var nameFieldElement = document.createElement("input");
			nameFieldElement.id = fullname_converted + ":namefield";
			nameFieldElement.type = "text";
			nameFieldElement.size = "60";
			nameFieldElement.name = "v.form.renames." + fullname_converted2;
			nameFieldElement.value = '**UNCHANGED**';
			nameFieldElement.style.display = 'none';	
			nameFieldElement.className = "name_field";
			nameTDElement.appendChild(nameFieldElement);
			// Create the <td> element with the node value
			var valueTDElement = document.createElement('td');
			valueTDElement.id = fullname_converted + ":valuetd";
			valueTDElement.className = "value_cell";
//			valueTDElement.width = 10;
			trElement.appendChild(valueTDElement);
//	                var valueTxtElement = document.createTextNode("&nbsp;");
//			valueTDElement.appendChild(valueTxtElement);
//	                var valueSpacerElement = document.createElement("spacer");
//			valueSpacerElement.type = "block";
//			valueSpacerElement.width = "10";
//			valueTDElement.appendChild(valueSpacerElement);
			// Add a <div> to handle mouse-over highlighting
//			var highlighterElement = document.createElement('div');
//			highlighterElement.className = "unhighlighted";
//			highlighterElement.style.height = '100%';
//			highlighterElement.style.marginTop = '0px';
//			highlighterElement.style.marginBottom = '0px';
//			highlighterElement.className = "highlighter";
			YAHOO.util.Event.addListener(valueTDElement, 'mouseover', nodeEditor.highlightTextOn);
			YAHOO.util.Event.addListener(valueTDElement, 'mouseout', nodeEditor.highlightTextOff);
//			valueTDElement.appendChild(highlighterElement);
			// Create the <span> containing the uneditable value
			var valueSpanElement = document.createElement('span');
			valueSpanElement.id = fullname_converted + ":valuespan";
//			valueSpanElement.style.width = '100px';
//			valueSpanElement.style.height = '100px';
//			valueSpanElement.style.background = "lime";
//			valueSpanElement.width = 10;
	                var valueTxtElement = document.createTextNode(subnode.value);
			valueSpanElement.appendChild(valueTxtElement);
			valueTDElement.appendChild(valueSpanElement);
			// Create the <input> containing the editable value, and make it invisible
			var valueFieldElement = document.createElement("input");
			valueFieldElement.id = fullname_converted + ":valuefield";
			valueFieldElement.type = "text";
			valueFieldElement.size = "60";
			valueFieldElement.name = "v.form.value_changes." + fullname_converted2;
			valueFieldElement.value = '**UNCHANGED**';
			valueFieldElement.style.display = 'none';	
			valueFieldElement.className = "value_field";
			valueTDElement.appendChild(valueFieldElement);
			// Listen for clicks on the value
			YAHOO.util.Event.addListener(valueTDElement, 'click', nodeEditor.valueTDElementClick);
			// Listen for clicks on the name
			YAHOO.util.Event.addListener(nameTDElement, 'click', nodeEditor.nameTDElementClick);
			// Create the blank <tr> element where expansion will occur
			if (subnode.has_subnodes) {
				var expandedTRElement = document.createElement('tr');
				var expandedTDElement = document.createElement('td');
				expandedTDElement.colSpan = 3;
				expandedTDElement.id = fullname_converted + ":expanded";
				expandedTRElement.style.display = 'none';
				expandedTRElement.id = fullname_converted + ":expandedtr";
				expandedTRElement.appendChild(expandedTDElement);
				tableElement.appendChild(expandedTRElement);
			}
		} // for subnodes
		// Change the A element to [-]
		var aElement = util.getE(nodepath_converted + ":expand");
		if (aElement)
			aElement.innerHTML = '<a href="#" onclick="return nodeEditor.collapse(\'' + dat.expandedNodePath + '\')">[-]</a>';
	}, //==== nodeEditor.expandNodeResponse() ====//
	//
	// nodeEditor.init()
	//
	// Purpose: This initializes the editor
	//
	// Parameters: none
	//
	init: function(nodePath) {
		// Expand the root path
		nodeEditor.expand(nodePath);
		// Turn on mouse highlighting of top node path span
                var topNodePathValueHighlighter = util.getE("top_node_path_value_td");
		YAHOO.util.Event.addListener(topNodePathValueHighlighter, 'mouseover', nodeEditor.highlightTextOn);
		YAHOO.util.Event.addListener(topNodePathValueHighlighter, 'mouseout', nodeEditor.highlightTextOff);
	}, //==== nodeEditor.init() ====//
}
