//
// reportFieldsUtil.js
//
var reportFieldsUtil = {
	//
	// tabs
	//
	tabActivated: function(tabId) {
		if (!util.isObject(tabId)) { // isObject has be addded due an IE problem, see customizeRE.js for details
			reportFieldsUtil.setTabPanel(tabId);
		}
	},
	setTabPanel: function(tabId) {
		reportFields.tabs.setActiveTab(tabId);
		var tabIds = reportFields.tabIds;
		for (var i = 0; i < tabIds.length; i++) {
			util.hideE('report_fields:' + tabIds[i] + ':panel');
		}
		util.showE('report_fields:' + tabId + ':panel');
		// Kepp track of the active tabId
		// reportFields.activeForm.tabId = tabId;
	},
	verifyAndSetFormDisplay: function(isDatabaseField, isExpression, isAggregatingField, isHierarchicalField) {
		// alert('verifyAndSetFormDisplay()');
		var activeForm = reportFields.activeForm;
        // Change settings if current form does not match the activeForm
		if (activeForm.isDatabaseField != isDatabaseField || 
			activeForm.isExpression != isExpression ||
			activeForm.isAggregatingField != isAggregatingField ||
			activeForm.isHierarchicalField != isHierarchicalField) {
			var showTabBarAndPanels = true; 
			util.hideE(['report_fields:override_category_section', 'report_fields:category_section']);
			// The tab sequnce changes		
			var tabSequnce = [];
			if (isDatabaseField && !isExpression) {
				if (isAggregatingField) {
					util.showE('report_fields:average_denominator_field_section');
					tabSequnce = ['general', 'numerical_options', 'column_info'];
				}
				else if (isHierarchicalField) {
					tabSequnce = ['general', 'hierarchical_field_options', 'column_info'];
				}
				else {
					tabSequnce = ['general', 'column_info'];
				}
				util.showE('report_fields:override_category_section');
			}
			else if (isExpression && !isDatabaseField) {
				if (!isAggregatingField) {
					tabSequnce = ['general', 'expression', 'column_info'];
				}
				else {
					util.hideE('report_fields:average_denominator_field_section');
					tabSequnce = ['general', 'expression', 'numerical_options', 'column_info'];
				}
				util.showE('report_fields:category_section');
			}
			else {
				// No source is selected, so we set the minimum tabs
				tabSequnce = ['general'];
				showTabBarAndPanels = false;
			}
            util.showE('report_fields:skip_escaping_section', !isAggregatingField);
			reportFields.tabs.setSequence(tabSequnce, 'general');
			// Set an initial tab so that all other tab panels are hidden
			reportFieldsUtil.setTabPanel('general');
			util.showEV(['report_fields:tab_bar', 'report_fields:tab_panels'], showTabBarAndPanels);
			//
			// Update activeForm state
			//
			activeForm.isDatabaseField = isDatabaseField;
			activeForm.isExpression = isExpression;
			activeForm.isAggregatingField = isAggregatingField;
			activeForm.isHierarchicalField = isHierarchicalField;
		}
	},
	//
	// Change source handling
	//
	sourceActor: function() {
		// The source has changed.
		// We may need to update the tab sequence
		var isDatabaseField = false;
		var isExpression = false;
		var isAggregatingField = false;
		var isHierarchicalField = false;
		var source = util.getF('report_fields:source');
		var isEnabledTypeList = false;
		if (source != '') {
			if (source != '__EXPRESSION__') {
				isDatabaseField = true;
				var dbFieldName = source;
				var dbFieldItem = reportFields.databaseFieldsDb[util.h(dbFieldName)];
				// util.showObject(dbFieldItem);
				isAggregatingField = dbFieldItem.isAggregatingField;
				isHierarchicalField = dbFieldItem.isHierarchicalField;
				// Update the type list
				util.setF('report_fields:type', dbFieldItem.type);
				// Update the database field category label
				reportFieldsUtil.updateDatabaseFieldCategoryLabel(dbFieldItem.category);
			}
			else {
				isExpression = true;
				isEnabledTypeList = true;
                isAggregatingField = true;
				// Reset type to int
				util.setF('report_fields:type', 'int');
			}
		}
		util.enableE('report_fields:type', isEnabledTypeList);
		reportFieldsUtil.verifyAndSetFormDisplay(isDatabaseField, isExpression, isAggregatingField, isHierarchicalField);
	},
	//
	// Change type handling
	//
	typeActor: function() {
		// The type changes, this is only possible if the selected source is set to Use Expression
		var type = util.getF('report_fields:type');
		var isDatabaseField = false;
		var isExpression = true;
		var isAggregatingField = (type != 'string');
		var isHierarchicalField = false;
		reportFieldsUtil.verifyAndSetFormDisplay(isDatabaseField, isExpression, isAggregatingField, isHierarchicalField);
	},
	overrideCategoryActor: function() {
		var isOverride = this.checked;
		util.enableE('report_fields:override_category', isOverride);
	},
	updateDatabaseFieldCategoryLabel: function(category) {
		var h = util.h;
		var label;
		if (category != '' && reportFields.fieldCategoriesDb[h(category)]) {
			var categoryItem = reportFields.fieldCategoriesDb[h(category)];
			label = categoryItem.label;
		}
		else {
			label = 'None';
		}
		util.updateT('report_fields:db_field_category_label', '(' + label + ')');
	},
	displayFormatTypeActor: function() {
		var displayFormatType = util.getF('report_fields:display_format_type');
		var isCustom = (displayFormatType == 'custom');
		util.showE('report_fields:custom_display_format_type_section', isCustom);
	},
	subitemsLevelActor: function() {
		var isSpecificSubitemsLevel = (this.id == 'subitems_type:specific_level');
		util.enableE('subitems_level', isSpecificSubitemsLevel);
	},
	toggleSortBeforeExpressionEvaluation: function() {
		var makeEnabled = this.checked;
		// Get current selected reportField which is set again so that
		// the selected report field remains selected, regardless if checked or unchecked
		var selectedReportFieldName = util.getF('report_fields:sort_by_before_expression_evaluation');
		if (makeEnabled) {
			// Update the sort by list because the report field names/labels could have been changed
			reportFieldsUtil.updateSortBeforeExpressionEvaluationList();
		}
		// Set the list
		reportFieldsUtil.setSortBeforeExpressionEvaluation(selectedReportFieldName, makeEnabled);
	},
	setSortBeforeExpressionEvaluation: function(reportFieldName, makeEnabled) {
		util.setF('report_fields:sort_by_before_expression_evaluation', reportFieldName);
		util.enableE('report_fields:sort_by_before_expression_evaluation', makeEnabled);
		util.enableE('report_fields:sort_direction_before_expression_evaluation', makeEnabled);
	},
	updateSortBeforeExpressionEvaluationList: function() {
		// Populates the list with up to date report fields data
		var itemsDb = reportFields.itemsDb;
		var reportFieldsListItems = [];
		reportFieldsListItems[0] = {name:'', label:langVar('lang_admin.report_fields.select_report_field')};
		for (var i = 0; i < itemsDb.length; i++) {
			var itemDat = itemsDb[i].dat;
			reportFieldsListItems[reportFieldsListItems.length] = {name:itemDat.nodeName, label:itemDat.label};
		}
		util.populateSelect('report_fields:sort_by_before_expression_evaluation', reportFieldsListItems, 'name', 'label');
	},
	//
	// updateListLabel
	//
	updateListLabelActor: function() {
		setTimeout('reportFieldsUtil.updateListLabel()', 300);
	},
	updateListLabel: function() {
		var label =  util.getF('report_fields:label');
		if (label == '') {
			label = '-';
		}
		reportFields.theList.updateListLabel(label);
	},
	//
	// View available expression fields
	//
	viewAvailableExpressionFields: {
		fieldsPanel: null,
		init: function() {
			var viewExprFieldsObj = {
				panelId: 'view_custom_expression_fields:panel',
				tbodyId: 'view_custom_expression_fields:tbody',
				panelLabel: langVar('lang_admin.available_expression_fields.available_fields'),
				availableExpressionFieldsDb: [] // empty array because report fields could change, so we update the list each time the window is opened
				// left: 0
			};
			reportFieldsUtil.viewAvailableExpressionFields.fieldsPanel = new AvailableExprFields(viewExprFieldsObj);
			YAHOO.util.Event.addListener('view_custom_expression_fields:close_btn', 'click', reportFieldsUtil.viewAvailableExpressionFields.close);
		},
		open: function() {
			// We create a fresh report fields list prior open the available fields panel
			var theList = reportFields.theList;
			var selectedItemId = theList.selectedItemId;
			var itemsDb = reportFields.itemsDb;
			var availableFields = [];
			for (var i = 0; i < itemsDb.length; i++) {
				var item = itemsDb[i];
				var itemDat = item.dat;
				/*
				if (i == 0) {
					util.showObject(item);
				}
				*/
				if (item.id != selectedItemId && itemDat.isDatabaseField) {
					availableFields[availableFields.length] = {label:itemDat.label, name:itemDat.nodeName};
				}
			}
			// util.showObject(availableFields);
			reportFieldsUtil.viewAvailableExpressionFields.fieldsPanel.updateList(availableFields);
			reportFieldsUtil.viewAvailableExpressionFields.fieldsPanel.open();
		},
		close: function() {
			reportFieldsUtil.viewAvailableExpressionFields.fieldsPanel.close();
		}
	}
};
//
// reportFields.js
//
var reportFields = {
	itemsDb: [], // items work array
	itemsDbBackup: [], // items array in the state when first loaded or last saved, it is used upon Undo Changes
	databaseFieldsDb: [],
	fieldCategoriesDb: [],
	reportsDb: {}, // contains reportIds with report labels
	reportFieldIdsUsedInReportsDb: {}, // itemId's of report_fields which are used in reports lookup
	theList: null,
	validator: null,
	saveChangesBtn: null,
	newItemBtn: null,
	deleteBtn: null,
	duplicateBtn: null,
	undoAllChangesBtn: null,
	tabIds: ['general', 'expression', 'hierarchical_field_options', 'numerical_options', 'column_info'],
	tabs: null,
	nodeNamePrefix: 'report_field',
	activeFormElementId: '', // no_item:form | report_fields:form
	// Active form data
	activeForm: {
		isNewItem: false,
		// tabSequnceType rembebers the last set tab sequence so that we know'
		// when the tab sequence must be set again.	
		//tabSequnceType: '', // non_aggregating_db_field | aggregating_db_field | non_aggregating_expression | aggregating_expression
		// Note, it is possible that isDatabaseField and isExpression is false, i.e. when a new report field is created
		isDatabaseField: null, // Used to set the right tab sequence
		isExpression: null, // Used to set the right tab sequence
		isAggregatingField: null, // Used to set the right tab sequence
		isHierarchicalField: null, // Used to set the right tab sequence
		// tabId: 'general', // the active tabId
		oriNodeName: '',
		// nodeName: '', --> has been moved to identifier.js
		oriLabel: '' // original un-expanded language variable, i.e. lang_stats.fields.page_views
	},
	init: function() {
		var YE = YAHOO.util.Event;
		// Create theList object
		reportFields.theList = new listcontroller.List({
			containerElementId: 'item_list_body',
			itemEvent: reportFields.itemActivated,
			isMoveControl: true
		});
		reportFields.validator = new util.Validator();		
		// Init tabs
		var tabIds = reportFields.tabIds;
		reportFields.tabs = new util.Tabs3('report_fields:tabs', tabIds, reportFieldsUtil.tabActivated);
		reportFields.tabs.setSequence(tabIds, 'general');		
		YE.addListener('report_fields:label', 'keyup', reportFieldsUtil.updateListLabelActor);
		// Init identifier
		identifier.init();
		YE.addListener('report_fields:source', 'change', reportFieldsUtil.sourceActor);
		YE.addListener('report_fields:type', 'change', reportFieldsUtil.typeActor);
		YE.addListener('report_fields:override_category_btn', 'click', reportFieldsUtil.overrideCategoryActor);
		YE.addListener('report_fields:display_format_type', 'click', reportFieldsUtil.displayFormatTypeActor);
		YE.addListener(
			['subitems_type:bottom_level', 'subitems_type:hierarchical', 'subitems_type:specific_level'], 'click',
			reportFieldsUtil.subitemsLevelActor
		);
		YE.addListener('report_fields:expression:show_available_fields_btn', 'click', reportFieldsUtil.viewAvailableExpressionFields.open);
		YE.addListener('report_fields:expression:view_help_btn', 'click', util.helpWindow.openGeneralHelp);
		YE.addListener('report_fields:sort_before_expression_evaluation_btn', 'click', reportFieldsUtil.toggleSortBeforeExpressionEvaluation);
		// init OptionInfo
		optionInfo.init();
		//
		// Populate lists
		//
		var i;
		var dbFieldItem;
		// Populate database fields list and average denominator field list
		var databaseFieldsDb = reportFields.databaseFieldsDb;
		var dbFieldsListItems = [];
		dbFieldsListItems[0] = {name:'', label:langVar('lang_admin.report_fields.select_db_field_or_expression')};
		dbFieldsListItems[1] = {name:'__EXPRESSION__', label:'<' + langVar('lang_admin.report_fields.use_expression') + '>'};
		var averageDenominatorListItems = [{name:'', label:'<' + langVar('lang_stats.general.none') + '>'}];
		for (i = 0; i < databaseFieldsDb.length; i++) {
			dbFieldItem = databaseFieldsDb[i];
			dbFieldsListItems[dbFieldsListItems.length] = {name:dbFieldItem.name, label:dbFieldItem.label};
			if (dbFieldItem.isAggregatingField) {
				averageDenominatorListItems[averageDenominatorListItems.length] = {name:dbFieldItem.name, label:dbFieldItem.label};
			}
		}
		util.populateSelect('report_fields:source', dbFieldsListItems, 'name', 'label');
		util.populateSelect('report_fields:average_denominator_field', averageDenominatorListItems, 'name', 'label');
		var fieldCategoriesDb = reportFields.fieldCategoriesDb;
		var categoryListItems = [];
		categoryListItems[0] = {name:'', label:langVar('lang_stats.btn.none')};
		for (i = 0; i < fieldCategoriesDb.length; i++) {
			var categoryItem = fieldCategoriesDb[i];
			categoryListItems[categoryListItems.length] = {name:categoryItem.name, label:categoryItem.label};
		}		
		util.populateSelect('report_fields:override_category', categoryListItems, 'name', 'label');
		util.populateSelect('report_fields:category', categoryListItems, 'name', 'label');
		// Create an initial updateSortBeforeExpressionEvaluation list
		reportFieldsUtil.updateSortBeforeExpressionEvaluationList();
		// Init viewAvailableExpressionFields
		reportFieldsUtil.viewAvailableExpressionFields.init();	
	},
	initToolbar: function() {
		reportFields.saveChangesBtn = new util.ToolbarButton('save_changes', reportFields.saveReportFields, toolbarButtonsDb);
		reportFields.newItemBtn = new util.ToolbarButton('new_report_field', reportFields.newItem, toolbarButtonsDb);
		reportFields.duplicateBtn = new util.ToolbarButton('duplicate', reportFields.duplicateItem, toolbarButtonsDb);
		reportFields.deleteBtn = new util.ToolbarButton('delete', reportFields.deleteItem, toolbarButtonsDb);
		reportFields.undoAllChangesBtn = new util.ToolbarButton('undo_all_changes', reportFields.undoAllChanges, toolbarButtonsDb);
		var permissions = pageInfo.permissions;
		// util.showObject(permissions);
		if (permissions.isEdit) {
			if (!permissions.isAdd) {
				reportFields.newItemBtn.disableAndIgnore();
				reportFields.duplicateBtn.disableAndIgnore();
			}
			if (!permissions.isDelete) {
				reportFields.deleteBtn.disableAndIgnore();
			}
			// Register isModifiedPageHandler in adminConfig.js
			// (We don't check for modifications if there is no edit 
			// permission because there is no Save button anyway!)
			adminConfig.getIsModifiedPageHandler = reportFields.getIsModifiedPage;
		}
		else {
			reportFields.saveChangesBtn.disableAndIgnore();
			reportFields.newItemBtn.disableAndIgnore();
			reportFields.duplicateBtn.disableAndIgnore();
			reportFields.deleteBtn.disableAndIgnore();
			reportFields.undoAllChangesBtn.disableAndIgnore();
		}
		// Set final toolbar state
		reportFields.saveChangesBtn.enable();
		reportFields.undoAllChangesBtn.enable();
		reportFields.newItemBtn.enable();
		reportFields.duplicateBtn.enable();
		reportFields.deleteBtn.enable();
	},
	initItemList: function() {
		reportFields.theList.init(reportFields.itemsDb);
		// select the first item
		var firstItemId = reportFields.theList.getFirstItemId();
		reportFields.setItem(firstItemId);
	},
	getReportFieldsData: function() {
	if (!pageInfo.exitActive) {
		var url = '?dp=config_pages.report_fields.get_report_fields_data';
		url += '&p=' + pageInfo.profileName;
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;		
			util.helpWindow.init('');
			util.serverPost(url, dat);
		}
	},
	getReportFieldsDataResponse: function(dat) {
		if (!pageInfo.exitActive) {
			reportFields.itemsDb = dat.reportFieldsDb;
			reportFields.itemsDbBackup = util.cloneObject(dat.reportFieldsDb);
			reportFields.databaseFieldsDb = dat.databaseFieldsDb;
			reportFields.fieldCategoriesDb = dat.fieldCategoriesDb;
			reportFields.reportsDb = dat.reportsDb;
			reportFields.reportFieldIdsUsedInReportsDb = dat.reportFieldIdsUsedInReportsDb;
			// dbFieldsWithSubitemsLevelSupport = dat.dbFieldsWithSubitemsLevelSupport;
			// util.showObject(dbFieldsWithSubitemsLevelSupport);
			util.createHash(reportFields.databaseFieldsDb, 'name');
			util.createHash(reportFields.fieldCategoriesDb, 'name');
			// Init
			reportFields.init();
			reportFields.initToolbar();
			reportFields.initItemList();
			util.showE('form_section');
			adminConfig.setItemListSize();
			YAHOO.util.Event.addListener(window, 'resize', adminConfig.setItemListSize);
			pageInfo.initComplete = true;
		}
	},
	itemActivated: function(itemId) {
		if (reportFields.validateActiveItem()) {			
			reportFields.setItem(itemId);
		}
	},
	setItem: function(itemId) {
		// selects active item in list and displays the form
		// alert('set item: ' + itemId);
		var activeFormElementId = '';
		var isItem = (itemId != null);
		if (isItem) {
			activeFormElementId = 'report_fields:form';
			reportFields.theList.selectItem(itemId);
			reportFields.updateForm(itemId);
		}
		else {
			activeFormElementId = 'no_item:form';
		}
		if (reportFields.activeFormElementId != activeFormElementId) {
			//
			// Update toolbar buttons
			//
			reportFields.duplicateBtn.enable(isItem);
			reportFields.deleteBtn.enable(isItem);
			//
			// Update form display
			//
			util.hideE(['no_item:form', 'report_fields:form']);
			util.showE(activeFormElementId);
			reportFields.activeFormElementId = activeFormElementId;
		}
	},
	newItem: function() {
		if (reportFields.validateActiveItem()) {
			var newItemId = reportFields.theList.getNewItemId();
			var label = langVar('lang_admin.report_fields.new_report_field');
			var newReportField = {
				id: newItemId,
				type: '',
				label: label,
				dat: {
					nodeName: '',
					oriNodeName: '',
					oriLabel: '',
					label: label,
					columnLabel: '',
					isDatabaseField: false,
					// category: '', --> property must only exist if expression or if we explicitly override the database field category
					sortType: '',
					displayFormatType: 'string',
					customDisplayFormatType: '',
					columnAlignment: '',
					columnInfo: '',
                    skipEscaping: false
				}
			}
			reportFields.activeForm.isNewItem = true;
			reportFields.theList.newItem(newReportField);
			reportFields.setItem(newItemId);
		}
	},
	duplicateItem: function() {
		if (reportFields.validateActiveItem()) {
			var theList = reportFields.theList;
			var clonedItemId = theList.cloneItem();
			// reset nodeName and ori_nodeName
			theList.setItemDatValue(clonedItemId, 'nodeName', '');
			theList.setItemDatValue(clonedItemId, 'oriNodeName', '');
			reportFields.setItem(clonedItemId);
		}
	},
	deleteItem: function() {
		var theList = reportFields.theList;
		var selectedItemId = theList.selectedItemId;
		// util.showObject(reportFieldIdsUsedInReportsDb);
		if (reportFields.reportFieldIdsUsedInReportsDb[selectedItemId]) {
			// The report field is used in reports,
			// delete is not allowed
			// Show alert
			var msg = langVar('lang_admin.report_fields.cannot_be_deleted_msg') + '\n';
			var usedReportIds = reportFields.reportFieldIdsUsedInReportsDb[selectedItemId];
			var reportsDb = reportFields.reportsDb;
			// var reportIds = reportFieldIdsUsedInReportsDb[selectedItemId.toUpperCase()].usedInReportIds;
			for (var i = 0; i < usedReportIds.length; i++) {
				var id = usedReportIds[i];
				var reportLabel = reportsDb[id];
				msg += '- ' + reportLabel + '\n';
			}
			alert(msg);
		}
		else {
			// The report field is not used in reports,
			// delete the item
			var nextItemIdToBeSelected = theList.deleteItem();
			// reset the validator in case that the deleted item indicated an error
			reportFields.validator.reset();
			reportFields.setItem(nextItemIdToBeSelected);
		}
	},
	updateForm: function(itemId) {
		// Check if this is a new item
		var isNewItem = reportFields.activeForm.isNewItem;
		// Reset reportFields.activeForm.isNewItem;
		reportFields.activeForm.isNewItem = false;
		var item = reportFields.theList.getSelectedItem();
		var itemDat = item.dat;
		// util.showObject(item);
		// util.showObject(itemDat);
		// reset form values
		util.resetF('report_fields:form');
		//
		// Handle identfier object
		//
		identifier.initUponUpdateForm(itemDat.nodeName);
		var label = itemDat.label;
		var activeForm = reportFields.activeForm;
		activeForm.oriNodeName = itemDat.oriNodeName;
		activeForm.oriLabel = itemDat.oriLabel;
		util.setF('report_fields:label', label);
		util.setF('report_fields:column_label', itemDat.columnLabel);
		// Set initial paramters for tab sequence setup which is handled by verifyAndSetFormDisplay()
		var isDatabaseField = false;
		var isExpression = false;
		var isAggregatingField = false;
		var isHierarchicalField = false;
		var initialSource = ''; // default value if isNewItem
		var reportFieldType = '';
		var isOverrideCategory = false;
		var databaseFieldCategoryName = '';
		var overrideCategory = '';
		var category = '';
		var isSortBeforeExpressionEvaluation = false;
		var sortByBEE = ''; // sortByBeforeExpressionEvaluation
		var sortDirectionBEE = '';
		if (!isNewItem) {
			if (itemDat.isDatabaseField) {
				//
				// Report field is based on a database field
				//
				isDatabaseField = true;
				var dbFieldName = itemDat.databaseField;
				var dbFieldItem = reportFields.databaseFieldsDb[util.h(dbFieldName)];
				isAggregatingField = dbFieldItem.isAggregatingField;
				isHierarchicalField = dbFieldItem.isHierarchicalField;
				initialSource = dbFieldName;
				reportFieldType = dbFieldItem.type;
				//
				// Handle category
				//
				databaseFieldCategoryName = dbFieldItem.category;
				// Check if the database field category is overriden
				if (itemDat['category']) {
					isOverrideCategory = true;
					overrideCategory = itemDat.category;
				}
				//
				// handle subitems level
				//
				if (isHierarchicalField) {
					var subitemsLevel = itemDat.subitemsLevel;
					switch(subitemsLevel) {
						case -1:
							util.setF('subitems_type:bottom_level', true);
							break;
						case 0:
							util.setF('subitems_type:hierarchical', true);
							break;
						default: // -2 or > 0
							util.setF('subitems_type:specific_level', true);
							util.setF('subitems_level', subitemsLevel);
							util.enableE('subitems_level');
							break;
					}
				}				
			}
			else {
				//
				// Report field is based on an expression
				//
				isExpression = true;
				initialSource = '__EXPRESSION__';
				reportFieldType = itemDat.type;				
				util.setF('report_fields:expression', itemDat.expression);
				isAggregatingField = (reportFieldType != 'string');
				category = itemDat.category;
				sortByBEE = itemDat.sortByBEE;
				sortDirectionBEE = itemDat.sortDirectionBEE;
				isSortBeforeExpressionEvaluation = (sortByBEE != '');
				if (isSortBeforeExpressionEvaluation) {
					// Note, setSortBeforeExpressionEvaluation() is always invoked below,
					// regardless if isSortBeforeExpressionEvaluation
					// Make sure we have the latest report fields list on the expression tab!
					reportFieldsUtil.updateSortBeforeExpressionEvaluationList();
					util.setF('report_fields:sort_direction_before_expression_evaluation', sortDirectionBEE);
				}
			}
		}
		util.setF('report_fields:sort_type', itemDat.sortType);
		util.setF('report_fields:override_category_btn', isOverrideCategory);
		util.enableE('report_fields:override_category', isOverrideCategory);
		util.setF('report_fields:override_category', overrideCategory);
		util.setF('report_fields:category', category);
		reportFieldsUtil.updateDatabaseFieldCategoryLabel(databaseFieldCategoryName);
		var displayFormatType = itemDat.displayFormatType;
		var isCustomDisplayFormat = (displayFormatType == 'custom');
		util.setF('report_fields:display_format_type', displayFormatType);
		util.setF('report_fields:custom_display_format_type', itemDat.customDisplayFormatType);
		util.showE('report_fields:custom_display_format_type_section', isCustomDisplayFormat);
		util.setF('report_fields:column_alignment', itemDat.columnAlignment);
		util.setF('report_fields:sort_before_expression_evaluation_btn', isSortBeforeExpressionEvaluation);
		reportFieldsUtil.setSortBeforeExpressionEvaluation(sortByBEE, isSortBeforeExpressionEvaluation);
		util.setF('report_fields:column_info', itemDat.columnInfo);
		//
		// Set initial source amd type
		// 
		util.setF('report_fields:source', initialSource);
		util.setF('report_fields:type', reportFieldType);
		util.enableE('report_fields:type', isExpression);
		//
		// Set numerical field options
		//
		if (isAggregatingField) {
			if (isDatabaseField) {
				util.setF('report_fields:average_denominator_field', itemDat.averageDenominatorField);
			}
			util.setF('report_fields:show_remainder_value', itemDat.showRemainderValue);
			util.setF('report_fields:show_average_value', itemDat.showAverageValue);
			util.setF('report_fields:show_min_value', itemDat.showMinValue);
			util.setF('report_fields:show_max_value', itemDat.showMaxValue);
			util.setF('report_fields:show_total_value', itemDat.showTotalValue);
			var percentCalculationBtnId = (itemDat.percentCalculation == 'sum') ? 'sum_btn' : 'sum_or_subsum_btn';
			util.setF('report_fields:percent_calculation:' + percentCalculationBtnId, true);
		}
        else {
            // Set skip escaping
            util.setF('report_fields:skip_escaping', itemDat.skipEscaping);
        }
		//
		// Verify and set form display
		//
		reportFieldsUtil.verifyAndSetFormDisplay(isDatabaseField, isExpression, isAggregatingField, isHierarchicalField);
	},
	validateActiveItem: function() {
		// Only validate if isEdit permission and if items
		var theList = reportFields.theList;
		if (pageInfo.permissions.isEdit && theList.isItems()) {
			var validator = reportFields.validator;
			validator.reset();
			var o = {};
			o.oriNodeName = reportFields.activeForm.oriNodeName;
			o.oriLabel = reportFields.activeForm.oriLabel;
			o.label = validator.isValue('report_fields:label');
			o.label = validator.isUnique('report_fields:label', theList.getLookupItems('label'), /* convertToLowercase */ true);
			o.columnLabel = util.getF('report_fields:column_label');
			//
			// handle node name
			//
			if (!identifier.isCustomIdentifier) {
				o.nodeName = identifier.initialNodeName;
				// if this is a new field with empty node name give it a node name now
				if (o.nodeName == '') {
					o.nodeName = util.labelToUniqueNodeName(o.label, theList.getLookupItems('nodeName'), reportFields.nodeNamePrefix);
				}
			}
			else {
				// Custom identifier is active
				// validate for valid and unique node name 
				o.nodeName = validator.isValue('identifier:node_name');
				o.nodeName = validator.isNodeName('identifier:node_name');
				o.nodeName = validator.isUnique('identifier:node_name', theList.getLookupItems('nodeName'));
			}
			// Set initial paramters for validation
			var isDatabaseField = false;
			// var isExpression = false;
			var isAggregatingField = false;
			var isHierarchicalField = false;
			var source = validator.isValue('report_fields:source');
			// alert('source: ' + source);
			if (source != '') {
				// Use Expression or a database field is selected
				// var fieldType;
				if (source != '__EXPRESSION__') {
					//
					// Based on database field
					//
					isDatabaseField = true;
					var dbFieldName = source;
					var dbFieldItem = reportFields.databaseFieldsDb[util.h(dbFieldName)];
					// util.showObject(dbFieldItem);
					isAggregatingField = dbFieldItem.isAggregatingField;
					isHierarchicalField = dbFieldItem.isHierarchicalField;
					o.databaseField = dbFieldName;
					if (util.getF('report_fields:override_category_btn')) {
						// We override the database field category,
						// the catgory "" (empty value) is allowed!
						o.category = util.getF('report_fields:override_category');
					}
					// Handle hierarchical field options (subitems level)
					if (isHierarchicalField) {
						var subitemsLevel;
						if (util.getF('subitems_type:bottom_level')) {
							subitemsLevel = -1
						}
						else if (util.getF('subitems_type:hierarchical')) {
							subitemsLevel = 0;
						}
						else {
							// Custom subitems level
							subitemsLevel = util.getF('subitems_level');
							// Autofix the subitemsLevel if it is not valid
							if (!util.isInteger(subitemsLevel, -2)) {
								subitemsLevel = 1;
							}
						}
						o.subitemsLevel = subitemsLevel;
					}
				}
				else {
					//
					// Based on expression
					//
					o.type = util.getF('report_fields:type');
					o.category = util.getF('report_fields:category');
					o.expression = validator.isValue('report_fields:expression');
					isAggregatingField = (o.type != 'string');
					// Handle sort by before expression evaluation
					var sortByBEE = '';
					var sortDirectionBEE = '';
					if (util.getF('report_fields:sort_before_expression_evaluation_btn')) {
						// We don't show any error if no report field is selected,
						// in this case we simply treat it as unchecked.
						var sortByReportFieldName = util.getF('report_fields:sort_by_before_expression_evaluation');
						if (sortByReportFieldName != '') {
							sortByBEE = sortByReportFieldName;
							sortDirectionBEE = util.getF('report_fields:sort_direction_before_expression_evaluation');
						}
					}
					o.sortByBEE = sortByBEE;
					o.sortDirectionBEE = sortDirectionBEE;
					if (o.expression == '') {
						// Invalid expression, make sure that the expression tab is active
						// so that the error message is visible
						reportFieldsUtil.setTabPanel('expression');
					}
				}
				// Add isDatabaseField!
				o.isDatabaseField = isDatabaseField;
				//
				// Handle numerical options and skipEscaping
				//
				if (isAggregatingField) {
					if (isDatabaseField) {
						o.averageDenominatorField = util.getF('report_fields:average_denominator_field');
					}
					o.showRemainderValue = util.getF('report_fields:show_remainder_value');
					o.showAverageValue = util.getF('report_fields:show_average_value');
					o.showMinValue = util.getF('report_fields:show_min_value');
					o.showMaxValue = util.getF('report_fields:show_max_value');
					o.showTotalValue = util.getF('report_fields:show_total_value');
					o.percentCalculation = util.getF('report_fields:percent_calculation:sum_btn') ? 'sum' : 'sum_or_subsum';
                    o.skipEscaping = false;
				}
                else {
                    o.skipEscaping = util.getF('report_fields:skip_escaping');
                }
				//
				// Handle common options
				//
				var displayFormatType = util.getF('report_fields:display_format_type');
				var customDisplayFormatType = '';
				if (displayFormatType == 'custom') {
					// We don't validate the customDisplayFormatType but simply reset displayFormatType
					// to string if customDisplayFormatType is equal "".
					customDisplayFormatType = util.getF('report_fields:custom_display_format_type');
					if (customDisplayFormatType == '') {
						displayFormatType = 'string';
					}
				}
				o.sortType = util.getF('report_fields:sort_type');
				o.displayFormatType = displayFormatType;
				o.customDisplayFormatType = customDisplayFormatType;
				o.columnAlignment = util.getF('report_fields:column_alignment');
				o.columnInfo = util.getF('report_fields:column_info');
			}
			// util.showObject(o);
			if (validator.allValid()) {
				theList.saveItem(o);
				return true;
			}
			return false;
		}
		// No isEdit permission or no items
		return true;
	},
	saveReportFields: function() {
		if (reportFields.validateActiveItem()) {
			var isModified = reportFields.theList.getIsModified();
			// alert('saveChanges() - isModified: ' + isModified);
			if (isModified) {
				util.hideE('form_section');
				util.showE('saving_info');
				var itemsDb = reportFields.itemsDb;
				var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
				var path = 'v.fp.report_fields';
				if (itemsDb.length > 0) {
					// Create properties lookup
					// Properties to NodeName lookup
					var propToNodeNameLookup = {
						// itemDat proerty name: node_name
						oriNodeName: 'ori_node_name',
						// nodeName:'node_name',
						oriLabel:'ori_label',
						label:'label',
						columnLabel:'column_label',
						databaseField:'database_field',
						averageDenominatorField:'average_denominator_field',
						expression:'expression',
						columnInfo:'column_info',
						type:'type',
						category:'category',
						displayFormatType:'display_format_type',
						customDisplayFormatType:'custom_display_format_type',
						columnAlignment:'column_alignment',
						subitemsLevel:'subitems_level',
						showRemainderValue:'show_remainder_value',
						showAverageValue:'show_average_value',
						showMinValue:'show_min_value',
						showMaxValue:'show_max_value',
						showTotalValue:'show_total_value',
						percentCalculation: 'percent_calculation',
						sortByBEE:'sort_by_before_expression_evaluation',
						sortDirectionBEE: 'sort_direction_before_expression_evaluation',
                        skipEscaping: 'skip_escaping'
					};
					var pattern = /\W/; // The pattern /\W/ is equal [^a-zA-Z0-9_]
					for (var i = 0; i < itemsDb.length; i++) {
						var item = itemsDb[i];
						var itemDat = item.dat;
						var itemPath = path + '.' + itemDat.nodeName;
						for (var prop in itemDat) {
							var itemNodeName = propToNodeNameLookup[prop];
							if (itemNodeName) {
								// This is a valid property, so we add it
								var itemValue = itemDat[prop];
								if (!itemNodeName) {
									alert('Missing prop in nodeName lookup: ' + prop);
									break;
								}
								if (pattern.test(itemValue)) {
									itemValue = encodeURIComponent(itemValue);
								}
								if (itemNodeName == 'display_format_type' && itemValue == 'string') {
									itemValue = '';
								}
								dat += itemPath + '.' + itemNodeName + '=' + itemValue + '&';
							}
						}
						// add position and is_new
						dat += itemPath + '.position=' + i + '&';
						dat += itemPath + '.is_new=' + item.isNew + '&';
					}
					dat = dat.replace(/&$/, '');
				}
				else {
					// No report field exists
					dat = path + '=';
				}
				var url = '?dp=config_pages.report_fields.save_report_fields';
				url += '&p=' + pageInfo.profileName;
				util.serverPost(url, dat);
			}
			else {
				alert(langVar('lang_stats.general.no_changes_to_save'));
			}
		}
	},
	saveReportFieldsResponse: function() {
		// As new nodeNames might have been applied we must update
		// the oriNodeName of all items.
		var theList = reportFields.theList;
		var itemsDb = reportFields.itemsDb;
		for (var i = 0; i < itemsDb.length; i++) {
			var item = itemsDb[i];
			var itemDat = item.dat;
			item.isNew = false;
			item.isModified = false;
			itemDat.oriNodeName = itemDat.nodeName;
		}
		// reset isModified
		theList.resetIsModified();
		// the saved work itemsDb becomes now the itemsDbBackup
		reportFields.itemsDbBackup = util.cloneObject(itemsDb);
		// re-update the selected item due above value changes
		if (itemsDb.length > 0) {
			var selectedItemId = theList.getSelectedItemId();
			reportFields.updateForm(selectedItemId);
		}
		util.hideE('saving_info');
		util.showE('form_section');
	},
	undoAllChanges: function() {
		reportFields.itemsDb = util.cloneObject(reportFields.itemsDbBackup);
		reportFields.initItemList();
	},
	getIsModifiedPage: function() {
		if (!reportFields.validateActiveItem() || reportFields.theList.getIsModified()) {
			return true;
		}
		return false;
	}
};
