var optionInfo = function() {
	var YE = YAHOO.util.Event;
	var YD = YAHOO.util.Dom;
	var GD = {
		isOpen: false,
		activeElementId: '',
		items: {} // saved/already loaded optionInfo items
	};
	function init() {
		// The elementId of an option info icon has the format "option info path" followed by ":option_info",
		// i.e. "profile.database.fields.suppress_top:option_info"
		// Add event listener to all images where elementId ends with ":option_info"
		var images = document.getElementsByTagName('img');
		var pattern = /:option_info/;
		YE.addListener('close_option_info_btn', 'click', optionInfo.close);
		for (var i = 0, max = images.length; i < max; i++) {
			var img = images[i];
			var elementId = img.id;
			if (pattern.test(elementId)) {
				// Make sure we have unique element ID's by adding the index
				// due possible duplicate option info items.
				var newElementId = elementId + ':' + i;
				img.id = newElementId;
				YE.addListener(img, 'click', optionInfo.display);
			}
		}
		//
		// handle external help in option_info display
		//
		YE.addListener('option_info_body_section', 'click', optionInfo.displayExternalHelp);
		//
		// Handle dragdrop
		//
		var dd = new YAHOO.util.DD("option_info_section");
		dd.setHandleElId('option_info_section:header');
	}
    function addCustomItems(theItems) {
        // This initializes additional info icons which have been dynamically generated
        // after init(). Element Id's of the icons and the info text are already known and
        // given in theItems. The text may not be an option_info at all, it can be from any
        // other source such as a snapon comment or whatever.
        // Note, delegating the event doesn't work, so we need to attach an event listener
        // per icon. Use removeCustomItems() to remove the event listeners before the containerElement
        // becomes cleaned up.
        var savedItems = GD.items;
        for (var i = 0, max = theItems.length; i < max; i++) {
            var item = theItems[i];
            // Add item to GD.items
            savedItems[item.id] = item.text;
            // Add event listener
            YE.addListener(item.id, 'click', optionInfo.display);
        }
    }
    function removeCustomItemsEventListener(containerElement) {
        // This removes any attached custom event listeners from the info icons which
        // are children of the containerElement.
        var images = containerElement.getElementsByTagName('img');
        for (var i = 0, max = images.length; i < max; i++) {
            YE.removeListener(images[i], 'click', optionInfo.display);
        }
    }
	function open(infoIconElement) { // opens optionInfo window
		// alert('optionInfo.open()');
		// set OptionInfo window position and size
		var infoIconReg = YD.getRegion(infoIconElement);
		// util.showObject(infoIconReg);
		var someSpace = 10;
		var left = 0
		var top = 0;
		var width = 272;
		var minHeight = 245;
		var maxHeight = 400;
		var viewportWidth = YD.getViewportWidth();
		var viewportHeight = YD.getViewportHeight();
		// Get left optionInfo position
		var rightSpace = viewportWidth - (infoIconReg.right + someSpace);
		var leftSpace = viewportWidth - infoIconReg.left - someSpace;
		if (rightSpace >= width || rightSpace > leftSpace) {
			//Display optionInfo on right of info icon
			left = infoIconReg.right + someSpace;
		}
		else {
			// Display optionInfo on left of info icon
			left = infoIconReg.left - width - someSpace;
			// Make sure left is greater than 0
			if (left < 0) {left = 0;}
		}
		// Get height of optionInfo
		var height = parseInt((viewportHeight / 3) * 2);
		if (height > maxHeight) {
			// limit height to maxHeight
			height = maxHeight
		}
		else if (height < minHeight) {
			// set height to minHeight
			height = minHeight;
		}
		// Get top optionInfo position
		top = infoIconReg.top - parseInt(height / 3);
		if (top + height + 40 > viewportHeight) {
			top = viewportHeight - height - 40;
		}
		// Make sure top is greater than 40
		if (top < 40) {top = 40;}
		var option_info_section = util.getE('option_info_section');
		var option_info_body_section = util.getE('option_info_body_section');
		option_info_section.style.top = top + 'px';
		option_info_section.style.left = left + 'px';
		option_info_section.style.width = width + 'px';
		option_info_body_section.style.height = height + 'px';
		util.showE('option_info_section');
		GD.isOpen = true;
	}
	function display(evt) {
        var element = evt.target || evt.srcElement;
        var elementId = element.id;
        var dat = '';
		if (GD.isOpen && elementId == GD.activeElementId) {
			// We close the already open option info window
			close();
		}
		else {
			if (GD.isOpen) {
				// mark item as inactive
				toggleImage(GD.activeElementId, false);
			}
			else {
				// open optionInfo window
				open(element);
			}
			// mark icon as active
			toggleImage(elementId, true);
			GD.activeElementId = elementId;
            // Get optionInfoPathId and optionInfoPath
            var optionInfoPath = '';
            var optionInfoPathId = '';
            if (elementId.indexOf(':option_info') != -1) {
                dat = elementId.split(':');
                optionInfoPath = dat[0];
                optionInfoPathId = '_' + optionInfoPath.replace(/\./g, '_');
            }
            else {
                // This is a custom item which has no option_info path
                optionInfoPathId = elementId;
            }
			if (GD.items.hasOwnProperty(optionInfoPathId)) {
                // Already loaded, display optionInfo
				setOptionInfoDisplayTo(GD.items[optionInfoPathId]);
			}
			else {
				// Load optionInfo from server
				// Reset current display
				setOptionInfoDisplayTo(' ... ');
				var url = '?dp=util.option_info.get_option_info';
				dat = 'v.fp.option_info_path=' + optionInfoPath;
				dat += '&v.fp.option_info_path_id=' + optionInfoPathId;
				util.serverPost(url, dat);
			}
		}
	}
	function displayResponse(dat) { // server response
		// alert(dat);
		var optionInfoPathId = dat.optionInfoPathId;
		var optionInfoText = dat.optionInfoText;
		// Save optionInfoText in GD.items for later use
		GD.items[optionInfoPathId] = optionInfoText;
		// Display optionInfoText
		setOptionInfoDisplayTo(optionInfoText);
	}
	function setOptionInfoDisplayTo(optionInfoText) {
		var optionInfoBodySection = util.getE('option_info_body_section');
		optionInfoBodySection.innerHTML = optionInfoText;
	}
	function displayExternalHelp(evt) {
		// User clicked in option info window.
		// If this is an anchor then open an external help window, else ignore the event.
		YE.preventDefault(evt);
		var element = evt.target || evt.srcElement;
		var tagName = element.nodeName;
		if (tagName == 'A') {
			var url = element.href;
			var width = YD.getViewportWidth() - 40;
			var height = YD.getViewportHeight() - 40;
			var features = 'width=' + width + ',height=' + height + ',menubar=yes,toolbar=yes,status=yes,scrollbars=yes,resizable=yes';
			var theWindow = window.open(url, 'help', features);
			theWindow.focus();
		}
	}
	function close() {
        if (GD.isOpen) {
            util.hideE('option_info_section');
            // unmark active option icon
            toggleImage(GD.activeElementId, false);
            GD.isOpen = false;
        }
	}
	function toggleImage(elementId, isActive) {
		var isIE6 = util.userAgent.isIE6;
		var img = util.getE(elementId);
		var imgSrc = isActive ? imgDb.optionInfoActive.src : imgDb.optionInfo.src;
		if (!isIE6) {
			img.src = imgSrc;
		}
		else {
			// IE6 only
			img.style.filter = "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='" + imgSrc + "', sizingMethod='scale')";
		}
	}
	//
	//
	// Return global properties and methods
	//
	//
	return {
		init: init,
        addCustomItems: addCustomItems,
        removeCustomItemsEventListener: removeCustomItemsEventListener,
		close: close,
        display: display,
		displayResponse: displayResponse,
		displayExternalHelp: displayExternalHelp
	}
}();
//
// adminConfig.js
//
adminConfig = {
	// getIsModifiedPageHandler is set to a function in Admin and Config pages
	// which checks if a page has been modified or not.
	getIsModifiedPageHandler: null,
	init: function() {
		// alert('adminConfig.init() - pageInfo.isAdminPage: ' + pageInfo.isAdminPage);
		// Don't add product_bar to navigationElements but the logout button only
		var navigationElements = ['admin_features:drop_down', 'admin_config_navbar', 'config_nav', 'product_bar:logout_btn'];
		var YE = YAHOO.util.Event;
		// init admin drop down
		util.initAdminDropDownMenu();
		if (pageInfo.isAdminPage) {
			//
			// init admin nav bar
			//
			util.showE('admin_config_navbar');
			YE.addListener('product_support_btn', 'click', adminConfig.openSupportPage);
		}
		else {
			// init config nav bar
			util.initBreadCrumbNav();
		}
		// Assign exitPage event to all header links
		YE.addListener(navigationElements, 'click', adminConfig.navigateToPage);
	},
	navigateToPage: function(evt) {
		// User clicked a link in Admin or Config to open a different page.
		// Check for unsaved changes!
		// alert('adminConfig.navigateToPage()');
		YAHOO.util.Event.preventDefault(evt);
		var element = evt.target || evt.srcElement;
		var elementId;
		var href;
		var theAnchorElement;
		/*
		var elementsToIgnore = { // ignore i.e. drop down buttons
			"product_bar:admin_btn": true,
			"change_licensing_tier:btn": true,
			"product_bar:about_btn": true
		}
		*/
		// The clicked element may be a SPAN or other inline element, so we have to check the parent for anchor as well
		var parentElement = element.parentNode;
		if (element.nodeName == 'A' || 
			parentElement.nodeName == 'A') {
			theAnchorElement = (element.nodeName == 'A') ? element : parentElement;
			// alert('adminConfig.navigateToPage()');
			href = theAnchorElement.href;
			elementId = theAnchorElement.id;
			// If this is a element which is not defined in elementsToIgnore
			// if (typeof elementsToIgnore[elementId] === 'undefined') {
			// }
			if (adminConfig.getIsExitPagePermission()) {
				// Follow the link
				location.href = href;
			}
			else {
				// Remove focus from links
				theAnchorElement.blur();
			}
		}
	},
	getIsExitPagePermission: function() {
		// alert('adminConfig.getIsExitPagePermission()');
		// Note that we don't need to check for unsaved pages as long as
		// pageInfo.initComplete is set to false!
		var activePage = pageInfo.page;
		var exitThePage = true;
		if (!pageInfo.initComplete || pageInfo.saveActive) {
			// We assume that changes are saved in the background,
			// so we allow to exit the active page if saveActive is true
			exitThePage = true;
			// Set pageInfo.exitActive to true so that the page
			// knows it doesn't need to display anything in case
			// that page data are yet loading.
			pageInfo.exitActive = true;
		}
		else {
			// Check for unsaved page changes
			// KHP 27/April/2010, "pageInfo.isModified" is no longer available,
			// it has been replaced with the adminConfig.isModifiedPageHandler property
			// if (pageInfo.isModified != null && pageInfo.isModified()) {
			if (adminConfig.getIsModifiedPageHandler != null && adminConfig.getIsModifiedPageHandler()) {
				exitThePage = confirm(langVar('lang_admin.general.confirm_unsaved_page_exit'));
			}
			else {
				exitThePage = true;
			}
		}
		// alert("exitThePage: " + exitThePage);
		if (exitThePage) {
			var menuSectionId = 'admin_config_navbar';
			// KHP-RC, instead of hiding the admin_config_toolbar we should disable the toolbar buttons!
			if (util.getE('admin_config_toolbar')) {util.hideEV('admin_config_toolbar');}
			if (util.userAgent.isIE6 && util.getE('config_nav:hidden_cover')) {util.hideE('config_nav:hidden_cover');}
			if (util.getE('config_nav')) {util.hideE('config_nav');}
			if (util.getE('form_section')) {util.hideE('form_section');}
			if (util.getE('loading_info')) {util.hideE('loading_info');}
			if (util.getE('saving_info')) {util.hideE('saving_info');}
			return true;
		}
		return false;
	},
	setItemListSize: function() {
		var activePage = pageInfo.page;
		var itemList = util.getE('item_list');
		var itemListBody = util.getE('item_list_body');
		var itemForm = util.getE('item_form');
		var clientHeight = YAHOO.util.Dom.getClientHeight();
		var itemFormPos = YAHOO.util.Dom.getXY(itemForm);
		var itemFormY = itemFormPos[1];
		var itemListHeight = clientHeight - itemFormY - 50; // 50 for 50px bottom space
		var itemListWidth = 254; // default
		var moveButtonsWidth = 13 + 23 + 13; // includes the margins
		// Pages with move buttons
		var pagesWithMoveButtons = {
			scheduler: '',
			log_parsing_filters: '',
			log_filters: '',
			log_source: '',
			database_filters: '',
			reports: {
				itemListWidth: 275
			},
			xrefs: '',
			report_fields: ''
		}
		var hasMoveControl = pagesWithMoveButtons[activePage] != null;
		if (hasMoveControl && pagesWithMoveButtons[activePage].itemListWidth != null) {
			itemListWidth = pagesWithMoveButtons[activePage].itemListWidth;
		}
		var itemListPos = YAHOO.util.Dom.getXY(itemList);
		var itemListBodyPos = YAHOO.util.Dom.getXY(itemListBody);
		var itemListHeaderHeight = itemListBodyPos[1] - itemListPos[1];
		// set itemForm left margin
		var itemFormLeftMargin = hasMoveControl ? moveButtonsWidth + itemListWidth + 20 : itemListWidth + 40; // 40 for 20px left margin and 20px right margin
		itemForm.style.marginLeft = itemFormLeftMargin + 'px';
		// set itemListMoveButtons size
		if (hasMoveControl) {
			var moveControl = util.getE('item_list_move_control');
			moveControl.style.left = '13px';
			moveControl.style.top = itemFormY + 'px';
		}
		// set itemList size
		var itemListLeft = hasMoveControl ? moveButtonsWidth : 20;
		itemList.style.left = itemListLeft + 'px';
		itemList.style.top = itemFormY + 'px';
		itemList.style.width = itemListWidth + 'px';
		itemList.style.height = itemListHeight + 'px';
		// alert('itemListHeight: ' + itemListHeight);
		// alert('itemListHeaderHeight: ' + itemListHeaderHeight);
		// set itemListBody height
		itemListBody.style.height = (itemListHeight - itemListHeaderHeight) + 'px';
		// adjust copyright_info position
		var copyright_info = util.getE('copyright_info');
		copyright_info.style.position = 'absolute';
		copyright_info.style.top = (clientHeight - 40) + 'px';
	},
	openSupportPage: function(evt) {
		YAHOO.util.Event.preventDefault(evt);
		// var url = '?dp=support';// does not work with preventDefault!
		var url = '?dp=admin_pages.support.support_page';
		var width = YAHOO.util.Dom.getViewportWidth() - 120;
		var height = YAHOO.util.Dom.getViewportHeight() - 60;
		var features = 'width=' + width + ',height=' + height + ',location=yes,menubar=yes,toolbar=yes,status=yes,scrollbars=yes,resizable=yes';
		var supportWindow = window.open(url, 'support', features);
		supportWindow.focus();
	}
}
window.onload = adminConfig.init;
