//
//
// rebuildDbAdvice.js
//
//
var rebuildDbAdvice = {
	panel: null,
	continueFunction: null, // A function in the callee to save the item changes. It is invoked upon click on Continue.
	init: function() {
		var panelObj = {
			panelId: 'rebuild_db_advice:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_stats.btn.save_changes'),
			left: 200,
			top: 100,
			zIndex: 20,
			isCover: true,
			closeEvent: rebuildDbAdvice.close
		};
		var YE = YAHOO.util.Event;
		rebuildDbAdvice.panel = new util.Panel3(panelObj);
		YE.addListener('rebuild_db_advice:continue_btn', 'click', rebuildDbAdvice.continueSave);
		YE.addListener('rebuild_db_advice:cancel_btn', 'click', rebuildDbAdvice.close);
	},
	open: function(continueFunction) {
		rebuildDbAdvice.continueFunction = continueFunction;
		if (!rebuildDbAdvice.panel) {
			rebuildDbAdvice.init();
		}
		rebuildDbAdvice.panel.open();
	},
	close: function() {
		rebuildDbAdvice.panel.close();
	},
	continueSave: function() {
		// Invoked upon click on Continue
		var isHideRebuildDbAdviceMessage = util.getF('rebuild_db_advice:hide_message_btn');
		if (isHideRebuildDbAdviceMessage) {
			// Set pageInfo.showRebuildDbAdvice to false now so that the message isn't shown again
			// while the current page is active. On the next page load pageInfo.showRebuildDbAdvice will
			// be set to false by default.
			pageInfo.showRebuildDbAdvice = false;
		}
		rebuildDbAdvice.close();
		rebuildDbAdvice.continueFunction(isHideRebuildDbAdviceMessage);
	}
};
