//
// admin profiles
//

var profiles = function() {
	
	var YE = YAHOO.util.Event;
	var YD = YAHOO.util.Dom;
	var GD = { // General global data
		
		profilesDb: [],
		numberOfLicensedProfiles: 0,
		numberOfAllProfiles: 0,
		newProfileBtn: null,
		convertProfilesBtn: null,
		newProfileWizardWindow: null,
		busyPanel: null,
		
		invalidV70ProfilesExist: false,
		invalidV80ProfilesExist: false,
		validProfilesExist: false,
		
		// invalidV80Profiles: [], // Array with itemId's
		
		confirmProfileConversionPanel: null,
		convertingProfileName: '',
		
		// Following properties are received in getProfileDataResponse(),
		// they indicate if a profile conversion is already active, if so then
		// we need to show conversion progress right away.
		isActiveConvertProfileTask: false,
		activeConvertProfileTaskId: '',
		activeConvertProfileName: ''
	};
	
	function init() {
		
		GD.newProfileBtn = new util.ToolbarButton('new_profile', createNewProfile, toolbarButtonsDb);
		
		if (pageInfo.isRootAdmin || pageInfo.permissions.isAdd) {
			YE.addListener('profiles:no_profile_info_btn', 'click', profiles.createNewProfile);
		}
		
		
		if (pageInfo.isRootAdmin) {
			
			var commandLinkOptions = {
				classNameEnabled: '',
				classNameDisabled: 'disabled'
			};	
			
			// GD.convertProfilesBtn = YE.addListener('profiles:convert_profiles_btn', 'click', profiles.startProfileConversion);
			GD.convertProfilesBtn = new util.CommandLink('profiles:convert_profiles_btn', profiles.confirmProfileConversion, true, commandLinkOptions);
		}
		
		YE.addListener('profiles:v7_profiles_list', 'click', profileLinkActivated);
		YE.addListener('profiles:profiles_list', 'click', profileLinkActivated);

		
		// Create simple progress panel
		GD.busyPanel = new util.BusyPanel();
		
		// Init help
		util.helpWindow.init('');
	}
	
	function updateNumberOfAllProfiles(numberOfAllProfiles) {
		
		GD.numberOfAllProfiles = numberOfAllProfiles;
	}
	
	function initProfilesDb() {
		
		// This sorts profilesDb and creates the profilesDb Hash for "name".
		// It also sets some global varaiables to check if there are invalid
		// v7 or v8.0/8.1 profiles. We need to know about this information before
		// the table is created.
		
		function compareProfileLabels(a, b) {
			var labelA = a.label.toLowerCase();
			var labelB = b.label.toLowerCase();
			if (labelA < labelB) {return -1}
			if (labelA > labelB) {return 1}
			return 0;
		}
		
		
		var profilesDb = GD.profilesDb;
		
		profilesDb.sort(compareProfileLabels);
		
		util.createHash(profilesDb, 'name');
		
		// Check for invalid profiles. 
		// Reset profiles exist object
		GD.invalidV70ProfilesExist = false;
		GD.invalidV80ProfilesExist = false;
		GD.validProfilesExist = false;
		// GD.invalidV80Profiles = [];
		
		for (var i = 0, l = profilesDb.length; i < l; i++) {
			
			var item = profilesDb[i];
			
			if (item.isValidProfile) {
				
				GD.validProfilesExist = true;
			}
			else {
				
				if (item.version == '7.0') {
					GD.invalidV70ProfilesExist = true;
				}
				
				if (item.version == '8.0') {
					GD.invalidV80ProfilesExist = true;
				}
			}
		}
		
		// util.showObject(GD);
	}
	
	function addNewProfilesDb(profilesDb) {
		
		// A new profilesDb has been loaded, so we need to update GD.profilesDb and the hash.
		GD.profilesDb = profilesDb
		initProfilesDb();
	}
	
	function updateProfilesDisplay() {
		
		// A new profilesDb has been loaded or a profile has been deleted from
		// the already loaded profilesDb.
	
		util.hideE([
			'profiles:no_profile_info',
			'max_profiles_exceeded_info',
			'profiles:v7_profiles_info',
			'profiles:convert_profiles_info',
			'profiles:profiles_list',
			'saving_info',
			'deleting_info'
		]);
		
		var profilesDb = GD.profilesDb;
		
		if (profilesDb.length > 0) {
			
			createProfilesList();

			// Set profiles list display
			
			if (GD.invalidV80ProfilesExist) {
				// Set text in convert_profiles_btn
				util.showE('profiles:convert_all_profiles_info', !GD.validProfilesExist);
				util.showE('profiles:convert_some_profiles_info', GD.validProfilesExist);
			}
			
			util.showE('profiles:v7_profiles_info', GD.invalidV70ProfilesExist);
			util.showE('profiles:convert_profiles_info', GD.invalidV80ProfilesExist);
			util.showE('profiles:profiles_list', (GD.validProfilesExist || GD.invalidV80ProfilesExist));
			
			if (pageInfo.isRootAdmin) {
				// util.enableE('profiles:convert_profiles_info', GD.invalidV80ProfilesExist && !GD.isActiveConvertProfileTask);
				GD.convertProfilesBtn.enable();
			}
		}
		else {
			
			util.showE('profiles:no_profile_info');
		}
		
		// Check if there is a limit on the number of profiles
		var numberOfLicensedProfiles = GD.numberOfLicensedProfiles;
		
		// Note, check for number_of_licensed_profiles element existence because the element is not always available
		if (numberOfLicensedProfiles != 0 && (util.getE('licensed_profiles_info') != null)) {
			// Update text
			var numberOfAllProfiles = GD.numberOfAllProfiles;
			
			util.updateT('licensed_profiles_info:number_of_licensed_profiles', numberOfLicensedProfiles);
			util.updateT('licensed_profiles_info:number_of_used_profiles', numberOfAllProfiles);
			util.showE('licensed_profiles_info');
		
			// If all profiles exceeds number of licensed profiles
			if (numberOfAllProfiles > numberOfLicensedProfiles) {
	
				util.updateT('max_profiles_exceeded_info:number_of_profiles', numberOfAllProfiles);
				util.updateT('max_profiles_exceeded_info:number_of_licensed_profiles', numberOfLicensedProfiles);
				util.showE('max_profiles_exceeded_info');
			}
		}
		
		GD.newProfileBtn.enable(!GD.invalidV80ProfilesExist && !GD.isActiveConvertProfileTask);
		
		util.showE('form_section');
		
		//
		// Check if we need to tap into profile conversion progress (upon initial page display only)
		//
		
		if (GD.isActiveConvertProfileTask) {
			
			GD.convertingProfileName = GD.activeConvertProfileName;
			var profileItem = profilesDb[util.h(GD.activeConvertProfileName)];
			var busyPanelText = langVar('lang_admin.profiles.converting_profiles_text') + '<strong>' + profileItem.label + '</strong>';
			GD.busyPanel.showCustom(busyPanelText);
			
			checkConvertProfileState(GD.activeConvertProfileTaskId);
			
			// Reset GD.isActiveConvertProfileTask so that it isn't called again unless the page becomes reloaded
			GD.isActiveConvertProfileTask = false;
		}
	}
	
	function getProfileData() {
	
		if (!pageInfo.exitActive) {
			
			var url = '?dp=admin_pages.profiles.get_profile_data';
			var dat = 'v.fp.page_token=' + pageInfo.pageToken;
			
			util.serverPost(url, dat);
		}
	}
	
	function getProfileDataResponse(dat) {
		
		if (!pageInfo.exitActive) {
			
			// Init buttons, etc., make sure init() is called only once because
			// getProfileDataResponse might be called multiple times.
			if (!GD.newProfileBtn) {
				init();
			}
			
			updateNumberOfAllProfiles(dat.numberOfAllProfiles);
			
			// profiles.configPagesDb = dat.configPagesDb;
			GD.numberOfLicensedProfiles = dat.numberOfLicensedProfiles;
			
			// Check if a profiles coversion is active
			GD.isActiveConvertProfileTask = dat.isActiveConvertProfileTask;
			GD.activeConvertProfileTaskId = dat.activeConvertProfileTaskId;
			GD.activeConvertProfileName = dat.activeConvertProfileName;
			
			addNewProfilesDb(dat.profilesDb);
			
			// util.showObject(GD.profilesDb);
			updateProfilesDisplay();
		}
	}
	
	function profileLinkActivated(evt) {
		
		// Global event on profiles list table, used for duplicate, rename and delete
		
		var element = evt.target || evt.srcElement;
		var elementId = element.id;
		
		// alert('profileLinkActivated() - elementId: ' + elementId);
		var pattern = /:(duplicate|rename|delete|toggle_invalid_profile_text)/;
		
		// if (elementId.indexOf(':delete:') != -1) {
		if (pattern.test(elementId)) {
			
			var dat = elementId.split(':');
			var profileName = dat[1];
			var operationKeyWord = dat[2];
			
			switch (operationKeyWord) {
				
				case 'rename':
				
					renameProfile.open(profileName);
					break;
				
				case 'duplicate':
				
					duplicateProfile.open(profileName);
					break;
					
				case 'delete':
				
					deleteProfile(profileName);
					break;
					
				case 'toggle_invalid_profile_text':
					
					toggleInvalidProfileText(profileName);
					break;
			}
		}
	}
	
	function createNewProfile() {
		
		// Verify that width and height are within available viewport size
		var viewPortWidth = YD.getViewportWidth();
		var viewPortHeight = YD.getViewportHeight();
		
		var width = (770 < viewPortWidth) ? 770 : viewPortWidth;
		var height = (510 < viewPortHeight) ? 510 : viewPortHeight;
		
		var windowName = 'new_profile_wizard'
		var url = '?dp=new_profile_wizard.index';
		
		var left = parseInt((screen.availWidth/2) - (width/2), 10);
		var top = parseInt((screen.availHeight/2) - (height/2), 10);
		GD.newProfileWizardWindow = window.open(url,windowName,'width=' + width + ',height=' + height + ',left=' + left + ',top=' + top + ',status=yes,scrollbars=yes,resizable=yes');
		GD.newProfileWizardWindow.focus();
	}
	
	
	function deleteProfile(profileName) {
		
		// alert('deleteProfile() - profileName:' + profileName);
		// util.showObject(profilesDb);
		
		// make sure no profile conversion is active
		
		var profileItem = GD.profilesDb[util.h(profileName)];
		var profileLabel = profileItem.label;
		
		var msg = langVar('lang_admin.profiles.confirm_delete_message');
		msg = msg.replace(/__PARAM__1/, profileLabel);
		
		if (confirm(msg)) {
			
			util.hideE('form_section');
			util.showE('deleting_info');
			
			var url = '?dp=admin_pages.profiles.delete_profile';
			
			// -p (profile name) is required by erase_database()!
			// Specify "-p" for valid profiles only, else we get a server error!
			if (profileItem.isValidProfile) {
				url += '&p=' + profileItem.name;
			}
			
			var dat = 'v.fp.page_token=' + pageInfo.pageToken;
			dat += '&v.fp.profile_name=' + profileName;
			dat += '&v.fp.is_valid_profile=' + profileItem.isValidProfile;
			dat += '&v.fp.version=' + profileItem.version;
			
			util.serverPost(url, dat);
		}
		
		return false;
	}
	
	function deleteProfileResponse(dat) {
		
		updateNumberOfAllProfiles(dat.numberOfAllProfiles);
		addNewProfilesDb(dat.profilesDb);
		
		// Update profiles display
		updateProfilesDisplay();
	}

	
	//
	//
	//
	// Create profiles list utilities
	//
	//
	//
	
	function createProfilesList() {
		
		// createProfilesList is called upon initial page load and when a new profile
		// has been created, so we have to clear any existing list.
	
		var isAdminLike = (pageInfo.isRootAdmin || pageInfo.permissions.isAdd || pageInfo.permissions.isDelete);
		var profilesDb = GD.profilesDb;
		
		// util.showObject(profilesDb);
		
		var v7Table = util.getE('profiles:v7_profiles_list');
		util.removeChildElements(v7Table);
		var v7Tbody = util.createE('tbody');
		
		var table = util.getE('profiles:profiles_list');
		util.removeChildElements(table);
		var tbody = util.createE('tbody');

		for (var i = 0, l = profilesDb.length; i < l; i++) {
			
			var item = profilesDb[i];
			
			// If valid v8 profile without any invalid v8 profiles
			if (item.isValidProfile && !GD.invalidV80ProfilesExist) {
				
				createListEntry(isAdminLike, tbody, item);
			}
			else if (item.isValidProfile || item.version == '8.0') {
			
				// Creates simple rows for all v8.0/8.1/8.5 profiles (unconverted and converted)
				createSimpleListEntry(isAdminLike, tbody, item);
			}
			else {
				
				// This must be an invalid version 7.0 profile
				createSimpleListEntry(isAdminLike, v7Tbody, item);
			}
		}
		
		v7Table.appendChild(v7Tbody);
		table.appendChild(tbody);
	}
	
	function addProfileLabelCell(isAdminLike, tr, item) {
		
		var th = util.createE('th');
		var txt = util.createT(item.label);
		
		th.appendChild(txt);
		
		if (isAdminLike && item.username != '') {
			
			var byUserLabel = ' (' + langVar('lang_admin.general.by_user') + ')';
			byUserLabel = byUserLabel.replace(/__PARAM__1/, item.username);
			
			var span = document.createElement('span');
			span.style.color = 'Gray';
			var spanText = document.createTextNode(byUserLabel);
			
			span.appendChild(spanText);
			th.appendChild(span);
		}
		
		tr.appendChild(th);
	}
	
	function addDeleteCell(tr, item) {
		
		addIconLinkCell(tr, imgDb.deleteProfile.src, item.name, 'delete', langVar('lang_admin.profiles.delete_profile') + ' "' + item.label + '"', langVar('lang_admin.profiles.delete_profile'));
	}
	
	function addTextLinkCell(tr, imgSrc, href, label) {
				
		var td = util.createE('td');
		var a = util.createE('a', {className:'link-50', href:href});
		var span = util.createE('span');
		var text = util.createT(label);
		var img = util.createE('img', {src:imgSrc, width:16, height:16, alt:label});
		
		util.chainE(tr, td, [a, img, [span, text]]);
	}
	
	function addIconLinkCell(tr, imgSrc, profileName, operationKeyWord, title, alt) {
		
		// operationKeyWord is: duplicate | rename | delete
	
		var anchorId = 'a:' + profileName + ':' + operationKeyWord;
		var imageId = 'img:' + profileName + ':' + operationKeyWord;
		
		var td = util.createE('td');
		var a = util.createE('a', {id:anchorId, className:'link-50', href:'javascript:;'});
		var img = util.createE('img', {id: imageId, src:imgSrc, width:16, height:16, title:title, alt:alt});
		
		util.chainE(tr, td, [a, img]);
	}
	
	function addEmptyCell(tr) {
		
		var td = document.createElement('td');
		var txt = document.createTextNode('\u00a0'); // creates &nbsp;
		td.appendChild(txt);
		tr.appendChild(td);
	}
	
	function createListEntry(isAdminLike, tbody, item) {
		
		var tr = util.createE('tr', {id:'tr:' + item.name});
		
		// add profileLabel
		
		addProfileLabelCell(isAdminLike, tr, item);
		
		// add View Reports link
		if (item.isViewReports) {
			
			var reportsUrl = '?dp=reports&p=' + item.name;
			
			if (item.df != '') {
				reportsUrl += '&df=' + item.df;
			}
			
			addTextLinkCell(tr, imgDb.viewReports.src, reportsUrl, langVar('lang_stats.btn.view_reports'));
		}
		else {
			addEmptyCell(tr);
		}
		
		// add View Config link
		if (item.isViewConfig) {
			addTextLinkCell(tr, imgDb.viewConfig.src, '?dp=config&page=config_home&p=' + item.name, langVar('lang_stats.btn.config_options'));
		}
		else {
			addEmptyCell(tr);
		}
		
		// add Rename link
		if (item.isRename) {
			
			addIconLinkCell(tr, imgDb.listEditItem.src, item.name, 'rename', langVar('lang_admin.profiles.rename_profile') + ' "' + item.label + '"', langVar('lang_admin.profiles.rename_profile'));
		}
		else {
			addEmptyCell(tr);
		}
	
		// add Duplicate link
		if (pageInfo.permissions.isAdd) {
			
			addIconLinkCell(tr, imgDb.listDuplicateItem.src, item.name, 'duplicate', langVar('lang_admin.profiles.duplicate_profile') + ' "' + item.label + '"', langVar('lang_admin.profiles.duplicate_profile'));
		}
		else {
			addEmptyCell(tr);
		}
		
		
		// add Delete link
		if (item.isDelete) {
			addDeleteCell(tr, item);
		}
		else {
			addEmptyCell(tr);
		}
		
		tbody.appendChild(tr);
	}
	
	function createSimpleListEntry(isAdminLike, tbody, item) {
		
		// This creates v7.0 or v8.x (unconverted and converted) rows.
		// They only contain profile name and a delete button.
		
		// util.showObject(item, 'Create row for');
		
		var tr = util.createE('tr', {id:'tr:' + item.name});
		
		// add profileLabel
		addProfileLabelCell(isAdminLike, tr, item);
		
		// Add state cell
		var label;
		
		if (item.isValidProfile) {
			label = langVar('lang_admin.profiles.valid_profile');
		}
		else if (item.version == '8.0') {
			label = langVar('lang_admin.profiles.version_80_or_81_profile');
		}
		else {
			label = langVar('lang_admin.profiles.version_7x_profile');
		}
			
		var td = util.createE('td', {color:'#aaaaaa'});
		var text = util.createT(label);
		util.chainE(tr, td, text);

		
		// add Delete link
		if (item.isDelete) {
			addDeleteCell(tr, item);
		}
		else {
			addEmptyCell(tr);
		}
		
		tbody.appendChild(tr);
	}
	
	//
	//
	//
	// Convert v8.0/8.1 profiles
	//
	//
	//
	
	
	function getNextProfileNameToConvert() {
	
		// This gets the next profileName of the profile which has to be converted.
		
		var profilesDb = GD.profilesDb;
		var profileName = '';
		
		for (var i = 0, l = profilesDb.length; i < l; i++) {
			
			var profileItem = profilesDb[i];
			
			if (!profileItem.isValidProfile && profileItem.version == '8.0') {
				profileName = profileItem.name;
				break;
			}
		}
		
		return profileName;
	}
	
	function confirmProfileConversion() {
		
		if (!GD.confirmProfileConversionPanel) {
			
			// Init the panel
			var panelObj = {
				panelId: 'convert_profiles:panel',
				panelClassName: 'panel-50',
				panelHeaderLabel: langVar('lang_admin.profiles.converting_profiles_text'),
				left: 80,
				top: 100,
				zIndex: 20,
				isCover: true,
				closeEvent: profiles.cancelProfileConversion
			};
			
			GD.confirmProfileConversionPanel = new util.Panel3(panelObj);
			
			YE.addListener('convert_profiles:no_btn', 'click', cancelProfileConversion);
			YE.addListener('convert_profiles:yes_btn', 'click', startProfileConversion);
		}
		
		GD.confirmProfileConversionPanel.open();
	}
	
	function cancelProfileConversion() {
		
		GD.confirmProfileConversionPanel.close();
	}
	
	function startProfileConversion() {
		
		// Close confirm window
		GD.confirmProfileConversionPanel.close();
		
		// Hide all delete buttons
		var container = util.getE('profiles:profiles_list');
		var aElements = container.getElementsByTagName('a');
		var numberOfElements = aElements.length;
		var pattern = /^.{1,}:delete/;
		
		for (var i = 0; i < numberOfElements; i++) {
			
			var e = aElements[i];
			var elementId = e.id;
			
			if (pattern.test(elementId)) {
				
				// Hide delete element
				e.style.display = 'none';
			}
		}
		
		var profileName = getNextProfileNameToConvert();
		convertProfile(profileName);
	}
	
	function convertProfile(profileName) {		
		
		GD.convertProfilesBtn.disable();
		
		// alert('convertProfile() - profileName: ' + profileName);
		
		// Keep track of the profileName which becomes converted
		GD.convertingProfileName = profileName;
		
		var profileItem =  GD.profilesDb[util.h(profileName)];
		
		var busyPanelText = langVar('lang_admin.profiles.converting_profiles_text') + ' <strong>' + profileItem.label + '</strong>';
		
		GD.busyPanel.showCustom(busyPanelText);
		
		var url = '?dp=admin_pages.profiles.convert_profile';
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		dat += '&v.fp.profile_name=' + profileName;

		util.serverPost(url, dat);
	}
	
	function convertProfileResponse(taskId) {
		
		// util.showObject(dat);
		
		// Check task state
		setTimeout('profiles.checkConvertProfileState("' + taskId + '")', 2500);
	}
	
	function checkConvertProfileState(taskId) {
		
		var url = '?dp=admin_pages.profiles.check_convert_profile_state';
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		dat += '&v.fp.task_id=' + taskId;
		
		util.serverPost(url, dat);
	}
	
	function checkConvertProfileStateResponse(dat) {
		
		// util.showObject(dat);
		// alert('convertProfileResponse() - taskId: ' + dat.taskId);
		if (dat.isActiveTask) {
			// Recheck task state
			setTimeout('profiles.checkConvertProfileState("' + dat.taskId + '")', 1750);
		}
		else {
			
			// alert('Task completed.);
			
			// Mark the current profile as converted
			var convertedProfileItem = GD.profilesDb[util.h(GD.convertingProfileName)];
			convertedProfileItem.isValidProfile = true;
			
			// Continue to convert the next profile, if any
			var nextProfileName = getNextProfileNameToConvert();
			
			// Remove converted profile from GD.invalidV80Profiles
			// GD.invalidV80Profiles.splice(0, 1);
			
			if (nextProfileName != '') {
				convertProfile(nextProfileName);
			}
			else {
				
				// All profiles converted, get fresh profile data
				
				// alert('All Profiles Converted');
				// getProfileData();
				
				// Get fresh profile data
				getProfileData();
				GD.convertingProfileName = '';
				GD.busyPanel.stop();
			}
		}
	}
	
	
	//
	//
	// Return global properties and methods
	//
	//
	
	return {
		
		GD: GD,
		updateNumberOfAllProfiles: updateNumberOfAllProfiles,
		createNewProfile: createNewProfile,
		addNewProfilesDb: addNewProfilesDb,
		updateProfilesDisplay: updateProfilesDisplay,
		getProfileData: getProfileData,
		getProfileDataResponse: getProfileDataResponse,
		deleteProfileResponse: deleteProfileResponse,
		confirmProfileConversion: confirmProfileConversion,
		cancelProfileConversion: cancelProfileConversion,
		convertProfileResponse: convertProfileResponse,
		checkConvertProfileState: checkConvertProfileState,
		checkConvertProfileStateResponse: checkConvertProfileStateResponse
	}
}();
