//
// schedulerActionsList.js
//

var schedulerActionsList = {
	
	moveControl: null,
	list: null,
	
	init: function() {
		
		//
		// Create the actionsList object
		//
		
		var obj = {
			name: 'actions',
			tbodyElementId: 'scheduler:actions_list:tbody',
			noItemText: langVar('lang_admin.scheduler.no_action_defined'),
			isDefaultItem: true,
			listChangeNotificationFunction: schedulerActionsList.listChangeNotification,
			editItemFunction: schedulerActions.editItem,
			duplicateItemFunction: schedulerActions.duplicateItem,
			labelBuilderFunction: schedulerActions.labelBuilder
		}
		
		schedulerActionsList.list = new listcontrollerB.List(obj);
		schedulerActionsList.moveControl = new util.MoveControl('sa_move_control', schedulerActionsList.moveItem);
	},
	
	listChangeNotification: function(listName, selectedItemIndex, numberOfItems) {
		// Called from wide item list controller upon list change
		// Set button state of move control
		schedulerActionsList.moveControl.setState(selectedItemIndex, numberOfItems);
	},
	
	moveItem: function(direction) {
		
		// Invoked from moveControl
		// var direction = schedulerActionsList.moveControl.getMoveDirection(this.id);
		
		// Move item in list
		schedulerActionsList.list.moveItem(direction);
	}
}
