//
// database_fields
//


var dbFields = {
	
	dbServerType: '',
	
	logFieldsDb: [],
	
	itemsDb: [],  // items work array
	itemsDbBackup: [], // items array in the state when first loaded or last saved, it is used upon Undo Changes
	deletedItemsDb: [], // trackes the node names of deleted database fields
	
	dbFieldIdsUsedInReportFieldsDb: {},
	
	/*
		dbFieldIdsUsedInReportFieldsDb contains all database field Ids which are used in report fields with all report field labels
		so that they can be indicated when trying to delete such a field.
		dbFieldIdsUsedInReportFieldsDb: {
			i0: ['report field 1', 'report field 2'],
			i5: ['report field 5']
		}
	*/

	theList: null,
	validator: null,
	nodeNamePrefix: 'db_field',
	
	saveChangesBtn: null,
	newItemBtn: null,
	deleteBtn: null,
	duplicateBtn: null,
	undoAllChangesBtn: null,
	
	activeFormElementId: '',
	
	activeForm: {
		oriNodeName: '',
		oriLabel: '',
		sqlFieldLength: 0, // keeps the default itemDat value
		updateSourceDatabaseFieldsListDone: false
	},
		
	init: function() {
		
		var YE = YAHOO.util.Event;
		
		dbFields.validator = new util.Validator();
		
		// Init identifier
		identifier.init();
		
		YE.addListener('db_fields:label', 'keyup', dbFields.updateListLabelActor);
		YE.addListener('db_fields:derivation_method', 'change', dbFields.derivationMethodActor);
		YE.addListener('db_fields:log_field', 'change', dbFields.logFieldActor);
		YE.addListener('db_fields:type', 'change', dbFields.typeActor);
		YE.addListener('db_fields:aggregation_method', 'change', dbFields.aggregationMethodActor);
				
		// Create theList object
		dbFields.theList = new listcontroller.List({
			containerElementId: 'item_list_body',
			itemEvent: dbFields.itemActivated
		});
		
		// init OptionInfo
		optionInfo.init();
		
		// Populate logFields list (The first -- Select Log Field -- option already exists)
		util.extendSelect('db_fields:log_field', dbFields.logFieldsDb, 'name', 'label');
	},
	
	initToolbar: function() {
		
		//
		// init toolbar buttons
		//
		
		dbFields.saveChangesBtn = new util.ToolbarButton('save_changes', dbFields.saveDbFields, toolbarButtonsDb);		
		dbFields.newItemBtn = new util.ToolbarButton('new_database_field', dbFields.newItem, toolbarButtonsDb);
		dbFields.duplicateBtn = new util.ToolbarButton('duplicate', dbFields.duplicateItem, toolbarButtonsDb);
		dbFields.deleteBtn = new util.ToolbarButton('delete', dbFields.deleteItem, toolbarButtonsDb);
		dbFields.undoAllChangesBtn = new util.ToolbarButton('undo_all_changes', dbFields.undoAllChanges, toolbarButtonsDb);
		
		var permissions = pageInfo.permissions;
		
		if (permissions.isEdit) {
			
			if (!permissions.isAdd) {
				dbFields.newItemBtn.disableAndIgnore();
				dbFields.duplicateBtn.disableAndIgnore();
			}
			
			if (!permissions.isDelete) {
				dbFields.deleteBtn.disableAndIgnore();
			}
			
			// Register isModifiedPageHandler in adminConfig.js
			// (We don't check for modifications if there is no edit 
			// permission because there is no Save button anyway!)
			adminConfig.getIsModifiedPageHandler = dbFields.getIsModifiedPage;
		}
		else {
			
			dbFields.saveChangesBtn.disableAndIgnore();
			dbFields.newItemBtn.disableAndIgnore();
			dbFields.duplicateBtn.disableAndIgnore();
			dbFields.deleteBtn.disableAndIgnore();
			dbFields.undoAllChangesBtn.disableAndIgnore();
		}
		
		dbFields.saveChangesBtn.enable();
		dbFields.newItemBtn.enable();
		dbFields.duplicateBtn.enable();
		dbFields.deleteBtn.enable();
		dbFields.undoAllChangesBtn.enable();
	},
	
	initItemList: function() {
		
		var theList = dbFields.theList;
	
		theList.init(dbFields.itemsDb);
		
		// select the first item
		var firstItemId = theList.getFirstItemId();
		dbFields.setItem(firstItemId);
	},
	
	getDbFieldsData: function() {

		if (!pageInfo.exitActive) {

			var url = '?dp=config_pages.database_fields.get_db_fields_data';
			url += '&p=' + pageInfo.profileName;
			var dat = 'v.fp.page_token=' + pageInfo.pageToken;
			
			// Init help
			util.helpWindow.init('');
			util.serverPost(url, dat);
		}
	},
	
	getDbFieldsDataResponse: function(dat) {
		
		if (!pageInfo.exitActive) {
			
			dbFields.dbServerType = dat.dbServerType;
			
			dbFields.logFieldsDb = dat.logFieldsDb;
			// Create logFieldsDb hash
			util.createHash(dbFields.logFieldsDb, 'name');
			
			// get itemsDb
			dbFields.itemsDb = dat.dbFieldsDb;
			dbFields.itemsDbBackup = util.cloneObject(dat.dbFieldsDb);
			
			dbFields.dbFieldIdsUsedInReportFieldsDb = dat.dbFieldIdsUsedInReportFieldsDb;
			
			// Init		
			dbFields.init();
			dbFields.initToolbar();
			dbFields.initItemList();
	
			util.showE('form_section');
			adminConfig.setItemListSize();
			YAHOO.util.Event.addListener(window, 'resize', adminConfig.setItemListSize);
			
			pageInfo.initComplete = true;
		}
	},
	
	itemActivated: function(itemId) {
	
		if (dbFields.validateActiveItem()) {			
			dbFields.setItem(itemId);
		}
	},
	
	setItem: function(itemId) {
		
		// selects active item in list and displays the form
		// alert('set item: ' + itemId);
		
		var activeFormElementId = '';
		var isItem = (itemId != null);
		
		if (isItem) {
			
			activeFormElementId = 'db_fields:form';
			dbFields.theList.selectItem(itemId);
			dbFields.updateForm();
		}
		else {
			activeFormElementId = 'no_item:form';
		}
		
		
		if (dbFields.activeFormElementId != activeFormElementId) {
			
			//
			// Update toolbar buttons
			//
			
			dbFields.duplicateBtn.enable(isItem);
			dbFields.deleteBtn.enable(isItem);
		
			//
			// Update form display
			//
			
			util.hideE(['no_item:form', 'db_fields:form']);
			util.showE(activeFormElementId);
			dbFields.activeFormElementId = activeFormElementId;
		}
	},
	
	newItem: function() {
		
		if (dbFields.validateActiveItem()) {
			
			theList = dbFields.theList;
		
			var newItemId = theList.getNewItemId();
			var label = langVar('lang_admin.database_fields.new_database_field');
			
			var newDbField = {
				id: newItemId,
				type: '',
				label: label,
				dat: {
					node_name: '',
					ori_node_name: '',
					label: label,
					ori_label: '',
					derivation_method: 'log_field',
					log_field: '',
					type: '',
					aggregation_method: 'none',
					source_database_field: '',
					category: '',
					index: true,
					sql_field_length: 200,
                    single_value_integer_bits: 0,
                    aggregated_value_integer_bits: 0,
					suppress_top: 0,
					suppress_bottom: 2,
					always_include_bottom_level_items: false,
                    itemnums_hash_function: 'mult_sum_c_i'
				}
			}
			
			theList.newItem(newDbField);
			dbFields.setItem(newItemId);
		}
	},
	
	duplicateItem: function() {
			
		if (dbFields.validateActiveItem()) {
			
			theList = dbFields.theList;
			
			var clonedItemId = theList.cloneItem();
			// reset node_name and node_name_ori
			theList.setItemDatValue(clonedItemId, 'node_name', '');
			theList.setItemDatValue(clonedItemId, 'ori_node_name', '');
			theList.setItemDatValue(clonedItemId, 'ori_label', '');
			dbFields.setItem(clonedItemId);
		}
	},
	
	deleteItem: function() {
		
		theList = dbFields.theList;
		
		var selectedItemId = theList.selectedItemId;
		
		// util.showObject(selectedItemObj);
			
		// if the database field is used in one report_field then don't allow to delete it.
		
		
		var usedItemIds = dbFields.dbFieldIdsUsedInReportFieldsDb;
		
		if (usedItemIds[selectedItemId]) {
			
			// Delete not allowed
			var usedInReportFields = usedItemIds[selectedItemId];
			
			// Show alert
			var msg = langVar('lang_admin.database_fields.cannot_be_deleted_msg') + '\n\n';
			
			for (var i = 0; i < usedInReportFields.length; i++) {
				
				msg += '- ' + usedInReportFields[i] + '\n';
			}
			
			alert(msg);
		}
		else {
			
			// Delete OK
			
			// Add deleted item to deletedItemsDb if it is not a new or copied item
			var item = theList.getSelectedItem();
			var oriNodeName = item.dat.ori_node_name;
			if (oriNodeName != '') {
				var deletedItemsDb = dbFields.deletedItemsDb;
				deletedItemsDb[deletedItemsDb.length] = oriNodeName;
			}
			
			// delete selected node item
			var nextItemIdToBeSelected = theList.deleteItem();
			
			// reset the validator in case that the deleted item indicated an error
			dbFields.validator.reset();
			dbFields.setItem(nextItemIdToBeSelected);
		}
	},
	
	updateForm: function() {
		
		var item = dbFields.theList.getSelectedItem();
		var itemDat = item.dat;

        // util.showObject(itemDat);
		
		var activeForm = dbFields.activeForm;
		activeForm.oriNodeName = itemDat.ori_node_name;
		activeForm.oriLabel = itemDat.ori_label;
		activeForm.sqlFieldLength = itemDat.sql_field_length;
		activeForm.updateSourceDatabaseFieldsListDone = false;
		
		// util.showObject(item);
		
		// reset form values
		util.resetF('db_fields:form');
		
		//
		// Handle identfier object
		//
		identifier.initUponUpdateForm(itemDat.node_name);
		
		util.setF('db_fields:label', itemDat.label);
		
		var derivationMethod = itemDat.derivation_method;
		var logField = '';
		var sessionField = '';
		var type = itemDat.type;
		var aggregationMethod = itemDat.aggregation_method;
		var isAggregatingField = (aggregationMethod != 'none');
		var isString = (type == 'string');
		var showFieldDetails = false;
		
		var derivationMethodIsLogField = (derivationMethod == 'log_field');
		
		// alert('derivationMethod: ' + derivationMethod);
		
		util.setF('db_fields:derivation_method', derivationMethod);
		
		if (derivationMethodIsLogField) {
			logField = itemDat.log_field;
			showFieldDetails = (logField != '');
			util.setF('db_fields:log_field', logField);
		}
		
		util.showE('db_fields:log_field_section', derivationMethodIsLogField);
		
		util.setF('db_fields:type', type);
		util.setF('db_fields:aggregation_method', itemDat.aggregation_method);
		
		
		// Handle source_database_field, we only update the source_database_field list if
		// this is an aggregating field. Else it will be updated upon aggregation_method change
		// alert('isAggregatingField: ' + isAggregatingField);
		if (isAggregatingField) {
			// Create full source_database_field list
			dbFields.updateSourceDatabaseFieldsList();
			util.setF('db_fields:source_database_field', itemDat.source_database_field);
		}
		util.showE('db_fields:source_database_field_section', isAggregatingField);
		
		util.setF('db_fields:category', itemDat.category);
		util.setF('db_fields:index', itemDat.index);
		
		if (type == "string") {
		
			util.setF('db_fields:suppress_top', itemDat.suppress_top);
			util.setF('db_fields:suppress_bottom', itemDat.suppress_bottom);
			util.setF('db_fields:always_include_bottom_level_items', itemDat.always_include_bottom_level_items);
		}
		
		util.setF('db_fields:sql_field_length', itemDat.sql_field_length); // We always set the default value
		util.setF('db_fields:single_value_integer_bits', itemDat.single_value_integer_bits); // We always set the default value
        util.setF('db_fields:aggregated_value_integer_bits', itemDat.aggregated_value_integer_bits); // We always set the default value

        util.showE(['db_fields:single_value_integer_bits:section', 'db_fields:aggregated_value_integer_bits:section'], (type != "float"));
		
		util.showE('db_fields:sql_field_length_section', (isString && dbFields.dbServerType != 'internal_sql'));
		util.showE(['db_fields:supress_label_section', 'db_fields:supress_top_section', 'db_fields:supress_bottom_section'], isString);
		
		// Show/hide always_include_bottom_level_items_section
		dbFields.setAlwaysIncludeBottomLevelItemsDisplay(type, logField);
		
		//
		// Handle itemnums_hash_function
		//
        
        var isItemnumsHashFunction = ((type == 'string' && aggregationMethod == 'none') ||
            (type == 'unique' && aggregationMethod == 'unique'));

        if (isItemnumsHashFunction) {
            util.setF('db_fields:itemnums_hash_function', itemDat.itemnums_hash_function);
        }

		util.showE('db_fields:itemnums_hash_function_section', isItemnumsHashFunction);
	},

	validateActiveItem: function() {
		
		var theList = dbFields.theList;
		
		if (pageInfo.permissions.isEdit && theList.isItems()) {
		
			var validator = dbFields.validator;
			validator.reset();
			var activeForm = dbFields.activeForm;
			var logField = '';
			
			var o = {};
			
			o.ori_label = activeForm.oriLabel;
			o.ori_node_name = activeForm.oriNodeName;
			
			o.label = validator.isValue('db_fields:label');
			o.label = validator.isUnique('db_fields:label', theList.getLookupItems('label'), /* convertToLowercase */ true);
			
			//
			// handle node name
			//
			
			if (!identifier.isCustomIdentifier) {
				
				o.node_name = identifier.initialNodeName;
		
				// if this is a new field with empty node name give it a node name now
				if (o.node_name == '') {
					o.node_name = util.labelToUniqueNodeName(o.label, theList.getLookupItems('node_name'), dbFields.nodeNamePrefix);
				}
			}
			else {
				
				// Custom identifier is active
				// validate for valid and unique node name 
				
				// KHP-RC, a custom node name change which is used in a source_database_field must be updated
				// in case that this object becomes saved!
				
				o.node_name = validator.isValue('identifier:node_name');
				o.node_name = validator.isNodeName('identifier:node_name');
				o.node_name = validator.isUnique('identifier:node_name', theList.getLookupItems('node_name'));
			}
			
			var derivationMethod = util.getF('db_fields:derivation_method');
			
			o.derivation_method = derivationMethod;
			
			if (derivationMethod == 'log_field') {
				
				logField = validator.isValue('db_fields:log_field');
				o.log_field = logField;
			}

            var type = validator.isValue('db_fields:type');
            var aggregationMethod = validator.isValue('db_fields:aggregation_method');
			
			o.type = type;
			o.aggregation_method = aggregationMethod;
			
			if (aggregationMethod != "none") {
				o.source_database_field = util.getF('db_fields:source_database_field');
			}
			
			o.category = util.getF('db_fields:category');
			o.index = util.getF('db_fields:index');
			
			var isString = (o.type == 'string');
			
			if (isString && dbFields.dbServerType != 'internal_sql') {
				
				o.sql_field_length = validator.isInteger('db_fields:sql_field_length', 1);
			}
			else {
				// Keep sql_field_length default value
				o.sql_field_length = activeForm.sqlFieldLength;
			}
			
			if (isString) {
				
				o.suppress_top = validator.isInteger('db_fields:suppress_top', 0);
				o.suppress_bottom = validator.isInteger('db_fields:suppress_bottom', 0);
				
				if (util.isInteger(o.suppress_top, 0) && util.isInteger(o.suppress_bottom, 0)) {
					if (parseInt(o.suppress_bottom, 10) < parseInt(o.suppress_top, 10)) {
						validator.isCustom('db_fields:suppress_bottom', langVar('lang_admin.database_fields.invalid_supress_bottom_msg'));
					}
				}
				
				// Handle always_include_bottom_level_items
				var isHierarchicalDatabaseField = dbFields.getIsHierarchicalDatabaseField(o.type, logField);
				var alwaysIncludeBottomLevelItems = isHierarchicalDatabaseField ? util.getF('db_fields:always_include_bottom_level_items') : false;
			
				o.always_include_bottom_level_items = alwaysIncludeBottomLevelItems;
			}
			
			o.single_value_integer_bits = (type != 'float') ? util.getF('db_fields:single_value_integer_bits') : 0;
            o.aggregated_value_integer_bits = (type != 'float') ? util.getF('db_fields:aggregated_value_integer_bits') : 0;
			
			//
			// Handle itemnums_hash_function
			//
            if ((type == 'string' && aggregationMethod == 'none') ||
                (type == 'unique' && aggregationMethod == 'unique')) {

                o.itemnums_hash_function = util.getF('db_fields:itemnums_hash_function');
            }

			
			// util.showObject(o);
			
			if (validator.allValid()) {
				
				theList.saveItem(o);
				
				return true;
			}
			
			return false;
		}
		
		// If no isEdit permission or no items
		return true;
	},

	saveDbFields: function() {
		
		if (dbFields.validateActiveItem()) {
			
			
			var theList = dbFields.theList;
			var isModified = theList.getIsModified();
			
			// alert('saveChanges() - isModified: ' + isModified);

			if (isModified) {
				
				if (pageInfo.showRebuildDbAdvice) {
					
					rebuildDbAdvice.open(dbFields.processSaveDbFields);
				}
				else {
					dbFields.processSaveDbFields();
				}
			}
			else {
				
				alert(langVar('lang_stats.general.no_changes_to_save'));
			}
		}
	},
	
	processSaveDbFields: function(isHideRebuildDbAdviceMessage) {
		
		// This function may be invoked from rebuildDbAdvice.
		// The argument isHideRebuildDbAdviceMessage only exists if invoked from rebuildDbAdvice
		
		var aggregationMethod;
		var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
		dat += 'v.fp.set_hide_rebuild_db_advice_message=' + setHideRebuildDbAdviceMessage + '&';
		var dbFieldType;
		var derivationMethod;
		var i;
		var item;
		var itemDat;
		var itemsDb = dbFields.itemsDb;
		var l;
		var setHideRebuildDbAdviceMessage = (isHideRebuildDbAdviceMessage != null) ? isHideRebuildDbAdviceMessage : false;
		var url;
		
		// alert('setHideRebuildDbAdviceMessage: ' + setHideRebuildDbAdviceMessage);
		
		util.hideE('form_section');
		util.showE('saving_info');
		
		if (itemsDb.length > 0) {
	
			// var pattern = /\W/; // The pattern /\W/ is equal [^a-zA-Z0-9_]
						
			for (i = 0, l = itemsDb.length; i < l; i++) {
				
				item = itemsDb[i];
				itemDat = item.dat;
				path = 'v.fp.database_fields.' + itemDat.node_name;
				
				dat += path + '.is_new=' + item.isNew + '&';
				
				// util.showObject(itemDat);
				
				dbFieldType = itemDat.type;
				derivationMethod = itemDat.derivation_method;
				aggregationMethod = itemDat.aggregation_method;
				
				dat += path + '.node_name=' + itemDat.node_name + '&';
				dat += path + '.ori_node_name=' + itemDat.ori_node_name + '&';
				dat += path + '.label=' + encodeURIComponent(itemDat.label) + '&';
				dat += path + '.ori_label=' + encodeURIComponent(itemDat.ori_label) + '&';
				
				dat += path + '.derivation_method=' + derivationMethod + '&';
				
				if (derivationMethod == 'log_field') {
					dat += path + '.log_field=' + itemDat.log_field + '&';
				}
				
				dat += path + '.type=' + dbFieldType + '&';
				dat += path + '.aggregation_method=' + aggregationMethod + '&';
				
				if (aggregationMethod != 'none') {
					dat += path + '.source_database_field=' + itemDat.source_database_field + '&';
				}
				
				dat += path + '.category=' + itemDat.category + '&';
				dat += path + '.index=' + itemDat.index + '&';
				
				if (dbFieldType == 'string') {
					
					dat += path + '.sql_field_length=' + itemDat.sql_field_length + '&';
					dat += path + '.suppress_top=' + itemDat.suppress_top + '&';
					dat += path + '.suppress_bottom=' + itemDat.suppress_bottom + '&';
					dat += path + '.always_include_bottom_level_items=' + itemDat.always_include_bottom_level_items + '&';
				}
				
				dat += path + '.single_value_integer_bits=' + itemDat.single_value_integer_bits + '&';
                dat += path + '.aggregated_value_integer_bits=' + itemDat.aggregated_value_integer_bits + '&';
				
				if (itemDat.itemnums_hash_function != null) {
					dat += path + '.itemnums_hash_function=' + itemDat.itemnums_hash_function + '&';
				}
			}
		}
		else {
			
			// No database items
			dat += 'v.fp.database_fields=&';
		}
		
		//
		// Handle deleted database field items
		//
		
		var deletedItemsDb = dbFields.deletedItemsDb;
		
		if (deletedItemsDb.length > 0) {
			
			for (i = 0; i < deletedItemsDb.length; i++) {
				
				dat += 'v.fp.deleted_database_fields.' + i + '=' + deletedItemsDb[i] + '&';
			}
		}
		else {
			
			// No deleted items
			dat += 'v.fp.deleted_database_fields=&';
		}
		
		
		dat = dat.replace(/&$/, '');
		
		url = '?dp=config_pages.database_fields.save_db_fields';
		url += '&p=' + pageInfo.profileName;
		
		util.serverPost(url, dat);
	},
	
	processSaveDbFieldsResponse: function() {
		
		// reset deletedItemsDb
		dbFields.deletedItemsDb = [];
		
		// As new nodeNames might have been applied we must update
		// the ori_node_name of all items and the active form item!
		var itemsDb = dbFields.itemsDb;
		
		for (var i = 0; i < itemsDb.length; i++) {
			var item = itemsDb[i];
			var itemDat = item.dat;
			item.isNew = false;
			item.isModified = false;
			itemDat.ori_node_name = itemDat.node_name;
		}
		
		// reset isModified
		var theList = dbFields.theList;
		theList.resetIsModified();
		
		
		// the saved work itemsDb becomes now the itemsDbBackup
		dbFields.itemsDbBackup = util.cloneObject(dbFields.itemsDb);
		
		// update form
		if (itemsDb.length > 0) {
			dbFields.updateForm();
		}
		
		util.hideE('saving_info');
		util.showE('form_section');
	},
	
	undoAllChanges: function() {
		
		dbFields.deletedItemsDb = [];
		dbFields.itemsDb = util.cloneObject(dbFields.itemsDbBackup);
		dbFields.initItemList();
	},
	
	
	//
	//
	//
	// Utilities
	//
	//
	//
	
	
	derivationMethodActor: function() {
		
		var derivationMethod = util.getF('db_fields:derivation_method');
		var isLogField = (derivationMethod == 'log_field');
		
		if (isLogField) {
			var logField = '';
			util.setF('db_fields:log_field', logField);
			dbFields.updateLogFieldsForm(logField);
			dbFields.setAlwaysIncludeBottomLevelItemsDisplay('', logField);
		}
		
		util.showE('db_fields:log_field_section', isLogField);
	},
	
	logFieldActor: function() {
		
		var logField = util.getF('db_fields:log_field');
		var databaseFieldType = util.getF('db_fields:type');
		dbFields.updateLogFieldsForm(logField);
		dbFields.setAlwaysIncludeBottomLevelItemsDisplay(databaseFieldType, logField);
	},
	
	updateLogFieldsForm: function(logField) {
		
		var isLogField = (logField != '');
		// util.showE('db_fields:field_details_section', isLogField);
	},


	getIsSourceDatabaseFieldSupport: function(sessionField) {
		
		var isSourceDatabaseFieldSupport = (sessionField == 'sessions' || sessionField == 'session_begin' || sessionField == 'session_end');
		return isSourceDatabaseFieldSupport;
	},
	
	handleSourceDatabaseFieldDisplay: function(sessionField, sourceDatabaseField) {
		
		var isSourceDatabaseFieldSupport = dbFields.getIsSourceDatabaseFieldSupport(sessionField);
		
		if (isSourceDatabaseFieldSupport) {
			
			// Update list box with up to date database fields where derivation_method is equal session_field.
			
			var itemsDb = dbFields.itemsDb;
			var selectedItemId = dbFields.theList.getSelectedItemId();
			var selectItems = [];
			selectItems[0] = {name:'', label:'--- ' + langVar('lang_admin.database_fields.select_source_database_field') + ' ---'};
		
			for (var i = 0; i < itemsDb.length; i++) {
				
				var item = itemsDb[i];
				var itemDat = item.dat;
				
				if (itemDat.derivation_method == 'session_field' && (item.id != selectedItemId)) {
				
					selectItems[selectItems.length] = {name:itemDat.node_name, label:itemDat.label};
				}
			}
			
			util.populateSelect('db_fields:source_database_field', selectItems, 'name', 'label');
			util.setF('db_fields:source_database_field', sourceDatabaseField);
		}
		
		util.showE('db_fields:source_database_field_section', isSourceDatabaseFieldSupport);
	},
	
	
	typeActor: function() {
		
		var type = util.getF('db_fields:type');
		var logField = util.getF('db_fields:log_field');
		
		util.showE(['db_fields:single_value_integer_bits:section', 'db_fields:aggregated_value_integer_bits:section'], (type != "float"));
		util.showE('db_fields:sql_field_length_section', (type == 'string' && dbFields.dbServerType != 'internal_sql'));
		util.showE(['db_fields:supress_label_section', 'db_fields:supress_top_section', 'db_fields:supress_bottom_section'], (type == 'string'));
		dbFields.setAlwaysIncludeBottomLevelItemsDisplay(type, logField);
        dbFields.updateItemnumsHashFunctionDisplay();
	},
	
	aggregationMethodActor: function() {
		
		var aggregationMethod = util.getF('db_fields:aggregation_method');
		var isAggregatingField = (aggregationMethod != 'none');
		
		// Handle source_database_field
		if (isAggregatingField) {
			dbFields.updateSourceDatabaseFieldsList();
		}
		
		util.showE('db_fields:source_database_field_section', isAggregatingField);

        dbFields.updateItemnumsHashFunctionDisplay();
	},
	
	updateSourceDatabaseFieldsList: function() {
		
		// alert('updateSourceDatabaseFieldsList()');
		
		if (!dbFields.activeForm.updateSourceDatabaseFieldsListDone) { // Avoids multiple updates of the same database Field
			
			// Create new database fields list (all fields except the active field)
			var itemsDb = dbFields.itemsDb;
			var selectedItemId = dbFields.theList.getSelectedItemId();
			var a = [{name: '', label:langVar('lang_stats.btn.none')}];
			
			for (var i = 0; i < itemsDb.length; i++) {
				
				var item = itemsDb[i];
				var itemDat = item.dat;
				
				if (item.id != selectedItemId) {
					a[a.length] = {name:itemDat.node_name, label:itemDat.label};
				}
			}
			
			util.populateSelect('db_fields:source_database_field', a, 'name', 'label');
			
			dbFields.activeForm.updateSourceDatabaseFieldsListDone = true;
		}
	},
	
	
	getIsHierarchicalDatabaseField: function(dbFieldType, logFieldName) {
		
		var isHierarchicalDatabaseField = false;
		
		if (dbFieldType == 'string' && logFieldName != '') {
			
			var logFieldItem = dbFields.logFieldsDb[util.h(logFieldName)];
			var logFieldType = logFieldItem.type;
			
			isHierarchicalDatabaseField = (logFieldType != 'flat' && logFieldType != 'agent');
		}
		
		return isHierarchicalDatabaseField;
	},
	
	setAlwaysIncludeBottomLevelItemsDisplay: function(dbFieldType, logFieldName) {
		
		// Show always_include_bottom_level_items section if the log field is hierarchical, else hide the section
		var isHierarchicalDatabaseField = dbFields.getIsHierarchicalDatabaseField(dbFieldType, logFieldName);
		util.showE('db_fields:always_include_bottom_level_items_section', isHierarchicalDatabaseField);
	},

    updateItemnumsHashFunctionDisplay: function() {

        var type = util.getF('db_fields:type');
        var aggregationMethod = util.getF('db_fields:aggregation_method');
        var isDisplay = ((type == 'string' && aggregationMethod == 'none') ||
            (type == 'unique' && aggregationMethod == 'unique'));

        util.showE('db_fields:itemnums_hash_function_section', isDisplay);
    },
	

	//
	// updateListLabel
	//
	
	updateListLabelActor: function() {
		
		setTimeout('dbFields.updateListLabel()', 300);
	},
	
	updateListLabel: function() {
		
		var label =  util.getF('db_fields:label');
		
		if (label == '') {
			label = '-';
		}
		
		dbFields.theList.updateListLabel(label);
	},
	
	getIsModifiedPage: function() {
		
		if (!dbFields.validateActiveItem() || dbFields.theList.getIsModified()) {
			return true;
		}
		return false;
	}
};
