//
// emailReport
//


var emailReport = {
	
	panel: null,
	addressControl: null,
	validator: null,
	
	defaultDat: null, // keeps default data from server response
	
	// active smtp_server values
	isSMTPServerEdit: false, // Set to true if SMPT server has been edited
	smtpServer: '',
	smtpUsername: '',
	smtpPassword: '',
	
	// Properties used in validate(), respectively read from here when sending
	returnAddress: '',
	subject: '',
	
	isCommentDisplay: false,
		
	init: function() {
		
		var YE = YAHOO.util.Event;
		
		var panelObj = {
			panelId: 'email_report:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_stats.email_report.email_report'),
			left: 100,
			top: 50,
			zIndex: 20,
			isCover: true,
			closeEvent: emailReport.close
		};

		emailReport.panel = new util.Panel3(panelObj);
		emailReport.validator = new util.Validator();
		
		// Build email form elements
		emailReport.buildForm();
		emailReport.addressControl = new emailUtil.AddressControl('email_report:address_control:container', 440);
		
		YE.addListener('email_report:send_btn', 'click', emailReport.send);
		YE.addListener('email_report:cancel_btn', 'click', emailReport.close);
		YE.addListener('email_report:comment:btn', 'click', emailReport.toggleComment);
		
		// Handle Edit SMTP
		var isRootAdmin = reportInfo.isRootAdmin;
		util.showE('email_report:edit_smtp_btn', isRootAdmin);
		
		if (isRootAdmin) {
			YE.addListener('email_report:edit_smtp_btn', 'click', smtp.open);
		}
	},
		
	open: function() {
		
		if (emailReport.panel == null) {
			emailReport.init();
		}
		else {
			// Form was already open, re-enable visibility
			util.showEV('email_report:form');
		}
		
		emailReport.resetForm();
		
		if (emailReport.defaultDat == null) {
			emailReport.getEmailDb();
			emailReport.disableForm();
		}
		else {
		
			emailReport.updateForm();
		}
		
		emailReport.panel.open();
	},
	
	getEmailDb: function() {
		
		var url = '?dp=statistics.email.get_email_db';
		url += '&p=' + reportInfo.profileName;
		
		var dat = 'v.fp.page_token=' + reportInfo.pageToken;
		dat += '&v.fp.report_name=' + reportInfo.reportName;
		
		util.serverPost(url, dat);
	},
	
	getEmailDbResponse: function(dat) {
		
		// alert('getEmailDbResponse()');
		emailReport.defaultDat = dat;
		emailReport.updateForm();
	},
	
	resetForm: function() {
		
		util.setF('email_report:return_address', '');
		util.setF('email_report:subject', '');
		util.setF('email_report:comment', '');
		
		if (emailReport.isCommentDisplay) {
			emailReport.toggleComment();
		}
		
		emailReport.addressControl.reset();
	},
	
	updateForm: function() {
		
		emailReport.disableForm(false);
		
		var dat = emailReport.defaultDat;
		
		util.setF('email_report:return_address', dat.returnAddress);
		util.setF('email_report:subject', dat.subject);
		util.setF('email_report:save_recipient_addresses_as_default', dat.saveRecipientAddressesAsDefault);
		util.setF('email_report:comment', '');
		
		emailReport.smtpServer = dat.smtpServer;
		emailReport.smtpUsername = dat.smtpUsername;
		
		emailReport.addressControl.init(dat.defaultAddresses);
	},
	
	disableForm: function(isDisable) {
		
		// Not is use because IE6 has a layout problem!
		
		// isDisable is optional
		var makeDisabled = (isDisable != null) ? isDisable : true;
		
		var a = [
			'email_report:return_address',
			'email_report:subject',
			'email_report:comment',
			'email_report:save_recipient_addresses_as_default',
			'email_report:send_btn',
			'email_report:edit_smtp_btn'
		];
		
		util.disableE(a, makeDisabled);
		emailReport.addressControl.disable(makeDisabled);
	},
	
	close: function() {
		
		util.hideE('delivering_mail_info');
		emailReport.panel.close();
	},
	
	send: function() {
		
		if (emailReport.validate()) {
			
			emailReport.setDisplayToDelivery();
			
			var url = '?dp=statistics.email.email_report_setup';
			url += '&p=' + reportInfo.profileName;
			
			var dat = 'v.fp.page_token=' + reportInfo.pageToken;
			dat += '&v.fp.report_job_id=' + reportInfo.reportJobId;
			dat += '&v.fp.report_name=' + reportInfo.reportName;
			
			// Check smtp_server
			var isSMTPServerEdit = emailReport.isSMTPServerEdit
			dat += '&v.fp.is_smtp_server_edit=' + isSMTPServerEdit;
			
			if (isSMTPServerEdit) {
				dat += '&v.fp.smtp_server=' + emailReport.smtpServer;
				dat += '&v.fp.smtp_username=' + emailReport.smtpUsername;
				dat += '&v.fp.smtp_password=' + emailReport.smtpPassword;
			}
			
			dat += '&v.fp.save_recipient_addresses_as_default=' + util.getF('email_report:save_recipient_addresses_as_default');
			dat += '&v.fp.return_address=' + encodeURIComponent(emailReport.returnAddress);
			dat += '&v.fp.report_email_subject=' + encodeURIComponent(emailReport.subject);
			
			var comment = (emailReport.isCommentDisplay) ? util.getF('email_report:comment') : '';
			dat += '&v.fp.comment=' + encodeURIComponent(comment);
			
			var addresses = emailReport.addressControl.getAddresses();
			
			for (var i = 0; i < addresses.length; i++) {
				
				var item = addresses[i];
				var path = '&v.fp.addresses.' + i;
				
				dat += path + '.type=' + item.type;
				dat += path + '.address=' + encodeURIComponent(item.address);
			}
			
			util.serverPost(url, dat);
		}
	},
	
	setDisplayToDelivery: function() {
		
		util.hideEV('email_report:form');
		
		// Set delivering mail element
		var region = YAHOO.util.Dom.getRegion('email_report:form');
		// util.showObject(region);
		var element = util.getE('delivering_mail_info');
		element.style.position = 'absolute';
		element.style.top = region.top + 'px';
		element.style.left = region.left + 'px';
		element.style.zIndex = '200';
		element.style.display = 'block';
	},
	
	sendResponse: function() {
		
		// alert('sendResponse()');
		
		// Clear default data so that we get the latest dataset upon re-sending
		emailReport.defaultDat = null;
		emailReport.isSMTPServerEdit = false;
		
		emailReport.close();
	},
	
	validate: function() {
		
		var validator = emailReport.validator;
		validator.reset();
		
		emailReport.returnAddress = validator.isValue('email_report:return_address');
		emailReport.returnAddress = validator.isEmailAddress('email_report:return_address');
		emailReport.subject = validator.isValue('email_report:subject');
		
		isValidRecipientAddress = emailReport.addressControl.validate();
		
		if (validator.allValid() && isValidRecipientAddress) {
			
			// Check SMTP server
			if (emailReport.smtpServer != '') {
				return true;
			}
			else {
				alert(langVar('lang_stats.email_report.no_smtp_server_defined_msg'));
			}
		}
		
		return false;
	},
	
	toggleComment: function() {
		
		var showComment = !emailReport.isCommentDisplay;
		util.showE('email_report:comment:row', showComment);
		emailReport.isCommentDisplay = showComment;
		
		var text = showComment ? langVar('lang_stats.email_report.remove_comment') : langVar('lang_stats.email_report.add_comment');
		util.updateT('email_report:comment:btn', text);
	},
	
	//
	// Build form utilities
	//
	
	buildForm: function() {
		
		var container = util.getE('email_report:container');
		var table = util.createE('table');
		var tbody = util.createE('tbody');
		
		emailReport.buildEmailSamplePart(tbody);
		emailReport.buildReturnAddressPart(tbody);
		emailReport.buildRecipientAddressPart(tbody);
		emailReport.buildSubjectPart(tbody);
		emailReport.buildCommentPart(tbody);
		emailReport.buildMiscControls(tbody);
		
		util.chainE(container, table, tbody);
	},
	
	buildEmailSamplePart: function(tbody) {
		
		var tr = util.createE('tr');
		var th = util.createE('th', {className:'field-sample'});
		var td = util.createE('td', {className:'field-sample'});
		var thText = util.createT('&nbsp;');
		var tdText = util.createT(langVar('lang_stats.email_report.address_format_example'));
		
		util.chainE(tbody, [tr, [th, thText], [td, tdText]]);
	},
	
	buildReturnAddressPart: function(tbody) {

		var tr = util.createE('tr');
		var th = util.createE('th');
		var td = util.createE('td');
		var text = util.createT(langVar('lang_stats.email_report.from') + ':');
		var input = util.createE('input', {id:'email_report:return_address', type:'text', value:'', width:'400px'});
		var div = util.createE('div', {id:'email_report:return_address:error', className:'form-error'});
		
		util.chainE(tbody, [tr, [th, text], [td, input, div]]);
	},
	
	buildRecipientAddressPart: function(tbody) {
		
		var tr = util.createE('tr');
		var th = util.createE('th', {paddingTop:'5px', verticalAlign:'top'});
		var td = util.createE('td', {id:'email_report:address_control:container', paddingTop:'5px'});
		var text = util.createT(langVar('lang_stats.email_report.recipients') + ':');
		
		util.chainE(tbody, [tr, [th, text], td]);
	},
	
	buildSubjectPart: function(tbody) {
		
		// Subject row
		var tr = util.createE('tr');
		var th = util.createE('th', {paddingTop:'18px'});
		var td =  util.createE('td', {paddingTop:'18px'});
		var text = util.createT(langVar('lang_stats.email_report.subject') + ':');
		var input = util.createE('input', {id:'email_report:subject', type:'text', value:'', width:'440px'});
		var div = util.createE('div', {id:'email_report:subject:error', className:'form-error'});
		
		util.chainE(tbody, [tr, [th, text], [td, input, div]]);
	},
	
	buildCommentPart: function(tbody) {
		
		var tr = util.createE('tr', {id:'email_report:comment:row', display:'none'});
		var th = util.createE('th', {paddingTop:'5px', verticalAlign:'top'});
		var td = util.createE('td', {paddingTop:'5px'});
		var text = util.createT(langVar('lang_stats.email_report.comment') + ':');
		var textArea = util.createE('textarea', {id:'email_report:comment', width:'440px', height:'90px'});
		
		util.chainE(tbody, [tr, [th, text], [td, textArea]]);
	},
		
	buildMiscControls: function(tbody) {
		
		// We use a nested table for Add/Remove comment and Remember recipients for this profile
		
		var tr = util.createE('tr');
		var th = util.createE('th');
		var td = util.createE('td', {paddingTop:'21px'});
		
		emailReport.buildMiscNestedControls(td);
		
		util.chainE(tbody, [tr, th, td]);
	},
	
	buildMiscNestedControls: function(tdContainer) {
		
		var table = util.createE('table', {cellSpacing:0});
		var tbody = util.createE('tbody');
		var tr = util.createE('tr');
		
		var td = util.createE('td', {verticalAlign:'baseline'});
		var a = util.createE('a', {id:'email_report:comment:btn', href:'javascript:;'});
		var aText = util.createT(langVar('lang_stats.email_report.add_comment'));

		var id = 'email_report:save_recipient_addresses_as_default';
		var td2 = util.createE('td', {paddingLeft:'18px', verticalAlign:'baseline'});
		var input = util.createE('input', {id:id, type:'checkbox'});
		var label = util.createE('label', {htmlFor:id});
		var labelText = util.createT(' ' + langVar('lang_stats.email_report.remember_recipients'));
		
		util.chainE(label, labelText);
		util.chainE(tdContainer, table, tbody, [tr, [td, [a, aText]], [td2, input, label]]);
	}
}
