//
// databaseUtil - a collection of database server validation utilities
//

var databaseUtil = function() {

	function getIsValidMysqlDatabaseName(databaseName) {

		var isValid = false,
			errorMessage = '';

		if (databaseName.length > 64) {
			errorMessage = langVar('lang_admin.database.mysql_max_length_msg');
		}
		else if (/[\.\/\\]/.test(databaseName)) {
			errorMessage = langVar('lang_admin.database.mysql_invalid_char_msg');
		}
		else {
			isValid = true;
		}

		return {isValid:isValid, errorMessage:errorMessage};
	}

	function getIsValidOdbcMssqlDatabaseName(databaseName) {

		// odbc_mssql (MS SQL Server)
		// must be <= 128 characters
		// and must match the following rule (added on 09/Jan/2013 by KHP):
		// the name must start with a Unicode letter, _, @, or #; followed by one
		// or more letters, numbers, @, $, #, or _. The documentation clearly
		// states that embedded spaces or special characters are not allowed.

		var isValid = false,
			errorMessage = '',
			pattern = unicode_hack(/^(\p{L}|[_@#]){1}(\p{L}|[0-9_@$#])+$/); // \p{L} matches any unicode letter, this requires the unicode_hack utility

		if (databaseName.length > 128) {

			errorMessage = langVar('lang_admin.database.mssql_max_length_msg');
		}
		else if (!pattern.test(databaseName)) {

			errorMessage = langVar('lang_admin.database.mssql_name_definition_msg');
		}

		isValid = (errorMessage == '');

		return {isValid:isValid, errorMessage:errorMessage};
	}

	function getIsValidDatabaseName(serverType, databaseName) {

		// This validates the databaseName. We assume that the server side
		// uses quoted database names, which means almost any string is allowed.
		// So this covers basic validation required for quoted and unquoted
		// database names.

		if (serverType == 'mysql') {

			return getIsValidMysqlDatabaseName(databaseName);
		}
		else {

			// serverType is odbc_mssql
			return getIsValidOdbcMssqlDatabaseName(databaseName);
		}
	}

	// Return global properties and methods

	return {
		getIsValidDatabaseName: getIsValidDatabaseName
	}

}();
	
