//
// preferences
//
var theList;
var itemsDb = [];  // items work array
var itemsDbBackup = []; // items array in the state when first loaded or last saved, it is used upon Undo Changes
var saveChangesBtn = null;
var undoAllChangesBtn = null;
var validator = new util.Validator();
var defaultMaxMemUsageSize = {number:0, unit:''};
function getPreferencesData() {
	if (!pageInfo.exitActive) {
		var url = '?dp=admin_pages.preferences.get_data';
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		util.serverPost(url, dat);
	}
}
function getPreferencesDataResponse(dat) {
	if (!pageInfo.exitActive) {
		// get itemsDb
		itemsDb = dat;
		itemsDbBackup = util.cloneObject(dat);
		// util.showObject(itemsDb);
		// Init
		init();
		initItems();
		util.showE('form_section');
		adminConfig.setItemListSize();
		YAHOO.util.Event.addListener(window, 'resize', adminConfig.setItemListSize);
		pageInfo.initComplete = true;
	}
}
function init() {
	var YE = YAHOO.util.Event;
	saveChangesBtn = new util.ToolbarButton('save_changes', savePreferences, toolbarButtonsDb);	
	undoAllChangesBtn = new util.ToolbarButton('undo_all_changes', undoAllChanges, toolbarButtonsDb);
	YE.addListener('password:password_expires', 'click', togglePasswordExpires);
	YE.addListener('password:prevent_use_of_previous_passwords', 'click', togglePreventUseOfPreviousPasswords);
	YE.addListener('server:maximum_memory_usage_size:number', 'keypress', enableCustomMaxMemoryUsage);
	saveChangesBtn.enable();
	undoAllChangesBtn.enable();
	if (pageInfo.permissions.isEdit) {
		// Register isModifiedPageHandler in adminConfig.js
		// (We don't check for modifications if there is no edit 
		// permission because there is no Save button anyway!)
		adminConfig.getIsModifiedPageHandler = getIsModifiedPage;
	}
	// Init help
	util.helpWindow.init('');
	// init OptionInfo
	optionInfo.init();
	// Create the list object
	theList = new listcontroller.List({
		containerElementId: 'item_list_body',
		itemEvent: itemActivated
	});
}
function initItems() {
	// Sets all input controls to initial itemsDb values
	// Also used upon Undo Changes
	//
	//	Init item list
	//
	// util.showObject(itemsDb);
	theList.init(itemsDb);
	// util.showObject(theList);
	setItem('i0');
	//
	// Init form data
	//
	for (var i = 0; i < itemsDb.length; i++) {
		var itemType = itemsDb[i].type;
		var itemDat = itemsDb[i].dat;
		// alert('itemType: ' + itemType);
		// util.showObject(itemDat);
		switch (itemType) {
			case 'server':
				// util.showObject(itemDat);
				initServerItems(itemDat);
				break;
			case 'security_permissions':
				initSecurityPermissionsItems(itemDat);
				break;
			default:
				initStandardItems(itemType, itemDat);
				break;
		}
	}
	//
	// Set password enabled/disabled field state
	//
	togglePasswordExpires();
	togglePreventUseOfPreviousPasswords();
}
function initServerItems(itemDat) {
	var numberOfItems = itemDat.length;
	var maxMemUsageType = '';
	var maxMemUsageSize = {};
	for (var i = 0; i < numberOfItems; i++) {
		var name = itemDat[i].name;
		var value = itemDat[i].value;
		if (name == 'maximum_memory_usage_type') {
			maxMemUsageType = value;
		}
		else if (name == 'maximum_memory_usage_size') {
			maxMemUsageSize = value;
			// Keep maxMemUsageSize for default value
			defaultMaxMemUsageSize.number = maxMemUsageSize.number;
			defaultMaxMemUsageSize.unit = maxMemUsageSize.unit;
		}
		else {
			var elementId = 'server:' + name;
			util.setF(elementId, value);
		}
	}
	// Set maximum memory usage
	util.setF('server:maximum_memory_usage_type:' + maxMemUsageType, true);
	// var maxMemUsageSizeNumber = (maxMemUsageType == 'custom') ? maxMemUsageSize.number : '';
	// var maxMemUsageSizeUnit = (maxMemUsageType == 'custom') ? maxMemUsageSize.unit : 'MB';
	util.setF('server:maximum_memory_usage_size:number',  maxMemUsageSize.number);
	util.setF('server:maximum_memory_usage_size:unit', maxMemUsageSize.unit);
}
function initSecurityPermissionsItems(itemDat) {
	var numberOfItems = itemDat.length;
	for (var i = 0; i < numberOfItems; i++) {
		var name = itemDat[i].name;
		var value = itemDat[i].value;
		// set permission checkboxes
		var checkboxBitValues = octalToBit(value);
		var numberCheckboxBitValues = checkboxBitValues.length;
		for (var j = 0; j < numberCheckboxBitValues; j++) {
			var elementId = 'security:' + name + ':bit' + j; // j is equal bit number
			util.setF(elementId, checkboxBitValues[j]);
		}
	}
}
function initStandardItems(itemType, itemDat) {
	var numberOfItems = itemDat.length;
	for (var i = 0; i < numberOfItems; i++) {
		var name = itemDat[i].name;
		var value = itemDat[i].value;
		if (name != 'login_plugins') {
			var idPrefix = itemType.indexOf('email_') == -1 ? itemType : 'email';
			var elementId = idPrefix + ':' + name;
			util.setF(elementId, value);
		}
		else {
			initLoginPlugins(value);
		}
	}
}
function initLoginPlugins(items) {
	for (var i = 0, len = items.length; i < len; i++) {
		var item = items[i];
		var itemId = 'security:login_plugin:' + item.name;
		util.setF(itemId, item.isActive);
	}
}
function togglePasswordExpires() {
	// Enable/disable days_until_password_expiration input field
	var isPasswordExpires = util.getF('password:password_expires');
	util.enableE('password:days_until_password_expiration', isPasswordExpires);
}
function togglePreventUseOfPreviousPasswords() {
	// Enable/disable number_of_previous_passwords_to_check input field
	var isPreventUseOfPreviousPasswords = util.getF('password:prevent_use_of_previous_passwords');
	util.enableE('password:number_of_previous_passwords_to_check', isPreventUseOfPreviousPasswords);
}
function enableCustomMaxMemoryUsage() {
	// User typed value in custom field, make 'Custom' checked
	util.setF('server:maximum_memory_usage_type:custom', true);
}
function itemActivated(itemId) {
	if (validateActiveItem()) {
		setItem(itemId);
	}
}
function setItem(itemId) {
	theList.selectItem(itemId);
	displayForm(itemId);
}
function displayForm(itemId) {
	var item = theList.getSelectedItem();
	var itemType = item.type;
	// Hide all forms
	var a = ['miscellaneous', 'server', 'security', 'password', 'security_permissions', 'email_smtp', 'email_miscellaneous', 'email_command_line'];
	for (var i = 0; i < a.length; i++) {
		util.hideE(a[i] + ':form');
	}
	util.showE(itemType + ':form');
	util.updateT('item_form_label', item.label);
}
function validateActiveItem() {
	// Only validate if isEdit permission
	if (pageInfo.permissions.isEdit) {
		validator.reset();
		var activeItem = theList.getSelectedItem();
		var itemType = activeItem.type;
		// For each itemType get a copy of item.dat and override it with form values
		// which will then be saved back to item.dat upon data change.
		var formDat = util.cloneObject(activeItem.dat);
		if (itemType != 'security_permissions') {
			validate_standard_items(itemType, formDat);
		}
		else {
			validate_security_permissions_items(formDat);
		}	
		if (validator.allValid()) {
			// util.showObject(formDat);
			theList.saveItem(formDat);
			// util.showObject(theList);
			return true;
		}
		return false;
	}
	// No isEdit permission
	return true;
}
function validate_standard_items(itemType, formDat) {
	// Save all form data which requires validation in "o",
	// then override formDat with actual data
	function getEmailAddress(elementId) {
		var emailAddress = '';
		if (util.getF(elementId) != '') {
			emailAddress = validator.isEmailAddresses(elementId);
		}
		return emailAddress;
	}
	var idPrefix = itemType.indexOf('email_') == -1 ? itemType : 'email';
	var o = {};
	switch (itemType) {
		case 'miscellaneous': 
			o.temporary_files_lifespan = validator.isInteger('miscellaneous:temporary_files_lifespan', 0);
			break;
		case 'server':
			o.web_server_port = validator.isInteger('server:web_server_port', 0, 65535);
			o.maximum_number_of_threads = validator.isInteger('server:maximum_number_of_threads', 1);
			o.cgi_directory = validator.isValue('server:cgi_directory');
			o.maximum_memory_usage_size = {};
			// Validate maximum_memory_usage_size
			if (util.getF('server:maximum_memory_usage_type:custom')) {
				o.maximum_memory_usage_type = 'custom';
				o.maximum_memory_usage_size.number = validator.isInteger('server:maximum_memory_usage_size:number', 1);
				o.maximum_memory_usage_size.unit = util.getF('server:maximum_memory_usage_size:unit');
			}
			else {
				if (util.getF('server:maximum_memory_usage_type:auto_shared')) {
					o.maximum_memory_usage_type = 'auto_shared';
				}
				else {
					o.maximum_memory_usage_type = 'auto_dedicated';
				}
				// Use default values for maximum_memory_usage_size
				o.maximum_memory_usage_size.number = defaultMaxMemUsageSize.number;
				o.maximum_memory_usage_size.unit = defaultMaxMemUsageSize.unit;
			}
			break;
		case 'security':
			// o.security_mode = util.getF('security:browse_and_modify') ? 'browse_and_modify' : 'browse_only';
			o.server_session_timeout = validator.isInteger('security:server_session_timeout', 0);
			o.administrative_remote_user = validator.isValue('security:administrative_remote_user');
			break;
		case 'password':
			// Validate days_until_password_expiration only if expiration is checked!
			if (util.getF('password:password_expires')) {
				o.days_until_password_expiration = validator.isInteger('password:days_until_password_expiration', 0, 65535);
			}
			o.minimum_length = validator.isInteger('password:minimum_length', 0, 65535);
			// Validate number_of_previous_passwords_to_check only  if prevent_use_of_previous_passwords is checked
			if (util.getF('password:prevent_use_of_previous_passwords')) {
				o.number_of_previous_passwords_to_check = validator.isInteger('password:number_of_previous_passwords_to_check', 0, 65535);
			}
			break;
		case 'email_miscellaneous':
			o.support_email_address = getEmailAddress('email:support_email_address');
			o.global_actions_email_address = getEmailAddress('email:global_actions_email_address');
			o.global_actions_return_address = getEmailAddress('email:global_actions_return_address');
			break;
		case 'email_command_line':
			o.return_address = getEmailAddress('email:return_address');
			o.recipient_address = getEmailAddress('email:recipient_address');
			o.cc_address = getEmailAddress('email:cc_address');
			o.bcc_address = getEmailAddress('email:bcc_address');
			break;
	}
	var numberOfItems = formDat.length;
	for (var i = 0; i < numberOfItems; i++) {
		var item = formDat[i];
		var name = item.name;
		switch(name) {
			case 'login_plugins':
				validateLoginPluginsValues(item.value);
				break;
			case 'maximum_memory_usage_size':
				// Handle maximum_memory_usage_size
				item.value.number = o.maximum_memory_usage_size.number;
				item.value.unit = o.maximum_memory_usage_size.unit;
				break;
			default:
				if (o[name] != null) {
					// Get validated value
					item.value = o[name];
				}
				else {
					// Get form value
					item.value = util.getF(idPrefix + ':' + name);
				}
				break;
		}
	}
}
function validateLoginPluginsValues(items) {
	for (var i = 0, len = items.length; i < len; i++) {
		var item = items[i];
		var itemId = 'security:login_plugin:' + item.name;
		item.isActive = util.getF(itemId, item.isActive);
	}
}
function validate_security_permissions_items(formDat) {
	var numberOfItems = formDat.length;
	for (var i = 0; i < numberOfItems; i++) {
		var name = formDat[i].name;
		// get octal value for permissions
		var octalValueOri = formDat[i].value;
		var octalSum = 0;
		var bitToOctalMap = [1, 2, 4, 10, 20, 40, 100, 200, 400, 1000];
		for (var j = 0; j < 10; j++) {
			var elementId = 'security:' + name + ':bit' + j; // j is equal bit number
			if (util.getF(elementId)) {
				// if checked add the corresponding bit value to the sum
				octalSum += bitToOctalMap[j];
			}
		}
		// Note, the octalSum must be of type string!
		formDat[i].value = octalSum.toString();
	}
}
function getLoginPluginsDat(items) {
	// Note, login_plugins are not saved within security but become
	// a separate node.
	var path = 'v.fp.login_plugins';
	var dat = '';
	for (var i = 0, len = items.length; i < len; i++) {
		var item = items[i];
		// Only add active items
		if (item.isActive) {
			dat += path + '.' + item.name + '=true&';
		}
	}
	// Set empty login_plugins node if no plugin is active
	if (dat == '') {
		dat += path + '=&';
	}
	return dat;
}
function savePreferences() {
	if (validateActiveItem()) {
		var isModified = theList.getIsModified();
		// alert('saveChanges() - isModified: ' + isModified);
		if (isModified) {
			util.hideE('form_section');
			util.showE('saving_info');
			var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
			// util.showObject(itemsDb);
			for (var i = 0, len = itemsDb.length; i < len; i++) {
				var itemType = itemsDb[i].type;
				var itemDat = itemsDb[i].dat;
				// var path = (itemType != 'security_permissions') ? 'v.fp.' + itemType : 'v.fp.security';
				var path = '';
				if (itemType.indexOf('email_') != -1) {
					path = 'v.fp.email'
				}
				else if (itemType == 'security_permissions') {
					path = 'v.fp.security';
				}
				else {
					path = 'v.fp.' + itemType;
				}
				for (var j = 0; j < itemDat.length; j++) {
					var name = itemDat[j].name;
					var value = itemDat[j].value;
					if (name != 'login_plugins') {
						if (name == 'maximum_memory_usage_size') {
							// Get bytes value
							value = value.number + value.unit;
						}
						dat += path + '.' + name + '=' + value + '&';
					}
					else {
						dat += getLoginPluginsDat(value);
					}
				}
			}
			dat = dat.replace(/&$/, '');
			// alert('dat:\n' + dat);
			var url = '?dp=admin_pages.preferences.save_data';	
			util.serverPost(url, dat);
		}
		else {
			alert(langVar('lang_stats.general.no_changes_to_save'));
		}
	}
}
function savePreferencesResponse(languageChanged) {
	if (!languageChanged) {
		// reset isModified
		theList.resetIsModified();
		// the saved work itemsDb becomes now the itemsDbBackup
		itemsDbBackup = util.cloneObject(itemsDb);
		util.hideE('saving_info');
		util.showE('form_section');
	}
	else {
		// reload the page to display the new language
		location.reload(true);
	}
}
function undoAllChanges() {
	itemsDb = util.cloneObject(itemsDbBackup);
	initItems();
}
function getIsModifiedPage() {
	// Note, isModified will be false if only the active item has been edited
	// but has an error, hence we also check "if (!validateActiveItem() ..."
	// alert('getIsModifiedPage() - theList.getIsModified(): ' + theList.getIsModified());
	if (!validateActiveItem() || theList.getIsModified()) {
		return true;
	}
	return false;
}
function octalToBit(octalString) {
	var octalToBinaryMap = ['000', '001', '010', '011', '100', '101', '110', '111'];
	var octalNumbers = octalString.split('');
	var binaryString = '';
	for (var i = 0; i < octalNumbers.length; i++) {
		var theOctal = parseInt(octalNumbers[i], 10);
		binaryString += octalToBinaryMap[theOctal];
	}
	var binaryArray = binaryString.split('');
	binaryArray.reverse(); // bit0 is now equal array index 0
	// map the binary value to checkbox true/false values,(bit0 matches 0 array index)
	var checkboxBits = [];
	for (var i = 0; i < 10; i++) {
		var bitValue = (binaryArray[i] != null) ? binaryArray[i] : 0;
		bitValue = (parseInt(bitValue, 10) == 1);
		checkboxBits[i] = bitValue;
	}
	// alert('binaryString: ' + binaryString + '\nbinaryArray reversed: ' + binaryArray + '\ncheckboxBits: ' + checkboxBits);
	return checkboxBits;
}
