//
//
// passwordReset.js
//
//
var passwordReset = function() {
	var YE = YAHOO.util.Event;
	var validator;
	function init() {
		validator = new util.Validator();
		YE.addListener(['password_reset:new_password', 'password_reset:new_password_2'], 'keypress', processFormViaEnterKey);
		YE.addListener('password_reset:submit_btn', 'click', processForm);
	}
	function processFormViaEnterKey(evt) {
		var keyCode = (evt.which) ? evt.which : evt.keyCode;
		if (keyCode == 13 || keyCode == 3) {
			processForm();
		}
	}
	function processForm() {
		validator.reset();
		var newPassword = validator.isValue('password_reset:new_password');
		var newPassword2 = validator.isValue('password_reset:new_password_2');
		if (newPassword != '') {
			var customErrorMessage = '';
			// Check for password_validation_rules object, it
			// only exists for non-root-admins.
			if (password_validation_rules) {
				var passwordCheck = passwordUtil.validatePassword(password_validation_rules, newPassword);
				if (!passwordCheck.isValid) {
					customErrorMessage = passwordCheck.errorMessage;
					validator.isCustom('password_reset:new_password', customErrorMessage);
				}
			}
			// If no custom error yet
			if (customErrorMessage == '' && newPassword != newPassword2) {
				customErrorMessage = langVar('lang_stats.authentication.invalid_retyped_password');
				validator.isCustom('password_reset:new_password_2', customErrorMessage);
			}
		}
		if (validator.allValid()) {
			util.hideE(['password_reset:error_message', 'password_reset:form']);
			util.showE('password_reset:loading');
			var accessCode = util.getF('password_reset:access_code');
			var url = '?dp=authentication';
			var dat = 'v.fp.is_password_reset_form_processing=true&'
			dat += 'v.fp.access_code=' + encodeURIComponent(accessCode) + '&';
			dat += 'v.fp.new_password=' + encodeURIComponent(newPassword);
			util.serverPost(url, dat);
		}
	}
	function processFormResponse(dat) {
		util.hideE('password_reset:loading');
		if (dat.errorMessage == '') {
			util.showE('password_reset:new_password_saved_info');
		}
		else {
			util.updateT('password_reset:error_message', dat.errorMessage);
			util.showE(['password_reset:error_message', 'password_reset:form']);
		}
	}
	//
	//
	// Return global properties and methods
	//
	//
	return {
		init:init,
		processFormResponse: processFormResponse
	}
}();
YAHOO.util.Event.onDOMReady(passwordReset.init);
