//
// reportsMenu.js
// reportsMenu.js is used in dynamic and static reports!
//
var reportsMenu = {
	isVisible: true,
	isDynamicReport: false, // set upon init to distingusish between dynamic and static reports
	init: function(isDynamicReport) {
		// alert('reportsMenuDb: ' + reportsMenuDb.length);
		reportsMenu.isDynamicReport = isDynamicReport;
		reportsMenu.createMenuHash();
		// Position the reports menu
//		var reportsRegion = YAHOO.util.Dom.getRegion('reports_menu_and_report_section');
//		var menuContainer = util.getE('reports_menu_section');
		var menuItemsContainer = util.getE('reports_menu_items');
		// alert('reportsRegion.top: '  + reportsRegion.top);
//		menuContainer.style.top = reportsRegion.top + 'px';
		var ul = document.createElement('ul');
		menuItemsContainer.appendChild(ul);
		// util.showObject(reportsMenuDb);
		reportsMenu.buildMenuItems(reportsMenuDb, '', reportInfo.reportName, reportInfo.isCalendar, false, ul);
		if (isDynamicReport) {
			reportsMenu.updateMenuItemLinks(
				reportsMenuDb,
				reportInfo.dateFilter,
				reportInfo.commandLineFilter,
				reportInfo.commandLineFilterComment,
				reportInfo.filterId,
				''
			);
		}
		else {
			reportsMenu.updateStaticMenuItemLinks(reportsMenuDb);
		}
		// Set initial expanded group state. Note, we keep the final expanded group state in reportsMenuDb
		// and not in reportInfo.expandedMenuGroups. reportInfo.expandedMenuGroups is only used for the initial
		// menu setup!
		var expandedMenuGroups = reportInfo.expandedMenuGroups;
		for (var i = 0; i < reportsMenuDb.length; i++) {
			if (reportsMenuDb[i].type == 'group') {
				var groupName = reportsMenuDb[i].name;
				if (expandedMenuGroups[groupName] != null) {
					reportsMenuDb[i].isExpanded = true;
					reportsMenu.expandCollapseGroup(reportsMenuDb[i]);
				}
				else {
					reportsMenuDb[i].isExpanded = false;
				}
			}
		}
		// Assign toggleMenu event
		// YAHOO.util.Event.addListener('reports_menu_switch', 'click', reportsMenu.toggleSidebar);
	},
	createMenuHash: function() {
		// Create a hash so that we can access the menu items and menu subitems by itemId
		for (var i = 0; i < reportsMenuDb.length; i++) {
			var item = reportsMenuDb[i];
			var itemId = item.id;
			reportsMenuDb[itemId] = item;
			if (item.type == 'group') {
				var subItems = item.items;
				for (var j = 0; j < subItems.length; j++) {
					var subItemId = subItems[j].id;
					reportsMenuDb[subItemId] = subItems[j];
				}
			}
		}
	},
	buildMenuItems: function(menuItems, menuGroupName, activeReportName, isCalendar, isItemInGroup, ul) {
		// If the active report is part of a menu group then add the menu group name
		// to reportInfo.expandedMenuGroups so that the group becomes expanded.
		// reportInfo.expandedMenuGroups may contains any expanded menu group names from
		// the previous reports display if this report has been called via a server
		// background call. By default we hide any report menu item of a group
		// util.showObject(menuItems);
		for (var i = 0; i < menuItems.length; i++) {
			var item = menuItems[i];
			var itemType = item.type;
			if (itemType == 'group') {
				// Create the group item
				reportsMenu.addMenuLiItem(ul, itemType, item.id, item.label, false, false);
				// Create the items in group
				reportsMenu.buildMenuItems(item.items, item.name, activeReportName, isCalendar, true, ul);
			}
			else {
				var isActiveMenuItem = false;
				if (itemType == 'report') {
					if (item.name == activeReportName) {
						isActiveMenuItem = true;
						if (isItemInGroup) {
							// add menu group name to reportInfo.expandedMenuGroups
							reportInfo.expandedMenuGroups[menuGroupName] = true;
						}
					}
				}
				else if (isCalendar) {
					// itemType is calendar and calendar is active
					isActiveMenuItem = true;
				}
				reportsMenu.addMenuLiItem(ul, itemType, item.id, item.label, isActiveMenuItem, isItemInGroup);
			}
		}
	},
	addMenuLiItem: function(ul, itemType, itemId, label, isActiveMenuItem, isItemInGroup) {
		// itemType: calendar | report | group
		var YE = YAHOO.util.Event;
		var li = document.createElement('li');
		li.id = 'reports_menu:li:' + itemId;
		var a = document.createElement('a');
		a.id = 'reports_menu:a:' + itemId;
		var img = document.createElement('img');
		img.width = 10;
		img.height = 12;
		img.alt = '';
		if (itemType == 'report') {
			img.src = imgDb.rmReport.src;
		}
		else if (itemType == 'group') {
			// li.style.fontWeight = 'bold';
			img.id = 'reports_menu:img:' + itemId;
			img.src = imgDb.rmExpand.src;
		}
		else {
			img.src = imgDb.rmCalendar.src;
		}
		// We create the span as IE hack so that hover works across the entire anchor aera.
		// It allows us to set the anchor element to 100% width, respectively we can set
		// the padding on the span element.
		var span = document.createElement('span');
		var txt = document.createTextNode(label);
		span.appendChild(img);
		span.appendChild(txt);
		a.appendChild(span);
		if (isItemInGroup) {
			li.style.display = 'none';
			span.style.paddingLeft = '22px';
		}
		if (isActiveMenuItem) {
			li.className = 'active';
		}
		if (itemType != 'group') {
			if (reportsMenu.isDynamicReport) {
				YE.addListener(a, 'click', newReport.getReportByMenuItem);
				YE.addListener(a, 'mousedown', zoomControl.zoomSilent);
			}
		}
		else {
			// li.style.fontWeight = 'bold';
			a.href = 'javascript:;';
			YE.addListener(a, 'click', reportsMenu.toggleGroup);
		}
		li.appendChild(a);
		ul.appendChild(li);
	},
	toggleGroup: function() {
		// alert('toggle_group: ' + this.id);
		var elementId = this.id;
		var dat = elementId.split(':');
		var itemId = dat[2];
		var groupItem = reportsMenuDb[itemId];
		groupItem.isExpanded = !groupItem.isExpanded;
		reportsMenu.expandCollapseGroup(groupItem);
		this.blur();
	},
	expandCollapseGroup: function(groupItem) {
		var isExpanded = groupItem.isExpanded;
		var groupItemId = groupItem.id;
		// IE hack, delayed group image setup because IE doesn't display the image without delay.
		setTimeout('reportsMenu.setExpandedCollapsedImage("' + groupItemId + '",' + isExpanded + ')', 20);
		// Expand or collapse report group
		var items = groupItem.items;
		// alert('isExpanded: ' + isExpanded);
		for (var i = 0; i < items.length; i++) {
			util.showE('reports_menu:li:' + items[i].id, isExpanded);
		}
	},
	setExpandedCollapsedImage: function(groupItemId, isExpanded) {
		// Set the right group item image
		var img = util.getE('reports_menu:img:' + groupItemId);
		img.src = isExpanded ? imgDb.rmCollapse.src : imgDb.rmExpand.src;
	},
	updateMenuItemLinks: function(menuItems, dateFilter, commandLineFilter, commandLineFilterComment, filterId, zoomInfoId) {
		// Updates all menu items upon init, upon zoom (date_filter change and/or add filter items)
		// alert('updateMenuItemLinks(): - zoomInfoId: ' + zoomInfoId);
		for (var i = 0; i < menuItems.length > 0; i++) {
			var item = menuItems[i];
			// util.showObject('');
			var itemType = item.type;
			if (itemType != 'group') {
				var itemId = item.id;
				var a = util.getE('reports_menu:a:' + itemId);
				var url = location.protocol + '//' + location.host + location.pathname + '?dp=reports';
				url += '&p=' + reportInfo.profileName;
				if (itemType == 'report') {
					url += '&rn=' + item.name;
				}
				else {
					// itemType is calendar
					url += '&calendar=true';
				}
				if (dateFilter != '') {
					url += '&df=' + encodeURIComponent(dateFilter);
				}
				if (commandLineFilter != '') {
					url += '&f=' + encodeURIComponent(commandLineFilter);
				}
				if (commandLineFilterComment != '') {
					url += '&fc=' + encodeURIComponent(commandLineFilterComment);
				}
				if (filterId != '') {
					url += '&fi=' + filterId;
				}
				if (zoomInfoId != '') {
					url += '&zii=' + zoomInfoId;
				}
				a.href = url;
			}
			else {
				reportsMenu.updateMenuItemLinks(
					item.items,
					dateFilter,
					commandLineFilter,
					commandLineFilterComment,
					filterId,
					zoomInfoId
				);
			} 
		}
	},
	updateStaticMenuItemLinks: function(menuItems) {
		for (var i = 0; i < menuItems.length > 0; i++) {
			var item = menuItems[i];
			// util.showObject('');
			var itemType = item.type;
			if (itemType != 'group') {
				var itemId = item.id;
				var a = util.getE('reports_menu:a:' + itemId);
				a.href = item.name + '.html';
			}
			else {
				reportsMenu.updateStaticMenuItemLinks(item.items);
			} 
		}
	}
//	toggleSidebar: function() {
//
//		// var reportsMenuSection = util.getE('reports_menu_items');
//		var reportSection = util.getE('report_section');
//		// var reportsMenuSwitch = util.getE('reports_menu_switch');
//		var reportsMenuSection = util.getE('reports_menu_section');
//		var body = util.getE('html:body');
//
//		var showSidebar = !reportsMenu.isVisible;
//
//		body.className = (showSidebar) ? 'reports' : ''; // Handles the sidebar background image
//		// reportsMenuSwitch.className = (showSidebar) ? 'reports-menu-switch' : 'reports-menu-switch-closed';
//		reportsMenuSection.className = (showSidebar) ? 'reports-menu' : 'reports-menu-closed';
//		util.showE('reports_menu_switch:close_btn', showSidebar);
//		util.showE('reports_menu_switch:open_btn', !showSidebar);
//		reportSection.style.marginLeft = (showSidebar) ? '180px' : '0px';
//
//		util.showE('reports_menu_switch:vertical_space', !showSidebar);
//
//		if (showSidebar) {
//
//			// delay due IE image rendering problem
//			setTimeout("reportsMenu.showSidebar()", 50);
//
//		}
//		else {
//			util.hideE('reports_menu_items');
//            util.hideE('reports_menu_section_bg');
//		}
//
//		reportsMenu.isVisible = showSidebar;
//	},
//	showSidebar: function() {
//
//        util.showE('reports_menu_section_bg');
//		util.showE('reports_menu_items');
//	}
}
