//
// admin licensing
//

var licensing = (function() {

	var YE = YAHOO.util.Event,
		activeLicensingTier = '',
		licenses = [];

	var k = 0;

	function init(dat) {

		util.showE('loading_info');

		if (pageInfo.permissions.isEdit) {
			YE.addListener('licensing:change_key_btn', 'click', addOrChangeLicense);
		}

		// Init help
		util.helpWindow.init('');

		// Get licensing data
		getLicensingData();
	}

	function getLicensingData() {

		if (!pageInfo.exitActive) {

			var url = '?dp=admin_pages.licensing.get_licensing_data';
			var dat = 'v.fp.page_token=' + pageInfo.pageToken;

			util.serverPost(url, dat);
		}
	}

	function getLicensingDataResponse(dat) {

		if (!pageInfo.exitActive) {

			// util.showObject(dat);

			util.updateT('licensing:tier', dat.licensingTier);
			util.updateT('licensing:number_of_profiles', dat.numberOfProfilesText);

			activeLicensingTier = dat.licensingTier;
			licenses = dat.licenses;

			// Sort licenses by number of profiles
			licenses.sort(numberOfProfilesSort);
			
			buildLicenseDetails(licenses);

			util.hideE('loading_info');
			util.showE('form_section');
		}
	}

	//
	// Add or change license key
	//

	function addOrChangeLicense() {

		// Create object with already installed keys
		var installedKeys = {},
			i;

		putInstalledKeysInObj(installedKeys, licenses);

		// util.showObject(installedKeys);
		licenseEditor.openPanel(installedKeys);
	}

	function putInstalledKeysInObj(obj, theLicenses) {

		var item,
			theKey,
			i;

		for (i = 0; i < theLicenses.length; i++) {

			item = theLicenses[i];
			theKey = item.licenseKey;

			// Add key to obj
			obj[theKey] = true;

			// Handle sublicenses
			if (item.sublicenses) {
				putInstalledKeysInObj(obj, item.sublicenses);
			}
		}
	}

	//
	// Delete license
	//

	function deleteLicense(evt) {

		var element = evt.target || evt.srcElement,
			elementId = element.id,
			dat = elementId.split(':'),
			licenseIndex = parseInt(dat[2]),
			theLicense = licenses[licenseIndex],
			msg = langVar('lang_admin.licensing.confirm_delete_message'),
			url = '',
			dat = '';

		msg = msg.replace(/__PARAM__1/, theLicense.licenseKey);

		if (confirm(msg)) {

			util.hideE('form_section');
			util.showE('deleting_info');

			url = '?dp=admin_pages.licensing.delete_license';
			dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
			dat += 'v.fp.license_node_name=' + theLicense.name;

			util.serverPost(url, dat);
		}

		return false;
	}

	function deleteLicenseResponse(dat) {

		if (dat.errorMsg !== '') {
			alert(dat.errorMsg);
		}

		// Reload licensing page in any case
		location.reload(true);
	}

	//
	// Build license table
	//

	function buildLicenseDetails(licenses) {

		var table = util.getE('licensing:keys_with_details'),
			inactiveTable = util.getE('licensing:inactive_keys_with_details'),
			thead = util.createE('thead'),
			tbody = util.createE('tbody'),
			inactiveTbody = util.createE('tbody'),
			tr = util.createE('tr'),
			i = 0,
			numOfLicenses = licenses.length,
			isDeletePermission = pageInfo.permissions.isDelete,
			addDeleteButton = isDeletePermission && (numOfLicenses > 1),
			theLicense = {},
			isActive = false,
			inactiveLicenseExists = false,
			finalTbody = null,
			licenseTier = '';

		// Add header row
		addCell(tr, 'header', langVar('lang_admin.licensing.license_keys'));
		addCell(tr, 'header', langVar('lang_admin.general.type'));
		addCell(tr, 'header', langVar('lang_stats.btn.profiles')); 
		addCell(tr, 'header', langVar('lang_admin.licensing.license_expiration'));
		// addCell(tr, 'header', langVar('lang_admin.licensing.valid'));

		if (addDeleteButton) {
			addCell(tr, 'header', '&nbsp;');
		}

		util.chainE(table, thead, tr);

		// Add the rows
		for (i = 0; i < numOfLicenses; i++) {

			theLicense = licenses[i];
			licenseTier = theLicense.type;
			isActive = theLicense.isValid && (licenseTier === activeLicensingTier || licenseTier === 'trial');
			finalTbody = isActive ? tbody : inactiveTbody;

			addLicenseRow(finalTbody, numOfLicenses, theLicense, i, isActive, addDeleteButton);

			if (!isActive) {
				inactiveLicenseExists = true;
			}
		}

		table.appendChild(tbody);
		table.appendChild(inactiveTbody);

		// Show inactive license keys legend\
		if (inactiveLicenseExists) {
			util.showE('licensing:inactive_license_keys_legend');
		}

		/*

		var sublicenses = dat.sublicenses;

		if (sublicenses.length > 0) {

			// Show sublicenses below the licenseKey
			var container = util.getE('licensing:key_section');

			for (var i = 0; i < sublicenses.length; i++) {

				var div = util.createE('div', {padding:'0 0 3px 12px', color:'#8b8b8b'});
				var text = util.createT('- ' + sublicenses[i]);

				util.chainE(container, div, text);
			}
		}
		*/
	}

	function addLicenseRow(tbody, numOfLicenses, theLicense, itemIndex, isActive, addDeleteButton) {

		var licenseKeyText = theLicense.licenseKey,
			sublicenses = theLicense.sublicenses,
			numOfSublicense = sublicenses.length,
			isSublicenses = (numOfSublicense > 0),
			tr = util.createE('tr'),
			className = '',
			classNameProfiles = 'profiles',
			i = 0;

		if (!isActive) {
			licenseKeyText += ' (' + langVar('lang_admin.licensing.inactive') + ')*';
			className = 'inactive';
			classNameProfiles = 'inactive profiles';
		}

		addCell(tr, className, licenseKeyText);
		addCell(tr, className, theLicense.type);
		addCell(tr, classNameProfiles, theLicense.numberOfProfilesText);
		addCell(tr, className, theLicense.expiration);

		if (addDeleteButton) {
			add_deleteCell(tr, itemIndex);
		}

		util.chainE(tbody, tr);

		if (isSublicenses) {

			for (i = 0; i < numOfSublicense; i++) {
				addSublicenseRow(tbody, sublicenses[i], isActive, addDeleteButton);
			}
		}
	}

	function addSublicenseRow(tbody, theSublicense, isActive, addDeleteButton) {

		var tr = util.createE('tr'),
			licenseKeyText = theSublicense.licenseKey,
			classNameKey = 'indent',
			classNameProfiles = 'profiles';

		if (!isActive) {
			licenseKeyText += ' (' + langVar('lang_admin.licensing.inactive') + ')*';
			classNameKey = 'inactive indent',
			classNameProfiles = 'inactive profiles';
		}

		addCell(tr, classNameKey, licenseKeyText);
		addCell(tr, '', '&nbsp;');
		addCell(tr, classNameProfiles, theSublicense.numberOfProfilesText);
		addCell(tr, '', ' ');

		if (addDeleteButton) {
			addCell(tr, '', ' ');
		}

		util.chainE(tbody, tr);
	}

	function addCell(tr, className, label) {

		var td = util.createE('td', {className: className}),
			text = util.createT(label);

		util.chainE(tr, [td, text]);
	}

	function add_deleteCell(tr, itemIndex) {

		var td = util.createE('td'),
			a = util.createE('a', {id:'delete_license:a:' + itemIndex, href:'javascript:;'}),
			text = util.createT(langVar('lang_stats.btn.delete'));

		YE.addListener(a, 'click', licensing.deleteLicense);
		util.chainE(tr, td, [a, text]);
	}

	function numberOfProfilesSort(a, b) {
		return (a.numberOfProfiles - b.numberOfProfiles);
	}

	return {
		init: init,
		getLicensingDataResponse: getLicensingDataResponse,
		deleteLicense: deleteLicense,
		deleteLicenseResponse: deleteLicenseResponse
	}

}());

YAHOO.util.Event.onDOMReady(licensing.init);


