//
// newProfileInfo.js
//

var newProfileInfo = {
	
	// newProfileItemId: '',
	
	panel: null,
	
	
	init: function() {
		
		var panelObj = {
			panelId: 'new_profile_info:panel',
			panelClassName: 'panel-30',
			panelHeaderLabel: '-',
			zIndex: 20,
			isCover: true,
			closeEvent: newProfileInfo.close
		};
		
		newProfileInfo.panel = new util.Panel3(panelObj);
		
		YAHOO.util.Event.addListener('new_profile_info:close_btn', 'click', newProfileInfo.close);
	},
	
	openViaNewProfileWizard: function(newProfileNodeName, numberOfAllProfiles, profilesDb) {
		
		// This function is called from New Profile Wizard when the profile has been saved.
		// profilesDb is up to date which includes the new profile.
		
		//
		// Close new profile wizard window
		//
		profiles.GD.newProfileWizardWindow.blur() // Hack for Firefox problem which doesn't close the window immediately, though blur moves it to the background!
		profiles.GD.newProfileWizardWindow.close();

		
		//
		// Update profiles.GD.profilesDb
		//
		
		// Note, we can't just set
		// profiles.GD.profilesDb = profilesDb
		// because IE keeps a reference to the New Profile Window which doesn't anymore exist.
		// Further, a simple clone of profilesDb doesn't work either due a somewhat strange structure
		// of profilesDb.
		
		// So we create a new profilesDb and clone each profilesDb object item individually.
		
		var newProfilesDb = [];
		
		for (var i = 0; i < profilesDb.length; i++) {
			
			var profileItem = profilesDb[i];
			// util.showObject(profilesDb[i]);
			newProfilesDb[i] = util.cloneObject(profileItem);
		}
		
		// util.createHash(profiles.GD.profilesDb, 'itemId');
		
		// Update profilesDb and profiles display so that the new profile
		// is actually visible hrough the transparent cover.
	        profiles.updateNumberOfAllProfiles(numberOfAllProfiles);
		profiles.addNewProfilesDb(newProfilesDb);
		profiles.updateProfilesDisplay();
		
		// Open new profile info panel
		newProfileInfo.open(newProfileNodeName);
	},
	
	open: function(newProfileNodeName) {
		
		// alert('open newProfileInfo for profile: ' + newProfileNodeName);
		
		var profilesDb = profiles.GD.profilesDb;		
		var newProfileItem = profilesDb[util.h(newProfileNodeName)];
		
		//
		// Init newProfileInfo panel
		//
		
		if (!newProfileInfo.panel) {
			newProfileInfo.init();
		}
		
		//
		// Get the new profile object in profilesDb
		//
		
		// Keep itemId for new profile delete action
		// newProfileInfo.newProfileItemId = newProfileItem.itemId;
		
		
		// Update the info label
		var label = langVar('lang_admin.profiles.profile_has_been_created');
		label = label.replace(/__PARAM__1/, newProfileItem.label);
		util.updateT('new_profile_info:label', label);
		
		//
		// Handle View Reports, View Config and Delete link
		//
		
		// util.showObject(newProfileItem);
		
		var isViewReportsPermission = newProfileItem.isViewReports;
		var isViewConfigPermission = newProfileItem.isViewConfig;
		
		if (isViewReportsPermission) {
			
			var viewReportsBtn = util.getE('new_profile_info:view_reports_btn');
			var viewReportsUrl = '?dp=reports&p=' + newProfileNodeName;
			if (newProfileItem.df != '') {
				viewReportsUrl += '&df=' + newProfileItem.df;
			}
			viewReportsBtn.href = viewReportsUrl;
		}
		
		if (isViewConfigPermission) {
			
			var viewConfigBtn = util.getE('new_profile_info:view_config_btn');
			var viewConfigUrl = '?dp=config&page=config_home&p=' + newProfileNodeName;
			viewConfigBtn.href = viewConfigUrl;
		}
		
		util.showE('new_profile_info:view_reports_btn', isViewReportsPermission);
		util.showE('new_profile_info:view_config_btn', isViewConfigPermission);
		
		//
		// Show profiles list and new profile info
		//
		
		newProfileInfo.panel.prePositionAtCenter();
		newProfileInfo.panel.open();
	},
	
	close: function() {
		
		newProfileInfo.panel.close();
	}
}
