//
//
// usersUtil.js
//
//

var usersUtil = {
	
	//
	//
	// Access List Utilities
	//
	//
	
	// Element Id's used in access table rows
	// The baseId, i.e. "acc0" does not specify the row number, it is random!
	// We get the active row number by checking the rows array of tbody!
	// ":op:" within the id stands for operate, so upon click on a cell which contains :op: we do something, else not
	// <tr id="acc0:tr" --> Id of access table row
	// <td id ="acc0:op:edit_profiles" --> Edit Access with profiles tab as default
	// <td id ="acc0:op:edit_roles" --> Edit Access with roles tab as default
	// <td id ="acc0:info" --> Info cell which contains text like "(by user 2)" or ("Owned by other user")
	// <td id ="acc0:op:edit" --> Edit Access with profiles tab as default
	// <td id ="acc0:op:delete" --> Delete the access item
	
	accessListLinkActivated: function(evt) {
		
		// Note, we use the elementId to check if this is an operational button or link
		// and we use the className to check if the item is in enabled or disabled state!
		
		var element = evt.target || evt.srcElement;
		var elementId = element.id;
		var className = element.className;
		
		// alert('accessListLinkActivated - elementId: ' + elementId);
		
		if ((className.indexOf('disabled') == -1) && (elementId.indexOf(':op:') != -1)) {
			
			// alert('linkActivated - elementId: ' + elementId);
			
			var dat = elementId.split(':');
			var baseId = dat[0];
			var accessOperation = dat[2];
			var accessItemIndex = usersUtil.getRowNumberFromBaseId(baseId);
			
			// alert('accessListLinkActivated - accessItemIndex: ' + accessItemIndex);
			
			var activeAccess = users.activeAccess;
			
			//
			// Check if the user has permission to edit the item
			//
			
			var isPermission = (pageInfo.isRootAdmin || users.isUnlimitedGrants);
			if (!isPermission) {
				isPermission = (activeAccess[accessItemIndex].created_by_user == users.activeUserNodeName);
			}
			
			
			if (isPermission) {
			
				if (accessOperation != 'delete') {
					
					// alert('open access manager');
					
					var activeTabIsRoles = (accessOperation == 'edit_roles');
					var isNewAccessPair = false;
					var accessItem = util.cloneObject(activeAccess[accessItemIndex]);
					usersAM.open(accessItemIndex, accessItem, activeTabIsRoles, isNewAccessPair);
				}
				else {
					
					//
					// Delete item
					//
			
					// Delete item from activeAccess array
					activeAccess.splice(accessItemIndex, 1);
					
					// Delete last row (we have to update the rows anyway due delete button display, so we simply delete the last row)
					var tbody = util.getE('users:access:tbody');
					var lastTr = tbody.lastChild;
					tbody.removeChild(lastTr);
					
					// Update all rows
					var numberOfAccessItems = activeAccess.length;
					for (var i = 0; i < numberOfAccessItems; i++) {
						usersUtil.updateAccessRow(i, activeAccess[i], numberOfAccessItems);
					}
				}
			}
			else {
				
				alert(langVar('lang_admin.users.no_permission_msg'));
			}
		}
	},
	
	hoverAccessListItem: function(evt) {
		
		var element = evt.target || evt.srcElement;
		var elementId = element.id;
		var className = element.className;
		
		// Note, we use the elementId to check if this is an operational button or link
		// and we use the className to check if the item is in enabled or disabled state!
		
		// Hover off upon mouseout must be always possible, even if disabled because
		// it possible that we accidently hover a disabled item after delete.
		
		// alert('hoverAccessListItem - elementId: ' + elementId + '\nevt.type: ' + evt.type);
		
		if (elementId.indexOf(':op:') != -1) {
			
			var eventType = evt.type;
			var isMouseOver = (evt.type == 'mouseover');
			
			if (!isMouseOver || (className.indexOf('disabled') == -1)) {
							
				element.style.backgroundColor = isMouseOver ? '#F2F2F2' : 'White';
				element.style.cursor = isMouseOver ? 'pointer' : 'default';
			}
		}
	},
	
	getSortedAccessItemProfileLabels: function(numberOfProfiles, profiles) {
		
		var profilesDb = users.profilesDb;
		
		var a = [];
		
		for (var i = 0; i < numberOfProfiles; i++) {
			
			var profileName = profiles[i];
			var profileItem = profilesDb[util.h(profileName)];
			var profileLabel = (profileItem != null) ? profileItem.label : langVar('lang_admin.users.unknown_profile');
			
			a[i] = profileLabel;
		}
		
		// Sort a
		a.sort();
		
		return a;
	},
	
	cleanUpAccessCell: function(element) {
		
		// alert('cleanUpAccessCell - element: ' + element);
		while (element.lastChild != null) {
			var theChild = element.lastChild;
			element.removeChild(theChild);
		}
	},
	
	updateAccessRow: function(index, accessItem, numberOfAccessItems) {
		
		// alert('updateAccessRow()');
		// util.showObject(accessItem);
		
		var i;
		var br;
		
		var rolesDb = users.rolesDb;
		
	
		var isRootAdmin = pageInfo.isRootAdmin;
		var isUnlimitedGrants = users.isUnlimitedGrants;
		var activeUserNodeName = users.activeUserNodeName;
		var createdByUserNodeName = accessItem.created_by_user;
		
		var isOwnedByOtherUser = (!isRootAdmin && !isUnlimitedGrants && (activeUserNodeName != createdByUserNodeName));
		
		
		//
		// Get the baseId of the row
		// 
		
		var tbody = util.getE('users:access:tbody');
		var allRows = tbody.getElementsByTagName('tr');
		var trId = allRows[index].id;
		// alert('updateAccessRow - trId: ' + trId);
		var dat = trId.split(':');
		var baseId = dat[0];
		// alert('updateAccessRow - baseId: ' + baseId);
		
		//
		//
		// Handle Profiles cell
		//
		//
		
		var isAllProfiles = accessItem.all_profiles;
		var profiles = accessItem.profiles;
		var numberOfProfiles = profiles.length;
		
		var profileTd = util.getE(baseId + ':op:edit_profiles');
		profileTd.className = !isOwnedByOtherUser ? '' : 'disabled'; // Don't remove, the className is used to check hover and link activation,
																	 // both are ignored if the className contains disabled!
		// alert('updateAccessRow - profileTd: ' + profileTd);
		
		usersUtil.cleanUpAccessCell(profileTd);
		
		var profileLabel;
		var profileText;
		
		if (isAllProfiles || (numberOfProfiles == 0)) {
			
			profileLabel = isAllProfiles ? langVar('lang_admin.users.all_profiles') : '[ ' + langVar('lang_admin.users.no_profile_defined') + ' ]';
			profileText = document.createTextNode(profileLabel);
			profileTd.appendChild(profileText);
		}
		else {
			
			// One or more profiles in list
			// KHP 14/Sep/2010 - Make sure we get sorted labels
			var sortedProfileLabels = usersUtil.getSortedAccessItemProfileLabels(numberOfProfiles, profiles);
			
			for (i = 0; i < numberOfProfiles; i++) {
				
				profileText = document.createTextNode(sortedProfileLabels[i]);
				
				profileTd.appendChild(profileText);
				
				// Add br tag if this is not the last profile
				if (numberOfProfiles > 1 && i + 1 != numberOfProfiles) {
					br = document.createElement('br');
					profileTd.appendChild(br);
				}
			}
		}
		
		//
		//
		// Handle Roles cell
		//
		//
		
		var roleTd = util.getE(baseId + ':op:edit_roles');
		roleTd.className = !isOwnedByOtherUser ? '' : 'disabled';
		usersUtil.cleanUpAccessCell(roleTd);
		
		var roles = accessItem.roles;
		var numberOfRoles = roles.length;
		
		var roleName;
		var roleLabel;
		var roleText;
		
		if (numberOfRoles > 0) {
			
			for (i = 0; i < numberOfRoles; i++) {
				
				roleName = roles[i];
				roleLabel = rolesDb[util.h(roleName)].label;
				roleText = document.createTextNode(roleLabel);
				roleTd.appendChild(roleText);
				
				// Add br tag if this is not the last role
				if (numberOfRoles > 1 && i + 1 != numberOfRoles) {
					br = document.createElement('br');
					roleTd.appendChild(br);
				}
			}
		}
		else {
			
			// No role defined
			roleText = document.createTextNode('[ ' + langVar('lang_admin.users.no_role_defined') + ' ]');
			roleTd.appendChild(roleText);
		}
		
		
		
		//
		// Handle info cell
		//
		
		
		var infoTd = util.getE(baseId + ':info');
		usersUtil.cleanUpAccessCell(infoTd);
		var infoLabel = '';
		
		if (createdByUserNodeName == activeUserNodeName) {
			// No info, add &nbsp;
			infoLabel = '\u00a0';
		}
		else {
			if (!isOwnedByOtherUser) {
				// Add info by whom the access pair has been created
				var username = usersUtil.getUsernameByUserNodeName(createdByUserNodeName);
				infoLabel = '(' + langVar('lang_admin.general.by_user')  + ')';
				infoLabel = infoLabel.replace(/__PARAM__1/, username);
			}
			else {
				// This are limited grants, there is no permission to edit this item
				infoLabel = '(' + langVar('lang_admin.users.owned_by_other_user') + ')';
			}
		}
		
		var infoText = document.createTextNode(infoLabel);
		infoTd.appendChild(infoText);
		
		
		//
		// Handle edit cell
		//
		
		var editTd = util.getE(baseId + ':op:edit');
		editTd.className = !isOwnedByOtherUser ? 'link' : 'link-disabled';
		
		
		//
		// Handle delete cell
		//
		
		if (users.isEnterprise) {
		
			var deleteTd = util.getE(baseId + ':op:delete');
			deleteTd.className = (!isOwnedByOtherUser && numberOfAccessItems > 1) ? 'link' : 'link-disabled';
		}
	},
	
	addAccessCell: function(tr, elementId, className, label) {
		
		// type is: edit_profiles | edit_roles
		var td = document.createElement('td');
		if (className != '') {td.className = className}
		td.id = elementId;
		var text = document.createTextNode(label);
		td.appendChild(text);
		tr.appendChild(td);
	},
	
	createAccessRow: function(tbody) {
		
		// alert('createAccessRow);
		
		// Get new unique baseId (i.e. acc8)
		var idCount = 0;
		var isUniqueId = false;
		var baseId = '';
		while (!isUniqueId) {
			if (util.getE('acc' + idCount + ':tr') == null) {
				baseId = 'acc' + idCount;
				isUniqueId = true;
			}
			idCount++;
		}
	
		
		var tr = document.createElement('tr');
		tr.id = baseId + ':tr';
		
		usersUtil.addAccessCell(tr, baseId + ':op:edit_profiles', '', '-');
		usersUtil.addAccessCell(tr, baseId + ':op:edit_roles', '', '-');
		usersUtil.addAccessCell(tr, baseId + ':info', 'info', '-');
		usersUtil.addAccessCell(tr, baseId + ':op:edit', 'link', langVar('lang_stats.btn.edit'));
		if (users.isEnterprise) {
			usersUtil.addAccessCell(tr, baseId + ':op:delete', 'link', langVar('lang_stats.btn.delete'));
		}
		
		tbody.appendChild(tr);
	},
	
	updateAccessList: function() {
		
		// Updates the access list
		
		// var table = util.getE('users:access:container');
		var tbody = util.getE('users:access:tbody');
		
		// Get the number of existing rows
		var allRows = tbody.getElementsByTagName('tr');
		var numberOfExistingAccessRows = allRows.length;
		
		var access = users.activeAccess;
		var numberOfAccessItems = access.length;
		
		// alert('numberOfExistingAccessRows: ' + numberOfExistingAccessRows + '\nnumberOfAccessItems: ' + numberOfAccessItems);
		
		//
		// Create/remove access rows
		//
		
		if (numberOfExistingAccessRows != numberOfAccessItems) {
			
			if (numberOfExistingAccessRows < numberOfAccessItems) {
				// Add new rows
				// alert('Add new rows!');
				for (i = numberOfExistingAccessRows; i < numberOfAccessItems; i++) {
					usersUtil.createAccessRow(tbody);
				}
			}
			else {
				// Remove rows
				// alert('Remove rows!');
				for (i = numberOfExistingAccessRows; i > numberOfAccessItems; i--) {
					// alert('Remove row: ' + i);
					var tr = tbody.lastChild;
					tbody.removeChild(tr);
				}
			}
		}
		
		//
		// Update the access cells
		//
		
		var isUnlimitedGrants = users.isUnlimitedGrants;
		
		for (i = 0; i < numberOfAccessItems; i++) {
			
			var accessItem = access[i];
			usersUtil.updateAccessRow(i, accessItem, numberOfAccessItems);
		}
	},
	
	
	//
	//
	//
	// Miscellaneous utilities
	//
	//
	//
	
	getRowNumberFromBaseId: function(baseId) {
		
		var tbody = util.getE('users:access:tbody');
		var allRows = tbody.getElementsByTagName('tr');
		var trBaseId = baseId + ':tr';
		var rowNumberIndex = 0;
		
		for (var i = 0; i < allRows.length; i++) {
			if (trBaseId == allRows[i].id) {
				rowNumberIndex = i;
				break;
			}
		}
		
		return rowNumberIndex;
	},
	
	getUsernameByUserNodeName: function(userNodeName) {
		
		var usersDb = users.usersDb;
		var username = '';
		
		for (var i = 0; i < usersDb.length; i++) {
			
			if (userNodeName == usersDb[i].dat.node_name) {
				username = usersDb[i].dat.username;
				break;
			}
		}
		
		if (username == '') {
			username = langVar('lang_admin.users.unknown_user');
		}
		
		return username;
	},
	
	getNewUserNodeName: function(usersDb, deletedUsersDb) {
		
		// Returns a new unique node name (with timestamp) so that it
		// is unique forever.
		
		//
		// Create a node name lookup
		//
		
		var usedNodeNames = {};
		var nodeName;
		var i;
		
		for (i = 0; i < usersDb.length; i++) {
			
			nodeName = usersDb[i].dat.node_name;
			nodeName = '_' + nodeName.toLowerCase();
			usedNodeNames[nodeName] = true;
		}
		
		for (i = 0; i < deletedUsersDb.length; i++) {
			
			nodeName = deletedUsersDb[i];
			nodeName = '_' + nodeName.toLowerCase();
			usedNodeNames[nodeName] = true;
		}
		
		//
		// Create new node name
		//
		
		// KHP 05/Jan/2011 - use timestamp to ensure unique user node name forever,
		// it should not be possible to create the same user node name even after
		// deletion of the user because there might be references of the node name
		// in "created_by_user" nodes.
		
		var d = new Date();
		var timestamp = d.getTime();
		var newNodeName = 'user_' + timestamp;
		
		// util.showObject({newNodeName__1: newNodeName});
		
		if (usedNodeNames['_' + newNodeName] != null) {
			
			// A user node name with this timestamp already exists.
			// This case shouldn't be possible but we cover it
			// by some older code
			
			var isUniqueNodeName = false;
			var count = 1;
			while (!isUniqueNodeName) {
				
				newNodeName = 'user_' + timestamp + count;
				
				// util.showObject({newNodeName__2: newNodeName});
				
				if (usedNodeNames['_' + newNodeName] == null) {
					isUniqueNodeName = true;
				}
				
				count++;
			}
		}
		
		return newNodeName;
	}
}
