//
// logFieldsUtil.js
//

var logFieldsUtil = {
	
	init: function(isDerivedLogField) {
		
		// util.disableE('node_name');
	
		util.hideE([
			'derived_from_1_section',
			'derived_from_2_section',
			'hierarchical_section'
		]);
		
		var isDisabledBtn = isDerivedLogField;
		
		logFields.duplicateBtn.enable(!isDerivedLogField);
		logFields.deleteBtn.enable(!isDerivedLogField);
		
		logFieldsUtil.lockEditing(isDerivedLogField);
		
		// Disable node_name in any case
		// util.disableE('node_name');
	},
	
	lockEditing: function(makeDisabled) {
		
		var form = util.getE('log_fields:form');
		
		var formElements = form.elements;
		
		// alert('form length: ' + e.length);
		
		for (var i = 0; i < formElements.length; i++) {
			
			var element = formElements[i];
			
			// Ignore the identifier:node_name field!
			if (element.id != 'identifier:node_name') {
				element.disabled = makeDisabled;
			}
		}
		
		logFields.activeForm.isDisabledForm = makeDisabled;
	},
	
	typeActor: function() {
		
		var isHirarchicalType = util.getF('type') == 'hierarchical' ? true : false;
		util.showE('hierarchical_section', isHirarchicalType);
	},
	
	//
	// updateListLabel
	//
	
	updateListLabelActor: function() {
		
		setTimeout('logFieldsUtil.updateListLabel()', 300);
	},
	
	updateListLabel: function() {
		
		var label =  util.getF('log_fields:label');
		
		if (label == '') {
			label = '-';
		}
		
		logFields.theList.updateListLabel(label);
	},


	getItemIdsWithLabelsObject: function(itemsDb) {
		
		// Returns a fresh itemId's with labels object
		
		var obj = {};
		
		for (var i = 0; i < itemsDb.length; i++) {
			
			var item = itemsDb[i];
			var itemId = item.id;
			var label = item.dat.label;
			
			obj[itemId] = label;
		}
		
		return obj;
	},
	
	getItemIdsWithNodeNamesLookup: function(itemsDb) {
		
		var obj = {};
		
		for (var i = 0; i < itemsDb.length; i++) {
			var item = itemsDb[i];
			var itemId = item.id;
			var nodeName = item.dat.node_name;
			obj[itemId] = nodeName;
		}
		
		return obj;
	}
}
