//
// miscellaneous
//


var theList;
var itemsDb = [];  // items work array
var itemsDbBackup = []; // items array in the state when first loaded or last saved, it is used upon Undo Changes

var validator = new util.Validator();

var miscellaneous = {
	
	saveChangesBtn: null,
	undoAllChangesBtn: null
}

function getMiscellaneousData() {
	
	if (!pageInfo.exitActive) {

		var url = '?dp=config_pages.miscellaneous.get_data';
		url += '&p=' + pageInfo.profileName;
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
	
		util.helpWindow.init('');
		util.serverPost(url, dat);
	}
}

function getMiscellaneousDataReponse(dat) {

	if (!pageInfo.exitActive) {
		
		// get itemsDb
		itemsDb = dat;
		itemsDbBackup = util.cloneObject(dat);
				
		// Init
		init();
		initItems();
		
		miscellaneous.saveChangesBtn.enable();
		miscellaneous.undoAllChangesBtn.enable();
		
		util.showE('form_section');
		
		adminConfig.setItemListSize();
		YAHOO.util.Event.addListener(window, 'resize', adminConfig.setItemListSize);
		
		pageInfo.initComplete = true;
	}
}

function init() {
	
	//
	// init toolbar buttons
	//
	
	miscellaneous.saveChangesBtn = new util.ToolbarButton('save_changes', saveChanges, toolbarButtonsDb);		
	miscellaneous.undoAllChangesBtn = new util.ToolbarButton('undo_all_changes', undoAllChanges, toolbarButtonsDb);
	
	var isEdit = pageInfo.permissions.isEdit;
	
	if (isEdit) {
		
		// Register isModifiedPageHandler in adminConfig.js
		// (We don't check for modifications if there is no edit 
		// permission because there is no Save button anyway!)
		adminConfig.getIsModifiedPageHandler = getIsModifiedPage;
	}
	else {
		
		miscellaneous.saveChangesBtn.disableAndIgnore();
		miscellaneous.undoAllChangesBtn.disableAndIgnore();
	}
		
	// Create theList object
	theList = new listcontroller.List({
		containerElementId: 'item_list_body',
		itemEvent: itemActivated
	});

	// init OptionInfo
	optionInfo.init();
}

function initItems() {
	
	// Sets all input controls to initial itemsDb values
	// Also used upon Undo Changes

	/*
		Init item list
	*/

	theList.init(itemsDb);
	setItem('i0');
	
	/*
		Init form data
	*/
	
	for (var i = 0; i < itemsDb.length; i++) {
		
		var item = itemsDb[i];
		var itemDat = item.dat;
		
		// util.showObject(itemDat);
		
		for (var prop in itemDat) {
			
			var value = itemDat[prop].value;
			var type = itemDat[prop].type;
			util.setF(prop, value);
		}
	}
	
	util.updateT('item_form_label', item.label);
}

function itemActivated(itemId) {
	
	if (validateActiveItem()) {
		setItem(itemId);
	}
}

function setItem(itemId) {
	
	theList.selectItem(itemId);
	
	// Display the form
	
	util.hideE([
		'miscellaneous:dns_lookup:section',
		'miscellaneous:email:section'
	]);
	
	var item = theList.getSelectedItem();
	util.updateT('item_form_label', item.label);
	util.showE('miscellaneous:' + item.type + ':section');
}

function validateActiveItem() {
	
	// Only validate if isEdit permission
	
	if (pageInfo.permissions.isEdit) {
	
		validator.reset();
		
		var activeItem = theList.getSelectedItem();
		
		// Clone the active item dat and set its values. (We clone it to keep
		// item dat properties such as type, etc.)
		var o = util.cloneObject(activeItem.dat);
		
		if (activeItem.type == 'dns_lookup') {
		
			var isActiveLookup = util.getF('look_up_ip_numbers');
			
			o.look_up_ip_numbers.value = isActiveLookup;
			o.dns_server.value = isActiveLookup ? validator.isValue('dns_server') : util.getF('dns_server');
			o.secondary_dns_server.value = util.getF('secondary_dns_server');
			o.maximum_simultaneous_dns_lookups.value = isActiveLookup ? validator.isInteger('maximum_simultaneous_dns_lookups', 1, 100) : util.getF('maximum_simultaneous_dns_lookups');
			o.dns_timeout.value = isActiveLookup ? validator.isInteger('dns_timeout', 0) : util.getF('dns_timeout');
			o.use_tcp_for_dns.value = util.getF('use_tcp_for_dns');
			o.look_up_ip_numbers_before_filtering.value = util.getF('look_up_ip_numbers_before_filtering');
		}
		else {
			
			// Email
			// Validate email addresses only if an address is specified
			o.actions_email_address.value = (util.getF('actions_email_address') == '') ? '' : validator.isEmailAddresses('actions_email_address');
			o.actions_return_address.value = (util.getF('actions_return_address') == '') ? '' : validator.isEmailAddresses('actions_return_address');
		}
		
		if (validator.allValid()) {
			theList.saveItem(o);
			return true;
		}
		
		return false;
	}
	else {
		
		// No isEdit permission
		return true;
	}
}

function saveChanges() {
	
	if (validateActiveItem()) {
		
		var isModified = theList.getIsModified();
		// alert('saveChanges() - isModified: ' + isModified);
		
		if (isModified) {
			
			util.hideE('form_section');
			util.showE('saving_info');
			
			var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
			
			for (var i = 0; i < itemsDb.length; i++) {
		
				var item = itemsDb[i];
				var itemDat = item.dat;
				
				for (var prop in itemDat) {
					
					var option = itemDat[prop];
					var optionValue = option.value;
					var optionType = option.type;
					
					if (optionType == 'string' && optionValue != '') {
						optionValue = encodeURIComponent(optionValue);
					}
					
					dat += 'v.fp.network.' + prop + '=' + optionValue + '&';
				}
			}
					
			dat = dat.replace(/&$/, '');
	
			// alert('dat:\n' + dat);
			
			var url = '?dp=config_pages.miscellaneous.save_data';
			url += '&p=' + pageInfo.profileName;
			
			util.serverPost(url, dat);			
		}
		else {
			
			alert(langVar('lang_stats.general.no_changes_to_save'));
		}
	}
}

function saveChangesResponse() {
	
	// reset isModified
	theList.resetIsModified();
	
	// the saved work itemsDb becomes now the itemsDbBackup
	itemsDbBackup = util.cloneObject(itemsDb);

	util.hideE('saving_info');
	util.showE('form_section');
}

function undoAllChanges() {
	
	itemsDb = util.cloneObject(itemsDbBackup);
	initItems();
}

function getIsModifiedPage() {
	
	// Before checking isModified we need to validate the form!
	if (!validateActiveItem() || theList.getIsModified()) {
		return true;
	}
	return false;
}
