//
//
// reports.js
//
//

var reports = {

	theList: null,
	
	itemsDb: [],
	itemsDbBackup: [],
	
	// reportElementMetaTypesDb - contains all report element types by report field name or by type.	
	// Note, the non-table report elements contain a prefix which distinguishes them from table report elements.
	// So for table report elements the name is equal the reportFieldName, for non-table report elements the
	// name is equal "__RET__" + report_element_type
	// This approach allows us to set and get meta type list values in a simple way
	// {name:__RET__overview, type:"overview", label:"Overview", },
	// {name:file_type, , type:"table", label:"File type"},
	// {name:page, type:"table", label:"Page"},
	// {name:__RET__log_detail, type:"table", label:"Page"},
	// ...
	
	reportElementMetaTypesDb: [],
	databaseFieldsDb: [], // Required for creSessionFields.js
	queryFieldsDb: [], // Contains all report fields with report field properties and additional information
	defaultGraphsDb: {},
	
	// sessionFieldsDb: [],
	// isBasicSessionReportsSupport: false,
	// isPageSessionReportsSupport: false,
	
	validator: null,
	moveControl: null,
	
	// mainButtons;
	saveChangesBtn: null,
	newReportGroupBtn: null,
	newReportBtn: null,
	deleteBtn: null,
	duplicateBtn: null,
	undoAllChangesBtn: null,
	
	// noItemFormIsActive: false,
	reportElementsMoveControlIsPositioned: false,
	
	activeMainDisplayElementId: '',
	
	activeType: '', // report | report_group
	
	activeReportGroupItemDat: {
		label_ori: ''
	},
	
	// activeReportItemDat contains active form data which are used by reportEditor to read upon open and write upon save
	// and when validating the active report.
	activeReportItemDat: {
		report_name: '',
		label_ori: '',
//		show_header_bar: true,
		sync_graph_axis_with_relative_date: false,
		description: '',
		header: '',
		footer: '',
		date_filter: '',
		filter_expression: '',
		filter_items: []
	},
	
	deletedReportNamesDb: [] // Contains the report node names of any deleted report. The list is send to the server upon save.
};

function init() {
	
	// init new session
	// util.initSession();
	
	reports.validator = new util.Validator();
	
	//
	// init toolbar buttons and form controls
	//
	
	reports.saveChangesBtn = new util.ToolbarButton('save_changes', saveReportChanges, toolbarButtonsDb);		
	reports.newReportGroupBtn = new util.ToolbarButton('new_report_group', newReportGroupItem, toolbarButtonsDb);
	reports.newReportBtn = new util.ToolbarButton('new_report', newReportItem, toolbarButtonsDb);
	reports.duplicateBtn = new util.ToolbarButton('duplicate', duplicateItem, toolbarButtonsDb);
	reports.deleteBtn = new util.ToolbarButton('delete', deleteItem, toolbarButtonsDb);
	reports.undoAllChangesBtn = new util.ToolbarButton('undo_all_changes', undoAllChanges, toolbarButtonsDb);
	
	var YE = YAHOO.util.Event;
	YE.addListener('reports:report_group_label', 'keyup', updateItemListLabel);
	YE.addListener('reports:report_label', 'keyup', updateItemListLabel);
	
	YE.addListener('reports:edit_report_properties_btn', 'click', reportEditor.openPanel);
	YE.addListener('reports:new_report_element_btn', 'click', reportElement.newItem);
	
	//
	// Ignore/Disable buttons according RBAC
	//
	
	var permissions = pageInfo.permissions;
	
	if (permissions.isEdit) {
		
		if (!permissions.isAdd) {
			reports.newReportGroupBtn.disableAndIgnore();
			reports.newReportBtn.disableAndIgnore();
			reports.duplicateBtn.disableAndIgnore();
		}
		
		if (!permissions.isDelete) {
			reports.deleteBtn.disableAndIgnore();
		}
		
		// Register isModifiedPageHandler in adminConfig.js
		// (We don't check for modifications if there is no edit 
		// permission because there is no Save button anyway!)
		adminConfig.getIsModifiedPageHandler = getIsModifiedPage;
	}
	else {
		reports.saveChangesBtn.disableAndIgnore();
		reports.newReportGroupBtn.disableAndIgnore();
		reports.newReportBtn.disableAndIgnore();
		reports.duplicateBtn.disableAndIgnore();
		reports.deleteBtn.disableAndIgnore();
		reports.undoAllChangesBtn.disableAndIgnore();
	}
		
	//
	// Create theList object
	//
	
	reports.theList = new listcontroller.List({
		containerElementId: 'item_list_body',
		itemEvent: itemActivated,
		switchEvent: itemSwitchActivated,
		isSwitch1: true,
		isSwitch2: true,
		switchButtonElementId: 'reports:item_list:switch_btn',
		switchLabelElementId: 'reports:item_list:switch_label',
		switch1Label: langVar('lang_admin.report_editor.show_in_dynamic_reports'),
		switch2Label: langVar('lang_admin.report_editor.show_in_static_reports'),
		isMoveControl: true
	});
	
	//
	// init Report Element List, Report Editor, ...
	//
	
	reportElementsList.init();
	reportEditor.init();
	reportElement.init();
	
	// Init view available fields panels
	reportsUtil.initViewAvailableFields();
	
	// init OptionInfo
	optionInfo.init();
}

function initMainDisplay() {
	
	// alert('initMainDisplay: ' + pageInfo.reportName);
	
	function getItemIdForGivenReportName(items, reportName) {
		
		// Returns the itemId for the given reportName,
		// or an empty string if the report_name does not exist.
		
		var itemId = '';
		
		for (var i = 0; i < items.length; i++) {
			var item = items[i];
			if (item.type == 'report') {
				if (item.dat.report_name == reportName) {
					itemId = item.id;
				}
			}
			else {
				var subitems = item.subitems;
				for (var j = 0; j < subitems.length; j++) {
					var subitem = subitems[j];
					if (subitem.dat.report_name == reportName) {
						itemId = subitem.id;
						break;
					}
				}
			}
		}
		
		return itemId;
	}
	
	var itemsDb = reports.itemsDb;
	
	if (itemsDb.length > 0) {
	
		var defaultItemId = '';
		var reportName = pageInfo.reportName;
		
		if (reportName != '') {
		
			// Check if the report exists and get the itemId
			defaultItemId = getItemIdForGivenReportName(itemsDb, reportName);
			
			// Reset the reportName because we don't want to select
			// any defaultReport when initMainDisplay() is inoked
			// upon undoChanges, etc.
			pageInfo.reportName = '';
		}
		
		// alert('defaultItemId: ' + defaultItemId);
		
		// If we don't have a defaultItemId yet get the first itemId.
		if (defaultItemId == '') {
			defaultItemId = reports.theList.getFirstItemId();
		}

		setItem(defaultItemId);
	}
	else {
		
		// no item exists
		setMainDisplay('no_item_form');
	}
	
	// Update moveControl button state
	// reports.theList.setMoveControlState();
	
	util.showE('form_section');
}

function setMainDisplay(displayElementId) {
	
	if (reports.activeMainDisplayElementId != displayElementId) {
		util.hideE(['no_item_form', 'report_group_form', 'report_form', 'loading_info', 'saving_info']);
		util.showE(displayElementId);
		reports.activeMainDisplayElementId = displayElementId;
		
		// Update form label
		var formLabel = '';
		if (displayElementId == 'report_group_form') {
			formLabel = langVar('lang_admin.report_editor.report_group');
		}
		else if (displayElementId == 'report_form') {
			formLabel = langVar('lang_admin.report_editor.report');
		}
		else {
			formLabel = '-';
		}
		
		util.updateT('item_form_label', formLabel);
	}
}

function getReportData() {
	
	util.showE('loading_info');
	
	if (!pageInfo.exitActive) {
		
		// Init help
		util.helpWindow.init('');

		var url = '?dp=config_pages.reports.get_report_data';
		url += '&p=' + pageInfo.profileName;
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		
		util.serverPost(url, dat);
	}
}

function getReportDataResponse(dat) {
	
	// alert('getReportDataResponse(): ' + dat);
	
	// Add report label property to itemsDb. The propery exists but has no value yet,
	// we get the label from label_ori.
	function fixReportLabels(items) {
		for (var i = 0; i < items.length; i++) {
			var item = items[i];
			if (item.type == 'report') {
				item.dat.label = item.dat.label_ori;
			}
			else {
				// Report Group, Recursively call fixReportLabels for subitems
				fixReportLabels(item.subitems);
			}
		}
	}
	
	var itemsDb = dat.reportsDb;
	fixReportLabels(itemsDb);
	
	// util.showObject(itemsDb);
	
	reports.itemsDb = itemsDb;
	reports.itemsDbBackup = util.cloneObject(itemsDb);
	
	reports.reportElementMetaTypesDb = dat.reportElementMetaTypesDb;

    // util.showObject(reports.reportElementMetaTypesDb);

	util.createHash(reports.reportElementMetaTypesDb, 'name');
	
	reports.defaultGraphsDb = dat.defaultGraphsDb;
	
	reports.databaseFieldsDb = dat.databaseFieldsDb;
	
	reports.queryFieldsDb = dat.queryFieldsDb;
	util.createHash(reports.queryFieldsDb, 'name');

	// util.showObject('reports.queryFieldsDb');

	//
	// Init
	//
	
	init();
	reports.theList.init(reports.itemsDb);
	initMainDisplay();
	
	// Set final toolbar state
	reports.saveChangesBtn.enable();
	reports.undoAllChangesBtn.enable();
	reports.newReportGroupBtn.enable();
	reports.newReportBtn.enable();
	updateToolbarButtons(); // handles Duplicate and Delete
	
	adminConfig.setItemListSize();
	YAHOO.util.Event.addListener(window, 'resize', adminConfig.setItemListSize);
	
	pageInfo.initComplete = true;
}

function updateToolbarButtons() {
	
	var isItems = reports.theList.isItems();
	reports.deleteBtn.enable(isItems);
	reports.duplicateBtn.enable(isItems);
}

function updateItemListLabel() {
	var label = this.value;
	setTimeout('setItemListLabel("' + label + '")', 150);
}

function setItemListLabel(label) {
	
	if (label == '') {
		label = '-';
	}
	
	reports.theList.updateListLabel(label);
}

function itemActivated(itemId) {
	
	// util.showE('transparent_cover');
	if (validateActiveItem()) {
		setItem(itemId);
	}
}


function itemSwitchActivated(itemId) {
	
	// A user clicked on an item checkbox (not necessarily a selected item)
	// and we may need to update the ViewReports link
	
	// alert('itemSwitchActivated() - itemId: ' + itemId);
	var activeSwitchKey = reports.theList.getActiveSwitchKey();
	
	// If checkboxes are set for dynamic reports
	if (activeSwitchKey == 'switch1') {
		
		// alert('itemSwitchActivated() - itemId: ' + itemId);
		setViewReportsLink();
	}
}

function setItem(itemId) {
	
	// selects active item in list and displays the form
	
	// alert('set item: ' + itemId);
	// Set session is active
	// util.sessionActive();
	
	reports.theList.selectItem(itemId);
	updateForm();
}

function newReportGroupItem() {
	
	if (validateActiveItem()) {
	
		var newItemId = reports.theList.getNewItemId();
		var newReportGroupLabel = langVar('lang_admin.general.new_report_group');
		
		var newReportGroupObj = {
			id: newItemId,
			type: 'report_group',
			switch1: true,
			switch2: true,
			label: newReportGroupLabel,
			dat: {
				label: newReportGroupLabel,
				label_ori: ''
			},
			subitems: []
		}
		
		// util.showObject(newReportGroupObj);
		
		var insertDirective = {insertAtRootLevel: true};
		
		reports.theList.newItem(newReportGroupObj, insertDirective);
		setItem(newItemId);
		updateToolbarButtons();
	}
}

function newReportItem() {
	
	// alert('newReportItem()');
	
	if (validateActiveItem()) {
	
		var newItemId = reports.theList.getNewItemId();
		var newReportLabel = langVar('lang_admin.general.new_report');
		
		var newReportObj = {
			id: newItemId,
			type: 'report',
			switch1: true,
			switch2: true,
			label: newReportLabel,
			dat: {
				report_name: '', // report node name
				label: newReportLabel,
				label_ori: '',
//				show_header_bar: true,
				description: '',
				header: '',
				footer: '',
				date_filter: '',
				filter_expression: '',
				filter_items: [],
				sync_graph_axis_with_relative_date: false,
				report_elements: []
			}
		}
		
		// util.showObject(newReportObj);
		
		var insertDirective = {};
		
		if (reports.activeType == 'report_group') {
			insertDirective.insertAsFirstSubItem = true;
		}
		else {
			insertDirective.insertAsItemOrSubItem = true;
		}

		reports.theList.newItem(newReportObj, insertDirective);
		setItem(newItemId);
		updateToolbarButtons();
	}
}

function duplicateItem() {
	
	if (validateActiveItem()) {
		
		var theList = reports.theList
		var clonedItemId = theList.cloneItem();
		
		// Update cloned item properties
		// KHP-RC, we have to update all subitems if this is a report group!
		theList.setItemDatValue(clonedItemId, 'report_name', '');
		theList.setItemDatValue(clonedItemId, 'label_ori', '');
		
		setItem(clonedItemId);
	}
}

function deleteItem() {
	
	var theList = reports.theList;
	var selectedItem = theList.getSelectedItem();
	
	//
	// Track deleted report items
	//
	var deletedReportsDb = reports.deletedReportNamesDb;
	var reportName = '';
	if (selectedItem.type == 'report_group') {
		var subitems = selectedItem.subitems;
		for (var i = 0; i < subitems.length; i++) {
			reportName = subitems[i].dat.report_name;
			if (reportName != '') {
				deletedReportsDb[deletedReportsDb.length] = reportName;
			}
		}
	}
	else {
		// This is a report item
		reportName = selectedItem.dat.report_name;
		if (reportName != '') {
			deletedReportsDb[deletedReportsDb.length] = reportName;
		}
	}
	
	//
	// Delete item
	//
	
	var nextItemIdToBeSelected = theList.deleteItem();
	
	if (nextItemIdToBeSelected) {
		
		// reset the validator in case that the deleted item indicated an error
		reports.validator.reset();
		setItem(nextItemIdToBeSelected);
	}
	else {
		// Last item has been deleted, so no item exists.
		reports.activeType = '';
		initMainDisplay();
	}
}

function updateForm() {
	
	var item = reports.theList.getSelectedItem();
	var itemDat = item.dat;
	
	// util.showObject(itemDat);
	
	var type = item.type;
	
	reports.activeType = type;
	
	var displayElementId = '';
	
	var activeReportName = '';
	var isShowInDynamicReports = false;
		
	if (type == 'report_group') {
		
		//
		// Update report group
		// 
		
		displayElementId = 'report_group_form';
		util.setF('reports:report_group_label', itemDat.label);
		
		reports.activeReportGroupItemDat.label_ori = itemDat.label_ori;
	}
	else {
		
		//
		// Update report
		//
		
		displayElementId = 'report_form';
		
		util.setF('reports:report_label', itemDat.label);
		
		// Write active itemDat data to reports.activeReportItemDat object so that they can be read by reportsEditor.js
		var activeReportItemDat = reports.activeReportItemDat;
		for (prop in activeReportItemDat) {
			activeReportItemDat[prop] = itemDat[prop];
		}
		
		// util.showObject(itemDat.filter_items);
		// util.showObject(activeReportItemDat.filter_items);
		
		//
		// Handle report elements list
		// 
	
		reportElementsList.list.compose(itemDat.report_elements);
	}

	//
	// Update display
	//
	
	if (reports.activeMainDisplayElementId != displayElementId) {
		setMainDisplay(displayElementId);
	}
	
	//
	// Update View Reports link
	//
	
	setViewReportsLink();
	

	//
	// Position the Report Elements Move Control
	//
	
	if (!reports.reportElementsMoveControlIsPositioned && type == 'report') {
		
		// We need to give it some time, else we don't get the right list position
		var s = 'reports:report_element_list:div';
		setTimeout('reportElementsList.moveControl.setPosition("' + s + '")', 250);
		reports.reportElementsMoveControlIsPositioned = true;
	}
}

function setViewReportsLink() {

	// This updates the "View Reports" link in the navigation
	// so that the selected report is the default report when
	// viewing reports.
	
	// Make sure the link exists!
	var theLinkElement = util.getE('config_nav:view_reports_btn');
	
	if (theLinkElement) {
	
		var reportNameToView = '';
		var defaultDateFilter = pageInfo.defaultDateFilter;
		
		if (reports.activeType == 'report') {
			
			// We only set the reportName if is not a new report (because it isn't saved yet)
			// and if it is active in dynamic reports
			
			var theList = reports.theList;
			var isNew = theList.getSelectedItemIsNew();
			var isActive = theList.getSelectedItemIsSwitch1(); // This already considers any parent switch to be true as well
			
			if (!isNew && isActive) {
				reportNameToView = reports.activeReportItemDat.report_name;
			}
		}
		
		// else it is a group for which no viewReportsName is defined
		
		// Set the link
		var href = '?dp=reports&p=' + pageInfo.profileName;
		
		if (defaultDateFilter != '') {
			href += '&df=' + defaultDateFilter;
		}
		
		if (reportNameToView != '') {
			href += '&rn=' + reportNameToView;
		}
		theLinkElement.href = href;
	}
}

function validateActiveItem() {
	
	var theList = reports.theList;
	
	// Only validate if isEdit permission and if items
	
	if (pageInfo.permissions.isEdit && theList.isItems()) {
		
		validator = reports.validator;
		
		var isReportItem = (reports.activeType == 'report');
		
		var o = {};
		
		if (!isReportItem) {
			
			// Report group
			o.label = validator.isValue('reports:report_group_label');
			o.label_ori = reports.activeReportGroupItemDat.label_ori;
		}
		else {
			
			// Report
			// Handle the label
			o.label = validator.isValue('reports:report_label');
			// KHP-RC, should we allow duplicate labels?
			// For now we allow it and don't check for duplicates!
			
			// Get activeReportItemDat
			var activeReportItemDat = reports.activeReportItemDat;
			for (var prop in activeReportItemDat) {
				o[prop] = activeReportItemDat[prop];
			}
		}
		
		if (validator.allValid()) {
			
			if (isReportItem) {
				// Get a clone of the report element items
				o.report_elements = reportElementsList.list.getItemsClone();
			}
			
			// alert('validateActiveItem() - isModified state before saving the item: ' + theList.getIsModified());
	
			theList.saveItem(o);
			
			// alert('validateActiveItem() - isModified state after saving the item: ' + theList.getIsModified());
			
			return true;
		}
	
		return false;
	}
	else {
		// No item exists or no isEdit permission
		return true;
	}
}

//
//
// saveReportChanges utilities
//
//

function assembleReportElementItemDat(path, item, reportElementCount) {
	
	function addNumberOfRows() {
		
		dat += path + '.number_of_rows=' + item.number_of_rows + '&';
	}
	
	function addColumns() {
		
		var columns = item.columns;
		
		for (var i = 0; i < columns.length; i++) {
			
			var columnsObj = columns[i];
			var columnsPath = path + '.columns.' + i; 
			
			for (var prop in columnsObj) {
				dat += columnsPath + '.' + prop + '=' + columnsObj[prop] + '&';
			}
			
			// Add position node
			dat += columnsPath + '.position=' + i + '&';
		}
	}
	
	function addSessionFields() {
		
		var sessionFields = creSessionFields.getSessionFields();
		
		// util.showObject(sessionFields);
		
		var sessionFieldName;
		
		for (sessionFieldName in sessionFields) {
			
			if (sessionFields[sessionFieldName][reportElementType]) {
				// Add session field value
				dat += path + '.' + sessionFieldName + '=' + encodeURIComponent(item[sessionFieldName]) + '&';
			}
		}
	}
	
	var reportElementType = item.type;
	var isLogDetail = (reportElementType == 'log_detail');
	var prop;
	var graphsObj;
	var pivotTableObj;
	var dat;
	
	dat = path + '.position=' + reportElementCount + '&'; // Used to sort reports in order on server side
	dat += path + '.label=' + encodeURIComponent(item.label) + '&';
	dat += path + '.label_ori=' + encodeURIComponent(item.label_ori) + '&';
	dat += path + '.type=' + item.type + '&';
	dat += path + '.display_side_by_side=' + item.display_side_by_side + '&';
	dat += path + '.show_header_bar=' + item.show_header_bar + '&';
	dat += path + '.report_link=' + item.report_link + '&';
	dat += path + '.description=' + encodeURIComponent(item.description) + '&';
	dat += path + '.header=' + encodeURIComponent(item.header) + '&';
	dat += path + '.footer=' + encodeURIComponent(item.footer) + '&';
	dat += path + '.date_filter.df=' + encodeURIComponent(item.date_filter) + '&';
	dat += path + '.filter.expression=' + encodeURIComponent(item.filter_expression) + '&';

	switch (reportElementType) {
		
		case 'overview':

			dat += path + '.compact_view=' + item.compact_view + '&';
			addColumns();
			break;
		
		case 'table':
			
			addNumberOfRows();
			dat += path + '.show_graphs=' + item.show_graphs + '&';
			dat += path + '.show_table=' + item.show_table + '&';

			dat += path + '.display_graphs_side_by_side=' + item.display_graphs_side_by_side + '&';
//			dat += path + '.display_graphs_table_side_by_side=' + item.display_graphs_table_side_by_side + '&';
			dat += path + '.maximum_table_bar_graph_length=' + item.maximum_table_bar_graph_length + '&';

			dat += path + '.omit_parenthesized_items=' + item.omit_parenthesized_items + '&';
			dat += path + '.use_overview_for_totals=' + item.use_overview_for_totals + '&';
			dat += path + '.table_filter_expression=' + encodeURIComponent(item.table_filter_expression) + '&';
			dat += path + '.sort_by=' + encodeURIComponent(item.sort_by) + '&';
			dat += path + '.sort_direction=' + item.sort_direction + '&';
			dat += path + '.show_remainder_row=' + item.show_remainder_row + '&';
			dat += path + '.show_averages_row=' + item.show_averages_row + '&';
			dat += path + '.show_min_row=' + item.show_min_row + '&';
			dat += path + '.show_max_row=' + item.show_max_row + '&';
			dat += path + '.show_totals_row=' + item.show_totals_row + '&';
			
			graphsObj = item.graphs;
			pivotTableObj = item.pivot_table;
			
			// util.showObject(graphsObj);
			
			for (prop in graphsObj) {
				dat += path + '.graphs.' + prop + '=' + graphsObj[prop] + '&';
			}
			
			for (prop in pivotTableObj) {
				dat += path + '.pivot_table.' + prop + '=' + pivotTableObj[prop] + '&';
			}
			
			addColumns();
			break;
			
		case 'log_detail':
			
			addNumberOfRows();
			dat += path + '.show_graphs=false&';
			dat += path + '.show_table=true&';
            dat += path + '.table_filter_expression=' + encodeURIComponent(item.table_filter_expression) + '&';
			dat += path + '.sort_by=' + encodeURIComponent(item.sort_by) + '&';
			dat += path + '.sort_direction=' + item.sort_direction + '&';
			addColumns();
			break;
			
		case 'sessions_overview':
			
			addSessionFields();
			break;
			
		case 'session_paths':
			
			addNumberOfRows();
			addSessionFields();
			dat += path + '.number_of_rows_expanded=' + item.number_of_rows_expanded + '&';
			dat += path + '.expand_paths_greater_than=' + item.expand_paths_greater_than + '&';
			break;
			
		case 'session_page_paths':
			
			addNumberOfRows();
			addSessionFields();
			break;
	}
		
	// util.showObject(dat);
	
	return dat;
}

function assembleFilterItemsDat(path, filterItems) {
	
	var dat = '';
	var itemValue;
	
	if (filterItems.length > 0) {
				
		for (var i = 0; i < filterItems.length; i++) {
			
			var itemPath = path + '.filter.filter_items.' + i;
			var item = filterItems[i];
			
			for (var prop in item) {
				
				dat += itemPath + '.' + prop + '=' + util.getEncodedURIComponent(item[prop]) + '&';
			}
		}
	}
	else {
		
		// No filter items
		dat = path + '.filter.filter_items=&';
	}
	
	return dat;
}

function assembleReportItemDat(item, reportCount) {
	
	var finalReportName = item.final_report_name;
	
	// var oriReportName = item.report_name;
	
	var path = 'v.fp.reports.' + finalReportName;
	
	var dat = path + '.position=' + reportCount + '&'; // Used to sort reports in order on server side
	// dat += path + '.report_name_ori=' + encodeURIComponent(item.report_name) + '&'; // Used to handle existing report dependencies and label lang variables
	dat += path + '.label=' + encodeURIComponent(item.label) + '&';
//	dat += path + '.show_header_bar=' + item.show_header_bar + '&';
	dat += path + '.description=' + encodeURIComponent(item.description) + '&';
	dat += path + '.header=' + encodeURIComponent(item.header) + '&';
	dat += path + '.footer=' + encodeURIComponent(item.footer) + '&';
	dat += path + '.date_filter.df=' + encodeURIComponent(item.date_filter) + '&';
	dat += path + '.filter.expression=' + encodeURIComponent(item.filter_expression) + '&';
	
	dat += assembleFilterItemsDat(path, item.filter_items);
	
	dat += path + '.sync_graph_axis_with_relative_date=' + item.sync_graph_axis_with_relative_date + '&';
	
	// util.showObject(item);
	
	var reportElements = item.report_elements;
	
	if (reportElements.length > 0) {
		
		for (var i = 0; i < reportElements.length; i++) {
			
			var reportElementPath = path + '.report_elements.' + i;
			var reportElementItemDat = assembleReportElementItemDat(reportElementPath, reportElements[i], i);
			
			dat += reportElementItemDat;
		}
	}
	else {
		// No report element exists
		dat += path + '.report_elements=&';
	}
	
	return dat;
}

function assembleMenuItemDat(path, position, item) {
	
	// util.showObject(item);
	
	var dat = '';
	dat += path + '.position=' + position + '&';
	dat += path + '.report=' + item.dat.final_report_name + '&';
	dat += path + '.show_in_dynamic_reports=' + item.switch1 + '&';
	dat += path + '.show_in_static_reports=' + item.switch2 + '&';
	
	return dat;
}

function verifyAndCreateReportNodeNames(itemsDb) {
	
	// Checks if we need to specify and add any new report node names

	function checkForValidExistingNodeNames(items, reportNodeNameItems) {
		
		// This checks for existing valid node names. A node name is valid
		// if it exists and if the label is equal label_ori. In this case we
		// keep the existing node name.
		
		for (var i = 0; i < items.length; i++) {
			
			var item = items[i];
			
			if (item.type == 'report') {
				
				var itemDat = item.dat;
				
				if ((itemDat.report_name != '') && (itemDat.label == itemDat.label_ori)) {
					// Use existing report name, so we add this node name to reportNodeNameItems
					reportNodeNameItems[reportNodeNameItems.length] = itemDat.report_name;;
				}
			}
			else {
				// This is a report group, check subitems recursively
				checkForValidExistingNodeNames(item.subitems, reportNodeNameItems);
			}
		}
	}
	
	function setFinalReportNodeNames(items, reportNodeNameItems) {
		
		// This sets the final report node names to be used upon saving the data
		// Note, we let the server know if we send a new node name or not.
		
		for (var i = 0; i < items.length; i++) {
			
			var item = items[i];
			
			if (item.type == 'report') {
				
				var itemDat = item.dat;
				var finalReportName = ''; // The final report node name
				
				if ((itemDat.report_name != '') && (itemDat.label == itemDat.label_ori)) {
					// Use existing node name, so we add this node name to reportNodeNameItems
					finalReportName = itemDat.report_name;
				}
				else {
					
					// Create a new report node name and add it to reportNodeNameItems
					finalReportName = util.labelToUniqueNodeName(itemDat.label, reportNodeNameItems, 'report');
					reportNodeNameItems[reportNodeNameItems.length] = finalReportName;
				}
				
				// Add finalReportName to items
				itemDat.final_report_name = finalReportName;
			}
			else {
				// This is a report group, check subitems recursively
				setFinalReportNodeNames(item.subitems, reportNodeNameItems);
			}
		}
	}
	
	var reportNodeNameItems = [];
	checkForValidExistingNodeNames(itemsDb, reportNodeNameItems);
	setFinalReportNodeNames(itemsDb, reportNodeNameItems);
	
	// util.showObject(reportNodeNameItems);
}

function getDeletedReportNamesDat() {
	
	var a = reports.deletedReportNamesDb;
	var path = 'v.fp.deleted_reports';
	var dat = '';
	
	if (a.length > 0) {
		for (var i = 0; i < a.length; i++) {
			dat += path + '.' + encodeURIComponent(a[i]) + '=true&';
		}
	}
	else {
		dat = path + '=&';
	}
	
	return dat;
}

//
//
// saveReportChanges
//
//

function saveReportChanges() {
	
	if (validateActiveItem()) {
		
		var theList = reports.theList;
		var isModified = theList.getIsModified();
		
		// alert('isModified: ' + isModified);

		if (isModified) {
			
			util.hideE('form_section');
			util.showE('saving_info');
			// setMainDisplay('saving_info');
			
			var itemsDb = reports.itemsDb;

			// util.showObject(itemsDb);
			
			var reportsDat = '';
			var reportsMenuDat = '';
			var reportItemDat;
			var menuItemDat;
			
			if (itemsDb.length > 0) {
				
				// var reportsPath = 'v.fp.reports';
				
				//
				// Handle report node names
				//
				verifyAndCreateReportNodeNames(itemsDb);
				
				
				//
				// Assemble the data
				//
				
				var reportCount = 0; // Used as subnode in reports to sort them in menu order on server side.
				
				for (var i = 0; i < itemsDb.length; i++) {
					
					var item = itemsDb[i];
					var type = item.type;
					var itemDat = item.dat;
					
					var reportsMenuPath = 'v.fp.reports_menu.' + i;
					
					if (type == 'report_group') {
						
						// This is a report group with zero or more report items
						
						reportsMenuDat += reportsMenuPath + '.position=' + i + '&';
						reportsMenuDat += reportsMenuPath + '.label=' + encodeURIComponent(itemDat.label) + '&';
						reportsMenuDat += reportsMenuPath + '.label_ori=' + encodeURIComponent(itemDat.label_ori) + '&';
						reportsMenuDat += reportsMenuPath + '.show_in_dynamic_reports=' + item.switch1 + '&';
						reportsMenuDat += reportsMenuPath + '.show_in_static_reports=' + item.switch2 + '&';
						
						var subitemsDb = item.subitems;
						
						if (subitemsDb.length > 0) {
						
							for (var j = 0; j < subitemsDb.length; j++) {
								
								// This is a single menu item with a single report
								var subitem = subitemsDb[j];
								var subItemDat = subitem.dat;
								
								var reportsMenuItemsPath = reportsMenuPath + '.items.' + j;
								
								menuItemDat = assembleMenuItemDat(reportsMenuItemsPath, j, subitem);
								reportsMenuDat += menuItemDat;
								
								reportItemDat = assembleReportItemDat(subItemDat, reportCount);
								reportsDat += reportItemDat;
								reportCount++;
							}
						}
						else {
							
							// This is a report group without any reports.
							reportsMenuDat += reportsMenuPath + '.items=&';
							// reportsDat += reportsMenuDat;
						}
					}
					else {
						
						// This is a single menu item with a single report
						
						menuItemDat = assembleMenuItemDat(reportsMenuPath, i, item);
						reportsMenuDat += menuItemDat;
						
						reportItemDat = assembleReportItemDat(itemDat, reportCount);
						reportsDat += reportItemDat;
						reportCount++;
					}
				}
			}
			else {
				// No item exists
				reportsDat = 'v.fp.reports=&';
				reportsMenuDat = 'v.fp.reports_menu=&';
			}
			
			var deletedReportNamesDat = getDeletedReportNamesDat();
			deletedReportNamesDat = deletedReportNamesDat.replace(/&$/, '');
			// reportsMenuDat = reportsMenuDat.replace(/&$/, '');
			
			var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
			dat += reportsDat + reportsMenuDat + deletedReportNamesDat;			
			pageInfo.saveActive = true;
			
			var url = '?dp=config_pages.reports.save_reports';
			url += '&p=' + pageInfo.profileName;

			util.serverPost(url, dat);
		}
		else {
			
			alert(langVar('lang_stats.general.no_changes_to_save'));
		}
	}
}

function saveReportChangesResponse() {
		
	//
	// Reset items
	//

	// Update the current itemsDb with saved report data
	// For all items:
	// itemDat.label_ori must be set to the value of itemDat.label
	// For report items only:
	// itemDat.report_name must be set to the value of itemDat.final_report_name
	
	function resetItems(items) {
		
		for (var i = 0; i < items.length; i++) {
			var item = items[i];
			item.isNew = false;
			
			if (item.type == 'report') {
				var itemDat = item.dat;
				itemDat.label_ori = itemDat.label;
				itemDat.report_name = itemDat.final_report_name;
				
				// Delete the final_report_name property because
				// it will cause isModifiedItem as it does not
				// exist when we save the item into listcontroller upon
				// validateActiveItem()
				
				delete itemDat.final_report_name;
			}
			else {
				// Report Group, Recursively call resetItems for subitems
				resetItems(item.subitems);
			}
		}
	}
	
	var itemsDb = reports.itemsDb;
	resetItems(itemsDb);
	
	
	// Reset itemsDbBackup
	reports.itemsDbBackup = util.cloneObject(itemsDb);
	
	//
	// Before we reset isModified we must update the form
	// of the current selected item because it may not match
	// the latest itemsDb data
	//
	
	if (itemsDb.length > 0) {
		updateForm();
	}
	else {
		// If updateForm() isn't executed we must handle setViewReportsLink
		setViewReportsLink();
	}
	
	//
	// Reset isModified
	//
	
	var theList = reports.theList;
	theList.resetIsModified();
	
	//
	// Recover the display
	//
	
	pageInfo.saveActive = false;
	
	util.hideE('saving_info');
	util.showE('form_section');
}

function undoAllChanges() {
	
	reports.deletedReportNamesDb = [];
	reports.itemsDb = util.cloneObject(reports.itemsDbBackup);
	reports.theList.init(reports.itemsDb);
	initMainDisplay();
}

function getIsModifiedPage() {
		
	// Note, isModified will be false if only the active item has been edited
	// but has an error, hence we also check "if (!validateActiveItem() ..."
	
	var theList = reports.theList;
	
	if (!validateActiveItem() || theList.getIsModified()) {
		return true;
	}
	
	return false;
}
